/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.issuehierarchy;

import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.issuehierarchy.IssueCountInfo;
import com.hello2morrow.sonargraph.core.model.issuehierarchy.IssueNamedElement;
import com.hello2morrow.sonargraph.core.model.issuehierarchy.IssueRootElement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class NamedElementIssueTree
extends NamedElementContainer {
    public NamedElementIssueTree(NamedElement parent) {
        super(parent);
    }

    @Override
    public String getShortName() {
        return this.getClass().getSimpleName();
    }

    public void clear() {
        this.forgetChildren(true);
    }

    @Override
    public void finishModification() {
        super.finishModification();
        this.accept(new IssueCountCalculator());
    }

    public IssueNamedElement getIssueElementFor(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'getIssueElementFor' must not be null";
        NamedElementIssueFinder finder = new NamedElementIssueFinder(element);
        this.accept(finder);
        return finder.getMatch();
    }

    public List<IssueNamedElement> getIssueElementsFor(List<Issue> issues) {
        assert (issues != null && !issues.isEmpty()) : "Parameter 'issues' of method 'getIssueElementsFor' must not be empty";
        IssueToHierarchicalElementFinder finder = new IssueToHierarchicalElementFinder(issues);
        this.accept(finder);
        return finder.getMatches();
    }

    public int getNumberOfIssueElements() {
        return this.getChildrenRecursively(IssueNamedElement.class, new Class[0]).size();
    }

    public int getTotalNumberOfChildren(IssueNamedElement issueNamedElement) {
        assert (issueNamedElement != null) : "Parameter 'node' of method 'getTotalNumberOfChildren' must not be null";
        int count = 0;
        for (IssueNamedElement child : issueNamedElement.getChildren(IssueNamedElement.class)) {
            ++count;
            count += this.getTotalNumberOfChildren(child);
        }
        return count;
    }

    private static class IssueCountCalculator
    implements IssueNamedElement.IIssueNamedElementVisitor {
        private final Deque<IssueStackElement> m_issueStack = new ArrayDeque<IssueStackElement>();

        private IssueCountCalculator() {
        }

        @Override
        public void visitNamedElement(NamedElement element) {
            if (element instanceof NamedElementIssueTree) {
                element.getChildren(IssueRootElement.class).forEach(root -> this.visitNamedElement((NamedElement)root));
                return;
            }
            if (element instanceof IssueRootElement) {
                this.m_issueStack.clear();
            }
            if (element instanceof IssueNamedElement) {
                this.m_issueStack.push(new IssueStackElement());
                this.visitChildrenOf(element);
                this.visitIssueNamedElement((IssueNamedElement)element);
            }
        }

        @Override
        public void visitChildrenOf(NamedElement element) {
            if (element instanceof IssueNamedElement) {
                for (NamedElement child : element.getChildren()) {
                    this.visitNamedElement(child);
                }
            }
        }

        @Override
        public void visitIssueNamedElement(IssueNamedElement issueElement) {
            IssueStackElement issueStackElement = this.m_issueStack.pop();
            int affectedElementCount = issueStackElement.m_affectedElementCount;
            List<Issue> ownIssues = issueElement.getOwnIssues();
            Set<Issue> allRecursiveIssues = issueStackElement.m_allRecursiveIssues;
            allRecursiveIssues.addAll(ownIssues);
            if (!ownIssues.isEmpty()) {
                ++affectedElementCount;
            }
            IssueCountInfo issueInfo = issueElement.getIssueInfo();
            if (affectedElementCount > 0) {
                issueInfo.setAffectedElementCount(affectedElementCount);
            }
            block6: for (Issue next : allRecursiveIssues) {
                Severity severity = next.getSeverity();
                switch (severity) {
                    case ERROR: {
                        issueInfo.increaseErrorCount();
                        break;
                    }
                    case WARNING: {
                        issueInfo.increaseWarningCount();
                        break;
                    }
                    case INFO: {
                        issueInfo.increaseInfoCount();
                        break;
                    }
                    case NONE: {
                        issueInfo.increaseNoneCount();
                        break;
                    }
                    default: {
                        assert (false) : "Unsupported severity: " + String.valueOf((Object)severity);
                        continue block6;
                    }
                }
            }
            if (!this.m_issueStack.isEmpty()) {
                IssueStackElement parentIssueStackElement = this.m_issueStack.peek();
                parentIssueStackElement.m_allRecursiveIssues.addAll(allRecursiveIssues);
                parentIssueStackElement.m_affectedElementCount += affectedElementCount;
            }
        }

        private static class IssueStackElement {
            private int m_affectedElementCount = 0;
            private final Set<Issue> m_allRecursiveIssues = new HashSet<Issue>();

            private IssueStackElement() {
            }
        }
    }

    private static class IssueToHierarchicalElementFinder
    implements IssueNamedElement.IIssueNamedElementVisitor {
        private final HashSet<Issue> m_issuesToFind;
        private final HashSet<IssueNamedElement> m_matchingIssueElements;

        public IssueToHierarchicalElementFinder(List<Issue> issuesToFind) {
            this.m_issuesToFind = new HashSet<Issue>(issuesToFind);
            this.m_matchingIssueElements = new HashSet();
        }

        @Override
        public void visitNamedElement(NamedElement element) {
            if (element instanceof NamedElementIssueTree) {
                element.getChildren(IssueRootElement.class).forEach(root -> this.visitNamedElement((NamedElement)root));
                return;
            }
            if (element instanceof IssueNamedElement) {
                this.visitChildrenOf(element);
                this.visitIssueNamedElement((IssueNamedElement)element);
            }
        }

        @Override
        public void visitChildrenOf(NamedElement element) {
            if (element instanceof IssueNamedElement) {
                for (NamedElement child : element.getChildren()) {
                    this.visitNamedElement(child);
                }
            }
        }

        @Override
        public void visitIssueNamedElement(IssueNamedElement issueElement) {
            List<Issue> ownIssues = issueElement.getOwnIssues();
            if (ownIssues.isEmpty()) {
                return;
            }
            HashSet<Issue> issues = new HashSet<Issue>(ownIssues);
            issues.retainAll(this.m_issuesToFind);
            if (issues.size() > 0) {
                this.m_matchingIssueElements.add(issueElement);
            }
        }

        public List<IssueNamedElement> getMatches() {
            return new ArrayList<IssueNamedElement>(this.m_matchingIssueElements);
        }
    }

    private static final class NamedElementIssueFinder
    implements NamedElement.INamedElementVisitor {
        private final NamedElement m_elementToMatch;
        private IssueNamedElement m_match;

        private NamedElementIssueFinder(NamedElement element) {
            assert (element != null) : "Parameter 'element' of method 'Finder' must not be null";
            this.m_elementToMatch = element;
        }

        @Override
        public void visitNamedElement(NamedElement element) {
            assert (element != null) : "Parameter 'element' of method 'visitNamedElement' must not be null";
            if (element instanceof NamedElementIssueTree) {
                this.visitChildrenOf(element);
                return;
            }
            assert (element instanceof IssueNamedElement) : "Unexpected class in method 'visitNamedElement': " + String.valueOf(element);
            IssueNamedElement issueElement = (IssueNamedElement)element;
            if (issueElement.getElement() == this.m_elementToMatch) {
                this.m_match = issueElement;
            }
            if (this.m_match == null) {
                this.visitChildrenOf(element);
            }
        }

        @Override
        public void visitChildrenOf(NamedElement element) {
            if (this.m_match == null) {
                element.getChildren().forEach(child -> this.visitNamedElement((NamedElement)child));
            }
        }

        public IssueNamedElement getMatch() {
            return this.m_match;
        }
    }
}

