/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.model.element.ISoftwareSystemDefinitionElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFindingList;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperationList;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewRefactoringList;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewViolationList;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewOperationMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewStructureMode;
import com.hello2morrow.sonargraph.core.model.explorationview.IExplorationViewRepresentationOwner;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.IModifiablePathListener;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFile;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import de.schlichtherle.truezip.file.TFile;
import java.util.List;

public final class ArchitecturalViewFile
extends ModifiableFile
implements IExplorationViewRepresentationOwner,
ISoftwareSystemDefinitionElement {
    private ExplorationViewStructureMode m_mode = ExplorationViewStructureMode.getDefault();
    private String m_description = "";
    private String m_basedOn;

    public ArchitecturalViewFile(NamedElement parent, TFile file, IModifiablePathListener listener) {
        super(parent, file, listener);
        this.addChild(new ArchitecturalViewOperationList(this));
        this.addChild(new ArchitecturalViewRefactoringList(this));
        this.addChild(new ArchitecturalViewViolationList(this));
        this.addChild(new ArchitecturalViewFindingList(this));
    }

    public ArchitecturalViewFile(NamedElement parent, TFile file, ExplorationViewStructureMode mode, IModifiablePathListener listener) {
        super(parent, file, listener);
        assert (mode != null) : "Parameter 'mode' of method 'ArchitecturalViewModel' must not be null";
        this.m_mode = mode;
        this.addChild(new ArchitecturalViewOperationList(this));
        this.addChild(new ArchitecturalViewRefactoringList(this));
        this.addChild(new ArchitecturalViewViolationList(this));
        this.addChild(new ArchitecturalViewFindingList(this));
    }

    @Override
    public NamedElement getNamedElement() {
        return this;
    }

    @Override
    public String getId() {
        return this.getIdentifyingPath();
    }

    @Override
    public String getViewImageResourceName() {
        return "ArchitecturalView";
    }

    @Override
    public ExplorationViewOperationMode getOperationMode() {
        return this.m_mode.isLogical() ? ExplorationViewOperationMode.ARCHITECTURAL_MODELLING_LOGICAL : ExplorationViewOperationMode.ARCHITECTURAL_MODELLING_PHYSICAL;
    }

    @Override
    public IFileType getFileType() {
        return CoreFileType.ARCHITECTURAL_VIEW;
    }

    @Override
    @Property
    public String getInformation() {
        return this.m_mode.getPresentationName();
    }

    @Override
    @Property
    public String getAbsolutePath() {
        return this.getFile().getNormalizedAbsolutePath();
    }

    public void setDescription(String description) {
        assert (description != null) : "Parameter 'description' of method 'setDescription' must not be null";
        this.m_description = description;
    }

    public ExplorationViewStructureMode getStructureMode() {
        return this.m_mode;
    }

    public void setStructureMode(ExplorationViewStructureMode mode) {
        assert (mode != null) : "Parameter 'mode' of method 'setStructureMode' must not be null";
        this.m_mode = mode;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    public String getBasedOn() {
        return this.m_basedOn;
    }

    public void setBasedOn(String basedOn) {
        assert (basedOn == null || !basedOn.isEmpty()) : "'basedOn' must be null or not empty";
        this.m_basedOn = basedOn;
    }

    public List<ArchitecturalViewOperation> getOperations() {
        return this.getUniqueExistingChild(ArchitecturalViewOperationList.class).getChildren(ArchitecturalViewOperation.class);
    }

    public List<ArchitecturalViewOperation> getNonInheritedOperations() {
        return this.getUniqueExistingChild(ArchitecturalViewOperationList.class).getNonInheritedOperations();
    }

    public boolean removeNonInheritedOperations() {
        return this.getUniqueExistingChild(ArchitecturalViewOperationList.class).removeNonInheritedOperations();
    }

    public ArchitecturalViewFindingList getFindingList() {
        return this.getUniqueExistingChild(ArchitecturalViewFindingList.class);
    }

    public ArchitecturalViewRefactoringList getRefactoringList() {
        return this.getUniqueExistingChild(ArchitecturalViewRefactoringList.class);
    }

    public ArchitecturalViewViolationList getViolationList() {
        return this.getUniqueExistingChild(ArchitecturalViewViolationList.class);
    }
}

