/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.architecture;

import com.hello2morrow.sonargraph.core.foundation.common.graph.IRepresentedNode;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureElement;
import com.hello2morrow.sonargraph.core.model.architecture.Connector;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureElementContainer;
import com.hello2morrow.sonargraph.core.model.architecture.IArtifact;
import com.hello2morrow.sonargraph.core.model.architecture.Interface;
import com.hello2morrow.sonargraph.core.model.element.ArchitectureStructureItem;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.IStructureItem;
import com.hello2morrow.sonargraph.core.model.element.ImageDecoratorInfo;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ShortNameFilter;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class Artifact
extends ArchitectureElement
implements IArchitectureElementContainer,
IArtifact,
IRepresentedNode<Artifact> {
    private final EnumSet<StereoType> m_stereoTypes;
    private final String m_className;
    private List<Connector> m_connectors;
    private List<Interface> m_interfaces;
    private List<Artifact> m_artifactsByPriority;
    private String m_templateClass;
    private int m_priority = 0;
    private boolean m_isRequired = false;
    private boolean m_isReferenced = false;
    private boolean m_isExternal = true;
    private boolean m_hasViolations;
    private boolean m_hasDeprecations;

    public Artifact(NamedElement parent, String name, FilePath definingFile, int line, String className) {
        super(parent, name, definingFile, line);
        assert (definingFile != null) : "Parameter 'definingFile' of method 'Artifact' must not be null";
        this.m_isRequired = false;
        this.m_className = className == null ? className : className.intern();
        this.m_stereoTypes = EnumSet.noneOf(StereoType.class);
    }

    public Artifact(NamedElement parent, Artifact other) {
        super(parent, other);
        this.m_className = other.m_className;
        this.m_templateClass = other.m_templateClass;
        this.m_stereoTypes = other.m_stereoTypes;
        this.m_isRequired = other.m_isRequired;
        this.m_priority = other.m_priority;
    }

    public int getPriority() {
        return this.m_priority;
    }

    public void setPriority(int priority) {
        this.m_priority = priority;
    }

    @Override
    public final boolean acceptsPatterns() {
        return this.m_templateClass == null;
    }

    @Override
    public final void markAsReferenced() {
        this.m_isReferenced = true;
        IArtifact parent = this.getParent(IArtifact.class, new Class[0]);
        if (parent != null && parent.isRequired()) {
            parent.markAsReferenced();
        }
    }

    public final void markAsRequired() {
        this.m_isRequired = true;
        this.getChildren(Artifact.class).forEach(Artifact::markAsRequired);
    }

    public void assignmentFinished() {
        for (Artifact child : this.getChildren(Artifact.class)) {
            child.assignmentFinished();
        }
        this.buildProxyTree();
    }

    public final void setTemplateClass(String templateClass) {
        this.m_templateClass = templateClass == null ? templateClass : templateClass.intern();
    }

    public final boolean isReferenced() {
        return this.m_isReferenced;
    }

    @Override
    public final Artifact getContainer() {
        return this;
    }

    @Override
    @Property
    public final boolean isRequired() {
        return this.m_isRequired;
    }

    @Property
    public final boolean isApplied() {
        return !this.isRequired() && this.getReferencedFromLineNumber() != -1;
    }

    @Override
    public void clear() {
        this.m_isExternal = true;
        this.m_connectors = null;
        this.m_interfaces = null;
        this.m_hasViolations = false;
        this.m_hasDeprecations = false;
        this.m_artifactsByPriority = null;
        super.clear();
    }

    @Override
    public boolean isExternal() {
        return this.m_isExternal;
    }

    @Override
    public final void prepareForExtend(FilePath definingFile, int line) {
        super.prepareForExtend(definingFile, line);
    }

    public final boolean isPublic() {
        return this.m_stereoTypes.contains((Object)StereoType.PUBLIC);
    }

    public final boolean isExposed() {
        return this.m_stereoTypes.contains((Object)StereoType.EXPOSED);
    }

    public final boolean isHidden() {
        return this.m_stereoTypes.contains((Object)StereoType.HIDDEN);
    }

    public final boolean isLocal() {
        return this.m_stereoTypes.contains((Object)StereoType.LOCAL);
    }

    @Override
    public final boolean isOptional() {
        return this.m_stereoTypes.contains((Object)StereoType.OPTIONAL);
    }

    @Override
    public final boolean isDeprecated() {
        return this.m_stereoTypes.contains((Object)StereoType.DEPRECATED);
    }

    public final boolean isUnrestricted() {
        return this.m_stereoTypes.contains((Object)StereoType.UNRESTRICTED);
    }

    public final boolean isStrict() {
        return this.m_stereoTypes.contains((Object)StereoType.STRICT);
    }

    public final boolean isRelaxed() {
        return this.m_stereoTypes.contains((Object)StereoType.RELAXED);
    }

    public final void makePublic() {
        this.m_stereoTypes.add(StereoType.PUBLIC);
    }

    public final void makeHidden() {
        this.m_stereoTypes.add(StereoType.HIDDEN);
    }

    public final void makeLocal() {
        this.m_stereoTypes.add(StereoType.LOCAL);
    }

    public final void makeExposed() {
        this.m_stereoTypes.add(StereoType.EXPOSED);
    }

    public final void makeOptional() {
        this.m_stereoTypes.add(StereoType.OPTIONAL);
    }

    public final void makeDeprecated() {
        this.m_stereoTypes.add(StereoType.DEPRECATED);
        this.m_priority = -9999999;
    }

    public final void makeUnrestricted() {
        this.m_stereoTypes.add(StereoType.UNRESTRICTED);
    }

    public final void makeStrict() {
        this.m_stereoTypes.add(StereoType.STRICT);
    }

    public final void makeRelaxed() {
        this.m_stereoTypes.add(StereoType.RELAXED);
    }

    private List<Artifact> getArtifactsByPriority() {
        if (this.m_artifactsByPriority == null) {
            this.m_artifactsByPriority = this.getChildren(Artifact.class);
            THashMap orderMap = new THashMap();
            int i = 0;
            while (i < this.m_artifactsByPriority.size()) {
                orderMap.put(this.m_artifactsByPriority.get(i), i);
                ++i;
            }
            this.m_artifactsByPriority.sort((arg_0, arg_1) -> Artifact.lambda$1((Map)orderMap, arg_0, arg_1));
        }
        return this.m_artifactsByPriority;
    }

    public Match offerComponent(IAssignableToArtifact element) {
        ArchitectureElement.MatchCategory mc;
        assert (element != null) : "Parameter 'element' of method 'offerComponent' must not be null";
        if (this.m_templateClass != null) {
            mc = ArchitectureElement.MatchCategory.WEAK;
        } else if (this.hasIncludeFilters()) {
            mc = this.matches(element, false);
            if (mc == ArchitectureElement.MatchCategory.NONE) {
                return null;
            }
        } else {
            if (this.isExcluded(element)) {
                return null;
            }
            mc = ArchitectureElement.MatchCategory.NONE;
        }
        for (Artifact child : this.getArtifactsByPriority()) {
            Match match = child.offerComponent(element);
            if (match == null) continue;
            return match;
        }
        if (mc == ArchitectureElement.MatchCategory.STRONG_INHERITED ? (mc = this.matches(element, true)) == ArchitectureElement.MatchCategory.NONE : mc == ArchitectureElement.MatchCategory.NONE) {
            return null;
        }
        return new Match(this, mc);
    }

    public final String getClassName() {
        return this.m_className;
    }

    @Override
    public final String getImageResourceName() {
        if (this.isUnrestricted()) {
            if (this.isRequired()) {
                return "ArtifactUnrestrictedRequired";
            }
            if (this.isApplied()) {
                return "ArtifactUnrestrictedApplied";
            }
            return "ArtifactUnrestricted";
        }
        if (this.isStrict()) {
            if (this.isRequired()) {
                return "ArtifactStrictRequired";
            }
            if (this.isApplied()) {
                return "ArtifactStrictApplied";
            }
            return "ArtifactStrict";
        }
        if (this.isRelaxed()) {
            if (this.isRequired()) {
                return "ArtifactRelaxedRequired";
            }
            if (this.isApplied()) {
                return "ArtifactRelaxedApplied";
            }
            return "ArtifactRelaxed";
        }
        if (this.isRequired()) {
            return "ArtifactRequired";
        }
        if (this.isApplied()) {
            return "ArtifactApplied";
        }
        return "Artifact";
    }

    @Override
    public final boolean hasViolations() {
        return this.m_hasViolations;
    }

    @Override
    public final void setHasViolations(boolean hasViolations) {
        this.m_hasViolations = hasViolations;
    }

    @Override
    public final boolean hasDeprecations() {
        return this.m_hasDeprecations;
    }

    @Override
    public final void setHasDeprecations(boolean hasDeprecations) {
        this.m_hasDeprecations = hasDeprecations;
    }

    @Override
    public final ImageDecoratorInfo getImageResourceDecoratorInfo() {
        String warningOrErrorMarker = null;
        if (this.m_hasViolations || this.hasUnresolvedErrorIssues()) {
            warningOrErrorMarker = "ErrorMarker";
        } else if (this.m_hasDeprecations || this.hasUnresolvedWarningIssues()) {
            warningOrErrorMarker = "WarningMarker";
        }
        boolean isPublic = this.isPublic();
        boolean isHidden = this.isHidden();
        boolean isLocal = this.isLocal();
        if (warningOrErrorMarker != null || isPublic || isHidden || isLocal) {
            return new ImageDecoratorInfo(warningOrErrorMarker, isPublic ? "PublicMarker" : null, isHidden ? "HiddenMarker" : null, isLocal ? "LocalMarker" : null);
        }
        return null;
    }

    public final List<Connector> getConnectors() {
        if (this.m_connectors == null) {
            this.m_connectors = this.getChildren(Connector.class);
        }
        return this.m_connectors;
    }

    public final List<Interface> getInterfaces() {
        if (this.m_interfaces == null) {
            this.m_interfaces = this.getChildren(Interface.class);
        }
        return this.m_interfaces;
    }

    @Override
    public void assignComponent(IAssignableToArtifact assignable) {
        assert (assignable != null) : "Parameter 'assignable' of method 'assignComponent' must not be null";
        for (Connector connector : this.getConnectors()) {
            if (connector.matches(assignable, true) == ArchitectureElement.MatchCategory.NONE) continue;
            connector.assignComponent(assignable);
        }
        for (Interface iface : this.getInterfaces()) {
            if (iface.matches(assignable, true) == ArchitectureElement.MatchCategory.NONE) continue;
            iface.assignComponent(assignable);
        }
        if (this.m_isExternal && !assignable.isExternal()) {
            this.m_isExternal = false;
        }
        super.assignComponent(assignable);
    }

    @Override
    public final <T> T getArchitectureElement(String name, Class<T> clazz) {
        return this.getFirstChild(new ShortNameFilter(name), clazz);
    }

    public final Artifact getChildArtifact(String name) {
        return this.getFirstChild(new ShortNameFilter(name), Artifact.class);
    }

    @Override
    public final int getNumberOfAssignedElements() {
        int result = super.getNumberOfAssignedElements();
        for (Artifact child : this.getChildren(Artifact.class)) {
            result += child.getNumberOfAssignedElements();
        }
        return result;
    }

    @Override
    public final IStructureItem getStructureItem() {
        return ArchitectureStructureItem.ARTIFACT;
    }

    @Override
    public final Collection<Artifact> getConnectedElements() {
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>();
        ArrayList<Interface> connectedInterfaces = new ArrayList<Interface>();
        result.addAll(this.getChildren(Artifact.class));
        for (Connector conn : this.getConnectors()) {
            connectedInterfaces.addAll(conn.getConnectedCycleRelevantInterfaces());
        }
        for (Interface connectedInterface : connectedInterfaces) {
            result.add(connectedInterface.getParent(Artifact.class, new Class[0]));
            connectedInterface.getExportedInterfacesRecursively().forEach(i -> {
                boolean bl = result.add(i.getParent(Artifact.class, new Class[0]));
            });
        }
        return result;
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        assert (visitor != null) : "Parameter 'visitor' of method 'accept' must not be null";
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitArtifact(this);
        } else {
            super.accept(visitor);
        }
    }

    public static final List<String> getArtifactPathParts(String artifactPath) {
        assert (artifactPath != null && artifactPath.length() > 0) : "Parameter 'artifactPath' of method 'getArtifactPathParts' must not be empty";
        ArrayList<String> parts = new ArrayList<String>(5);
        int pos = artifactPath.indexOf(58);
        assert (pos != -1) : "'artifactPath' not valid: " + artifactPath;
        parts.add(artifactPath.substring(0, pos));
        String artifacts = artifactPath.substring(pos + 1);
        StringTokenizer tokenizer = new StringTokenizer(artifacts, ".");
        while (tokenizer.hasMoreElements()) {
            parts.add(tokenizer.nextToken());
        }
        return parts;
    }

    public static String getArtifactPath(FilePath inFile, Artifact artifact) {
        assert (inFile != null) : "Parameter 'inFile' of method 'getArtifactPath' must not be null";
        assert (artifact != null) : "Parameter 'artifact' of method 'getArtifactPath' must not be null";
        return inFile.getIdentifyingPath() + ":" + artifact.getName();
    }

    public boolean processRequiredReferences(Set<Artifact> unrequiredCollector) {
        boolean wasRemoved = false;
        if (this.isRequired()) {
            if (this.isReferenced()) {
                if (unrequiredCollector != null) {
                    unrequiredCollector.add(this);
                }
            } else {
                this.remove();
                wasRemoved = true;
            }
        }
        return wasRemoved;
    }

    @Property
    public final String getStereotypes() {
        if (this.m_stereoTypes == null || this.m_stereoTypes.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (StereoType next : this.m_stereoTypes) {
            builder.append(next.getPresentationName()).append(',');
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    public Set<StereoType> getStereotypesAsSet() {
        return Collections.unmodifiableSet(this.m_stereoTypes);
    }

    public boolean connectsTo(Interface iface) {
        for (Connector c : this.getConnectors()) {
            if (!c.connectsDirectlyToInterface(iface)) continue;
            return true;
        }
        return false;
    }

    public void collectNestedArtifacts(List<Artifact> collector) {
        for (Artifact artifact : this.getChildren(Artifact.class)) {
            collector.add(artifact);
            artifact.collectNestedArtifacts(collector);
        }
    }

    private static /* synthetic */ int lambda$1(Map map, Artifact c1, Artifact c2) {
        return c1.getPriority() == c2.getPriority() ? (Integer)map.get(c1) - (Integer)map.get(c2) : c2.getPriority() - c1.getPriority();
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitArtifact(Artifact var1);
    }

    public static final class Match {
        private final Artifact m_finalOwner;
        private final ArchitectureElement.MatchCategory m_matchCategory;

        public Match(Artifact finalOwner, ArchitectureElement.MatchCategory matchCategory) {
            this.m_finalOwner = finalOwner;
            this.m_matchCategory = matchCategory;
        }

        public Artifact getFinalOwner() {
            return this.m_finalOwner;
        }

        public boolean isStrong() {
            return this.m_matchCategory == ArchitectureElement.MatchCategory.STRONG;
        }
    }

    public static enum StereoType implements IStandardEnumeration
    {
        PUBLIC,
        HIDDEN,
        LOCAL,
        EXPOSED,
        OPTIONAL,
        DEPRECATED,
        UNRESTRICTED,
        RELAXED,
        STRICT;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

