/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.annotation;

import com.hello2morrow.sonargraph.core.model.annotation.AnnotationValue;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import java.io.IOException;

public final class NumericAnnotationValue
extends AnnotationValue {
    private Number m_number;

    public NumericAnnotationValue() {
    }

    public NumericAnnotationValue(Number number) {
        assert (number != null) : "Parameter 'number' of method 'NumericAnnotationValue' must not be null";
        this.m_number = number;
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        this.m_number = reader.readBoolean() ? (Number)Float.valueOf(reader.readFloat()) : (Number)reader.readLong();
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        if (this.m_number instanceof Double) {
            writer.writeBoolean(true);
            writer.writeFloat(this.m_number.floatValue());
        } else {
            writer.writeBoolean(false);
            writer.writeLong(this.m_number.longValue());
        }
    }

    @Override
    public Number asNumber() {
        return this.m_number;
    }

    public String toString() {
        return this.m_number.toString();
    }
}

