/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.representation;

import com.hello2morrow.sonargraph.core.model.architecture.AssignedElement;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.representation.IRepresentationProvider;
import java.util.Map;
import java.util.Set;

public final class ProgrammingElementCollector
extends NamedElementVisitor
implements ProgrammingElement.IVisitor,
LogicalProgrammingElement.IVisitor,
AssignedElement.IVisitor {
    private final IDomainRoot.Domain m_domain;
    private final PresentationMode m_presentationMode;
    private final Set<ProgrammingElement> m_programmingElementCollector;
    private final Map<IAssignableToArtifact, AssignedElement> m_componentToProxyCollector;
    private final NamedElement m_collectFor;
    private final Set<NamedElement> m_mainNodes;
    private final Set<NamedElement> m_additionalNodes;
    private final boolean m_dontCollectTypesRecursively;
    private final IRepresentationProvider m_representationProvider;

    public ProgrammingElementCollector(IRepresentationProvider representationProvider, IDomainRoot.Domain domain, PresentationMode presentationMode, Set<ProgrammingElement> programmingElementCollector, Map<IAssignableToArtifact, AssignedElement> componentToProxyCollector, NamedElement collectFor, Set<NamedElement> mainNodes, Set<NamedElement> additionalNodes, boolean dontCollectTypesRecursively) {
        assert (representationProvider != null) : "Parameter 'representationProvider' of method 'ProgrammingElementCollector' must not be null";
        assert (domain != null) : "Parameter 'domain' of method 'ProgrammingElementCollector' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'ProgrammingElementCollector' must not be null";
        assert (programmingElementCollector != null) : "Parameter 'programmingElementCollector' of method 'ProgrammingElementCollector' must not be null";
        assert (collectFor != null) : "Parameter 'collectFor' of method 'ProgrammingElementCollector' must not be null";
        assert (mainNodes != null) : "Parameter 'mainNodes' of method 'ProgrammingElementCollector' must not be null";
        assert (additionalNodes != null) : "Parameter 'additionalNodes' of method 'ProgrammingElementCollector' must not be null";
        this.m_representationProvider = representationProvider;
        this.m_domain = domain;
        this.m_presentationMode = presentationMode;
        this.m_programmingElementCollector = programmingElementCollector;
        this.m_componentToProxyCollector = componentToProxyCollector;
        this.m_collectFor = collectFor;
        this.m_mainNodes = mainNodes;
        this.m_additionalNodes = additionalNodes;
        this.m_dontCollectTypesRecursively = dontCollectTypesRecursively;
    }

    @Override
    public final void visitNamedElement(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitNamedElement' must not be null";
        if (this.m_collectFor == element || !this.m_mainNodes.contains(element) && !this.m_additionalNodes.contains(element)) {
            this.visitChildrenOf(element);
        }
    }

    @Override
    public final void visitProgrammingElement(ProgrammingElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitProgrammingElement' must not be null";
        if (this.m_dontCollectTypesRecursively) {
            assert (this.m_collectFor instanceof IType) : "Unexpected class in method 'visitProgrammingElement': " + String.valueOf(this.m_collectFor);
            if (element instanceof IType && element != this.m_collectFor) {
                return;
            }
        }
        if (this.m_collectFor == element || !this.m_mainNodes.contains(element) && !this.m_additionalNodes.contains(element)) {
            this.m_programmingElementCollector.add(element);
            this.visitChildrenOf(element);
        }
    }

    @Override
    public final void visitLogicalProgrammingElement(LogicalProgrammingElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitLogicalProgrammingElement' must not be null";
        if (this.m_dontCollectTypesRecursively) {
            assert (this.m_collectFor instanceof LogicalProgrammingElement && ((LogicalProgrammingElement)this.m_collectFor).getPrimaryProgrammingElement() instanceof IType) : "Unexpected class in method 'visitProgrammingElement': " + String.valueOf(this.m_collectFor);
            if (element.getPrimaryProgrammingElement() instanceof IType && !element.equals(this.m_collectFor)) {
                return;
            }
        }
        if (this.m_collectFor == element || !this.m_mainNodes.contains(element) && !this.m_additionalNodes.contains(element)) {
            this.m_programmingElementCollector.addAll(element.getProgrammingElements());
            this.visitChildrenOf(element);
        }
    }

    @Override
    public final void visitAssignedElement(AssignedElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitComponentProxy' must not be null";
        assert (this.m_componentToProxyCollector != null) : "'m_componentToProxyCollector' of method 'visitAssignedComponent' must not be null";
        NamedElement elementForProxy = element.getRepresentedElement();
        this.m_componentToProxyCollector.put((IAssignableToArtifact)((Object)elementForProxy), element);
        if (this.m_collectFor == element || !this.m_mainNodes.contains(element) && !this.m_additionalNodes.contains(element)) {
            if (elementForProxy instanceof LogicalProgrammingElement) {
                LogicalProgrammingElement lpe = (LogicalProgrammingElement)elementForProxy;
                this.m_programmingElementCollector.addAll(lpe.getProgrammingElements());
                this.visitChildrenOf(lpe);
            } else {
                if (elementForProxy instanceof ProgrammingElement) {
                    this.m_programmingElementCollector.add((ProgrammingElement)elementForProxy);
                }
                this.m_programmingElementCollector.addAll(elementForProxy.getChildrenRecursively(ProgrammingElement.class, new Class[0]));
            }
        }
    }

    @Override
    public final void visitChildrenOf(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitChildrenOf' must not be null";
        Set<NamedElement> children = this.m_representationProvider.getChildrenFromPresentationMode(element, this.m_domain, this.m_presentationMode, false);
        for (NamedElement next : children) {
            next.accept(this);
        }
    }
}

