/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.migration;

import com.hello2morrow.sonargraph.core.controller.system.migration.RegexBasedFileMigration;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.integration.access.foundation.MigrationCheck;

public final class QualityGateConditionIssueIdMigration
extends RegexBasedFileMigration {
    private static final String THRESHOLD_WARNING_PATTERN = "<(.*) issueType=\"ThresholdViolation\" (.*)severity=\"Any\"(.*)>";
    private static final String THRESHOLD_WARNING_REPLACEMENT = "<$1 issueType=\"ThresholdViolation\" $2severity=\"Warning\"$3>";
    private static final String THRESHOLD_ERROR_PATTERN = "<(.*) issueType=\"ThresholdViolationError\" (.*)severity=\"\\w*\"(.*)>";
    private static final String THRESHOLD_ERROR_REPLACEMENT = "<$1 issueType=\"ThresholdViolation\" $2severity=\"Error\"$3>";
    private static final String CRITICAL_CYCLE_GROUP_PATTERN = "<(.*)issueType=\"Critical(\\w*CycleGroup)\" (.*)severity=\"\\w*\"(.*)>";
    private static final String CRITCAL_CYCLE_GROUP_REPLACEMENT = "<$1issueType=\"$2\" $3severity=\"Error\"$4>";
    private static final String CYCLE_GROUP_PATTERN = "<(.*)issueType=\"(\\w*CycleGroup)\" (.*)severity=\"Any\"(.*)>";
    private static final String CYCLE_GROUP_REPLACEMENT = "<$1issueType=\"$2\" $3severity=\"Warning\"$4>";

    public QualityGateConditionIssueIdMigration(boolean writeToDisk, boolean migrateVersion) {
        super(CoreFileType.QUALITY_GATE, "qualityGate", writeToDisk, migrateVersion);
    }

    @Override
    protected String migrateContent(String original, OperationResult result) {
        assert (original != null && original.length() > 0) : "Parameter 'original' of method 'migrateContent' must not be empty";
        assert (result != null) : "Parameter 'result' of method 'migrateContent' must not be null";
        String migrated = original.replaceAll(THRESHOLD_WARNING_PATTERN, THRESHOLD_WARNING_REPLACEMENT);
        migrated = migrated.replaceAll(THRESHOLD_ERROR_PATTERN, THRESHOLD_ERROR_REPLACEMENT);
        migrated = migrated.replaceAll(CRITICAL_CYCLE_GROUP_PATTERN, CRITCAL_CYCLE_GROUP_REPLACEMENT);
        migrated = migrated.replaceAll(CYCLE_GROUP_PATTERN, CYCLE_GROUP_REPLACEMENT);
        return migrated;
    }

    @Override
    protected boolean needsMigration(String version) {
        assert (version != null && version.length() > 0) : "Parameter 'version' of method 'needsMigration' must not be empty";
        return MigrationCheck.isPreUnificationOfIssueIds((String)version);
    }
}

