/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.IExplorationViewRepresentationOwner;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExplorationViewLogger {
    private static Logger LOGGER = LoggerFactory.getLogger(ExplorationViewLogger.class);

    private ExplorationViewLogger() {
    }

    private static String getRepresentationInfo(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'getRepresentationInfo' must not be null";
        StringBuilder builder = new StringBuilder();
        builder.append("[").append(representation.getClass().getSimpleName()).append("]");
        builder.append(" ").append((Object)representation.getOperationMode()).append(",").append((Object)representation.getStructureMode()).append(",").append((Object)representation.getPresentationMode());
        if (representation.inInitialCreation()) {
            builder.append(",IN_INITIAL_CREATION");
        } else if (representation.inModification()) {
            builder.append(",IN_MODIFICATION");
        }
        if (representation.isInEditOperation()) {
            builder.append(",IN_EDIT_OPERATION");
        }
        if (representation.isInTransfer()) {
            builder.append(",IN_TRANSFER");
        }
        return builder.toString();
    }

    private static String getOwnerInfo(IExplorationViewRepresentationOwner owner) {
        assert (owner != null) : "Parameter 'owner' of method 'getOwnerInfo' must not be null";
        return "[" + owner.getClass().getSimpleName() + "] '" + owner.getId() + "' " + String.valueOf((Object)owner.getOperationMode());
    }

    private static String getElementsInfo(Collection<? extends ArchitecturalViewElement> elements) {
        int size;
        assert (elements != null) : "Parameter 'elements' of method 'getElementsInfo' must not be null";
        if (elements.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(" - Based on " + size + ((size = elements.size()) == 1 ? " element:" : " elements:"));
        for (ArchitecturalViewElement architecturalViewElement : elements) {
            builder.append("\n - ").append(architecturalViewElement.getElementInfo());
        }
        return builder.toString();
    }

    private static String getInfo(Collection<String> basedOn) {
        int size;
        assert (basedOn != null) : "Parameter 'basedOn' of method 'getInfo' must not be null";
        if (basedOn.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(" - based on " + size + ((size = basedOn.size()) == 1 ? " entry:" : " entries:"));
        for (String next : basedOn) {
            builder.append("\n - ").append(next);
        }
        return builder.toString();
    }

    private static String getDependenciesInfo(Collection<ArchitecturalViewNode.ArchitecturalViewDependency> dependencies) {
        int size;
        assert (dependencies != null) : "Parameter 'dependencies' of method 'getDependenciesInfo' must not be null";
        if (dependencies.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(" - based on " + size + ((size = dependencies.size()) == 1 ? " parser dependency:" : " parser dependencies:"));
        for (ArchitecturalViewNode.ArchitecturalViewDependency next : dependencies) {
            builder.append("\n - ").append(next.getFrom().getRelativePath()).append(" -> ").append(next.getTo().getRelativePath());
        }
        return builder.toString();
    }

    private static String getParserDependenciesInfo(Collection<? extends ParserDependency> parserDependencies) {
        int size;
        assert (parserDependencies != null) : "Parameter 'parserDependencies' of method 'getParserDependenciesInfo' must not be null";
        if (parserDependencies.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(" - based on " + size + ((size = parserDependencies.size()) == 1 ? " parser dependency:" : " parser dependencies:"));
        for (ParserDependency parserDependency : parserDependencies) {
            builder.append("\n - ").append(parserDependency);
        }
        return builder.toString();
    }

    private static String getMessage(String op, PresentationMode presentationMode, String info, ExplorationViewRepresentation representation) {
        assert (op != null && op.length() > 0) : "Parameter 'op' of method 'getMessage' must not be empty";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'getMessage' must not be null";
        assert (info != null) : "Parameter 'info' of method 'getMessage' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'getMessage' must not be null";
        return ExplorationViewLogger.getOwnerInfo(representation.getParent(IExplorationViewRepresentationOwner.class, new Class[0])) + " " + ExplorationViewLogger.getRepresentationInfo(representation) + " " + op + " '[" + String.valueOf((Object)presentationMode) + "]'" + (String)(!info.isEmpty() ? " (" + info + ")" : "");
    }

    static void logOp(String op, PresentationMode presentationMode, String info, ExplorationViewRepresentation representation) {
        assert (op != null && op.length() > 0) : "Parameter 'op' of method 'logOp' must not be empty";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'logOp' must not be null";
        assert (info != null) : "Parameter 'info' of method 'logOp' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'logOp' must not be null";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(ExplorationViewLogger.getMessage(op, presentationMode, info, representation));
        }
    }

    static void logOp(String op, PresentationMode presentationMode, String info, Collection<String> basedOn, ExplorationViewRepresentation representation) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'logOp' must not be null";
        assert (op != null && op.length() > 0) : "Parameter 'op' of method 'logOp' must not be empty";
        assert (info != null) : "Parameter 'info' of method 'logOp' must not be null";
        assert (basedOn != null) : "Parameter 'parserDependencies' of method 'logOp' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'logOp' must not be null";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(ExplorationViewLogger.getMessage(op, presentationMode, info, representation) + ExplorationViewLogger.getInfo(basedOn));
        }
    }

    static void logOpElementBased(String op, PresentationMode presentationMode, String info, List<? extends ArchitecturalViewElement> elements, ExplorationViewRepresentation representation) {
        assert (op != null && op.length() > 0) : "Parameter 'op' of method 'logOpElementBased' must not be empty";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'logOpElementBased' must not be null";
        assert (info != null) : "Parameter 'info' of method 'logOpElementBased' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'logOpElementBased' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'logOpElementBased' must not be null";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(ExplorationViewLogger.getMessage(op, presentationMode, info, representation) + ExplorationViewLogger.getElementsInfo(elements));
        }
    }

    static void logOpDependencyBased(String op, PresentationMode presentationMode, String info, Collection<ArchitecturalViewNode.ArchitecturalViewDependency> dependencies, ExplorationViewRepresentation representation) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'logOpDependencyBased' must not be null";
        assert (op != null && op.length() > 0) : "Parameter 'op' of method 'logOpDependencyBased' must not be empty";
        assert (info != null) : "Parameter 'info' of method 'logOpDependencyBased' must not be null";
        assert (dependencies != null) : "Parameter 'dependencies' of method 'logOpDependencyBased' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'logOpDependencyBased' must not be null";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(ExplorationViewLogger.getMessage(op, presentationMode, info, representation) + ExplorationViewLogger.getDependenciesInfo(dependencies));
        }
    }

    static void logOpParserDependencyBased(String op, PresentationMode presentationMode, String info, Collection<? extends ParserDependency> parserDependencies, ExplorationViewRepresentation representation) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'logOpParserDependencyBased' must not be null";
        assert (op != null && op.length() > 0) : "Parameter 'op' of method 'logOpParserDependencyBased' must not be empty";
        assert (info != null) : "Parameter 'info' of method 'logOpParserDependencyBased' must not be null";
        assert (parserDependencies != null) : "Parameter 'parserDependencies' of method 'logOpParserDependencyBased' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'logOpParserDependencyBased' must not be null";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(ExplorationViewLogger.getMessage(op, presentationMode, info, representation) + ExplorationViewLogger.getParserDependenciesInfo(parserDependencies));
        }
    }

    static void logStartModification(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'logStartModification' must not be null";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("<<Start modification>> " + ExplorationViewLogger.getOwnerInfo(representation.getParent(IExplorationViewRepresentationOwner.class, new Class[0])) + " " + ExplorationViewLogger.getRepresentationInfo(representation));
        }
    }

    static void logFinishModification(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'logFinishModification' must not be null";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("<<Finish modification>> " + ExplorationViewLogger.getOwnerInfo(representation.getParent(IExplorationViewRepresentationOwner.class, new Class[0])) + " " + ExplorationViewLogger.getRepresentationInfo(representation));
        }
    }

    public static String logLoad(IExplorationViewRepresentationOwner owner, PresentationMode presentationMode) {
        assert (owner != null) : "Parameter 'owner' of method 'logInteraction' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'logInteraction' must not be null";
        if (LOGGER.isDebugEnabled()) {
            String msg = "<<Load>> " + ExplorationViewLogger.getOwnerInfo(owner) + "," + String.valueOf((Object)presentationMode);
            LOGGER.debug(msg);
            return msg;
        }
        return "";
    }

    public static String logInteraction(String interaction, String additionalInfo, ExplorationViewRepresentation representation) {
        assert (interaction != null && interaction.length() > 0) : "Parameter 'interaction' of method 'logInteraction' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'logInteraction' must not be null";
        if (LOGGER.isDebugEnabled()) {
            String msg = "<<" + interaction + ">> " + ExplorationViewLogger.getOwnerInfo(representation.getParent(IExplorationViewRepresentationOwner.class, new Class[0])) + " " + ExplorationViewLogger.getRepresentationInfo(representation) + (String)(additionalInfo != null && !additionalInfo.isEmpty() ? "\n<Detail> " + additionalInfo : "");
            LOGGER.debug(msg);
            return msg;
        }
        return "";
    }

    public static void logDone(String msg, String additionalInfo) {
        assert (msg != null) : "Parameter 'msg' of method 'logDone' must not be null";
        if (LOGGER.isDebugEnabled()) {
            assert (msg.length() > 0) : "Parameter 'msg' of method 'logDone' must not be empty";
            LOGGER.debug(msg + (String)(additionalInfo != null && !additionalInfo.isEmpty() ? " <" + additionalInfo + ">" : "") + " - done");
        }
    }
}

