/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.base;

import com.hello2morrow.sonargraph.core.model.event.Modification;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModelModificationInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelModificationInfo.class);
    private boolean m_workspaceModelModified;
    private boolean m_physicalModelModified;
    private boolean m_logicalModelModified;
    private boolean m_architectureModelModified;
    private boolean m_refactoringsModified;
    private boolean m_issuesModified;

    public void physicalModelModified() {
        this.m_physicalModelModified = true;
    }

    public void logicalModelModified() {
        this.m_logicalModelModified = true;
    }

    public void architectureModelModified() {
        this.m_architectureModelModified = true;
    }

    public void issuesModified() {
        this.m_issuesModified = true;
    }

    public EnumSet<ModelModification> consumeModelModifications(EnumSet<Modification> modifications, boolean refactoringsModified, boolean issuesModified) {
        if (modifications != null) {
            LOGGER.debug("Processing incoming modifications");
            if (modifications.contains((Object)Modification.PARSER_MODEL_MODIFIED) || modifications.contains((Object)Modification.WORKSPACE_CLEARED) || modifications.contains((Object)Modification.WORKSPACE_MODIFIED)) {
                LOGGER.debug("Set physical model modified");
                this.m_physicalModelModified = true;
            }
            if (modifications.contains((Object)Modification.WORKSPACE_SETUP_MODIFIED)) {
                LOGGER.debug("Set workspace model modified");
                this.m_workspaceModelModified = true;
            }
            if (modifications.contains((Object)Modification.VIRTUAL_MODEL_MODIFIED)) {
                LOGGER.debug("Set issues modified");
                this.m_issuesModified = true;
            }
            if (modifications.contains((Object)Modification.REFACTORINGS_MODIFIED)) {
                LOGGER.debug("Set refactorings modified");
                this.m_refactoringsModified = true;
            }
            if (modifications.contains((Object)Modification.ARCHITECTURE_MODIFIED)) {
                LOGGER.debug("Set architecture model modified");
                this.m_architectureModelModified = true;
            }
        }
        EnumSet<ModelModification> modelModifications = EnumSet.noneOf(ModelModification.class);
        if (this.m_issuesModified || issuesModified) {
            LOGGER.debug("Issues modified");
            if (modifications != null) {
                modifications.add(Modification.VIRTUAL_MODEL_MODIFIED);
            }
            this.m_issuesModified = false;
            modelModifications.add(ModelModification.ISSUES_MODIFIED);
        }
        if (this.m_refactoringsModified || refactoringsModified) {
            LOGGER.debug("Refactorings modified");
            if (modifications != null) {
                modifications.add(Modification.REFACTORINGS_MODIFIED);
            }
            this.m_refactoringsModified = false;
        }
        if (this.m_workspaceModelModified) {
            LOGGER.debug("Workspace model modified");
            this.m_workspaceModelModified = false;
            modelModifications.add(ModelModification.WORKSPACE_MODEL_MODIFIED);
        }
        if (this.m_physicalModelModified) {
            LOGGER.debug("Physical model modified");
            this.m_physicalModelModified = false;
            modelModifications.add(ModelModification.PHYSICAL_MODEL_MODIFIED);
        }
        if (this.m_logicalModelModified) {
            LOGGER.debug("Logical model modified");
            this.m_logicalModelModified = false;
            modelModifications.add(ModelModification.LOGIGAL_MODEL_MODIFIED);
        }
        if (this.m_architectureModelModified) {
            LOGGER.debug("Architecture model modified");
            if (modifications != null) {
                modifications.add(Modification.ARCHITECTURE_MODIFIED);
            }
            this.m_architectureModelModified = false;
            modelModifications.add(ModelModification.ARCHITECTURE_MODEL_MODIFIED);
        }
        return modelModifications;
    }

    public boolean haveRefactoringsBeenModified() {
        return this.m_refactoringsModified;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.m_workspaceModelModified) {
            builder.append("Workspace model modified");
            builder.append("\n");
        }
        if (this.m_physicalModelModified) {
            builder.append("Physical model modified");
            builder.append("\n");
        }
        if (this.m_logicalModelModified) {
            builder.append("Logical model modified");
            builder.append("\n");
        }
        if (this.m_architectureModelModified) {
            builder.append("Architecture model modified");
            builder.append("\n");
        }
        if (this.m_refactoringsModified) {
            builder.append("Refactorings modified");
            builder.append("\n");
        }
        if (this.m_issuesModified) {
            builder.append("Issues modified");
            builder.append("\n");
        }
        return builder.toString();
    }

    public static enum ModelModification {
        ISSUES_MODIFIED,
        WORKSPACE_MODEL_MODIFIED,
        PHYSICAL_MODEL_MODIFIED,
        LOGIGAL_MODEL_MODIFIED,
        ARCHITECTURE_MODEL_MODIFIED;

    }
}

