/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.architecture;

import com.hello2morrow.sonargraph.core.controller.system.architecture.AssignableAttributeRetriever;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitecturalModelProvider;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;

public final class PhysicalFilterNameRetriever
extends AssignableAttributeRetriever<ProgrammingElement> {
    private static final String NAME = "PhysicalFilterName";

    @Override
    public boolean availableFor(IArchitecturalModelProvider.ArchitectureModel architectureModel) {
        assert (architectureModel != null) : "Parameter 'architectureModel' of method 'availableFor' must not be null";
        switch (architectureModel) {
            case LOGICAL: {
                return true;
            }
            case PHYSICAL: {
                return false;
            }
        }
        assert (false) : "Unhandled architecture model: " + String.valueOf((Object)architectureModel);
        return false;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public String getDescription(IArchitecturalModelProvider.ArchitectureModel architectureModel) {
        assert (architectureModel != null) : "Parameter 'architectureModel' of method 'getDescription' must not be null";
        assert (architectureModel.equals((Object)IArchitecturalModelProvider.ArchitectureModel.LOGICAL)) : "Unexpected model: " + String.valueOf((Object)architectureModel);
        return "Matches the pattern against the 'Architecture Filter Name Physical' of " + "Component".toLowerCase() + "s containing the corresponding " + "Top-Level Programming Element".toLowerCase() + ".\n\nAllows you to mix physical and logical assignment strategies.\n\nWildcards: ?=any character, *=any sequence between slashes, **=any sequence\n\nNote: Only available in the context of a logical model.";
    }

    @Override
    protected String computeAttributeForLogicalProgrammingElement(IWorkerContext workerContext, LogicalProgrammingElement assignable, String[] params) {
        assert (assignable != null) : "Parameter 'assignable' of method 'computeAttributeForLogicalProgrammingElement' must not be null";
        ProgrammingElement programmingElement = assignable.getPrimaryProgrammingElement();
        assert (programmingElement != null) : "'programmingElement' of method 'computeAttributeForLogicalProgrammingElement' must not be null";
        String datum = this.getDatum(programmingElement);
        if (datum == null) {
            IComponent component = programmingElement.getParent(IComponent.class, ParentMode.SELF_OR_FIRST_PARENT);
            assert (component != null) : "'component' of method 'computeAttributeForLogicalProgrammingElement' must not be null";
            datum = component.getArchitectureFilterName();
            assert (datum != null && datum.length() > 0) : "'datum' of method 'computeAttributeForLogicalProgrammingElement' must not be empty";
            this.setDatum(programmingElement, datum);
        }
        return this.createAttribute(datum);
    }
}

