/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.architecture;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

final class AutoCompletionArtifact {
    private final String m_identifyingPath;
    private final String m_fullName;
    private final String m_name;
    private final int m_startLine;
    private final boolean m_isExposed;
    private AutoCompletionArtifact m_parent;
    private Set<AutoCompletionArtifact> m_artifacts;
    private Set<String> m_interfaces;
    private Set<String> m_connectors;
    private int m_endLine;
    private int m_curlyBraces;

    AutoCompletionArtifact(String identifyingPath, String fullName, String name, int startLine, boolean isExposed) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'AutoCompletionArtifact' must not be empty";
        assert (fullName != null && fullName.length() > 0) : "Parameter 'fullName' of method 'AutoCompletionArtifact' must not be empty";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'AutoCompletionArtifact' must not be empty";
        this.m_identifyingPath = identifyingPath;
        this.m_fullName = fullName;
        this.m_name = name;
        this.m_startLine = startLine;
        this.m_isExposed = isExposed;
    }

    List<AutoCompletionArtifact> getArtifactChain() {
        if (this.m_parent == null) {
            return Collections.singletonList(this);
        }
        ArrayList<AutoCompletionArtifact> chain = new ArrayList<AutoCompletionArtifact>();
        AutoCompletionArtifact current = this;
        while (current != null) {
            chain.add(0, current);
            current = current.m_parent;
        }
        return Collections.unmodifiableList(chain);
    }

    boolean isChildOf(AutoCompletionArtifact potentialParent) {
        assert (potentialParent != null) : "Parameter 'potentialParent' of method 'isChildOf' must not be null";
        if (this.m_parent != null) {
            if (this.m_parent == potentialParent) {
                return true;
            }
            return this.m_parent.isChildOf(potentialParent);
        }
        return false;
    }

    String getFullName() {
        return this.m_fullName;
    }

    String getName() {
        return this.m_name;
    }

    boolean isExposed() {
        return this.m_isExposed;
    }

    int inc() {
        ++this.m_curlyBraces;
        return this.m_curlyBraces;
    }

    int dec() {
        --this.m_curlyBraces;
        return this.m_curlyBraces;
    }

    int getStartLine() {
        return this.m_startLine;
    }

    void setEndline(int line) {
        this.m_endLine = line;
    }

    int getEndline() {
        return this.m_endLine;
    }

    void addArtifact(AutoCompletionArtifact artifact) {
        assert (artifact != null) : "Parameter 'artifact' of method 'addArtifact' must not be null";
        if (this.m_artifacts == null) {
            this.m_artifacts = new THashSet();
        }
        this.m_artifacts.add(artifact);
        artifact.m_parent = this;
    }

    Set<AutoCompletionArtifact> getArtifacts() {
        return this.m_artifacts != null ? Collections.unmodifiableSet(this.m_artifacts) : Collections.emptySet();
    }

    void addInterface(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'addInterface' must not be empty";
        if (this.m_interfaces == null) {
            this.m_interfaces = new THashSet();
        }
        this.m_interfaces.add(name);
    }

    Set<String> getInterfaces() {
        return this.m_interfaces != null ? Collections.unmodifiableSet(this.m_interfaces) : Collections.emptySet();
    }

    void addConnector(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'addConnector' must not be empty";
        if (this.m_connectors == null) {
            this.m_connectors = new THashSet();
        }
        this.m_connectors.add(name);
    }

    public Set<String> getConnectors() {
        return this.m_connectors != null ? Collections.unmodifiableSet(this.m_connectors) : Collections.emptySet();
    }

    public String toString() {
        Set<AutoCompletionArtifact> artifacts;
        Set<String> interfaces;
        StringBuilder builder = new StringBuilder();
        builder.append("[").append(this.m_identifyingPath).append("] ");
        if (this.isExposed()) {
            builder.append("exposed ");
        }
        builder.append("artifact ").append(this.m_fullName).append(" (").append(this.m_name).append(") [").append(this.m_startLine).append("-").append(this.m_endLine).append("] <").append(this.m_curlyBraces).append(">");
        Set<String> connectors = this.getConnectors();
        if (!connectors.isEmpty()) {
            builder.append("\nConnectors [").append(connectors.size()).append("]");
            for (String next : connectors) {
                builder.append("\n").append(next);
            }
        }
        if (!(interfaces = this.getInterfaces()).isEmpty()) {
            builder.append("\nInterfaces [").append(interfaces.size()).append("]");
            for (String next : interfaces) {
                builder.append("\n Interfaces: ").append(next);
            }
        }
        if (!(artifacts = this.getArtifacts()).isEmpty()) {
            builder.append("\nNested artifacts [").append(artifacts.size()).append("]");
            for (AutoCompletionArtifact next : artifacts) {
                builder.append("\n <Nested> ").append(next);
            }
        }
        return builder.toString();
    }
}

