/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.architecture;

import com.hello2morrow.sonargraph.core.controller.system.architecture.IReplaceStrategy;
import java.util.Map;

final class ArchitectureFileNameReplaceStrategy
implements IReplaceStrategy {
    private static final String QUOTATION_MARK = "\"";
    private final Map<String, String> m_replacementMap;

    ArchitectureFileNameReplaceStrategy(Map<String, String> replacementMap) {
        assert (!replacementMap.isEmpty());
        this.m_replacementMap = replacementMap;
    }

    private static String removeQuotationMarks(String text) {
        assert (text != null) : "Parameter 'text' of method 'hasQuotationMarks' must not be null";
        if (text.startsWith(QUOTATION_MARK) && text.endsWith(QUOTATION_MARK)) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    private static String addQuotationMarks(String text) {
        assert (text != null) : "Parameter 'text' of method 'addQuotationMarks' must not be null";
        return QUOTATION_MARK + text + QUOTATION_MARK;
    }

    @Override
    public String replace(String text) {
        assert (text != null && text.length() > 0) : "Parameter 'text' of method 'replace' must not be empty";
        text = ArchitectureFileNameReplaceStrategy.removeQuotationMarks(text);
        String replacement = this.m_replacementMap.get(text);
        assert (replacement != null);
        return ArchitectureFileNameReplaceStrategy.addQuotationMarks(replacement);
    }
}

