/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.coupling;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.coupling.AbstractDependencyMetricsModuleAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.foundation.common.graph.IOutgoingDependencyCumulatorAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.graph.OutgoingDependencyCumulator;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.element.CoreProviderId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.metrics.ValueList;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapter;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Module;

public final class OutgoingDependencyMetricsModule
extends AbstractDependencyMetricsModuleAdapter {
    public static final IConfigurableAnalyzerId ID = CoreAnalyzerId.OUTGOING_DEPENDENCY_METRICS_MODULE;
    private final IMetricDescriptor m_acdMetric;
    private final IMetricDescriptor m_ccdMetric;
    private final IMetricDescriptor m_nccdMetric;
    private final IMetricDescriptor m_dependsUponModule;
    private final IMetricDescriptor m_maxAcdDescriptor;
    private final IMetricDescriptor m_fanOutDescriptor;
    private final IMetricDescriptor m_propagationCostDescriptor;

    public OutgoingDependencyMetricsModule(IAnalyzerController controller) {
        super(controller, ID);
        MetricProvider mp = this.getInstallation().getExtension(IMetricsProvider.class).getMetricProvider(CoreProviderId.INSTANCE);
        this.m_acdMetric = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_ACD, CoreMetricLevel.MODULE, null);
        this.m_ccdMetric = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CCD, CoreMetricLevel.MODULE, null);
        this.m_propagationCostDescriptor = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_PROPAGATION_COST, CoreMetricLevel.MODULE, null);
        this.m_nccdMetric = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_NCCD, CoreMetricLevel.MODULE, null);
        this.m_dependsUponModule = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_DEPENDS_UPON_MODULE, CoreMetricLevel.COMPONENT, null);
        this.m_fanOutDescriptor = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_FAN_OUT_MODULE, CoreMetricLevel.COMPONENT, null);
        this.m_maxAcdDescriptor = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_MAX_ACD, CoreMetricLevel.SYSTEM, null);
    }

    @Override
    public void runJobs(AnalyzerResult result) {
        OutgoingDependencyMetricsModuleJob job = new OutgoingDependencyMetricsModuleJob(this.getGroup(), result, this.getController());
        job.start();
    }

    private class OutgoingDependencyMetricsModuleJob
    extends AbstractDependencyMetricsModuleAdapter.DependencyMetricsModuleJob
    implements IOutgoingDependencyCumulatorAdapter {
        private final ValueList m_ccdList;
        private final ValueList m_acdList;
        private final ValueList m_nccdList;
        private final ValueList m_propagationCostList;
        private NamedElement m_currentModule;
        private ValueList m_currentDependsUponList;
        private ValueList m_currentFanOutList;
        private float m_maxAcd;

        private OutgoingDependencyMetricsModuleJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller) {
            super(group, result, controller);
            SoftwareSystem softwareSystem = this.getSoftwareSystem();
            this.m_ccdList = OutgoingDependencyMetricsModule.this.createValueList(result, OutgoingDependencyMetricsModule.this.m_ccdMetric, softwareSystem);
            this.m_acdList = OutgoingDependencyMetricsModule.this.createValueList(result, OutgoingDependencyMetricsModule.this.m_acdMetric, null);
            this.m_nccdList = OutgoingDependencyMetricsModule.this.createValueList(result, OutgoingDependencyMetricsModule.this.m_nccdMetric, null);
            this.m_propagationCostList = OutgoingDependencyMetricsModule.this.createValueList(result, OutgoingDependencyMetricsModule.this.m_propagationCostDescriptor, null);
        }

        @Override
        protected void processModule(Module module, NodeAdapterSet<ParserDependencyNodeAdapter> nodeAdapterSet) {
            assert (module != null) : "Parameter 'module' of method 'calculateDependencyMetrics' must not be null";
            this.m_currentModule = module;
            this.m_currentDependsUponList = OutgoingDependencyMetricsModule.this.createValueList(this.getResult(), OutgoingDependencyMetricsModule.this.m_dependsUponModule, module);
            this.m_currentFanOutList = OutgoingDependencyMetricsModule.this.createValueList(this.getResult(), OutgoingDependencyMetricsModule.this.m_fanOutDescriptor, module);
            if (nodeAdapterSet != null && !nodeAdapterSet.getNodes().isEmpty()) {
                new OutgoingDependencyCumulator(nodeAdapterSet.getNodes(), this.getWorkerContext(), this);
            }
            this.m_currentModule = null;
        }

        @Override
        public void internalRun() {
            super.internalRun();
            OutgoingDependencyMetricsModule.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), Float.valueOf(this.m_maxAcd), OutgoingDependencyMetricsModule.this.m_maxAcdDescriptor);
        }

        @Override
        public final void setDependsUpon(INode<?> node, int dependsUpon) {
            assert (node != null) : "Parameter 'node' of method 'setDependsUpon' must not be null";
            this.m_currentDependsUponList.addValue(((ParserDependencyNodeAdapter)node).getUnderlyingObject(), dependsUpon);
        }

        @Override
        public final void setCumulativeComponentDependency(int ccd) {
            this.m_ccdList.addValue(this.m_currentModule, ccd);
        }

        @Override
        public final void setAverageComponentDependency(float acd) {
            this.m_acdList.addValue(this.m_currentModule, Float.valueOf(acd));
            if (acd > this.m_maxAcd) {
                this.m_maxAcd = acd;
            }
        }

        @Override
        public final void setPropagationCost(float propagationCost) {
            this.m_propagationCostList.addValue(this.m_currentModule, Float.valueOf(propagationCost));
        }

        @Override
        public final void setNormalizedCumulativeComponentDependency(float nccd) {
            this.m_nccdList.addValue(this.m_currentModule, Float.valueOf(nccd));
        }

        @Override
        public void setFanOut(INode<?> node, float fanOut) {
            this.m_currentFanOutList.addValue(((ParserDependencyNodeAdapter)node).getUnderlyingObject(), Float.valueOf(fanOut));
        }

        @Override
        public boolean isNodeIncluded(INode<?> node) {
            assert (node != null) : "Parameter 'node' of method 'isNodeIncluded' must not be null";
            NamedElement namedElement = ((ParserDependencyNodeAdapter)node).getUnderlyingObject();
            return !namedElement.ignoreIssues();
        }
    }
}

