/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.base;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerWorkerContext;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.model.analysis.Analyzer;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerJobElement;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerState;
import com.hello2morrow.sonargraph.core.model.analysis.IAnalyzerJob;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AnalyzerJob
implements IAnalyzerJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyzerJob.class);
    private final AnalyzerGroup m_analyzerGroup;
    private final AnalyzerResult m_result;
    private final AnalyzerWorkerContext m_workerContext;
    private final IAnalyzerController m_controller;
    private final List<AnalyzerResult> m_requiredResults;
    private AnalyzerJobElement m_jobElement;

    protected AnalyzerJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller, Collection<AnalyzerResult> requiredResults) {
        assert (group != null) : "Parameter 'group' of method 'AnalyzerJob' must not be null";
        assert (result != null) : "Parameter 'result' of method 'AnalyzerJob' must not be null";
        assert (controller != null) : "Parameter 'controller' of method 'AnalyzerJob' must not be null";
        assert (requiredResults != null) : "Parameter 'requiredResults' of method 'AnalyzerJob' must not be null";
        for (AnalyzerResult nextResult : requiredResults) {
            assert (nextResult != null) : "'nextResult' of method 'AnalyzerJob' must not be null";
        }
        this.m_analyzerGroup = group;
        this.m_result = result;
        this.m_controller = controller;
        this.m_workerContext = new AnalyzerWorkerContext(controller, this);
        this.m_requiredResults = requiredResults.isEmpty() ? Collections.emptyList() : new ArrayList<AnalyzerResult>(requiredResults);
    }

    protected AnalyzerJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller) {
        this(group, result, controller, Collections.emptyList());
    }

    @Override
    public final AnalyzerGroup getAnalyzerGroup() {
        return this.m_analyzerGroup;
    }

    public final SoftwareSystem getSoftwareSystem() {
        return this.m_controller.getSoftwareSystem();
    }

    public final Installation getInstallation() {
        return this.m_controller.getInstallation();
    }

    @Override
    public final AnalyzerResult getResult() {
        return this.m_result;
    }

    protected final boolean dependsOnOtherAnalyzers() {
        return !this.m_requiredResults.isEmpty();
    }

    public final Analyzer getAnalyzer() {
        return this.m_result.getParent(Analyzer.class, new Class[0]);
    }

    public final IWorkerContext getWorkerContext() {
        return this.m_workerContext;
    }

    protected float percentage(int value, int reference) {
        if (reference == 0) {
            return 0.0f;
        }
        return (float)value * 100.0f / (float)reference;
    }

    protected final List<AnalyzerResult> getRequiredResults() {
        assert (this.m_requiredResults != null && !this.m_requiredResults.isEmpty()) : "'m_requiredResults' of method 'getRequiredResults' must not be empty";
        for (AnalyzerResult next : this.m_requiredResults) {
            assert (next.getState() == AnalyzerState.FINISHED) : "Required result not FINISHED for: " + String.valueOf(next.getId());
        }
        return Collections.unmodifiableList(this.m_requiredResults);
    }

    public final void start() {
        this.m_jobElement = new AnalyzerJobElement(this.m_result, this.getName());
        this.m_result.addChild(this.m_jobElement);
        this.m_result.incrementNumberOfRunningJobs();
        if (!this.m_controller.submitJob(this, this.dependsOnOtherAnalyzers())) {
            this.m_result.decrementNumberOfRunningJobs();
        }
    }

    @Override
    public AnalyzerJobElement getElement() {
        return this.m_jobElement;
    }

    @Override
    public String getName() {
        return this.getAnalyzer().getName();
    }

    @Override
    public AnalyzerState getState() {
        return this.m_jobElement.getState();
    }

    @Override
    public final void cancel() {
        this.m_workerContext.cancel();
    }

    protected abstract void internalRun();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void awaitRequiredResultAndRun() {
        ArrayList<AnalyzerResult> frozen;
        block31: {
            Iterator iterator;
            Iterator iterator2;
            if (!$assertionsDisabled) {
                if (this.m_requiredResults == null) throw new AssertionError((Object)"'m_requiredResults' of method 'awaitRequiredResultAndRun' must not be empty");
                if (this.m_requiredResults.isEmpty()) {
                    throw new AssertionError((Object)"'m_requiredResults' of method 'awaitRequiredResultAndRun' must not be empty");
                }
            }
            frozen = new ArrayList<AnalyzerResult>(this.m_requiredResults.size());
            try {
                try {
                    AnalyzerState state = null;
                    int numberOfRequiredResults = this.m_requiredResults.size();
                    Iterator<AnalyzerResult> iterator3 = this.m_requiredResults.iterator();
                    while (true) {
                        AnalyzerResult nextAnalyzerResult;
                        if (!iterator3.hasNext()) {
                            if (numberOfRequiredResults != frozen.size() || this.m_workerContext.hasBeenCanceled()) break;
                            try {
                                this.internalRun();
                            }
                            catch (Throwable throwable) {
                                this.m_controller.exceptionCaught("Exception in AnalyzerJob.awaitRequiredResultAndRun() executing internalRun() in analyzer '" + this.getName() + "'", throwable);
                            }
                            break block31;
                        }
                        AnalyzerResult analyzerResult = nextAnalyzerResult = iterator3.next();
                        synchronized (analyzerResult) {
                            state = nextAnalyzerResult.getState();
                            if (!(state != AnalyzerState.RUNNING && state != AnalyzerState.HAS_NOT_BEEN_RUN || this.m_workerContext.hasBeenCanceled())) {
                                do {
                                    nextAnalyzerResult.wait();
                                } while ((state = nextAnalyzerResult.getState()) == AnalyzerState.RUNNING && !this.m_workerContext.hasBeenCanceled());
                            }
                            if (state.isEndState()) {
                                nextAnalyzerResult.freeze();
                                frozen.add(nextAnalyzerResult);
                            }
                        }
                    }
                    this.cancel();
                    break block31;
                }
                catch (Throwable t) {
                    this.cancel();
                    this.m_controller.exceptionCaught("Exception in AnalyzerJob.awaitRequiredResultAndRun() in analyzer '" + this.getName() + "'", t);
                    iterator2 = frozen.iterator();
                }
            }
            catch (Throwable throwable) {
                iterator = frozen.iterator();
            }
            while (true) {
                AnalyzerResult nextAnalyzerResult;
                if (!iterator2.hasNext()) {
                    return;
                }
                AnalyzerResult analyzerResult = nextAnalyzerResult = (AnalyzerResult)iterator2.next();
                synchronized (analyzerResult) {
                    nextAnalyzerResult.unfreeze();
                }
            }
            while (true) {
                AnalyzerResult nextAnalyzerResult;
                if (!iterator.hasNext()) {
                    throw throwable;
                }
                AnalyzerResult analyzerResult = nextAnalyzerResult = (AnalyzerResult)iterator.next();
                synchronized (analyzerResult) {
                    nextAnalyzerResult.unfreeze();
                }
            }
        }
        Iterator iterator = frozen.iterator();
        while (iterator.hasNext()) {
            AnalyzerResult nextAnalyzerResult;
            AnalyzerResult analyzerResult = nextAnalyzerResult = (AnalyzerResult)iterator.next();
            synchronized (analyzerResult) {
                nextAnalyzerResult.unfreeze();
            }
        }
        return;
    }

    @Override
    public final void run() {
        block10: {
            try {
                try {
                    this.m_workerContext.start(this.getName());
                    this.m_jobElement.setState(AnalyzerState.RUNNING);
                    if (this.m_requiredResults.isEmpty()) {
                        try {
                            this.internalRun();
                        }
                        catch (Throwable throwable) {
                            this.m_controller.exceptionCaught("Exception in AnalyzerJob.run() executing internalRun() in analyzer '" + this.getName() + "'", throwable);
                        }
                    } else {
                        this.awaitRequiredResultAndRun();
                    }
                    if (!this.m_workerContext.hasBeenCanceled()) {
                        LOGGER.debug("Analyzer job '{}' finished", (Object)this.getName());
                        this.m_workerContext.stop();
                        this.m_jobElement.setState(AnalyzerState.FINISHED);
                        break block10;
                    }
                    LOGGER.debug("Analyzer job '{}' cancelled", (Object)this.getName());
                    this.m_jobElement.setState(AnalyzerState.CANCELLED);
                }
                catch (Throwable t) {
                    this.m_controller.exceptionCaught("Exception in AnalyzerJob.run() in analyzer '" + this.getName() + "'", t);
                    this.m_result.decrementNumberOfRunningJobs();
                    this.m_controller.finishedJob(this);
                }
            }
            finally {
                this.m_result.decrementNumberOfRunningJobs();
                this.m_controller.finishedJob(this);
            }
        }
    }

    public String toString() {
        return this.getName();
    }
}

