/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.LanguageProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderAccessor;
import com.hello2morrow.sonargraph.core.controller.system.PersistenceAccessor;
import com.hello2morrow.sonargraph.core.controller.system.SoftwareSystemDataTransferExtension;
import com.hello2morrow.sonargraph.core.controller.system.WorkspaceExtension;
import com.hello2morrow.sonargraph.core.controller.system.base.AbstractUndoRedoProvider;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.foundation.common.history.FileHistoryOperation;
import com.hello2morrow.sonargraph.core.foundation.common.history.ModifiableFileHistory;
import com.hello2morrow.sonargraph.core.foundation.common.history.RestoreStateDto;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFile;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.ModifiableModel;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemFileEntry;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemFileHistory;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemState;
import com.hello2morrow.sonargraph.core.model.transaction.AnalyzerExecutionInfo;
import com.hello2morrow.sonargraph.core.model.transaction.TransactionContext;
import com.hello2morrow.sonargraph.core.persistence.system.XmlSystemPersistenceProvider;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import de.schlichtherle.truezip.file.TFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class SoftwareSystemUndoRedoProvider
extends AbstractUndoRedoProvider {
    private final SoftwareSystem m_softwareSystem;
    private final LanguageProviderAccessor m_languageProviderAccessor;
    private final PersistenceAccessor m_persistenceAccessor;
    private SoftwareSystemFileHistory m_softwareSystemFileHistory;

    public SoftwareSystemUndoRedoProvider(SoftwareSystem system, LanguageProviderAccessor languageProviderAccessor, PersistenceAccessor persistenceAccessor) {
        assert (system != null) : "Parameter 'system' of method 'SoftwareSystemUndoRedoProvider' must not be null";
        assert (languageProviderAccessor != null) : "Parameter 'languageProviderAccessor' of method 'SoftwareSystemUndoRedoProvider' must not be null";
        assert (persistenceAccessor != null) : "Parameter 'persistenceAccessor' of method 'SoftwareSystemUndoRedoProvider' must not be null";
        this.m_softwareSystem = system;
        this.m_languageProviderAccessor = languageProviderAccessor;
        this.m_persistenceAccessor = persistenceAccessor;
    }

    @Override
    public List<Class<? extends IModifiableFile>> getModifiableFileClasses() {
        return Collections.singletonList(SoftwareSystemFile.class);
    }

    @Override
    public AnalyzerExecutionInfo getAnalyzerExecutionInfo(String identifyingPath, RestoreStateDto restoreDto) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'getAnalyzerExecutionInfo' must not be empty";
        return AnalyzerExecutionInfo.all();
    }

    @Override
    public void writeModifiableFileToStream(IModifiableFile file, OutputStream stream, OperationResult result) {
        assert (file instanceof SoftwareSystemFile) : "Unexpected class: " + file.getClass().getName();
        assert (stream != null) : "Parameter 'stream' of method 'writeContentToStream' must not be null";
        assert (result != null) : "Parameter 'result' of method 'writeModifiableFileToStream' must not be null";
        try {
            this.m_persistenceAccessor.getPersistence(this.m_languageProviderAccessor.getAvailableLanguages()).writeToStream(this.m_softwareSystem, this.m_softwareSystem.getClassLoader(), stream);
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)ex);
        }
    }

    public OperationResultWithOutcome<SoftwareSystemFile> restoreModifiableFileFromStream(InputStream inputStream, RestoreStateDto dto, EnumSet<Modification> determinedModifications, List<String> otherFilesOfTx) {
        assert (inputStream != null) : "Parameter 'inputStream' of method 'restoreModifiableFileFromStream' must not be null";
        assert (dto != null) : "Parameter 'dto' of method 'restoreModifiableFileFromStream' must not be null";
        assert (determinedModifications != null) : "Parameter 'determinedModifications' of method 'restoreModifiableFileFromStream' must not be null";
        assert (otherFilesOfTx != null) : "Parameter 'otherFilesOfTx' of method 'restoreModifiableFileFromStream' must not be null";
        OperationResultWithOutcome restoreResult = new OperationResultWithOutcome("Restore software system");
        XmlSystemPersistenceProvider persistence = this.m_persistenceAccessor.getPersistence(this.m_languageProviderAccessor.getAvailableLanguages());
        OperationResultWithOutcome<SoftwareSystem> result = persistence.readFromStream(this.m_softwareSystem, inputStream, dto.getModifiableFilePath());
        if (result.isFailure()) {
            restoreResult.addMessagesFrom(result);
            return restoreResult;
        }
        boolean previousClearable = this.m_softwareSystem.isClearable();
        Set<Language> previousLanguages = this.m_softwareSystem.getUsedLanguages();
        SoftwareSystem system = (SoftwareSystem)result.getOutcome();
        assert (system.getName().equals(this.m_softwareSystem.getName())) : "Rename of system not supported by history";
        Installation installation = this.m_softwareSystem.getExtension(ISoftwareSystemProvider.class).getInstallation();
        for (LanguageProvider nextLp : this.m_languageProviderAccessor.getLanguageProviders(system.getUsedLanguages())) {
            nextLp.finishLoadFromPersistence(installation, system, (OperationResult)restoreResult, true);
        }
        ModifiableModel modifiableModel = this.m_softwareSystem.getExtension(WorkspaceExtension.class).switchToFactsModel();
        SoftwareSystemDataTransferExtension transferExtension = this.m_softwareSystem.getExtension(SoftwareSystemDataTransferExtension.class);
        determinedModifications.addAll(transferExtension.transferDataInSoftwareSystemRestore(this.m_languageProviderAccessor, system, this.m_softwareSystem));
        this.m_softwareSystem.getExtensions().forEach(e -> e.finishSoftwareSystemInitializationInRestore((OperationResult)result));
        WorkspaceExtension workspaceExtension = this.m_softwareSystem.getExtension(WorkspaceExtension.class);
        if (!previousLanguages.equals(this.m_softwareSystem.getUsedLanguages())) {
            determinedModifications.add(Modification.AVAILABLE_LANGUAGES_MODIFIED);
            HashSet<Language> added = new HashSet<Language>(this.m_softwareSystem.getUsedLanguages());
            added.removeAll(previousLanguages);
            HashSet<Language> removed = new HashSet<Language>(previousLanguages);
            removed.removeAll(this.m_softwareSystem.getUsedLanguages());
            workspaceExtension.availableLanguagesModifiedInUndoRedo((Set<Language>)added, (Set<Language>)removed, (OperationResult)result);
        }
        this.m_softwareSystem.consumeNeedsReparseModification();
        system.remove();
        SoftwareSystemFileEntry currentEntry = (SoftwareSystemFileEntry)dto.getCurrentStateFileEntry();
        if (currentEntry.getNeedsReparseState()) {
            WorkspaceExtension.setNeedsReparse(this.m_softwareSystem, (OperationResult)restoreResult);
        } else {
            this.m_softwareSystem.setNeedsReparse(false);
        }
        this.m_softwareSystem.consumeNeedsReparseModification();
        boolean modelLoaded = workspaceExtension.isClearable();
        if (!modelLoaded) {
            if (previousClearable) {
                determinedModifications.add(Modification.WORKSPACE_CLEARED);
            }
            this.m_languageProviderAccessor.getLanguageProviders(this.m_softwareSystem.getUsedLanguages()).forEach(lp -> lp.clear(this.m_softwareSystem, false));
            this.m_softwareSystem.setState(SoftwareSystemState.OPENED);
            workspaceExtension.refreshWorkspaceDependencies(determinedModifications);
        }
        this.m_softwareSystem.setIsClearable(modelLoaded);
        if (modifiableModel != null) {
            this.m_softwareSystem.getExtension(WorkspaceExtension.class).finishSwitchToFactsModel(modifiableModel, determinedModifications);
        }
        restoreResult.setOutcome((Object)this.m_softwareSystem.getUniqueExistingChild(Files.class).getSoftwareSystemFile());
        return restoreResult;
    }

    @Override
    public void updateState(IModifiableFile file, ModifiableFileHistory.FileHistoryEntry entry, boolean invalidatesParserModel) {
        assert (file != null) : "Parameter 'file' of method 'updateState' must not be null";
        assert (file instanceof SoftwareSystemFile) : "Unexpected class: " + file.getClass().getName();
        assert (file == this.m_softwareSystem.getUniqueExistingChild(Files.class).getSoftwareSystemFile()) : "file must be identical to softwareSystemFile";
        assert (entry != null) : "Parameter 'entry' of method 'updateState' must not be null";
        assert (entry instanceof SoftwareSystemFileEntry) : "Unexpected class: " + entry.getClass().getName();
        super.updateState(file, entry, invalidatesParserModel);
        SoftwareSystemFileEntry systemEntry = (SoftwareSystemFileEntry)entry;
        systemEntry.setNeedsReparseState(this.m_softwareSystem.needsReparse(), true, invalidatesParserModel);
    }

    @Override
    public ModifiableFileHistory createFileHistory(String name, String fileId) {
        this.m_softwareSystemFileHistory = new SoftwareSystemFileHistory(name, fileId);
        return this.m_softwareSystemFileHistory;
    }

    @Override
    public List<ModifiableFileHistory.FileHistoryEntry> createEntry(TransactionContext context, IModifiableFile historyFile, ModifiableFileHistory history, boolean needsSave, TFile stateFile) {
        assert (context != null) : "Parameter 'context' of method 'createEntry' must not be null";
        assert (historyFile != null) : "Parameter 'historyFile' of method 'createEntry' must not be null";
        assert (history != null) : "Parameter 'history' of method 'createEntry' must not be null";
        assert (history instanceof SoftwareSystemFileHistory) : "Unexpected class: " + history.getClass().getName();
        assert (stateFile != null) : "Parameter 'stateFile' of method 'createEntry' must not be null";
        List<ModifiableFileHistory.FileHistoryEntry> toBeRemoved = super.createEntry(context, historyFile, history, needsSave, stateFile);
        SoftwareSystemFileEntry fileEntry = (SoftwareSystemFileEntry)history.getLastAddedEntry();
        fileEntry.setNeedsReparseFlagModification(context.getNeedsReparseFlagModification());
        fileEntry.setInvalidatesParserModel(context.invalidatesParserModel());
        fileEntry.setNeedsReparseState(this.m_softwareSystem.needsReparse());
        return toBeRemoved;
    }

    @Override
    public String getConfirmationMessageForNextRestore(RestoreStateDto dto) {
        String stateInfo;
        assert (dto != null) : "Parameter 'dto' of method 'getConfirmationMessageForNextRestore' must not be null";
        assert (dto.getCurrentStateFileEntry() instanceof SoftwareSystemFileEntry) : "Unexpected class: " + dto.getClass().getName();
        SoftwareSystemFileEntry entry = (SoftwareSystemFileEntry)dto.getCurrentStateFileEntry();
        if (dto.getOperation() == FileHistoryOperation.UNDO) {
            stateInfo = "previous";
        } else if (dto.getOperation() == FileHistoryOperation.REDO) {
            stateInfo = "next";
        } else {
            stateInfo = "";
            assert (false) : "Support for operation " + dto.getOperation().name() + " not yet implemented";
        }
        if (this.m_softwareSystem.isClearable() && (entry.getNeedsReparseState() && this.m_softwareSystem.needsReparse() || entry.invalidatesParserModel())) {
            return "Restoring the " + stateInfo + " state of '" + dto.getCurrentStateFileEntry().getIdentifyingPath() + "' might clear the system.\nDo you want to continue?";
        }
        return null;
    }
}

