/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.IQualityModelProvider;
import com.hello2morrow.sonargraph.core.controller.system.base.IModifiableFileProvider;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.SoftwareSystemDefinitionFileReadError;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFileAccess;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFileDeltaKey;
import com.hello2morrow.sonargraph.core.model.path.ImportQualityModel;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileCandidate;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDelta;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDeltaDetector;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFilesDirectory;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemMode;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemSettingsDirectory;
import com.hello2morrow.sonargraph.core.model.system.settings.PersistenceRoot;
import com.hello2morrow.sonargraph.core.model.system.settings.SoftwareSystemSettingsFile;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;

public abstract class SoftwareSystemSettingsExtension
extends Extension
implements IModifiableFileDeltaKey,
IModifiableFileProvider,
IQualityModelProvider {
    private static final String ROOT_ELEMENT = "systemSettings";
    private final Installation m_installation;
    private final SoftwareSystem m_softwareSystem;

    public static boolean isValidRootElement(String rootElement) {
        assert (rootElement != null && rootElement.length() > 0) : "Parameter 'rootElement' of method 'isValidRootElement' must not be empty";
        return ROOT_ELEMENT.equals(rootElement);
    }

    protected SoftwareSystemSettingsExtension(Installation installation, SoftwareSystem softwareSystem) {
        assert (installation != null) : "Parameter 'installation' of method 'SoftwareSystemSettingsExtension' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'SoftwareSystemSettingsExtension' must not be null";
        this.m_softwareSystem = softwareSystem;
        this.m_installation = installation;
    }

    private void createSoftwareSystemSettingsFileIfItDoesNotExist() {
        Files files = this.getSoftwareSystem().getUniqueExistingChild(Files.class);
        SoftwareSystemSettingsDirectory settingsDirectory = files.getSoftwareSystemSettingsDirectory();
        List<SoftwareSystemSettingsFile> existingFiles = settingsDirectory.getChildren(new NamedElement.IFilter(){

            @Override
            public boolean accept(NamedElement namedElement) {
                if (!($assertionsDisabled || namedElement != null && namedElement instanceof SoftwareSystemSettingsFile)) {
                    throw new AssertionError((Object)("Unexpected class in method 'createSoftwareSystemSettingsFileIfItDoesNotExist': " + String.valueOf(namedElement)));
                }
                return SoftwareSystemSettingsExtension.this.getLanguage().equals(namedElement.getLanguage());
            }
        }, SoftwareSystemSettingsFile.class);
        assert (existingFiles.size() <= 1) : "More than on file exist: " + String.valueOf(existingFiles);
        if (existingFiles.isEmpty()) {
            SoftwareSystemSettingsFile settingsFile = new SoftwareSystemSettingsFile(settingsDirectory, new TFile((File)settingsDirectory.getFile(), this.getFileName()), files, this.getLanguage());
            settingsDirectory.addChild(settingsFile);
        }
    }

    @Override
    public void finishSoftwareSystemInitialization(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'finishSoftwareSystemInitialization' must not be null";
        if (this.getSoftwareSystem().getUsedLanguages().contains(this.getLanguage())) {
            this.createSoftwareSystemSettingsFileIfItDoesNotExist();
        }
    }

    @Override
    public void finishSoftwareSystemInitializationInRestore(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'finishSoftwareSystemInitializationInRestore' must not be null";
        if (this.getSoftwareSystem().getUsedLanguages().contains(this.getLanguage())) {
            this.createSoftwareSystemSettingsFileIfItDoesNotExist();
        }
    }

    void aboutToCreateFirstModule() {
        this.createSoftwareSystemSettingsFileIfItDoesNotExist();
    }

    void lastModuleDeleted() {
        SoftwareSystemSettingsFile settingsFile = this.getSoftwareSystemSettingsFile(true);
        if (!settingsFile.exists()) {
            settingsFile.remove();
        }
    }

    protected abstract Language getLanguage();

    protected abstract OperationResult loadSettingsFileContentInto(TFile var1, NamedElement var2, EnumSet<Modification> var3);

    protected abstract OperationResult saveSettingsFile(SoftwareSystemSettingsFile var1, TFile var2);

    protected abstract void restoreDefaults(EnumSet<Modification> var1);

    private IModifiableFileDeltaKey getModifiableFileDeltaKey() {
        return this;
    }

    protected final Installation getInstallation() {
        return this.m_installation;
    }

    protected final SoftwareSystem getSoftwareSystem() {
        return this.m_softwareSystem;
    }

    protected final String getFileName() {
        return this.getLanguage().getStandardName() + "SystemSettings.xml";
    }

    private SoftwareSystemSettingsFile getOrCreateSoftwareSystemSettingsFile(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'getOrCreateSoftwareSystemSettingsFile' must not be null";
        Files files = this.getSoftwareSystem().getUniqueExistingChild(Files.class);
        SoftwareSystemSettingsDirectory settingsDirectory = files.getSoftwareSystemSettingsDirectory();
        List<SoftwareSystemSettingsFile> existingFiles = settingsDirectory.getChildren(new NamedElement.IFilter(){

            @Override
            public boolean accept(NamedElement namedElement) {
                if (!($assertionsDisabled || namedElement != null && namedElement instanceof SoftwareSystemSettingsFile)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getOrCreateSoftwareSystemSettingsFile': " + String.valueOf(namedElement)));
                }
                return SoftwareSystemSettingsExtension.this.getLanguage().equals(namedElement.getLanguage());
            }
        }, SoftwareSystemSettingsFile.class);
        assert (existingFiles.size() <= 1) : "More than on file exist: " + String.valueOf(existingFiles);
        if (!existingFiles.isEmpty()) {
            return existingFiles.get(0);
        }
        SoftwareSystemSettingsFile settingsFile = new SoftwareSystemSettingsFile(settingsDirectory, new TFile((File)settingsDirectory.getFile(), this.getFileName()), files, this.getLanguage());
        settingsDirectory.addChild(settingsFile);
        assert (FileUtility.areEqual((TFile)file, (TFile)settingsFile.getFile())) : "Different files: " + String.valueOf(file) + "/" + String.valueOf(settingsFile.getFile());
        return settingsFile;
    }

    private SoftwareSystemSettingsFile getSoftwareSystemSettingsFile(boolean fileMustExist) {
        Files files = this.getSoftwareSystem().getUniqueExistingChild(Files.class);
        SoftwareSystemSettingsDirectory settingsDirectory = files.getSoftwareSystemSettingsDirectory();
        List<SoftwareSystemSettingsFile> existing = settingsDirectory.getChildren(new NamedElement.IFilter(){

            @Override
            public boolean accept(NamedElement namedElement) {
                if (!($assertionsDisabled || namedElement != null && namedElement instanceof SoftwareSystemSettingsFile)) {
                    throw new AssertionError((Object)("Unexpected class in method 'accept': " + String.valueOf(namedElement)));
                }
                return SoftwareSystemSettingsExtension.this.getLanguage().equals(namedElement.getLanguage());
            }
        }, SoftwareSystemSettingsFile.class);
        if (fileMustExist) {
            assert (existing.size() == 1) : "Exactly one file expected: " + String.valueOf(existing);
            return existing.get(0);
        }
        assert (existing.size() <= 1) : "More than 1 file exists: " + String.valueOf(existing);
        return existing.isEmpty() ? null : existing.get(0);
    }

    protected final SoftwareSystemSettingsFile getSoftwareSystemSettingsFile() {
        return this.getSoftwareSystemSettingsFile(true);
    }

    public final List<IModifiableFile> getAvailableFiles() {
        List<IModifiableFile> available = this.getSoftwareSystem().getUniqueExistingChild(Files.class).getSoftwareSystemSettingsDirectory().getChildren(SoftwareSystemSettingsFile.class).stream().filter(f -> f.existsOnDisk() && f.getLanguage().equals(this.getLanguage())).collect(Collectors.toList());
        assert (available.size() <= 1) : "At most one file expected: " + String.valueOf(available);
        return available;
    }

    @Override
    public final void checkOutOfSync(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'checkOutOfSync' must not be null";
        SoftwareSystemSettingsDirectory settingsDirectory = this.getSoftwareSystem().getUniqueExistingChild(Files.class).getSoftwareSystemSettingsDirectory();
        settingsDirectory.enforceExistence(result);
        IModifiableFileAccess access = new IModifiableFileAccess(){

            @Override
            public boolean accept(String fileName) {
                if (!$assertionsDisabled && fileName == null) {
                    throw new AssertionError((Object)"Parameter 'fileName' of method 'accept' must not be null");
                }
                return SoftwareSystemSettingsExtension.this.getFileName().equals(fileName);
            }
        };
        if (result.isSuccess() && settingsDirectory.isOutOfSync(access, (String[][])new String[][]{CoreFileType.SOFTWARE_SYSTEM_SETTINGS.getExtensions()})) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_SYSTEM_OUT_OF_SYNC, "Consider to refresh the system files", new Object[0]);
        }
    }

    @Override
    public final void exportFile(IModifiableFile file, TFile targetFile, OperationResult result) {
        assert (file != null && file instanceof SoftwareSystemSettingsFile) : "Unexpected class in method 'exportFile': " + String.valueOf(file);
        assert (targetFile != null) : "Parameter 'targetFile' of method 'exportFile' must not be null";
        assert (result != null) : "Parameter 'result' of method 'exportFile' must not be null";
        result.addMessagesFrom(this.saveSettingsFile((SoftwareSystemSettingsFile)file, targetFile));
    }

    @Override
    public final void prepareRefresh(ModifiableFileDeltaDetector deltaDetector, final boolean onSystemOpen, final PrepareRefreshResult prepareRefreshResult) {
        assert (deltaDetector != null) : "Parameter 'deltaDetector' of method 'prepareRefresh' must not be null";
        assert (prepareRefreshResult != null) : "Parameter 'result' of method 'prepareRefresh' must not be null";
        if (onSystemOpen || this.m_softwareSystem.getMode() == SoftwareSystemMode.SYSTEM) {
            deltaDetector.detect(new ModifiableFileDeltaDetector.IProvider(){

                @Override
                public IModifiableFileDeltaKey getKey() {
                    return SoftwareSystemSettingsExtension.this.getModifiableFileDeltaKey();
                }

                @Override
                public boolean exists(IModifiableFile modifiableFile) {
                    if (!onSystemOpen && modifiableFile instanceof SoftwareSystemSettingsFile && SoftwareSystemSettingsExtension.this.getFileName().equals(((SoftwareSystemSettingsFile)modifiableFile).getShortName())) {
                        return ((SoftwareSystemSettingsFile)modifiableFile).existsOnDisk();
                    }
                    return false;
                }

                @Override
                public boolean accept(TFile file) {
                    if (!$assertionsDisabled && file == null) {
                        throw new AssertionError((Object)"Parameter 'file' of method 'accept' must not be null");
                    }
                    return SoftwareSystemSettingsExtension.this.getFileName().equals(file.getName());
                }

                @Override
                public boolean recursive() {
                    return false;
                }

                @Override
                public DirectoryPath getDirectoryPath() {
                    return SoftwareSystemSettingsExtension.this.getSoftwareSystem().getUniqueExistingChild(Files.class).getSoftwareSystemSettingsDirectory();
                }

                @Override
                public List<IFileType> getFileTypes() {
                    return Collections.singletonList(CoreFileType.SOFTWARE_SYSTEM_SETTINGS);
                }

                @Override
                public String getImageResource(IFileType fileType) {
                    return SoftwareSystemSettingsFile.class.getSimpleName();
                }
            });
            if (!onSystemOpen) {
                deltaDetector.getDelta().visit(new ModifiableFileDelta.IVisitor(){

                    @Override
                    public IModifiableFileDeltaKey getKey() {
                        return SoftwareSystemSettingsExtension.this.getModifiableFileDeltaKey();
                    }

                    @Override
                    public void visitModified(IModifiableFile modified) {
                        if (!($assertionsDisabled || modified != null && modified instanceof SoftwareSystemSettingsFile)) {
                            throw new AssertionError((Object)("Unexpected class in method 'visitModified': " + String.valueOf(modified)));
                        }
                        prepareRefreshResult.addInfo(SoftwareSystemSettingsExtension.this.getFileName() + " will be re-loaded");
                    }

                    @Override
                    public void visitDeleted(IModifiableFile deleted) {
                        if (!($assertionsDisabled || deleted != null && deleted instanceof SoftwareSystemSettingsFile)) {
                            throw new AssertionError((Object)("Unexpected class in method 'visitDeleted': " + String.valueOf(deleted)));
                        }
                        prepareRefreshResult.addInfo(SoftwareSystemSettingsExtension.this.getFileName() + " will be set to defaults");
                    }

                    @Override
                    public void visitAdded(ModifiableFileCandidate added) {
                        if (!$assertionsDisabled && added == null) {
                            throw new AssertionError((Object)"Parameter 'added' of method 'visitAdded' must not be null");
                        }
                        prepareRefreshResult.addInfo(SoftwareSystemSettingsExtension.this.getFileName() + " will be loaded");
                    }
                }, false);
            }
        }
    }

    @Override
    public final void refreshFiles(IWorkerContext workerContext, ModifiableFileDelta delta, final EnumSet<Modification> modifications, final OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'refreshFiles' must not be null";
        assert (delta != null) : "Parameter 'delta' of method 'refreshFiles' must not be null";
        delta.visit(new ModifiableFileDelta.IVisitor(){

            @Override
            public IModifiableFileDeltaKey getKey() {
                return SoftwareSystemSettingsExtension.this.getModifiableFileDeltaKey();
            }

            @Override
            public void visitModified(IModifiableFile modified) {
                if (!($assertionsDisabled || modified != null && modified instanceof SoftwareSystemSettingsFile)) {
                    throw new AssertionError((Object)("Unexpected class in method 'visitModified': " + String.valueOf(modified)));
                }
                SoftwareSystemSettingsFile settingsFile = SoftwareSystemSettingsExtension.this.getSoftwareSystemSettingsFile(true);
                if (!$assertionsDisabled && modified != settingsFile) {
                    throw new AssertionError((Object)"Different files");
                }
                settingsFile.removeIssues(CoreIssueId.SOFTWARE_SYSTEM_DEFINITION_FILE_READ_ERROR);
                PersistenceRoot root = new PersistenceRoot();
                OperationResult loadResult = SoftwareSystemSettingsExtension.this.loadSettingsFileContentInto(settingsFile.getFile(), root, modifications);
                if (loadResult.isSuccess()) {
                    settingsFile.forgetChildren(true);
                    root.transferChildrenTo(settingsFile);
                    ((SoftwareSystemSettingsFile)modified).resetTimestamp();
                }
                result.addMessagesFrom(loadResult);
            }

            @Override
            public void visitDeleted(IModifiableFile deleted) {
                if (!($assertionsDisabled || deleted != null && deleted instanceof SoftwareSystemSettingsFile)) {
                    throw new AssertionError((Object)("Unexpected class in method 'visitDeleted': " + String.valueOf(deleted)));
                }
                SoftwareSystemSettingsFile settingsFile = SoftwareSystemSettingsExtension.this.getSoftwareSystemSettingsFile(true);
                if (!$assertionsDisabled && deleted != settingsFile) {
                    throw new AssertionError((Object)"Different files");
                }
                SoftwareSystemSettingsExtension.this.restoreDefaults(modifications);
                if (SoftwareSystemSettingsExtension.this.getSoftwareSystem().getUsedLanguages().contains(SoftwareSystemSettingsExtension.this.getLanguage())) {
                    settingsFile.setExistsOnDisk(false);
                    settingsFile.forgetChildren(true);
                } else {
                    settingsFile.remove();
                }
            }

            @Override
            public void visitAdded(ModifiableFileCandidate added) {
                if (!$assertionsDisabled && added == null) {
                    throw new AssertionError((Object)"Parameter 'added' of method 'visitAdded' must not be null");
                }
                SoftwareSystemSettingsFile settingsFile = SoftwareSystemSettingsExtension.this.getOrCreateSoftwareSystemSettingsFile(added.getFile());
                PersistenceRoot root = new PersistenceRoot();
                OperationResult addedResult = SoftwareSystemSettingsExtension.this.loadSettingsFileContentInto(settingsFile.getFile(), root, modifications);
                if (addedResult.isSuccess()) {
                    root.transferChildrenTo(settingsFile);
                    settingsFile.setExistsOnDisk(true);
                    settingsFile.setNeedsSave(false);
                } else {
                    settingsFile.addIssue(new SoftwareSystemDefinitionFileReadError(settingsFile, "Unable to read: " + addedResult.toString()));
                }
                result.addMessagesFrom(addedResult);
            }
        }, true);
    }

    @Override
    public final void setQualityModelRoot(TFile qualityModel) {
        assert (qualityModel != null) : "Parameter 'qualityModel' of method 'setQualityModelRoot' must not be null";
        this.getSoftwareSystem().getUniqueExistingChild(Files.class).getSoftwareSystemSettingsDirectory().setPath(new TFile((File)qualityModel, "./Settings"));
    }

    @Override
    public final boolean exports(IModifiableFile modifiableFile) {
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'exports' must not be null";
        return CoreFileType.SOFTWARE_SYSTEM_SETTINGS.equals(modifiableFile.getFileType()) && this.getFileName().equals(modifiableFile.getFile().getName());
    }

    @Override
    public final String getExportBaseDirectory() {
        return "Settings";
    }

    @Override
    public final void discardFiles(IWorkerContext workerContext, EnumSet<Modification> modfications, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'discardFiles' must not be null";
        assert (result != null) : "Parameter 'result' of method 'discardFiles' must not be null";
        SoftwareSystemSettingsFile settingsFile = this.getSoftwareSystemSettingsFile(false);
        if (settingsFile != null) {
            if (settingsFile.existsOnDisk()) {
                this.restoreDefaults(modfications);
                SoftwareSystemFilesDirectory.removeFile(settingsFile.getFile(), false, result);
            }
            if (modfications != null) {
                modfications.add(Modification.WORKSPACE_SETUP_MODIFIED);
            }
        }
    }

    private OperationResult importContent(TFile contentFile, SoftwareSystemSettingsFile settingsFile, EnumSet<Modification> modifications) {
        assert (contentFile != null) : "Parameter 'contentFile' of method 'importContent' must not be null";
        assert (settingsFile != null) : "Parameter 'settingsFile' of method 'importContent' must not be null";
        OperationResult result = new OperationResult("Import System Settings Content '" + String.valueOf(this.getLanguage()) + "'");
        PersistenceRoot root = new PersistenceRoot();
        OperationResult loadResult = this.loadSettingsFileContentInto(contentFile, root, modifications);
        result.addMessagesFrom(loadResult);
        if (loadResult.isSuccess()) {
            settingsFile.forgetChildren(true);
            root.transferChildrenTo(settingsFile);
            settingsFile.resetTimestamp();
            settingsFile.setNeedsSave(true);
            OperationResult saveResult = this.saveSettingsFile(settingsFile, settingsFile.getFile());
            result.addMessagesFrom(saveResult);
            if (saveResult.isSuccess()) {
                settingsFile.setExistsOnDisk(true);
                settingsFile.setNeedsSave(false);
            }
        }
        return result;
    }

    private ImportQualityModel.ImportQualityModelCandidate getImportCandidate(ImportQualityModel importQualityModel) {
        assert (importQualityModel != null) : "Parameter 'importQualityModel' of method 'getImportCandidate' must not be null";
        for (ImportQualityModel.ImportQualityModelCandidate next : importQualityModel.getCandidatesByFileType(CoreFileType.SOFTWARE_SYSTEM_SETTINGS)) {
            if (!next.isIncluded() || !next.getModifiableFile().getFile().getName().equals(this.getFileName())) continue;
            return next;
        }
        return null;
    }

    @Override
    public final void importFiles(IWorkerContext workerContext, ImportQualityModel importQualityModel, EnumSet<Modification> modifications, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'importFiles' must not be null";
        assert (importQualityModel != null) : "Parameter 'importQualityModel' of method 'importFiles' must not be null";
        assert (result != null) : "Parameter 'result' of method 'importFiles' must not be null";
        ImportQualityModel.ImportQualityModelCandidate candidate = this.getImportCandidate(importQualityModel);
        if (candidate != null) {
            List<IModifiableFile> availableFiles;
            TFile contentFile = candidate.getModifiableFile().getFile();
            if (importQualityModel.discardCurrentContent() || !candidate.isAlreadyInModel()) {
                OperationResult importContentResult = this.importContent(contentFile, this.getOrCreateSoftwareSystemSettingsFile(contentFile), modifications);
                result.addMessagesFrom(importContentResult);
            } else if (!importQualityModel.discardCurrentContent() && !(availableFiles = this.getAvailableFiles()).isEmpty()) {
                assert (availableFiles.size() == 1) : "Exactly one file expected: " + String.valueOf(availableFiles);
                IModifiableFile availableFile = availableFiles.get(0);
                assert (availableFile instanceof SoftwareSystemSettingsFile) : "Unexpected class in method 'importFiles': " + String.valueOf(availableFile);
                OperationResult importContentResult = this.importContent(contentFile, (SoftwareSystemSettingsFile)availableFile, modifications);
                if (importContentResult.isSuccess()) {
                    ((SoftwareSystemSettingsFile)availableFile).reloaded(contentFile.lastModified(), false);
                }
                result.addMessagesFrom(importContentResult);
            }
        }
    }

    public final OperationResult save(SoftwareSystemSettingsFile settingsFile) {
        assert (settingsFile != null) : "Parameter 'settingsFile' of method 'save' must not be null";
        assert (settingsFile == this.getSoftwareSystemSettingsFile(true)) : "Different files";
        OperationResult saveResult = this.saveSettingsFile(settingsFile, settingsFile.getFile());
        if (saveResult.isSuccess()) {
            settingsFile.setNeedsSave(false);
        }
        return saveResult;
    }
}

