/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderAccessor;
import com.hello2morrow.sonargraph.core.controller.system.LogicalNodeAndEdgeRepresentationDescriptorCalculator;
import com.hello2morrow.sonargraph.core.controller.system.RepresentationExtension;
import com.hello2morrow.sonargraph.core.controller.system.representation.ArchitectureNodeAndEdgeRepresentationDescriptorCalculator;
import com.hello2morrow.sonargraph.core.controller.system.representation.FocusModeCollector;
import com.hello2morrow.sonargraph.core.controller.system.representation.PhysicalNodeAndEdgeRepresentationDescriptorCalculator;
import com.hello2morrow.sonargraph.core.controller.system.representation.RemoveFromFocusCollector;
import com.hello2morrow.sonargraph.core.controller.system.representation.RepresentationDescriptorCalculator;
import com.hello2morrow.sonargraph.core.controllerinterface.system.INodeAndEdgeRepresentationExtension;
import com.hello2morrow.sonargraph.core.foundation.common.graph.CycleAnalyzer;
import com.hello2morrow.sonargraph.core.model.analysis.CycleAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.model.analysis.OnDemandCycleGroup;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.RepresentationModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.RepresentationRemovedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemEvent;
import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import com.hello2morrow.sonargraph.core.model.programming.EndpointType;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.representation.CreateRepresentationMode;
import com.hello2morrow.sonargraph.core.model.representation.FocusMode;
import com.hello2morrow.sonargraph.core.model.representation.NodeAndEdgeRepresentation;
import com.hello2morrow.sonargraph.core.model.representation.NodeType;
import com.hello2morrow.sonargraph.core.model.representation.Representation;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationEdge;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationNavigationStateWrapper;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationNode;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationUtility;
import com.hello2morrow.sonargraph.core.model.system.INamedElementResolver;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.StructureItemRegistry;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.event.Event;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NodeAndEdgeRepresentationExtension<T extends NodeAndEdgeRepresentation>
extends RepresentationExtension<T>
implements INodeAndEdgeRepresentationExtension<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeAndEdgeRepresentationExtension.class);

    public NodeAndEdgeRepresentationExtension(LanguageProviderAccessor languageProviderAccessor, SoftwareSystem softwareSystem, INamedElementResolver namedElementResolver, StructureItemRegistry structureItemRegistry) {
        super(languageProviderAccessor, softwareSystem, namedElementResolver, structureItemRegistry);
    }

    protected final void getConnectedNodes(Set<NamedElement> collector, RepresentationNode node, FocusMode mode, boolean onlyInternals) {
        assert (collector != null) : "Parameter 'collector' of method 'getConnectedNodes' must not be null";
        assert (mode != null) : "Parameter 'mode' of method 'getConnectedNodes' must not be null";
        assert (node != null) : "Parameter 'node' of method 'getConnectedNodes' must not be null";
        if (mode != FocusMode.OUT) {
            for (RepresentationEdge incoming : node.getIncomingEdges()) {
                NamedElement from = ((RepresentationNode)incoming.getFrom()).getUnderlyingObject();
                if (onlyInternals && from.isExternal()) continue;
                collector.add(from);
            }
        }
        if (mode != FocusMode.IN) {
            for (RepresentationEdge outgoing : node.getOutgoingEdges()) {
                NamedElement to = ((RepresentationNode)outgoing.getTo()).getUnderlyingObject();
                if (onlyInternals && to.isExternal()) continue;
                collector.add(to);
            }
        }
    }

    protected Set<RepresentationNode> collectNodesForFocus(Collection<RepresentationNode> elementsToFocus) {
        return new HashSet<RepresentationNode>(elementsToFocus);
    }

    @Override
    public final T extendFocus(IWorkerContext workerContext, T representationToFocus, List<Element> selection, boolean onlyVisible) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'extendFocusWithDependencies' must not be null";
        assert (representationToFocus != null) : "Parameter 'representationToFocus' of method 'extendFocusWithDependencies' must not be null";
        assert (selection != null && !selection.isEmpty()) : "Parameter 'selection' of method 'extendFocusWithDependencies' must not be empty";
        FocusMode mode = ((NodeAndEdgeRepresentation)representationToFocus).getFocusMode();
        Set<CoreParserDependencyType> dependencyTypes = ((NodeAndEdgeRepresentation)representationToFocus).getParserDependencyTypesForEdges();
        boolean levelized = ((NodeAndEdgeRepresentation)representationToFocus).isLevelized();
        EndpointType endpointType = ((Representation)representationToFocus).getEndpointType();
        List<RepresentationNode> elementsToExtendFocus = this.isExtendFocusPossible(selection);
        assert (elementsToExtendFocus != null && !elementsToExtendFocus.isEmpty()) : "Parameter 'elementsToExtendFocus' of method 'extendFocus' must not be empty";
        if (!onlyVisible) {
            HashSet<RepresentationNode> mainNodes = new HashSet<RepresentationNode>(elementsToExtendFocus);
            mainNodes.addAll(((NodeAndEdgeRepresentation)representationToFocus).getMainNodes().stream().map(mainNode -> representationToFocus.getNode((NamedElement)mainNode)).collect(Collectors.toSet()));
            EnumSet<NodeAndEdgeRepresentation.RepresentationProperty> representationProperties = ((NodeAndEdgeRepresentation)representationToFocus).getRepresentationProperties();
            representationProperties.remove((Object)NodeAndEdgeRepresentation.RepresentationProperty.ONLY_VISIBLE);
            return this.focus(workerContext, representationToFocus, mainNodes, dependencyTypes, mode, representationProperties);
        }
        for (Element element : selection) {
            assert (element instanceof RepresentationNode) : "Unexpected class in method 'extendFocus': " + String.valueOf(element);
            RepresentationNode node = (RepresentationNode)element;
            node.setIsOriginalInputRelated(true);
            ((Representation)representationToFocus).addToOriginalInput(node.getUnderlyingObject());
        }
        for (RepresentationNode node : elementsToExtendFocus) {
            ((NodeAndEdgeRepresentation)representationToFocus).convertNode(node.getUnderlyingObject(), NodeType.ADDITIONAL, NodeType.MAIN);
            node.setIsAdditionalNode(false);
            node.setIsMainPathNode(true);
        }
        HashSet<NamedElement> additionalNodes = new HashSet<NamedElement>(((NodeAndEdgeRepresentation)representationToFocus).getAdditionalNodes().stream().map(NamedElement::getRepresentative).collect(Collectors.toSet()));
        Set<NamedElement> newMainNodes = elementsToExtendFocus.stream().map(RepresentationNode::getUnderlyingObject).collect(Collectors.toSet());
        additionalNodes.removeAll(newMainNodes);
        FocusModeCollector collector = new FocusModeCollector(this.getSoftwareSystem(), newMainNodes, additionalNodes, Collections.emptySet(), ((NodeAndEdgeRepresentation)representationToFocus).getProgrammingElementToProxy(), dependencyTypes, ((Representation)representationToFocus).getDomain(), mode, ((NodeAndEdgeRepresentation)representationToFocus).getPresentationMode(), true, false, endpointType);
        ArrayList<NamedElement> inputForNodeAdapterSet = new ArrayList<NamedElement>();
        inputForNodeAdapterSet.addAll(newMainNodes);
        inputForNodeAdapterSet.addAll(additionalNodes);
        ParserDependencyNodeAdapterSet nodeAdapterSet = new ParserDependencyNodeAdapterSet(workerContext, inputForNodeAdapterSet, collector, RepresentationUtility.PE, RepresentationUtility.PD);
        HashMap<NamedElement, Set<ProgrammingElement>> mainNodeToProgrammingElementCollector = new HashMap<NamedElement, Set<ProgrammingElement>>();
        HashMap<NamedElement, Set<ProgrammingElement>> additionalNodeToProgrammingElementCollector = new HashMap<NamedElement, Set<ProgrammingElement>>();
        if (levelized) {
            if (endpointType == EndpointType.PARSER_DEPENDENCY) {
                this.analyzeCycleGroupsInRepresentation(workerContext, nodeAdapterSet, representationToFocus, newMainNodes);
            } else if (endpointType == EndpointType.WORKSPACE_DEPENDENCY) {
                CycleAnalyzerAdapter cycleAnalyzerAdapter = new CycleAnalyzerAdapter(nodeAdapterSet);
                CycleAnalyzer.compute(cycleAnalyzerAdapter, workerContext);
            }
        }
        this.createEdges(representationToFocus, nodeAdapterSet, mainNodeToProgrammingElementCollector, additionalNodeToProgrammingElementCollector);
        for (Map.Entry entry : mainNodeToProgrammingElementCollector.entrySet()) {
            collector.updateProgrammingElementsForMainNode((NamedElement)entry.getKey(), (Set)entry.getValue());
        }
        for (Map.Entry entry : additionalNodeToProgrammingElementCollector.entrySet()) {
            collector.updateProgrammingElementsForAdditionalNode((NamedElement)entry.getKey(), (Set)entry.getValue());
        }
        ((NodeAndEdgeRepresentation)representationToFocus).updateNodes(this.updateKeysToOriginalElements(collector.getProgrammingElementsOfMainNodes()), this.updateKeysToOriginalElements(collector.getProgrammingElementsOfAdditionalNodes()), false);
        if (((Representation)representationToFocus).getEndpointType() == EndpointType.PARSER_DEPENDENCY) {
            this.updateUnderlyingDependencies(representationToFocus);
        }
        ((NamedElement)representationToFocus).finishModification();
        if (LOGGER.isDebugEnabled()) {
            OperationResult checkTreeConsistencyResult = NodeAndEdgeRepresentationExtension.checkRepresentationConsistency(representationToFocus);
            assert (checkTreeConsistencyResult.isSuccess()) : checkTreeConsistencyResult.getErrorMessages();
        }
        return representationToFocus;
    }

    protected void removeNodeForRemoveFromFocus(T representation, NamedElement elementForRemovedNode) {
        assert (representation != null) : "Parameter 'representation' of method 'removeNodeForRemoveFromFocus' must not be null";
        assert (elementForRemovedNode != null) : "Parameter 'elementForRemovedNode' of method 'removeNodeForRemoveFromFocus' must not be null";
        ((NodeAndEdgeRepresentation)representation).removeNode(elementForRemovedNode, NodeType.ADDITIONAL, true);
    }

    protected void finishRemoveFromFocus(T representationToFocus) {
        assert (representationToFocus != null) : "Parameter 'representationToFocus' of method 'finishRemoveFromFocus' must not be null";
    }

    @Override
    public final T removeFromFocus(IWorkerContext workerContext, T representationToFocus, List<Element> selection) {
        assert (representationToFocus != null) : "Parameter 'representationToFocus' of method 'removeFromFocus' must not be null";
        assert (selection != null && !selection.isEmpty()) : "Parameter 'selection' of method 'removeFromFocus' must not be empty";
        FocusMode mode = ((NodeAndEdgeRepresentation)representationToFocus).getFocusMode();
        Set<CoreParserDependencyType> dependencyTypes = ((NodeAndEdgeRepresentation)representationToFocus).getParserDependencyTypesForEdges();
        boolean levelized = ((NodeAndEdgeRepresentation)representationToFocus).isLevelized();
        EndpointType endpointType = ((Representation)representationToFocus).getEndpointType();
        HashSet<NamedElement> mainNodes = new HashSet<NamedElement>(((NodeAndEdgeRepresentation)representationToFocus).getMainNodes().stream().map(NamedElement::getRepresentative).collect(Collectors.toSet()));
        List<RepresentationNode> elementsToRemoveFromFocus = this.isRemoveFromFocusPossible(mainNodes, selection);
        assert (elementsToRemoveFromFocus != null && !elementsToRemoveFromFocus.isEmpty()) : "Parameter 'elementsToRemoveFromFocus' of method 'removeFromFocus' must not be empty";
        for (Element element : selection) {
            assert (element instanceof RepresentationNode) : "Unexpected class in method 'removeFromFocus': " + String.valueOf(element);
            RepresentationNode node = (RepresentationNode)element;
            node.setIsOriginalInputRelated(false);
            ((Representation)representationToFocus).removeFromOriginalInput(node.getUnderlyingObject());
        }
        for (RepresentationNode node : elementsToRemoveFromFocus) {
            NamedElement underlyingObject = node.getUnderlyingObject();
            ((NodeAndEdgeRepresentation)representationToFocus).convertNode(underlyingObject, NodeType.MAIN, NodeType.ADDITIONAL);
            node.setIsAdditionalNode(true);
            node.setIsMainPathNode(false);
            node.setIsOriginalInputRelated(false);
            ((Representation)representationToFocus).removeFromOriginalInput(underlyingObject);
            node.removeEdges();
            mainNodes.remove(underlyingObject);
        }
        assert (mainNodes != null && !mainNodes.isEmpty()) : "Parameter 'mainNodes' of method 'removeFromFocus' must not be empty";
        Set<NamedElement> newAdditionalNodes = elementsToRemoveFromFocus.stream().map(RepresentationNode::getUnderlyingObject).collect(Collectors.toSet());
        RemoveFromFocusCollector collector = new RemoveFromFocusCollector(this.getSoftwareSystem(), mainNodes, newAdditionalNodes, Collections.emptySet(), ((NodeAndEdgeRepresentation)representationToFocus).getProgrammingElementToProxy(), dependencyTypes, ((Representation)representationToFocus).getDomain(), mode, ((NodeAndEdgeRepresentation)representationToFocus).getPresentationMode(), true, false, endpointType);
        ArrayList<NamedElement> inputForNodeAdapterSet = new ArrayList<NamedElement>();
        inputForNodeAdapterSet.addAll(mainNodes);
        inputForNodeAdapterSet.addAll(newAdditionalNodes);
        ParserDependencyNodeAdapterSet nodeAdapterSet = new ParserDependencyNodeAdapterSet(workerContext, inputForNodeAdapterSet, collector, RepresentationUtility.PE, RepresentationUtility.PD);
        HashMap<NamedElement, Set<ProgrammingElement>> mainNodeToProgrammingElementCollector = new HashMap<NamedElement, Set<ProgrammingElement>>();
        HashMap<NamedElement, Set<ProgrammingElement>> additionalNodeToProgrammingElementCollector = new HashMap<NamedElement, Set<ProgrammingElement>>();
        if (levelized) {
            if (endpointType == EndpointType.PARSER_DEPENDENCY) {
                this.analyzeCycleGroupsInRepresentation(workerContext, nodeAdapterSet, representationToFocus, mainNodes);
            } else if (endpointType == EndpointType.WORKSPACE_DEPENDENCY) {
                CycleAnalyzerAdapter cycleAnalyzerAdapter = new CycleAnalyzerAdapter(nodeAdapterSet);
                CycleAnalyzer.compute(cycleAnalyzerAdapter, workerContext);
            }
        }
        this.createEdges(representationToFocus, nodeAdapterSet, mainNodeToProgrammingElementCollector, additionalNodeToProgrammingElementCollector);
        for (Map.Entry entry : mainNodeToProgrammingElementCollector.entrySet()) {
            collector.updateProgrammingElementsForMainNode((NamedElement)entry.getKey(), (Set)entry.getValue());
        }
        for (Map.Entry entry : additionalNodeToProgrammingElementCollector.entrySet()) {
            collector.updateProgrammingElementsForAdditionalNode((NamedElement)entry.getKey(), (Set)entry.getValue());
        }
        ((NodeAndEdgeRepresentation)representationToFocus).updateNodes(this.updateKeysToOriginalElements(collector.getProgrammingElementsOfMainNodes()), this.updateKeysToOriginalElements(collector.getProgrammingElementsOfAdditionalNodes()), false);
        ArrayList<NamedElement> nodesToRemove = new ArrayList<NamedElement>();
        for (NamedElement additionalElement : ((NodeAndEdgeRepresentation)representationToFocus).getAdditionalNodes()) {
            RepresentationNode additionalNode = ((NodeAndEdgeRepresentation)representationToFocus).getNode(additionalElement);
            if (additionalNode.hasEdges()) continue;
            nodesToRemove.add(additionalElement);
        }
        for (NamedElement namedElement : nodesToRemove) {
            this.removeNodeForRemoveFromFocus(representationToFocus, namedElement);
        }
        if (((Representation)representationToFocus).getEndpointType() == EndpointType.PARSER_DEPENDENCY) {
            this.updateUnderlyingDependencies(representationToFocus);
        }
        ((NamedElement)representationToFocus).finishModification();
        this.finishRemoveFromFocus(representationToFocus);
        if (LOGGER.isDebugEnabled()) {
            OperationResult checkTreeConsistencyResult = NodeAndEdgeRepresentationExtension.checkRepresentationConsistency(representationToFocus);
            assert (checkTreeConsistencyResult.isSuccess()) : checkTreeConsistencyResult.getErrorMessages();
        }
        return representationToFocus;
    }

    @Override
    public final void updateRepresentation(IWorkerContext workerContext, T representationToUpdate, INavigationState navigationState, List<SoftwareSystemEvent> eventsToDispatch) {
        CreateRepresentationMode createRepresentationMode;
        EnumSet<NodeAndEdgeRepresentation.RepresentationProperty> representationProperties;
        PresentationMode presentationMode;
        FocusMode focusMode;
        Set<CoreParserDependencyType> parserDependencyTypesForEdges;
        Set<NamedElement> additionalNodes;
        Set<NamedElement> mainNodes;
        Set<NamedElement> originalInput;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'updateRepresentation' must not be null";
        assert (representationToUpdate != null) : "Parameter 'representationToUpdate' of method 'updateRepresentation' must not be null";
        assert (eventsToDispatch != null) : "Parameter 'eventsToDispatch' of method 'updateRepresentation' must not be null";
        boolean fromUndoRedo = false;
        if (navigationState != null) {
            RepresentationNavigationStateWrapper stateWrapper = new RepresentationNavigationStateWrapper(navigationState, this.getNamedElementResolver());
            originalInput = new HashSet<NamedElement>(stateWrapper.getOriginalInput());
            mainNodes = new HashSet<NamedElement>(stateWrapper.getMainNodes());
            additionalNodes = new HashSet<NamedElement>(stateWrapper.getAdditionalElements());
            parserDependencyTypesForEdges = stateWrapper.getDependencyTypesForEdges();
            focusMode = stateWrapper.getFocusMode();
            presentationMode = stateWrapper.getPresentationMode();
            representationProperties = stateWrapper.getProperties();
            createRepresentationMode = CreateRepresentationMode.NAVIGATION;
            fromUndoRedo = true;
        } else {
            RepresentationDescriptorCalculator representationDescriptorCalculator = this.getRepresentationDescriptorCalculator(((NamedElement)representationToUpdate).getName());
            if (representationDescriptorCalculator == null) {
                representationDescriptorCalculator = this.createRepresentationDescriptorCalculator(representationToUpdate);
            }
            originalInput = this.getElementsForUpdate(this.getSoftwareSystem(), (Representation)representationToUpdate, representationDescriptorCalculator, NodeType.ORIGINAL);
            mainNodes = this.getElementsForUpdate(this.getSoftwareSystem(), (Representation)representationToUpdate, representationDescriptorCalculator, NodeType.MAIN);
            additionalNodes = this.getElementsForUpdate(this.getSoftwareSystem(), (Representation)representationToUpdate, representationDescriptorCalculator, NodeType.ADDITIONAL);
            parserDependencyTypesForEdges = ((NodeAndEdgeRepresentation)representationToUpdate).getParserDependencyTypesForEdges();
            focusMode = ((NodeAndEdgeRepresentation)representationToUpdate).getFocusMode();
            presentationMode = ((NodeAndEdgeRepresentation)representationToUpdate).getPresentationMode();
            createRepresentationMode = CreateRepresentationMode.UPDATE;
            representationProperties = ((NodeAndEdgeRepresentation)representationToUpdate).getRepresentationProperties();
        }
        if (originalInput.isEmpty() || mainNodes.isEmpty()) {
            if (((Representation)representationToUpdate).getEndpointType() == EndpointType.WORKSPACE_DEPENDENCY) {
                T workspaceDependencyRepresentation = this.createWorkspaceDependencyRepresentation(workerContext, representationToUpdate);
                eventsToDispatch.add(new RepresentationModifiedEvent(this.getSoftwareSystem().getExtension(ISoftwareSystemProvider.class), (Representation)workspaceDependencyRepresentation, true, fromUndoRedo));
            } else {
                this.removeRepresentation(representationToUpdate, true, false, eventsToDispatch);
            }
        } else {
            T updatedRepresentation = this.createRepresentation((IWorkerContext)DefaultWorkerContext.INSTANCE, representationToUpdate, originalInput, mainNodes, additionalNodes, parserDependencyTypesForEdges, ((NodeAndEdgeRepresentation)representationToUpdate).getDependencyFilter(), focusMode, presentationMode, representationProperties, createRepresentationMode, navigationState != null ? navigationState.getId() : 0);
            if (updatedRepresentation == null) {
                for (NodeAndEdgeRepresentation dependantRepresentation : ((NodeAndEdgeRepresentation)representationToUpdate).getSlaveRepresentations()) {
                    this.removeRepresentation(dependantRepresentation, true, false, eventsToDispatch);
                }
                this.removeRepresentation(representationToUpdate, true, false, eventsToDispatch);
            } else if (((NodeAndEdgeRepresentation)updatedRepresentation).shouldRemoveRepresentation()) {
                this.removeRepresentation(updatedRepresentation, true, false, eventsToDispatch);
            } else {
                eventsToDispatch.add(new RepresentationModifiedEvent(this.getSoftwareSystem().getExtension(ISoftwareSystemProvider.class), (Representation)updatedRepresentation, true, fromUndoRedo));
                for (NodeAndEdgeRepresentation dependantRepresentation : ((NodeAndEdgeRepresentation)updatedRepresentation).getSlaveRepresentations()) {
                    if (!dependantRepresentation.shouldRemoveRepresentation()) continue;
                    this.removeRepresentation(dependantRepresentation, true, false, eventsToDispatch);
                }
            }
        }
    }

    @Override
    protected final RepresentationDescriptorCalculator<T> createRepresentationDescriptorCalculator(T representationToUpdate) {
        assert (representationToUpdate != null) : "Parameter 'representationToUpdate' of method 'createRepresentationDescriptorCalculator' must not be null";
        IDomainRoot.Domain domain = ((Representation)representationToUpdate).getDomain();
        return switch (domain) {
            case IDomainRoot.Domain.PHYSICAL -> new PhysicalNodeAndEdgeRepresentationDescriptorCalculator((NodeAndEdgeRepresentation)representationToUpdate);
            case IDomainRoot.Domain.LOGICAL_SYSTEM_SCOPE, IDomainRoot.Domain.LOGICAL_MODULE_SCOPE -> new LogicalNodeAndEdgeRepresentationDescriptorCalculator((NodeAndEdgeRepresentation)representationToUpdate);
            case IDomainRoot.Domain.ARCHITECTURE_PHYSICAL, IDomainRoot.Domain.ARCHITECTURE_LOGICAL -> new ArchitectureNodeAndEdgeRepresentationDescriptorCalculator((NodeAndEdgeRepresentation)representationToUpdate);
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unexpected domain: " + String.valueOf((Object)domain)));
                }
                yield null;
            }
        };
    }

    protected final void removeSlaveRepresentations(T masterRepresentation) {
        assert (masterRepresentation != null) : "Parameter 'masterRepresentation' of method 'removeSlaveRepresentation' must not be null";
        Iterator<NodeAndEdgeRepresentation> it = ((NodeAndEdgeRepresentation)masterRepresentation).getSlaveRepresentations().iterator();
        while (it.hasNext()) {
            NodeAndEdgeRepresentation slaveRepresentation = it.next();
            if (!slaveRepresentation.shouldRemoveRepresentation()) continue;
            it.remove();
            this.removeRepresentation(slaveRepresentation, true, false);
        }
    }

    private final void removeRepresentation(T representation, boolean fireRepresentationRemovedEvent, boolean removeSlaveRepresentations, boolean inSlaveRemoval, List<SoftwareSystemEvent> eventsToDispatch) {
        NodeAndEdgeRepresentation masterRepresentation;
        assert (representation != null) : "Parameter 'representation' of method 'removeRepresentation' must not be null";
        if (removeSlaveRepresentations) {
            for (NodeAndEdgeRepresentation slaveRepresentation : ((NodeAndEdgeRepresentation)representation).getSlaveRepresentations()) {
                this.removeRepresentation(slaveRepresentation, true, true, true, eventsToDispatch);
            }
            ((NodeAndEdgeRepresentation)representation).cleanUpSlaveRepresentations();
        }
        if (!inSlaveRemoval && (masterRepresentation = ((NodeAndEdgeRepresentation)representation).getMasterRepresentation()) != null) {
            masterRepresentation.removeSlaveRepresentation((NodeAndEdgeRepresentation)representation);
        }
        ((NodeAndEdgeRepresentation)representation).remove();
        if (fireRepresentationRemovedEvent) {
            if (eventsToDispatch != null) {
                eventsToDispatch.add(new RepresentationRemovedEvent(this.getSoftwareSystem().getExtension(ISoftwareSystemProvider.class), (Representation)representation));
            } else {
                EventManager.getInstance().dispatch((Object)this, (Event)new RepresentationRemovedEvent(this.getSoftwareSystem().getExtension(ISoftwareSystemProvider.class), (Representation)representation));
            }
        }
    }

    @Override
    public void removeRepresentation(Representation representation, boolean fireRepresentationRemovedEvent, boolean removeSlaveRepresentations) {
        this.removeRepresentation((NodeAndEdgeRepresentation)representation, fireRepresentationRemovedEvent, removeSlaveRepresentations, false, null);
    }

    @Override
    protected final void removeRepresentation(T representation, boolean fireRepresentationRemovedEvent, boolean removeSlaveRepresentations, List<SoftwareSystemEvent> eventsToDispatch) {
        assert (eventsToDispatch != null) : "Parameter 'eventsToDispatch' of method 'removeRepresentation' must not be null";
        this.removeRepresentation(representation, fireRepresentationRemovedEvent, removeSlaveRepresentations, false, eventsToDispatch);
    }

    protected final Map<NamedElement, Set<ProgrammingElement>> updateKeysToOriginalElements(Map<NamedElement, Set<ProgrammingElement>> map) {
        assert (map != null) : "Parameter 'map' of method 'updateKeysToOriginalElements' must not be null";
        HashMap<NamedElement, Set<ProgrammingElement>> updated = new HashMap<NamedElement, Set<ProgrammingElement>>();
        for (Map.Entry<NamedElement, Set<ProgrammingElement>> entry : map.entrySet()) {
            updated.put(entry.getKey().getOriginal(), entry.getValue());
        }
        return updated;
    }

    protected final Set<NamedElement> updateElementsToOriginalElements(Collection<NamedElement> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'updateElementsToOriginalElements' must not be null";
        return elements.stream().map(namedElement -> namedElement.getOriginal()).collect(Collectors.toSet());
    }

    protected final void updateSlaveRepresentations(NodeAndEdgeRepresentation currentRepresentation, NodeAndEdgeRepresentation newRepresentation) {
        assert (currentRepresentation != null) : "Parameter 'currentRepresentation' of method 'updateCycleFqNamesForSlaveRepresentations' must not be null";
        assert (newRepresentation != null) : "Parameter 'newRepresentation' of method 'updateCycleFqNamesForSlaveRepresentations' must not be null";
        currentRepresentation.getSlaveRepresentations().forEach(dependentRepresentation -> {
            newRepresentation.addSlaveRepresentation((NodeAndEdgeRepresentation)dependentRepresentation);
            block0: for (OnDemandCycleGroup oldCycle : currentRepresentation.getChildren(OnDemandCycleGroup.class)) {
                String oldFqNamePart = oldCycle.getFullyQualifiedNamePart();
                for (OnDemandCycleGroup newCycle : newRepresentation.getChildren(OnDemandCycleGroup.class)) {
                    String newFqNamePart = newCycle.getFullyQualifiedNamePart();
                    if (!oldFqNamePart.equals(newFqNamePart)) continue;
                    dependentRepresentation.updateCycleForRepresentationFqName(newCycle.getFullyQualifiedName());
                    continue block0;
                }
            }
        });
    }

    private static String getSetOfElementsAsMessage(Set<NamedElement> namedElements) {
        assert (namedElements != null) : "Parameter 'namedElements' of method 'getSetOfElementsAsMessage' must not be null";
        if (!namedElements.isEmpty()) {
            StringBuilder msg = new StringBuilder(StringUtility.LINE_SEPARATOR);
            for (NamedElement namedElement : namedElements) {
                msg.append(namedElement.getPresentationName(false));
                msg.append(StringUtility.LINE_SEPARATOR);
            }
            return msg.toString();
        }
        return null;
    }

    public static OperationResult checkRepresentationConsistency(NodeAndEdgeRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'checkTreeConsistency' must not be null";
        HashSet<NamedElement> mainNodes = new HashSet<NamedElement>(representation.getMainNodes());
        HashSet<NamedElement> additionalNodes = new HashSet<NamedElement>(representation.getAdditionalNodes());
        HashSet<NamedElement> originalInputNodes = new HashSet<NamedElement>(representation.getOriginalNodes());
        HashSet<NamedElement> mainNodesNotInCollection = new HashSet<NamedElement>();
        HashSet<NamedElement> additionalNodesNotInCollection = new HashSet<NamedElement>();
        HashSet<NamedElement> originalInputNodesNotInCollection = new HashSet<NamedElement>();
        OperationResult result = new OperationResult("Representation consistency check");
        for (RepresentationNode representationNode : representation.getNodes()) {
            boolean removed;
            boolean removed2;
            NamedElement originalUnderlyingObject;
            if ((representationNode.isMainNode() || representationNode.isAdditionalNode()) && representation.getEndpointType() == EndpointType.PARSER_DEPENDENCY && !RepresentationUtility.isValidElementForRepresentation(representationNode.getUnderlyingObject())) {
                result.addError((OperationResult.IMessageCause)RepresentationMessageCause.NOT_VALID_ELEMENT_FOR_REPRESENTATION, "'" + String.valueOf(representationNode.getUnderlyingObject()) + "' in not valid", new Object[0]);
            }
            if ((originalUnderlyingObject = representationNode.getUnderlyingObject().getOriginal()) instanceof OnDemandCycleGroup) {
                for (NamedElement cyclicNamedElement : ((OnDemandCycleGroup)originalUnderlyingObject).getCyclicNamedElements()) {
                    boolean removed3 = mainNodes.remove(cyclicNamedElement);
                    if (!removed3) {
                        removed3 = additionalNodes.remove(cyclicNamedElement);
                    }
                    if (!removed3) {
                        if (representationNode.isMainNode()) {
                            mainNodesNotInCollection.add(cyclicNamedElement);
                        } else if (representationNode.isAdditionalNode()) {
                            additionalNodesNotInCollection.add(cyclicNamedElement);
                        }
                    }
                    if (originalInputNodes.remove(cyclicNamedElement) || !representationNode.isOriginalInputRelated()) continue;
                    originalInputNodesNotInCollection.add(cyclicNamedElement);
                }
                continue;
            }
            if (representationNode.isMainNode()) {
                boolean removed4 = mainNodes.remove(originalUnderlyingObject);
                if (!removed4) {
                    mainNodesNotInCollection.add(originalUnderlyingObject);
                }
            } else if (representationNode.isAdditionalNode() && !(removed2 = additionalNodes.remove(originalUnderlyingObject))) {
                additionalNodesNotInCollection.add(originalUnderlyingObject);
            }
            if (!representationNode.isOriginalInputRelated() || (removed = originalInputNodes.remove(originalUnderlyingObject))) continue;
            originalInputNodesNotInCollection.add(originalUnderlyingObject);
        }
        String string = NodeAndEdgeRepresentationExtension.getSetOfElementsAsMessage(mainNodes);
        String additionalNodesMsg = NodeAndEdgeRepresentationExtension.getSetOfElementsAsMessage(additionalNodes);
        String originalNodesMsg = NodeAndEdgeRepresentationExtension.getSetOfElementsAsMessage(originalInputNodes);
        String mainNodesNotInCollectionMsg = NodeAndEdgeRepresentationExtension.getSetOfElementsAsMessage(mainNodesNotInCollection);
        String additionalNodesNotInCollectionMsg = NodeAndEdgeRepresentationExtension.getSetOfElementsAsMessage(additionalNodesNotInCollection);
        String originalInputNodesNotInCollectionMSg = NodeAndEdgeRepresentationExtension.getSetOfElementsAsMessage(originalInputNodesNotInCollection);
        if (string != null) {
            result.addError((OperationResult.IMessageCause)RepresentationMessageCause.NODES_IN_MAIN_NODES_COLLECTION_NOT_MARKED_AS_MAIN_NODES, string, new Object[0]);
        }
        if (additionalNodesMsg != null) {
            result.addError((OperationResult.IMessageCause)RepresentationMessageCause.NODES_IN_ADDITIONAL_NODES_COLLECTION_NOT_MARKED_AS_ADDITIONAL_NODES, additionalNodesMsg, new Object[0]);
        }
        if (mainNodesNotInCollectionMsg != null) {
            result.addError((OperationResult.IMessageCause)RepresentationMessageCause.NODES_MARK_AS_MAIN_NODES_NOT_IN_MAIN_NODES_COLLECTION, mainNodesNotInCollectionMsg, new Object[0]);
        }
        if (additionalNodesNotInCollectionMsg != null) {
            result.addError((OperationResult.IMessageCause)RepresentationMessageCause.NODES_MARK_AS_ADDITIONAL_NODES_NOT_IN_ADDITIONAL_NODES_COLLECTION, additionalNodesNotInCollectionMsg, new Object[0]);
        }
        if (originalNodesMsg != null) {
            result.addError((OperationResult.IMessageCause)RepresentationMessageCause.NODES_IN_ORIGIANAL_NODES_COLLECTION_NOT_MARKED_AS_ORIGINAL_NODES, originalNodesMsg, new Object[0]);
        }
        if (originalInputNodesNotInCollectionMSg != null) {
            result.addError((OperationResult.IMessageCause)RepresentationMessageCause.NODES_MARK_AS_ORIGINAL_NODES_NOT_IN_ORIGINAL_NODES_COLLECTION, originalInputNodesNotInCollectionMSg, new Object[0]);
        }
        return result;
    }

    @Override
    public final void updateUnderlyingDependencies(T representation) {
        assert (representation != null) : "Parameter 'representation' of method 'updateUnderlyingDependencies' must not be null";
        IProviderId issueProviderId = null;
        NamedElement rootElement = ((Representation)representation).getRootElement();
        if (rootElement instanceof ArchitectureFile) {
            issueProviderId = ((ArchitectureFile)rootElement).getIssueProviderId();
        }
        for (RepresentationNode representationNode : ((NodeAndEdgeRepresentation)representation).getNodes()) {
            for (RepresentationEdge edge : representationNode.getOutgoingEdges()) {
                edge.update(issueProviderId);
            }
        }
    }

    @Override
    public List<RepresentationNode> isExtendFocusPossible(List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'isExtendFocusWithDependenciesPossible' must not be null";
        ArrayList<RepresentationNode> nodes = new ArrayList<RepresentationNode>();
        for (Element element : elements) {
            if (!(element instanceof RepresentationNode)) {
                return Collections.emptyList();
            }
            nodes.add((RepresentationNode)element);
        }
        Set<RepresentationNode> adjustedElementsToRemoveFromFocus = this.collectNodesForFocus(nodes);
        List<RepresentationNode> mainNodesToRemoveFromFocus = adjustedElementsToRemoveFromFocus.stream().filter(RepresentationNode::isAdditionalNode).collect(Collectors.toList());
        return mainNodesToRemoveFromFocus;
    }

    @Override
    public final List<RepresentationNode> isRemoveFromFocusPossible(Set<NamedElement> currentMainNodes, List<Element> elementsToRemoveFromFocus) {
        assert (elementsToRemoveFromFocus != null) : "Parameter 'elements' of method 'isRemoveFromFocusPossible' must not be null";
        ArrayList<RepresentationNode> nodes = new ArrayList<RepresentationNode>();
        for (Element element : elementsToRemoveFromFocus) {
            if (!(element instanceof RepresentationNode)) {
                return Collections.emptyList();
            }
            nodes.add((RepresentationNode)element);
        }
        Set<RepresentationNode> adjustedElementsToRemoveFromFocus = this.collectNodesForFocus(nodes);
        List<RepresentationNode> mainNodesToRemoveFromFocus = adjustedElementsToRemoveFromFocus.stream().filter(RepresentationNode::isMainNode).collect(Collectors.toList());
        if (mainNodesToRemoveFromFocus.size() < currentMainNodes.size()) {
            return mainNodesToRemoveFromFocus;
        }
        return Collections.emptyList();
    }

    protected abstract T createWorkspaceDependencyRepresentation(IWorkerContext var1, T var2);

    protected abstract <U extends NodeAdapter> void createEdges(T var1, NodeAdapterSet<U> var2, Map<NamedElement, Set<ProgrammingElement>> var3, Map<NamedElement, Set<ProgrammingElement>> var4);

    protected abstract void analyzeCycleGroupsInRepresentation(IWorkerContext var1, NodeAdapterSet<? extends NodeAdapter> var2, T var3, Collection<NamedElement> var4);

    private static enum RepresentationMessageCause implements OperationResult.IMessageCause
    {
        NODES_IN_MAIN_NODES_COLLECTION_NOT_MARKED_AS_MAIN_NODES,
        NODES_IN_ADDITIONAL_NODES_COLLECTION_NOT_MARKED_AS_ADDITIONAL_NODES,
        NODES_MARK_AS_MAIN_NODES_NOT_IN_MAIN_NODES_COLLECTION,
        NODES_MARK_AS_ADDITIONAL_NODES_NOT_IN_ADDITIONAL_NODES_COLLECTION,
        NOT_VALID_ELEMENT_FOR_REPRESENTATION,
        NODES_IN_ORIGIANAL_NODES_COLLECTION_NOT_MARKED_AS_ORIGINAL_NODES,
        NODES_MARK_AS_ORIGINAL_NODES_NOT_IN_ORIGINAL_NODES_COLLECTION,
        NOT_VISIBLE_NODE_IS_EXPANDED,
        NOT_VISIBLE_NODE_HAS_EDGES;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

