/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.ArchitecturalViewRepresentationCreator;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderAccessor;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewContext;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewMessageCause;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewNameValidator;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewNodeInfo;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ExplorationViewBasedOnArchitectureFileContext;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ExplorationViewLogger;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ExplorationViewOnDemandCreator;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ExplorationViewOnDemandDataCollector;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.FocusHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.LoadedRepresentationInfo;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ModificationHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.OperationExecutor;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.RepresentationHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.StateHandler;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableAttributeRetriever;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableAttributeRetrieverProvider;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.event.ArchitecturalViewModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.ArchitecturalViewUnloadedEvent;
import com.hello2morrow.sonargraph.core.model.event.ContextsModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemEvent;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFileInvalidBasedOnIssue;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFindingList;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperationList;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewState;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocus;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocusProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewOnDemand;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewStructureMode;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewBaseProvider;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.IExplorationViewRepresentationOwner;
import com.hello2morrow.sonargraph.core.model.explorationview.ParserDependencyEndPoints;
import com.hello2morrow.sonargraph.core.model.path.ArchitecturalViewsDirectory;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFileAccess;
import com.hello2morrow.sonargraph.core.model.path.Path;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.LogicalModuleNamespaces;
import com.hello2morrow.sonargraph.core.model.system.LogicalSystemNamespaces;
import com.hello2morrow.sonargraph.core.model.system.OptionalExtension;
import com.hello2morrow.sonargraph.core.model.system.Representations;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.core.persistence.architecturalview.ArchitecturalViewPersistence;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.event.Event;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ArchitecturalViewBaseProvider
extends OptionalExtension
implements IAssignableAttributeRetrieverProvider,
IArchitecturalViewBaseProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchitecturalViewBaseProvider.class);
    private final Map<String, IAssignableAttributeRetriever> m_nameToRetriever = new THashMap();
    private final LanguageProviderAccessor m_accessor;
    private final IElementResolver m_resolver;
    private final Installation m_installation;
    private final SoftwareSystem m_softwareSystem;
    private final IFinishModelProcessor m_finishModelProcessor;

    ArchitecturalViewBaseProvider(LanguageProviderAccessor accessor, Installation installation, SoftwareSystem softwareSystem, IElementResolver resolver, IFinishModelProcessor finishModelProcessor, boolean enabled) {
        super(enabled);
        assert (accessor != null) : "Parameter 'accessor' of method 'ArchitecturalViewProvider' must not be null";
        assert (installation != null) : "Parameter 'installation' of method 'ArchitecturalViewProvider' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'ArchitecturalViewProvider' must not be null";
        assert (resolver != null) : "Parameter 'resolver' of method 'ArchitecturalViewProvider' must not be null";
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'ArchitecturalViewProvider' must not be null";
        this.m_accessor = accessor;
        this.m_installation = installation;
        this.m_softwareSystem = softwareSystem;
        this.m_resolver = resolver;
        this.m_finishModelProcessor = finishModelProcessor;
        this.m_nameToRetriever.putAll(ArchitecturalViewRepresentationCreator.createAvailableAttributeRetrievers(this.m_accessor));
    }

    protected final SoftwareSystem getSoftwareSystem() {
        return this.m_softwareSystem;
    }

    protected final IElementResolver getResolver() {
        return this.m_resolver;
    }

    protected final IFinishModelProcessor getFinishModelProcessor() {
        return this.m_finishModelProcessor;
    }

    @Override
    public final IContext getContext(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'getContext' must not be null";
        assert (representation.isValid()) : "Not valid: " + String.valueOf(representation);
        IExplorationViewRepresentationOwner owner = representation.getParent(IExplorationViewRepresentationOwner.class, ParentMode.ONLY_DIRECT_PARENT);
        assert (owner != null) : "'owner' of method 'getContext' must not be null";
        IContext defaultContext = this.m_softwareSystem.getExtension(ISoftwareSystemProvider.class).getDefaultContext();
        if (owner instanceof ArchitecturalViewFile) {
            return new ArchitecturalViewContext(defaultContext, representation, ((ArchitecturalViewFile)owner).getIdentifyingPath());
        }
        assert (owner != null && owner instanceof ExplorationViewOnDemand) : "Unexpected class in method 'getContext': " + String.valueOf(owner);
        if (representation.getBasedOnArchitectureFile() != null) {
            return new ExplorationViewBasedOnArchitectureFileContext(defaultContext, representation);
        }
        return defaultContext;
    }

    @Override
    public final ArchitecturalViewFile getArchitecturalViewFile(Collection<? extends Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'getArchitecturalViewFile' must not be null";
        if (!elements.isEmpty()) {
            ArchitecturalViewFile commonFile = null;
            THashSet architecturalViewElements = new THashSet();
            for (Element element : elements) {
                if (element instanceof ArchitecturalViewElement) {
                    architecturalViewElements.add((ArchitecturalViewElement)element);
                    continue;
                }
                if (element instanceof ArchitecturalViewNode.ArchitecturalViewDependency) {
                    architecturalViewElements.add(((ArchitecturalViewNode.ArchitecturalViewDependency)element).getFrom());
                    continue;
                }
                if (element instanceof ArchitecturalViewOperation) {
                    ArchitecturalViewFile nextFile = ((ArchitecturalViewOperation)element).getParent(ArchitecturalViewFile.class, new Class[0]);
                    if (nextFile == null) {
                        return null;
                    }
                    if (commonFile == null) {
                        commonFile = nextFile;
                        continue;
                    }
                    if (commonFile == nextFile) continue;
                    return null;
                }
                if (element instanceof ArchitecturalViewFile) {
                    if (commonFile == null) {
                        commonFile = (ArchitecturalViewFile)element;
                        continue;
                    }
                    if (commonFile == element) continue;
                    return null;
                }
                return null;
            }
            if (!architecturalViewElements.isEmpty() && commonFile != null) {
                ArchitecturalViewFile representationFile;
                ExplorationViewRepresentation explorationViewRepresentation = RepresentationHandler.getRepresentation((Collection<? extends IArchitecturalViewElement>)architecturalViewElements);
                if (explorationViewRepresentation != null && (representationFile = explorationViewRepresentation.getParent(ArchitecturalViewFile.class, ParentMode.ONLY_DIRECT_PARENT)) == commonFile) {
                    return commonFile;
                }
            } else {
                if (commonFile == null) {
                    ExplorationViewRepresentation explorationViewRepresentation = RepresentationHandler.getRepresentation((Collection<? extends IArchitecturalViewElement>)architecturalViewElements);
                    return explorationViewRepresentation != null ? explorationViewRepresentation.getParent(ArchitecturalViewFile.class, ParentMode.ONLY_DIRECT_PARENT) : null;
                }
                return commonFile;
            }
        }
        return null;
    }

    @Override
    public final ExplorationViewRepresentation getArchitecturalViewRepresentation(Collection<? extends IArchitecturalViewElement> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'getArchitecturalViewRepresentation' must not be null";
        return RepresentationHandler.getRepresentation(elements);
    }

    @Override
    public final IAssignableAttributeRetriever getAttributeRetriever(String name) {
        assert (name != null) : "Parameter 'name' of method 'getAttributeRetriever' must not be null";
        return this.m_nameToRetriever.get(name);
    }

    @Override
    public final String getDefaultRetrieverName() {
        return "ArchitectureFilterName";
    }

    protected final void checkOutOfSync(OperationResult result) {
        IModifiableFileAccess fileAccess;
        assert (result != null) : "Parameter 'result' of method 'checkOutOfSync' must not be null";
        ArchitecturalViewsDirectory directory = this.getArchitecturalViewsDirectory();
        directory.enforceExistence(result);
        if (result.isSuccess() && directory.isOutOfSync(fileAccess = new IModifiableFileAccess(){

            @Override
            public List<IModifiableFile> getModifiableFiles(SoftwareSystemDirectoryPath directoryPath) {
                if (!$assertionsDisabled && directoryPath == null) {
                    throw new AssertionError((Object)"Parameter 'directoryPath' of method 'checkOutOfSync' must not be null");
                }
                return directoryPath.getChildrenRecursively(IModifiableFile.class, new Class[0]);
            }
        }, (String[][])new String[][]{CoreFileType.ARCHITECTURAL_VIEW.getExtensions()})) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_SYSTEM_OUT_OF_SYNC, "Consider to refresh the system", new Object[0]);
        }
    }

    @Override
    public final ITextValidator getArchitecturalViewNameValidator() {
        return new ArchitecturalViewNameValidator(this.getAvailableArchitecturalViewFiles());
    }

    protected final ArchitecturalViewPersistence getPersistence() {
        return new ArchitecturalViewPersistence(this.m_installation.getVersion(), this);
    }

    protected final ArchitecturalViewFile createFile(String name, String description, ExplorationViewStructureMode mode, ArchitecturalViewFile basedOn, OperationResult result) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'createFile' must not be empty";
        assert (description != null) : "Parameter 'description' of method 'createFile' must not be null";
        assert (mode != null) : "Parameter 'mode' of method 'createFile' must not be null";
        assert (result != null) : "Parameter 'result' of method 'createFile' must not be null";
        assert (basedOn == null || basedOn.getStructureMode().equals((Object)mode)) : "Structure mode does not match";
        ArchitecturalViewsDirectory directory = this.getArchitecturalViewsDirectory();
        Path parent = basedOn == null ? directory : basedOn;
        ArchitecturalViewFile newFile = new ArchitecturalViewFile(parent, new TFile((File)directory.getFile(), name + CoreFileType.ARCHITECTURAL_VIEW.getDefaultExtension()), mode, this.m_softwareSystem.getUniqueExistingChild(Files.class));
        newFile.setBasedOn(basedOn != null ? basedOn.getIdentifyingPath() : null);
        newFile.setDescription(description);
        parent.addChild(newFile);
        result.addMessagesFrom(this.getPersistence().save(newFile));
        if (result.isSuccess()) {
            newFile.setNeedsSave(false);
            newFile.setExistsOnDisk(true);
            newFile.resetTimestamp();
        } else {
            newFile.setNeedsSave(true);
            newFile.setExistsOnDisk(false);
        }
        return newFile;
    }

    protected final OperationResult save(ArchitecturalViewFile file) {
        assert (file != null) : "Parameter 'file' of method 'save' must not be null";
        assert (file.needsSave()) : "Does not need save: " + file.getName();
        OperationResult saveResult = this.getPersistence().save(file);
        if (saveResult.isSuccess()) {
            file.setNeedsSave(false);
            file.resetTimestamp();
        }
        return saveResult;
    }

    public final ArchitecturalViewFile findByIdentifyingPath(String identifyingPath) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'findByIdentifyingPath' must not be empty";
        for (ArchitecturalViewFile next : this.getAvailableArchitecturalViewFiles()) {
            if (!next.getIdentifyingPath().equals(identifyingPath)) continue;
            return next;
        }
        return null;
    }

    protected final ArchitecturalViewsDirectory getArchitecturalViewsDirectory() {
        return this.m_softwareSystem.getUniqueExistingChild(Files.class).getArchitecturalViews();
    }

    protected final List<ArchitecturalViewFile> getAvailableArchitecturalViewFiles() {
        List<ArchitecturalViewFile> available = this.getArchitecturalViewsDirectory().getChildrenRecursively(ArchitecturalViewFile.class, ExplorationViewRepresentation.class);
        Collections.sort(available, new Comparator<ArchitecturalViewFile>(){

            @Override
            public int compare(ArchitecturalViewFile f1, ArchitecturalViewFile f2) {
                if (!$assertionsDisabled && f1 == null) {
                    throw new AssertionError((Object)"Parameter 'f1' of method 'compare' must not be null");
                }
                if (!$assertionsDisabled && f2 == null) {
                    throw new AssertionError((Object)"Parameter 'f2' of method 'compare' must not be null");
                }
                return f1.getIdentifyingPath().compareTo(f2.getIdentifyingPath());
            }
        });
        return available;
    }

    @Override
    public final ExplorationViewOnDemand isLoadable(ExplorationViewStructureMode mode) {
        assert (mode != null) : "Parameter 'mode' of method 'isLoadable' must not be null";
        return ExplorationViewOnDemandCreator.isLoadable(this.m_softwareSystem, mode);
    }

    @Override
    public ExplorationViewOnDemand isLoadable(AnalyzerCycleGroup cycleGroup, ArchitectureFile architectureFile) {
        assert (cycleGroup != null) : "Parameter 'cycleGroup' of method 'isLoadable' must not be null";
        return ExplorationViewOnDemandCreator.isLoadable(this.m_softwareSystem, cycleGroup, architectureFile);
    }

    @Override
    public final List<ExplorationViewOnDemand> isLoadable(Collection<? extends Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'isLoadPossible' must not be null";
        return ExplorationViewOnDemandCreator.isLoadable(this.m_softwareSystem, elements);
    }

    @Override
    public final boolean isLoadable(ArchitecturalViewFile element) {
        assert (element != null) : "Parameter 'element' of method 'isLoadable' must not be null";
        return this.m_softwareSystem.isClearable();
    }

    @Override
    public final boolean hasBeenLoaded(IExplorationViewRepresentationOwner owner) {
        assert (owner != null) : "Parameter 'owner' of method 'hasBeenLoaded' must not be null";
        return owner.getNamedElement().getUniqueChild(ExplorationViewRepresentation.class) != null;
    }

    @Override
    public final boolean hasLoadedArchitecturalViews(boolean includingOnDemand) {
        for (ArchitecturalViewFile next : this.getAvailableArchitecturalViewFiles()) {
            if (!this.hasBeenLoaded(next)) continue;
            return true;
        }
        return includingOnDemand ? !this.m_softwareSystem.getUniqueExistingChild(Representations.class).getChildren(ExplorationViewOnDemand.class).isEmpty() : false;
    }

    protected final boolean load(IWorkerContext workerContext, ArchitecturalViewFile file, PresentationMode presentationMode, ExplorationViewFocus focus, ArchitecturalViewState state, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'load' must not be null";
        assert (file != null) : "Parameter 'file' of method 'load' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'load' must not be null";
        boolean loaded = false;
        if (this.m_softwareSystem.isClearable()) {
            LOGGER.debug("Load architectural view from file '" + file.getIdentifyingPath() + "'");
            workerContext.working("Load architectural view from file", true);
            ExplorationViewRepresentation representation = ArchitecturalViewRepresentationCreator.createRepresentation(this.m_accessor, this.m_softwareSystem, file.getStructureMode(), this.m_resolver, file, null);
            workerContext.setNumberOfSteps(5, new int[]{72, 7, 7, 7, 7});
            boolean success = ArchitecturalViewRepresentationCreator.createNodes(workerContext, this.m_softwareSystem, representation, null);
            workerContext.endStep();
            if (success) {
                assert (file.getUniqueChild(ExplorationViewRepresentation.class) == null) : "Representation already set";
                representation.setParent(file);
                file.addChild(representation);
                workerContext.working("Finish initial element creation", true);
                RepresentationHandler.finishInitialElementCreation(representation);
                workerContext.endStep();
                OperationExecutor.applyOperations(workerContext, file, representation);
                workerContext.endStep();
                workerContext.working("Finish initial element structure", true);
                PresentationMode presentationModeOfLastApplicableOp = null;
                List<ArchitecturalViewOperation> operations = file.getOperations();
                ListIterator<ArchitecturalViewOperation> reverseIter = operations.listIterator(operations.size());
                while (reverseIter.hasPrevious()) {
                    ArchitecturalViewOperation nextOp = reverseIter.previous();
                    if (nextOp.hasIssues(CoreIssueId.ARCHITECTURAL_VIEW_OPERATION_NOT_APPLICABLE)) continue;
                    presentationModeOfLastApplicableOp = nextOp.getPresentationMode();
                    break;
                }
                ArchitecturalViewNodeInfo nodeInfo = RepresentationHandler.finishInitialElementStructure(presentationModeOfLastApplicableOp == null ? presentationMode : presentationModeOfLastApplicableOp, representation);
                workerContext.endStep();
                ModificationHandler.finishModification(workerContext, representation, focus, state, null, nodeInfo);
                workerContext.endStep();
                loaded = true;
            } else if (result != null && !workerContext.hasBeenCanceled()) {
                result.addWarning((OperationResult.IMessageCause)ArchitecturalViewMessageCause.UNABLE_TO_LOAD_ARCHITECTURAL_VIEW_FILE, "No suitable programming elements found.", new Object[0]);
                result.setIsSuccess(false);
            }
        } else if (result != null && !workerContext.hasBeenCanceled()) {
            result.addWarning((OperationResult.IMessageCause)ArchitecturalViewMessageCause.UNABLE_TO_LOAD_ARCHITECTURAL_VIEW_FILE, "Software system is empty.", new Object[0]);
            result.setIsSuccess(false);
        }
        LOGGER.debug("Load architectural view from file '" + file.getIdentifyingPath() + "'" + (loaded ? " <loaded>" : " <not loaded>"));
        return loaded;
    }

    protected final boolean load(IWorkerContext workerContext, final ExplorationViewOnDemand onDemand, PresentationMode presentationMode, Pair<ExplorationViewFocus, ArchitecturalViewState> focusAndState, ExplorationViewFocusProperties focusProperties, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'load' must not be null";
        assert (onDemand != null) : "Parameter 'file' of method 'load' must not be null";
        assert (onDemand.getParent() == null) : "'onDemand' has already a parent: " + String.valueOf(onDemand.getParent());
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'load' must not be null";
        String msg = ExplorationViewLogger.logLoad(onDemand, presentationMode);
        boolean loaded = false;
        if (this.m_softwareSystem.isClearable()) {
            workerContext.working("Load architectural view on demand", true);
            ExplorationViewOnDemandCreator.complete(this.m_softwareSystem, onDemand);
            ArchitectureFile architectureFile = onDemand.getArchitectureFile();
            ExplorationViewRepresentation representation = ArchitecturalViewRepresentationCreator.createRepresentation(this.m_accessor, this.m_softwareSystem, onDemand.getStructureMode(), this.m_resolver, onDemand, architectureFile == null ? null : architectureFile.getIdentifyingPath());
            workerContext.setNumberOfSteps(4, new int[]{70, 10, 10, 10});
            boolean success = ArchitecturalViewRepresentationCreator.createNodes(workerContext, this.m_softwareSystem, representation, architectureFile);
            workerContext.endStep();
            if (success) {
                ArchitecturalViewState applyState;
                ExplorationViewFocus applyFocus;
                assert (onDemand.getUniqueChild(ExplorationViewRepresentation.class) == null) : "Representation already set";
                representation.setParent(onDemand);
                onDemand.addChild(representation);
                Representations representations = this.m_softwareSystem.getUniqueExistingChild(Representations.class);
                onDemand.setParent(representations);
                representations.addChild(onDemand);
                RepresentationHandler.finishInitialElementCreation(representation);
                workerContext.endStep();
                ArchitecturalViewNodeInfo nodeInfo = RepresentationHandler.finishInitialElementStructure(presentationMode, representation);
                workerContext.endStep();
                if (focusAndState != null) {
                    assert (focusProperties == null) : "'focusProperties' of method 'load' must be null";
                    applyFocus = (ExplorationViewFocus)focusAndState.getFirst();
                    applyState = (ArchitecturalViewState)focusAndState.getSecond();
                } else {
                    Set<NamedElement> namedElements = onDemand.getNamedElements();
                    if (!namedElements.isEmpty()) {
                        String startPath = switch (representation.getStructureMode()) {
                            case ExplorationViewStructureMode.LOGICAL_MODULE_SCOPE -> this.m_softwareSystem.getUniqueExistingChild(LogicalModuleNamespaces.class).getFullyQualifiedName();
                            case ExplorationViewStructureMode.LOGICAL_SYSTEM_SCOPE -> this.m_softwareSystem.getUniqueExistingChild(LogicalSystemNamespaces.class).getFullyQualifiedName();
                            case ExplorationViewStructureMode.PHYSICAL_WITH_ROOT_DIRECTORIES, ExplorationViewStructureMode.PHYSICAL_WITHOUT_ROOT_DIRECTORIES -> this.m_softwareSystem.getUniqueExistingChild(Workspace.class).getFullyQualifiedName();
                            default -> {
                                if (!$assertionsDisabled) {
                                    throw new AssertionError((Object)("Unhandled structure mode: " + String.valueOf((Object)representation.getStructureMode())));
                                }
                                yield "";
                            }
                        };
                        THashSet programmingElements = new THashSet();
                        THashSet nodes = new THashSet();
                        THashSet relPathNodes = new THashSet();
                        ExplorationViewOnDemandDataCollector.collect(startPath, namedElements, (Set<ProgrammingElement>)programmingElements, (Set<ArchitecturalViewNode>)nodes, (Set<String>)relPathNodes, onDemand.getArtifactMapping(), representation);
                        if (!onDemand.getFocusParserDependencies().isEmpty()) {
                            assert (focusProperties == null) : "'focusProperties' of method 'load' must be null";
                            applyFocus = new ExplorationViewFocus();
                            ParserDependencyEndPoints endPoints = new ParserDependencyEndPoints();
                            for (ParserDependency next : onDemand.getFocusParserDependencies()) {
                                if (!representation.includeParserDependency(next, endPoints)) continue;
                                applyFocus.addParserDependency(next);
                            }
                        } else if (!programmingElements.isEmpty()) {
                            applyFocus = focusProperties != null ? FocusHandler.createOnDemandFocus((Set<ProgrammingElement>)programmingElements, focusProperties, representation) : null;
                        } else {
                            if (focusProperties != null) {
                                LOGGER.warn("Focus properties not null, but no programming elements found to focus");
                            }
                            applyFocus = null;
                        }
                        applyState = StateHandler.createOnDemandState((Set<ArchitecturalViewNode>)nodes, (Set<String>)relPathNodes, representation);
                    } else {
                        applyFocus = null;
                        applyState = null;
                    }
                }
                StateHandler.IApplyStateListener applyStateListener = applyState == null ? null : new StateHandler.IApplyStateListener(){

                    @Override
                    public void selected(ArchitecturalViewNode node) {
                        if (!$assertionsDisabled && node == null) {
                            throw new AssertionError((Object)"Parameter 'node' of method 'selected' must not be null");
                        }
                        if (onDemand.getNodeToBeRevealed() == null) {
                            for (NamedElement nextUnderlying : node.getUnderlyingElements()) {
                                if (nextUnderlying != onDemand.getToBeRevealed()) continue;
                                onDemand.setNodeToReveal(node);
                                break;
                            }
                        }
                    }
                };
                ModificationHandler.finishModification(workerContext, representation, applyFocus, applyState, applyStateListener, nodeInfo);
                workerContext.endStep();
                loaded = true;
            } else if (result != null && !workerContext.hasBeenCanceled()) {
                result.addWarning((OperationResult.IMessageCause)ArchitecturalViewMessageCause.UNABLE_TO_LOAD_ARCHITECTURAL_VIEW_ON_DEMAND, "No suitable programming elements found.", new Object[0]);
                result.setIsSuccess(false);
            }
        } else if (result != null && !workerContext.hasBeenCanceled()) {
            result.addWarning((OperationResult.IMessageCause)ArchitecturalViewMessageCause.UNABLE_TO_LOAD_ARCHITECTURAL_VIEW_ON_DEMAND, "Software system is empty.", new Object[0]);
            result.setIsSuccess(false);
        }
        ExplorationViewLogger.logDone(msg, loaded ? "loaded" : "not loaded");
        return loaded;
    }

    protected final void performUnload(IExplorationViewRepresentationOwner owner) {
        assert (owner != null) : "Parameter 'owner' of method 'unload' must not be null";
        assert (this.hasBeenLoaded(owner)) : "Not loaded: " + String.valueOf(owner);
        ExplorationViewRepresentation representation = owner.getNamedElement().getUniqueChild(ExplorationViewRepresentation.class);
        assert (representation != null) : "'representation' of method 'performUnload' must not be null";
        representation.setInvalid();
        representation.remove();
        if (owner instanceof ArchitecturalViewFile) {
            ArchitecturalViewFile file = (ArchitecturalViewFile)owner;
            file.getFindingList().forgetChildren(false);
            file.getRefactoringList().forgetChildren(false);
            file.getViolationList().forgetChildren(false);
            this.resetOperations(file);
        } else {
            assert (owner instanceof ExplorationViewOnDemand) : "Unexpected class in method 'performUnload': " + String.valueOf(owner);
            ((ExplorationViewOnDemand)owner).remove();
        }
    }

    @Override
    public final void unload(IExplorationViewRepresentationOwner owner) {
        assert (owner != null) : "Parameter 'owner' of method 'unload' must not be null";
        this.performUnload(owner);
        this.getFinishModelProcessor().finishModification(this.m_softwareSystem, EnumSet.of(Modification.VIRTUAL_MODEL_MODIFIED));
        EventManager.getInstance().dispatch((Object)this, (Event)new ArchitecturalViewUnloadedEvent(this.m_softwareSystem.getExtension(ISoftwareSystemProvider.class), owner));
        EventManager.getInstance().dispatch((Object)this, (Event)new ContextsModifiedEvent(this.m_softwareSystem.getExtension(ISoftwareSystemProvider.class)));
    }

    @Override
    public final void removeRefactoringLists() {
        for (ArchitecturalViewFile file : this.getAvailableArchitecturalViewFiles()) {
            if (!this.hasBeenLoaded(file)) continue;
            file.getRefactoringList().forgetChildren(false);
        }
    }

    @Override
    public final void removeViolationLists() {
        for (ArchitecturalViewFile file : this.getAvailableArchitecturalViewFiles()) {
            if (!this.hasBeenLoaded(file)) continue;
            file.getViolationList().forgetChildren(false);
        }
    }

    protected final void notifyModification(IExplorationViewRepresentationOwner owner, ArchitecturalViewModifiedEvent.ArchitecturalViewModification modification) {
        assert (owner != null) : "Parameter 'owner' of method 'notifyModification' must not be null";
        assert (modification != null) : "Parameter 'modification' of method 'notifyModification' must not be null";
        if (owner instanceof ArchitecturalViewFile) {
            this.fileContentModified((ArchitecturalViewFile)owner);
        }
        EventManager.getInstance().dispatch((Object)this, (Event)new ArchitecturalViewModifiedEvent(this.m_softwareSystem.getExtension(ISoftwareSystemProvider.class), owner, modification));
    }

    private void updateInheritedOperations(LinkedHashMap<ArchitecturalViewFile, List<ArchitecturalViewOperation>> inheritedFromToOperations, ArchitecturalViewFile currentFile, Consumer<ArchitecturalViewFile> consumer) {
        assert (inheritedFromToOperations != null) : "Parameter 'inheritedFromToOperations' of method 'updateInheritedOperations' must not be null";
        assert (currentFile != null) : "Parameter 'currentFile' of method 'updateInheritedOperations' must not be null";
        if (consumer != null) {
            consumer.accept(currentFile);
        }
        ArchitecturalViewOperationList operations = currentFile.getUniqueExistingChild(ArchitecturalViewOperationList.class);
        ArrayList<ArchitecturalViewOperation> newOperations = new ArrayList<ArchitecturalViewOperation>();
        for (Map.Entry<ArchitecturalViewFile, List<ArchitecturalViewOperation>> nextEntry : inheritedFromToOperations.entrySet()) {
            for (ArchitecturalViewOperation nextInheritedOp : nextEntry.getValue()) {
                ArchitecturalViewOperation nextInheritedCopy = nextInheritedOp.copy(operations);
                nextInheritedCopy.setInheritedFrom(nextEntry.getKey());
                newOperations.add(nextInheritedCopy);
            }
        }
        List<NamedElement> previousOperations = operations.forgetChildren(true);
        if (previousOperations != null) {
            for (NamedElement nextOp : previousOperations) {
                assert (nextOp instanceof ArchitecturalViewOperation) : "Unexpected class in method 'updateInheritedOperations': " + String.valueOf(nextOp);
                if (((ArchitecturalViewOperation)nextOp).getInheritedFrom() != null) continue;
                nextOp.setParent(operations);
                newOperations.add((ArchitecturalViewOperation)nextOp);
            }
        }
        newOperations.forEach(o -> operations.addChild((NamedElement)o));
        List<ArchitecturalViewFile> children = currentFile.getChildren(ArchitecturalViewFile.class);
        if (!children.isEmpty()) {
            inheritedFromToOperations.put(currentFile, currentFile.getNonInheritedOperations());
            children.forEach(f -> this.updateInheritedOperations(inheritedFromToOperations, (ArchitecturalViewFile)f, consumer));
            inheritedFromToOperations.remove(currentFile);
        }
    }

    protected final void resetOperations(ArchitecturalViewFile file) {
        assert (file != null) : "Parameter 'file' of method 'resetOperations' must not be null";
        for (ArchitecturalViewOperation nextOp : file.getOperations()) {
            nextOp.removeIssues(CoreIssueId.ARCHITECTURAL_VIEW_OPERATION_NOT_APPLICABLE);
            nextOp.reset();
        }
    }

    protected final void processModified(IWorkerContext workerContext, SoftwareSystem softwareSystem, List<ArchitecturalViewFile> files, boolean filesModified, List<SoftwareSystemEvent> eventsToDispatch) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'processModified' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'processModified' must not be null";
        assert (files != null) : "Parameter 'files' of method 'processModified' must not be null";
        ISoftwareSystemProvider systemProvider = softwareSystem.getExtension(ISoftwareSystemProvider.class);
        boolean contextsModified = false;
        for (ArchitecturalViewFile nextFile : files) {
            if (this.hasBeenLoaded(nextFile)) {
                ExplorationViewRepresentation nextRepresentation = nextFile.getUniqueExistingChild(ExplorationViewRepresentation.class);
                if (nextRepresentation.isInTransfer()) continue;
                ExplorationViewFocus focus = !nextRepresentation.getFocus().isEmpty() ? nextRepresentation.getFocus().copy() : null;
                ArchitecturalViewState state = StateHandler.createState(nextRepresentation);
                this.performUnload(nextFile);
                workerContext.working("Updating architectural view from file '" + nextFile.getIdentifyingPath() + "'", true);
                if (this.load((IWorkerContext)DefaultWorkerContext.INSTANCE, nextFile, nextRepresentation.getPresentationMode(), focus, state, null)) {
                    eventsToDispatch.add(new ArchitecturalViewModifiedEvent(softwareSystem.getExtension(ISoftwareSystemProvider.class), nextFile, new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.MODEL)));
                } else {
                    eventsToDispatch.add(new ArchitecturalViewUnloadedEvent(systemProvider, nextFile));
                }
                contextsModified = true;
                continue;
            }
            if (!filesModified) continue;
            this.resetOperations(nextFile);
            eventsToDispatch.add(new ArchitecturalViewModifiedEvent(softwareSystem.getExtension(ISoftwareSystemProvider.class), nextFile, new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.OPERATION_WITHOUT_STRUCTURE_MODIFICATION)));
            contextsModified = true;
        }
        if (contextsModified) {
            eventsToDispatch.add(new ContextsModifiedEvent(systemProvider));
        }
    }

    protected final void filesModified(IWorkerContext workerContext, boolean onSystemOpen) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'filesModified' must not be null";
        LinkedHashMap<String, ArchitecturalViewFile> identifyingPathToFile = new LinkedHashMap<String, ArchitecturalViewFile>();
        LinkedHashMap<ArchitecturalViewFile, String> fileToBasedOn = new LinkedHashMap<ArchitecturalViewFile, String>();
        ArchitecturalViewsDirectory directory = this.getArchitecturalViewsDirectory();
        for (ArchitecturalViewFile architecturalViewFile : this.getAvailableArchitecturalViewFiles()) {
            identifyingPathToFile.put(architecturalViewFile.getIdentifyingPath(), architecturalViewFile);
            String nextBasedOn = architecturalViewFile.getBasedOn();
            if (nextBasedOn != null) {
                fileToBasedOn.put(architecturalViewFile, nextBasedOn);
            }
            architecturalViewFile.changeParent(directory, true);
            architecturalViewFile.removeIssues(CoreIssueId.ARCHITECTURAL_VIEW_FILE_INVALID_BASED_ON);
        }
        for (Map.Entry entry : fileToBasedOn.entrySet()) {
            ArchitecturalViewFile nextFile = (ArchitecturalViewFile)entry.getKey();
            String nextBasedOnEntry = (String)entry.getValue();
            ArchitecturalViewFile nextBasedOn = (ArchitecturalViewFile)identifyingPathToFile.get(nextBasedOnEntry);
            if (nextBasedOn != null) {
                if (!nextFile.equals(nextBasedOn)) {
                    if (!nextBasedOn.hasAsParent(nextFile, false)) {
                        if (nextFile.getStructureMode().equals((Object)nextBasedOn.getStructureMode())) {
                            nextFile.changeParent(nextBasedOn, true);
                            continue;
                        }
                        nextFile.addIssue(new ArchitecturalViewFileInvalidBasedOnIssue(nextFile, "Ignored 'basedOn=\"" + nextBasedOnEntry + "\"' because of different 'structureMode' entries."));
                        continue;
                    }
                    nextFile.addIssue(new ArchitecturalViewFileInvalidBasedOnIssue(nextFile, "Ignored 'basedOn=\"" + nextBasedOnEntry + "\"' which would cause a cycle."));
                    continue;
                }
                nextFile.addIssue(new ArchitecturalViewFileInvalidBasedOnIssue(nextFile, "Ignored 'basedOn=\"" + nextBasedOnEntry + "\"' which references itself."));
                continue;
            }
            nextFile.addIssue(new ArchitecturalViewFileInvalidBasedOnIssue(nextFile, "'" + nextBasedOnEntry + "' not found."));
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        directory.getChildren(ArchitecturalViewFile.class).forEach(f -> this.updateInheritedOperations(inheritedFromToOperations, (ArchitecturalViewFile)f, null));
        if (!onSystemOpen) {
            ArrayList<SoftwareSystemEvent> eventsToDispatch = new ArrayList<SoftwareSystemEvent>();
            this.processModified(workerContext, this.m_softwareSystem, this.getAvailableArchitecturalViewFiles(), true, eventsToDispatch);
            eventsToDispatch.forEach(e -> EventManager.getInstance().dispatch((Object)this, (Event)e));
        }
    }

    protected final void fileContentModified(final ArchitecturalViewFile file) {
        assert (file != null) : "Parameter 'file' of method 'fileContentModified' must not be null";
        List<ArchitecturalViewFile> parentFiles = file.getParents(ArchitecturalViewFile.class, ArchitecturalViewsDirectory.class);
        Collections.reverse(parentFiles);
        LinkedHashMap<ArchitecturalViewFile, List<ArchitecturalViewOperation>> inheritedFromToOperations = new LinkedHashMap<ArchitecturalViewFile, List<ArchitecturalViewOperation>>();
        parentFiles.forEach(p -> {
            List<ArchitecturalViewOperation> list = inheritedFromToOperations.put((ArchitecturalViewFile)p, p.getNonInheritedOperations());
        });
        final ArrayList<ArchitecturalViewFile> processedFiles = new ArrayList<ArchitecturalViewFile>();
        this.updateInheritedOperations(inheritedFromToOperations, file, new Consumer<ArchitecturalViewFile>(){

            @Override
            public void accept(ArchitecturalViewFile processed) {
                if (processed != file) {
                    processedFiles.add(processed);
                }
            }
        });
        ArrayList<SoftwareSystemEvent> eventsToDispatch = new ArrayList<SoftwareSystemEvent>();
        this.processModified((IWorkerContext)DefaultWorkerContext.INSTANCE, this.m_softwareSystem, processedFiles, true, eventsToDispatch);
        eventsToDispatch.forEach(e -> EventManager.getInstance().dispatch((Object)this, (Event)e));
    }

    protected final LoadedRepresentationInfo getLoadedRepresentationInfo(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'getLoadedRepresentationInfo' must not be null";
        assert (element.isValid()) : "Not a valid element: " + String.valueOf(element);
        IExplorationViewRepresentationOwner owner = element.getParent(IExplorationViewRepresentationOwner.class, ParentMode.SELF_OR_FIRST_PARENT);
        assert (owner != null) : "'owner' of method 'getLoadedRepresentationInfo' must not be null";
        LoadedRepresentationInfo loadedInfo = new LoadedRepresentationInfo(owner, owner.getNamedElement().getUniqueChild(ArchitecturalViewOperationList.class), owner.getNamedElement().getUniqueChild(ArchitecturalViewFindingList.class), owner.getNamedElement().getUniqueExistingChild(ExplorationViewRepresentation.class));
        assert (!(element instanceof ExplorationViewRepresentation) || loadedInfo.getRepresentation() == element) : "Representations do not match";
        return loadedInfo;
    }
}

