/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocusProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.explorationview.RevealRequest;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;

public final class RevealCommand
extends ArchitecturalViewCommand<IRevealInteraction> {
    public RevealCommand(ISoftwareSystemProvider provider, IRevealInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public final ICommandId getId() {
        return CoreCommandId.REVEAL_IN_ARCHITECTURAL_VIEW;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        RevealData data = new RevealData();
        if (!((IRevealInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        RevealRequest request = data.getRequest();
        ExplorationViewFocusProperties focusProperties = request.getFocusProperties();
        if (focusProperties != null && !((IRevealInteraction)this.getInteraction()).collect(focusProperties)) {
            return;
        }
        this.getSoftwareSystem().getExtension(IArchitecturalViewProvider.class).reveal(request);
    }

    public static interface IRevealInteraction
    extends IArchitecturalViewCommandInteraction {
        public boolean collect(RevealData var1);

        public boolean collect(ExplorationViewFocusProperties var1);
    }

    public static final class RevealData
    implements IArchitecturalViewCommandInteractionData {
        private RevealRequest m_request;

        RevealData() {
        }

        public void setRequest(RevealRequest request) {
            assert (request != null) : "Parameter 'request' of method 'setRequest' must not be null";
            this.m_request = request;
        }

        RevealRequest getRequest() {
            assert (this.m_request != null) : "Parameter 'm_request' of method 'getRequest' must not be null";
            return this.m_request;
        }
    }
}

