/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.CreateArtifactData;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ICreateArtifactInteraction;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IArchitecturalViewExtension;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;

public final class CreateArtifactCommand
extends ArchitecturalViewCommand<ICreateArtifactInteraction> {
    public CreateArtifactCommand(ISoftwareSystemProvider provider, ICreateArtifactInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean providesProgress() {
        return false;
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.CREATE_ARCHITECTURAL_VIEW_ARTIFACT;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (this.getController().hasSoftwareSystem()) : "No system available";
        CreateArtifactData data = new CreateArtifactData();
        if (!((ICreateArtifactInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        IArchitecturalViewExtension extension = this.getController().getSoftwareSystem().getExtension(IArchitecturalViewExtension.class);
        OperationResult result = extension.createArtifact(workerContext, data.getTargetInfo(), data.getShortName(), data.getArtifactProperties(), data.getFilter());
        ((ICreateArtifactInteraction)this.getInteraction()).processCreateArtifactResult(result);
    }
}

