/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IReportExtension;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricCategory;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import de.schlichtherle.truezip.file.TFile;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public final class ExportMetaDataCommand
extends SoftwareSystemBasedCommand<IExportInteraction> {
    public ExportMetaDataCommand(ISoftwareSystemProvider provider, IExportInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.EXPORT_METADATA;
    }

    @Override
    protected boolean isUndoable() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        IReportExtension reportExtension = this.getController().getSoftwareSystem().getExtension(IReportExtension.class);
        ExportData data = new ExportData(reportExtension.getAvailableMetricIds(workerContext), reportExtension.getIssueProviderIds(workerContext), reportExtension.getIssueIds(workerContext));
        if (!((IExportInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        OperationResultWithOutcome<TFile> result = reportExtension.exportMetaData(workerContext, data.getMetricIds(), data.getIssueProviders(), data.getIssueIds(), data.getTargetFile());
        ((IExportInteraction)this.getInteraction()).processResult(result);
    }

    public static final class ExportData
    implements ICommandInteractionData {
        private List<IMetricId> m_metricIds;
        private TFile m_targetFile;
        private final Map<IMetricCategory, List<IMetricId>> m_availableMetricMap = new TreeMap<IMetricCategory, List<IMetricId>>(new IMetricCategory.CategoryComparator());
        private final List<IProviderId> m_issueProviderIds;
        private final List<IIssueId> m_issueIds;

        public ExportData(Map<IMetricCategory, List<IMetricId>> availableMetricMap, List<IProviderId> issueProviderIds, List<IIssueId> issueIds) {
            assert (availableMetricMap != null && this.convertMapValuesToList(availableMetricMap).size() > 0) : "Parameter 'availableMetricMap' of method 'MetricExportData' must not be empty";
            assert (issueProviderIds != null && !issueProviderIds.isEmpty()) : "Parameter 'issueProviderIds' of method 'ExportData' must not be empty";
            assert (issueIds != null && !issueIds.isEmpty()) : "Parameter 'issueIds' of method 'ExportData' must not be empty";
            this.m_availableMetricMap.putAll(availableMetricMap);
            this.m_issueProviderIds = issueProviderIds;
            this.m_issueIds = issueIds;
        }

        public Map<IMetricCategory, List<IMetricId>> getAvailableMetrics() {
            return Collections.unmodifiableMap(this.m_availableMetricMap);
        }

        public void setMetricIds(List<IMetricId> metricIds) {
            assert (metricIds != null && metricIds.size() > 0) : "Parameter 'metricIds' of method 'setMetricIds' must not be empty";
            this.m_metricIds = metricIds;
        }

        public List<IMetricId> getMetricIds() {
            return Collections.unmodifiableList(this.m_metricIds);
        }

        public void setTargetFile(TFile targetFile) {
            assert (targetFile != null) : "Parameter 'targetFile' of method 'setTargetFile' must not be null";
            this.m_targetFile = targetFile;
        }

        public TFile getTargetFile() {
            assert (this.m_targetFile != null) : "field m_targetFile is null";
            return this.m_targetFile;
        }

        private List<IMetricId> convertMapValuesToList(Map<IMetricCategory, List<IMetricId>> availableMetricMap) {
            return availableMetricMap.values().stream().flatMap(list -> list.stream()).distinct().collect(Collectors.toList());
        }

        public List<IProviderId> getIssueProviders() {
            return this.m_issueProviderIds;
        }

        public List<IIssueId> getIssueIds() {
            return this.m_issueIds;
        }
    }

    public static interface IExportInteraction
    extends ICommandInteraction {
        public boolean collect(ExportData var1);

        public void processResult(OperationResultWithOutcome<TFile> var1);
    }
}

