/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.SimpleSoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IWorkspaceExtension;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.IWorkspaceProvider;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import java.util.ArrayList;
import java.util.List;

public final class DeleteWorkspaceElementsCommand
extends SimpleSoftwareSystemBasedCommand {
    private final List<Element> m_workspaceElements;

    public DeleteWorkspaceElementsCommand(ISoftwareSystemProvider provider, SimpleSoftwareSystemBasedCommand.ISimpleCommandInteraction interaction, List<Element> workspaceElements) {
        super(provider, interaction);
        assert (workspaceElements != null) : "Parameter 'workspaceElements' of method 'DeleteWorkspaceElementCommand' must not be null";
        this.m_workspaceElements = workspaceElements;
    }

    @Override
    public final ICommandId getId() {
        return CoreCommandId.DELETE_WORKSPACE_ELEMENTS;
    }

    @Override
    public Result isEnabled() {
        Result enabled = super.isEnabled();
        if (enabled.isSuccess()) {
            if (this.m_workspaceElements.isEmpty()) {
                enabled.addErrorMessage("No workspace elements to delete");
            } else {
                List<Element> deletable = this.getController().getSoftwareSystem().getExtension(IWorkspaceProvider.class).getDeletableWorkspaceElements(this.m_workspaceElements);
                if (deletable == null || deletable.isEmpty()) {
                    enabled.addErrorMessage("Workspace elements are not deletable");
                }
            }
        }
        return enabled;
    }

    @Override
    public ActivityMode getActivityMode() {
        return ActivityMode.MODAL;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        OperationResult result = this.getSoftwareSystem().getExtension(IWorkspaceExtension.class).delete(workerContext, this.m_workspaceElements);
        ((SimpleSoftwareSystemBasedCommand.ISimpleCommandInteraction)this.getInteraction()).process(result);
    }

    @Override
    public List<String> getAdditionalExecutionInfo() {
        ArrayList<String> deleted = new ArrayList<String>();
        for (Element next : this.m_workspaceElements) {
            deleted.add("Deleted instance of class: " + next.getClass().getName());
        }
        return deleted;
    }

    @Override
    public boolean invalidatesParserModel() {
        return this.getController().getSoftwareSystem().getExtension(IWorkspaceProvider.class).deletionInvalidatesParserModel(this.m_workspaceElements);
    }
}

