/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SonargraphCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IBalancedDependencyRepresentationExtension;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.representation.BalancedDependencyRepresentation;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.Result;

public class CreateBalancedDependencyRepresentationCommand
extends SonargraphCommand {
    private final NamedElement m_input;
    private BalancedDependencyRepresentation m_representation;

    public CreateBalancedDependencyRepresentationCommand(ISoftwareSystemProvider provider, NamedElement input) {
        super(provider);
        assert (input != null) : "Parameter 'input' of method 'CreateBalancedDependencyRepresentationCommand' must not be null";
        this.m_input = input;
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.CREATE_BALANCED_DEPENDENCY_REPRESENTATION;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        this.m_representation = this.getController().getSoftwareSystem().getExtension(IBalancedDependencyRepresentationExtension.class).createDependencyRepresentation(workerContext, this.m_input, -1);
    }

    @Override
    public ActivityMode getActivityMode() {
        return ActivityMode.MODAL;
    }

    @Override
    public boolean providesProgress() {
        return false;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public Result isEnabled() {
        Result enabled = new Result();
        if (!this.getController().hasSoftwareSystem()) {
            enabled.addErrorMessage("No software system opened");
        }
        if (this.m_representation != null) {
            enabled.addErrorMessage("Symmetric Dependency representation already created");
        }
        return enabled;
    }

    public BalancedDependencyRepresentation getRepresentation() {
        return this.m_representation;
    }

    public NamedElement getInput() {
        return this.m_input;
    }

    public void setRepresentation(BalancedDependencyRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'setRepresentation' must not be null";
        this.m_representation = representation;
    }
}

