/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.userfeedback.model;

import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Feedback {
    private final TFile m_logFile;
    private Salutation m_salutation = Salutation.MR;
    private String m_contactName;
    private String m_userEmail;
    private String m_userPhone;
    private String m_contextInfo;
    private String m_activationCode;
    private final boolean m_testOnly;
    private final TFile m_rootForZip;
    private final Map<String, TFile> m_additionalFiles = new HashMap<String, TFile>();

    public Feedback(TFile logFile, boolean testOnly) {
        this(logFile, null, testOnly);
    }

    public Feedback(TFile logFile, TFile rootForZip, boolean testOnly) {
        this.m_logFile = logFile;
        this.m_testOnly = testOnly;
        this.m_rootForZip = rootForZip;
    }

    public void setAdditionalFiles(List<TFile> files) {
        assert (files != null) : "Parameter 'files' of method 'setAdditionalFile' must not be null";
        for (TFile next : files) {
            assert (!this.m_additionalFiles.containsKey(next.getName())) : "additionalFiles already contain a file with name '" + next.getName() + "'";
            this.m_additionalFiles.put(next.getName(), next);
        }
    }

    public List<TFile> getAdditionalFiles() {
        return Collections.unmodifiableList(new ArrayList<TFile>(this.m_additionalFiles.values()));
    }

    public boolean isTestOnly() {
        return this.m_testOnly;
    }

    public TFile getLogFile() {
        return this.m_logFile;
    }

    public TFile getRootForZip() {
        return this.m_rootForZip;
    }

    public void setActivationCode(String activationCode) {
        assert (activationCode != null) : "Parameter 'activationCode' of method 'setActivationCode' must not be null";
        this.m_activationCode = activationCode;
    }

    public String getActivationCode() {
        return this.m_activationCode;
    }

    public void setContactName(String contactName) {
        this.m_contactName = contactName;
    }

    public String getContactName() {
        return this.m_contactName;
    }

    public void setSalutation(Salutation salutation) {
        assert (salutation != null) : "Parameter 'salutation' of method 'setSalutation' must not be null";
        this.m_salutation = salutation;
    }

    public Salutation getSalutation() {
        return this.m_salutation;
    }

    public String getEmail() {
        return this.m_userEmail;
    }

    public void setEmail(String email) {
        this.m_userEmail = email;
    }

    public String getPhone() {
        return this.m_userPhone;
    }

    public void setPhone(String phone) {
        this.m_userPhone = phone;
    }

    public String getContextInfo() {
        return this.m_contextInfo;
    }

    public void setContextInfo(String contextInfo) {
        this.m_contextInfo = contextInfo;
    }

    public static final class Salutation
    extends Enum<Salutation>
    implements IStandardEnumeration {
        public static final /* enum */ Salutation MR = new Salutation("Mr.");
        public static final /* enum */ Salutation MRS = new Salutation("Mrs.");
        public static final /* enum */ Salutation MS = new Salutation("Ms.");
        public static final /* enum */ Salutation DR = new Salutation("Dr.");
        public static final /* enum */ Salutation PROF = new Salutation("Prof.");
        private String m_presentationName;
        private static final /* synthetic */ Salutation[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Salutation[]{MR, MRS, MS, DR, PROF};
        }

        private Salutation(String presentationName) {
            assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentationName' of method 'enclosing_method' must not be empty";
            this.m_presentationName = presentationName;
        }

        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return this.m_presentationName;
        }

        public static Salutation fromPresentationName(String presentationName) throws IllegalArgumentException {
            assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentationName' of method 'fromPresentationName' must not be empty";
            Salutation[] salutationArray = Salutation.values();
            int n = salutationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Salutation s = salutationArray[n2];
                if (s.getPresentationName().equalsIgnoreCase(presentationName)) {
                    return s;
                }
                ++n2;
            }
            return null;
        }

        public static Salutation[] values() {
            Salutation[] salutationArray = ENUM$VALUES;
            int n = salutationArray.length;
            Salutation[] salutationArray2 = new Salutation[n];
            System.arraycopy(ENUM$VALUES, 0, salutationArray2, 0, n);
            return salutationArray2;
        }

        public static Salutation valueOf(String string) {
            return Enum.valueOf(Salutation.class, string);
        }
    }
}

