/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.excel;

import com.hello2morrow.sonargraph.foundation.excel.ExcelExportMessageCause;
import com.hello2morrow.sonargraph.foundation.export.ColumnDatatype;
import com.hello2morrow.sonargraph.foundation.export.ExportData;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import jxl.Workbook;
import jxl.biff.DisplayFormat;
import jxl.format.CellFormat;
import jxl.write.DateFormat;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormats;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;

public final class ExcelExporter {
    public static final int MAX_ROW_COUNT = 65000;
    private static ExcelExporter s_instance;

    private ExcelExporter() {
    }

    public static ExcelExporter getInstance() {
        if (s_instance == null) {
            s_instance = new ExcelExporter();
        }
        return s_instance;
    }

    public void exportToFile(TFile filePath, List<ExportData> exportData, OperationResult result) {
        block6: {
            WritableWorkbook workbook = null;
            try {
                if (filePath.exists()) {
                    filePath.rm();
                }
                workbook = Workbook.createWorkbook((File)filePath);
                Collections.reverse(exportData);
                for (ExportData next : exportData) {
                    this.exportToWorkbook(workbook, next);
                }
                workbook.write();
                workbook.close();
            }
            catch (Exception e) {
                result.addError(ExcelExportMessageCause.FAILED_TO_CREATE_WORKBOOK, e);
                if (workbook == null || e instanceof IOException) break block6;
                try {
                    workbook.close();
                }
                catch (Exception e1) {
                    result.addError(ExcelExportMessageCause.FAILED_TO_CLOSE_WORKBOOK, e1);
                }
            }
        }
    }

    private void exportToWorkbook(WritableWorkbook workbook, ExportData exportData) throws RowsExceededException, WriteException {
        int rowCount = exportData.getRowCount();
        int columnCount = exportData.getColumnCount();
        int sheetRow = 0;
        WritableSheet[] sheets = new WritableSheet[rowCount / 65000 + 1];
        int i = 0;
        while (i < sheets.length) {
            sheets[i] = i == 0 ? workbook.createSheet(exportData.getSheetName(), 0) : workbook.createSheet(exportData.getSheetName() + "(" + (i + 1) + ")", 0 + i);
            ++i;
        }
        if (exportData.getSheetHeader() != null) {
            WritableFont headerFont = new WritableFont(WritableFont.ARIAL, 14, WritableFont.BOLD);
            WritableCellFormat headerFormat = new WritableCellFormat(headerFont);
            int j = 0;
            while (j < sheets.length) {
                sheets[j].addCell((WritableCell)new Label(0, sheetRow, exportData.getSheetHeader(), (CellFormat)headerFormat));
                ++j;
            }
            sheetRow += 2;
        }
        int[] columnWidth = new int[columnCount];
        List<String> names = exportData.getColumnNames();
        WritableFont columnHeaderFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD);
        WritableCellFormat columnHeaderFormat = new WritableCellFormat(columnHeaderFont);
        int i2 = 0;
        while (i2 < columnCount) {
            int j = 0;
            while (j < sheets.length) {
                String name = names.get(i2);
                columnWidth[i2] = name.length() > 10 ? name.length() : 10;
                sheets[j].addCell((WritableCell)new Label(i2, sheetRow, name, (CellFormat)columnHeaderFormat));
                ++j;
            }
            ++i2;
        }
        if (rowCount > 0) {
            sheetRow += 2;
            WritableCellFormat floatFormat = new WritableCellFormat(NumberFormats.FLOAT);
            WritableCellFormat integerFormat = new WritableCellFormat(NumberFormats.INTEGER);
            DateFormat customDateFormat = new DateFormat("yyyy-MM-dd");
            WritableCellFormat dateFormat = new WritableCellFormat((DisplayFormat)customDateFormat);
            int i3 = 0;
            while (i3 < rowCount) {
                int sheetColumn = 0;
                while (sheetColumn < columnCount) {
                    int sheetNumber = i3 / 65000;
                    int currentSheetRow = sheetRow - sheetNumber * 65000;
                    if (exportData.isColumnDatatype(sheetColumn, ColumnDatatype.NUMBER)) {
                        value = (java.lang.Number)exportData.getValueAt(i3, sheetColumn);
                        if (value != null) {
                            WritableCellFormat numberFormat = value instanceof Integer || value instanceof Long ? integerFormat : floatFormat;
                            sheets[sheetNumber].addCell((WritableCell)new Number(sheetColumn, currentSheetRow, ((java.lang.Number)value).doubleValue(), (CellFormat)numberFormat));
                        }
                    } else if (exportData.isColumnDatatype(sheetColumn, ColumnDatatype.DATE)) {
                        value = (Date)exportData.getValueAt(i3, sheetColumn);
                        if (value != null) {
                            sheets[sheetNumber].addCell((WritableCell)new DateTime(sheetColumn, currentSheetRow, (Date)value, (CellFormat)dateFormat));
                            String formattedValue = customDateFormat.getDateFormat().format((Date)value);
                            if (columnWidth[sheetColumn] < formattedValue.length() + 1) {
                                columnWidth[sheetColumn] = formattedValue.length() + 1;
                            }
                        }
                    } else {
                        value = exportData.getValueAt(i3, sheetColumn);
                        String stringValue = value == null ? "" : value.toString();
                        if (columnWidth[sheetColumn] < stringValue.length()) {
                            columnWidth[sheetColumn] = stringValue.length();
                        }
                        sheets[sheetNumber].addCell((WritableCell)new Label(sheetColumn, currentSheetRow, stringValue));
                    }
                    ++sheetColumn;
                }
                ++sheetRow;
                ++i3;
            }
        }
        int k = 0;
        while (k < columnCount) {
            int j = 0;
            while (j < sheets.length) {
                sheets[j].setColumnView(k, columnWidth[k]);
                ++j;
            }
            ++k;
        }
    }

    public static String getValidSheetName(String sheetName) {
        assert (sheetName != null && sheetName.length() > 0) : "Parameter 'sheetName' of method 'getValidSheetName' must not be empty";
        String result = sheetName;
        if (sheetName.length() > 31) {
            result = sheetName.substring(0, 31);
        }
        return result.replaceAll("[\\\\/?*\\[\\]:]", "-");
    }
}

