/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.service.impl;

import com.hello2morrow.sonargraph.build.api.RootPathInfo;
import com.hello2morrow.sonargraph.build.api.SystemInfo;
import com.hello2morrow.sonargraph.build.ui.BuildUserInterfaceAdapter;
import com.hello2morrow.sonargraph.core.command.system.AbstractOpenCommand;
import com.hello2morrow.sonargraph.core.command.system.CreateSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.OpenSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.SaveSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemMessageCause;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModificationOnSave;
import com.hello2morrow.sonargraph.core.model.path.QualityModelFileDescriptor;
import com.hello2morrow.sonargraph.core.model.path.ResolvedQualityModelDescriptorFile;
import com.hello2morrow.sonargraph.core.model.system.IAdditionalDynamicInfoProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.dynamic.DynamicSystemInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.ModuleInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.RootPathInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.RootPathType;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SonargraphBuildSystemOpener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonargraphBuildSystemOpener.class);

    static DynamicSystemInfo convertSystemInfo(Map<String, IAdditionalDynamicInfoProvider> infoProviders, SystemInfo system, OperationResult result) {
        assert (infoProviders != null) : "Parameter 'infoProviders' of method 'convertSystemInfo' must not be null";
        assert (system != null) : "Parameter 'system' of method 'convertSystemInfo' must not be null";
        assert (result != null) : "Parameter 'result' of method 'convertSystemInfo' must not be null";
        DynamicSystemInfo info = new DynamicSystemInfo(system.getId(), system.getName(), system.getDescription());
        HashMap<String, ModuleInfo> modules = new HashMap<String, ModuleInfo>();
        info.setTsConfigFile(system.getTsConfigFile());
        info.setPythonRoot(system.getPythonRoot());
        info.setPythonVirtualEnvironment(system.getPythonVirtualEnvironment());
        for (com.hello2morrow.sonargraph.build.api.ModuleInfo nextModule : system.getModules()) {
            IAdditionalDynamicInfoProvider infoProvider = infoProviders.get(nextModule.getLanguage());
            if (infoProvider == null) {
                result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.FAILED_TO_CREATE_MODULE, String.format("Module '%s' of language '%s' is not supported for dynamic creation!", nextModule.getName(), nextModule.getLanguage()), new Object[0]);
                return null;
            }
            String moduleType = infoProvider.getDynamicModuleType();
            ModuleInfo module = new ModuleInfo(nextModule.getId(), nextModule.getName(), nextModule.getDescription(), nextModule.getLanguage(), moduleType);
            info.addModule(module);
            modules.put(module.getId(), module);
        }
        for (com.hello2morrow.sonargraph.build.api.ModuleInfo nextModule : system.getModules()) {
            RootPathInfo rootPathInfo;
            ModuleInfo module = (ModuleInfo)modules.get(nextModule.getId());
            for (com.hello2morrow.sonargraph.build.api.ModuleInfo nextDep : nextModule.getDependsUpon()) {
                ModuleInfo dep = (ModuleInfo)modules.get(nextDep.getId());
                assert (dep != null) : "Dependency to module '" + nextDep.getId() + "' cannot be created";
                module.addDependsOn(dep);
            }
            IAdditionalDynamicInfoProvider infoProvider = infoProviders.get(nextModule.getLanguage());
            RootPathType outPathType = infoProvider.getCompileDirectoryRootPathType();
            RootPathType sourcePathType = infoProvider.getSourceDirectoryRootPathType();
            for (com.hello2morrow.sonargraph.build.api.RootPathInfo nextRoot : nextModule.getRootPathsByCategory(RootPathInfo.Category.OUT)) {
                rootPathInfo = new RootPathInfo(nextRoot.getAbsolutePath(), outPathType);
                module.addRootPath(rootPathInfo);
            }
            for (com.hello2morrow.sonargraph.build.api.RootPathInfo nextRoot : nextModule.getRootPathsByCategory(RootPathInfo.Category.SOURCE)) {
                rootPathInfo = new RootPathInfo(nextRoot.getAbsolutePath(), sourcePathType, false);
                module.addRootPath(rootPathInfo);
            }
            for (com.hello2morrow.sonargraph.build.api.RootPathInfo nextRoot : nextModule.getRootPathsByCategory(RootPathInfo.Category.GENERATED_SOURCE)) {
                rootPathInfo = new RootPathInfo(nextRoot.getAbsolutePath(), sourcePathType, true);
                module.addRootPath(rootPathInfo);
            }
        }
        return info;
    }

    static TFile determineQualityModelFile(ISoftwareSystemProvider systemProvider, TFile qualityModelFile, OperationResult result) {
        assert (systemProvider != null) : "Parameter 'systemProvider' of method 'determineQualityModelFile' must not be null";
        assert (qualityModelFile != null) : "Parameter 'qualityModelFile' of method 'determineQualityModelFile' must not be null";
        assert (result != null) : "Parameter 'result' of method 'determineQualityModelFile' must not be null";
        String path = qualityModelFile.getPath();
        if (!path.startsWith("Sonargraph:")) {
            if (!qualityModelFile.exists()) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, "Quality model '" + qualityModelFile.getNormalizedAbsolutePath() + "' does not exist!", new Object[0]);
            } else if (!qualityModelFile.isDirectory() || !qualityModelFile.isArchive()) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, "Quality model '" + qualityModelFile.getNormalizedAbsolutePath() + "' is not a an archive!", new Object[0]);
            }
            return qualityModelFile;
        }
        String identifier = path.substring("Sonargraph:".length(), path.length());
        Object actualIdentifier = !identifier.endsWith(CoreFileType.QUALITY_MODEL.getDefaultExtension()) ? identifier + CoreFileType.QUALITY_MODEL.getDefaultExtension() : identifier;
        List descriptors = CreateSoftwareSystemCommand.getQualityModelFileDescriptors((ISoftwareSystemProvider)systemProvider);
        List<ResolvedQualityModelDescriptorFile> resolved = SonargraphBuildSystemOpener.loadQualityModelFiles(descriptors, result);
        Optional<ResolvedQualityModelDescriptorFile> match = resolved.stream().filter(arg_0 -> SonargraphBuildSystemOpener.lambda$0((String)actualIdentifier, arg_0)).findFirst();
        if (match.isPresent()) {
            return match.get().getResolvedFile();
        }
        result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, "Failed to load quality model '" + (String)actualIdentifier + "' from installation!", new Object[0]);
        return null;
    }

    private static List<ResolvedQualityModelDescriptorFile> loadQualityModelFiles(List<QualityModelFileDescriptor> qualityModelFileDescriptors, OperationResult result) {
        assert (qualityModelFileDescriptors != null && !qualityModelFileDescriptors.isEmpty()) : "Parameter 'qualityModelFileDescriptors' of method 'loadQualityModelFiles' must not be empty";
        ArrayList<ResolvedQualityModelDescriptorFile> resolvedDescriptors = new ArrayList<ResolvedQualityModelDescriptorFile>(qualityModelFileDescriptors.size());
        for (QualityModelFileDescriptor nextQMFileDescriptor : qualityModelFileDescriptors) {
            Bundle bundle = Platform.getBundle((String)nextQMFileDescriptor.getBundleId());
            if (bundle == null) continue;
            try {
                URL configURL = bundle.getResource(nextQMFileDescriptor.getFileName());
                TFile resourceFile = new TFile(FileLocator.toFileURL((URL)configURL).getPath());
                if (!resourceFile.exists()) {
                    result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, "QualityModel file '" + nextQMFileDescriptor.getFileName() + "' does not exist!", new Object[0]);
                }
                resolvedDescriptors.add(new ResolvedQualityModelDescriptorFile(nextQMFileDescriptor, resourceFile));
            }
            catch (Exception ex) {
                LOGGER.error("Cannot get quality model file", (Throwable)ex);
            }
        }
        return resolvedDescriptors;
    }

    static OpenSoftwareSystemCommand createOpenCommand(final ISoftwareSystemProvider systemProvider, final File systemDirectory, final String workspaceProfile, final File qualityModelFile, final DynamicSystemInfo dynamicSystem, final OperationResult openResult) {
        assert (systemProvider != null) : "Parameter 'systemProvider' of method 'createOpenCommand' must not be null";
        assert (systemDirectory != null) : "Parameter 'systemDirectory' of method 'createOpenCommand' must not be null";
        OpenSoftwareSystemCommand open = new OpenSoftwareSystemCommand(systemProvider, new AbstractOpenCommand.IOpenInteraction(){

            public Map<IModifiableFile, IModificationOnSave> aboutToSave(SoftwareSystem system, List<IModifiableFile> toBeSaved) {
                if (!$assertionsDisabled && system == null) {
                    throw new AssertionError((Object)"Parameter 'system' of method 'aboutToSave' must not be null");
                }
                if (!$assertionsDisabled && toBeSaved == null) {
                    throw new AssertionError((Object)"Parameter 'toBeSaved' of method 'aboutToSave' must not be null");
                }
                return Collections.emptyMap();
            }

            public boolean closeSoftwareSystem() {
                LOGGER.error("There is already an open software system.");
                return false;
            }

            public boolean collectSaveData(SaveSoftwareSystemCommand.ModifiableFilesToBeSavedData data) {
                return true;
            }

            public boolean processSaveResult(OperationResult result) {
                return true;
            }

            public INavigationState getNavigationState() {
                return null;
            }

            public boolean collectOpenData(AbstractOpenCommand.OpenData data) {
                data.setLocation(new TFile(systemDirectory));
                if (workspaceProfile != null) {
                    data.setWorkspaceProfileName(workspaceProfile);
                }
                if (qualityModelFile != null) {
                    data.setQualityModelFile(SonargraphBuildSystemOpener.determineQualityModelFile(systemProvider, new TFile(qualityModelFile), openResult));
                }
                if (dynamicSystem != null) {
                    data.setDynamicSystemInfo(dynamicSystem);
                }
                return true;
            }

            public void processOpenResult(OperationResult result) {
                BuildUserInterfaceAdapter.getInstance().process(result);
                openResult.addMessagesFromAndSetOutcome(result);
            }

            public boolean confirmSystemSaveDueToExternalFileChangesOnOpen(boolean hasUndoHistory) {
                return false;
            }

            public void processSaveResultDueToExternalFileChangesOnOpen(OperationResult saveResult) {
                BuildUserInterfaceAdapter.getInstance().process(saveResult);
            }
        }, false);
        return open;
    }

    private static /* synthetic */ boolean lambda$0(String string, ResolvedQualityModelDescriptorFile r) {
        return r.getResolvedFile().getName().equalsIgnoreCase(string);
    }
}

