/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.go.model.programming;

import com.hello2morrow.sonargraph.core.model.element.GenericStructureItem;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IRefactorable;
import com.hello2morrow.sonargraph.core.model.element.IStructureItem;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.utilities.Joiner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class GoTypeAlias
extends ProgrammingElement
implements IRefactorable {
    private String m_type;
    private List<String> m_typeParameters;

    public GoTypeAlias(NamedElement parent) {
        super(parent);
    }

    public GoTypeAlias(IModelServiceProvider msp, NamedElement parent, String shortName, int lineNumber, String type, List<String> typeParameters) {
        super(msp, parent, shortName, lineNumber);
        assert (type != null);
        assert (typeParameters != null);
        this.m_type = type;
        this.m_typeParameters = typeParameters;
    }

    public ProgrammingElement getOriginal() {
        if (!this.isExternal()) {
            return (ProgrammingElement)this.getOriginal(this.getModelServiceProvider());
        }
        return this;
    }

    public ProgrammingElement getRepresentative() {
        if (!this.isExternal()) {
            return (ProgrammingElement)this.getRepresentative(this.getModelServiceProvider());
        }
        return this;
    }

    public List<String> getTypeParameters() {
        return this.m_typeParameters;
    }

    public String getPresentationName(boolean shortName) {
        StringBuilder sb = new StringBuilder();
        if (!shortName) {
            sb.append(this.getParent().getPresentationName(shortName)).append('.');
        }
        sb.append(this.getShortName());
        if (!this.m_typeParameters.isEmpty()) {
            sb.append('[').append(Joiner.join(this.m_typeParameters)).append(']');
        }
        return sb.toString();
    }

    public IStructureItem getStructureItem() {
        return GenericStructureItem.PROGRAMMING_ELEMENT;
    }

    public String getFullyQualifiedNamePart() {
        return super.getFullyQualifiedNamePart() + "-" + Integer.toString(this.getLineNumber());
    }

    public boolean isMember() {
        return false;
    }

    public String getType() {
        return this.m_type;
    }

    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(this.m_type);
        writer.writeString(Joiner.join(this.m_typeParameters, (String)";"));
    }

    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_type = reader.readString();
        String typeParamsStr = reader.readString();
        String[] typeParams = typeParamsStr.split(";");
        this.m_typeParameters = new ArrayList<String>(typeParams.length);
        Arrays.stream(typeParams).forEach(tp -> {
            boolean bl = this.m_typeParameters.add((String)tp);
        });
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitGoTypeAlias(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor {
        public void visitGoTypeAlias(GoTypeAlias var1);
    }
}

