/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.go.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.WorkspaceExtension;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericRootDirectory;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.DirectoryScanner;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.go.foundation.common.GoMessageCause;
import com.hello2morrow.sonargraph.languageprovider.go.model.IGoWorkspaceProvider;
import com.hello2morrow.sonargraph.languageprovider.go.model.path.GoFileType;
import com.hello2morrow.sonargraph.languageprovider.go.model.workspace.GoModule;
import com.hello2morrow.sonargraph.languageprovider.go.model.workspace.GoModuleType;
import de.schlichtherle.truezip.file.TFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;

public final class GoWorkspaceExtension
extends Extension
implements IGoWorkspaceProvider {
    private final IFinishModelProcessor m_finishModelProcessor;

    public GoWorkspaceExtension(IFinishModelProcessor finishModelProcessor) {
        this.m_finishModelProcessor = finishModelProcessor;
    }

    private String extractModuleName(TFile goModFile) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new FileReader((File)goModFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!(line = line.trim()).startsWith("module ")) continue;
                String moduleName = line.substring(7).trim();
                return moduleName;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }

    @Override
    public List<TFile> findGoModuleFiles(TFile root) {
        DirectoryScanner scanner = new DirectoryScanner(Collections.emptyList(), false);
        Consumer consumer = new Consumer();
        scanner.scan(root, (DirectoryScanner.IFileConsumer)consumer);
        return consumer.getModuleFiles();
    }

    private void addModule(SoftwareSystem system, WorkspaceExtension wsExt, EnumSet<Modification> modification, TFile goModFile, String name) {
        Module module = wsExt.createModule((Module.IModuleType)GoModuleType.GO_MODULE, name, "", modification);
        GenericRootDirectory root = new GenericRootDirectory((IModelServiceProvider)system, (NamedElement)module, goModFile.getParentFile().getNormalizedAbsoluteFile());
        module.addChild((NamedElement)root);
    }

    public void initGoSoftwareSystem(OperationResult result, SoftwareSystem system, List<TFile> goModFiles) {
        assert (result != null);
        assert (goModFiles != null && !goModFiles.isEmpty());
        ArrayList<String> moduleNames = new ArrayList<String>();
        ArrayList<TFile> duplicateModules = new ArrayList<TFile>();
        for (TFile goMod : goModFiles) {
            try {
                String name = this.extractModuleName(goMod);
                if (name == null) {
                    result.addError((OperationResult.IMessageCause)GoMessageCause.CANNOT_EXTRACT_MODULE_NAME, "Cannot extract module name from: " + goMod.getPath(), new Object[0]);
                    return;
                }
                if (moduleNames.contains(name)) {
                    duplicateModules.add(goMod);
                }
                moduleNames.add(name);
            }
            catch (IOException ex) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, (Throwable)ex, "File '%s'", new Object[]{goMod.getPath()});
                return;
            }
        }
        WorkspaceExtension wsExt = (WorkspaceExtension)system.getExtension(WorkspaceExtension.class);
        EnumSet<Modification> modification = EnumSet.noneOf(Modification.class);
        int i = 0;
        while (i < goModFiles.size()) {
            TFile goModFile = goModFiles.get(i);
            if (duplicateModules.contains(goModFile)) {
                result.addWarning((OperationResult.IMessageCause)GoMessageCause.DUPLICATE_MODULE_NAME, String.format("Could not add module file '%s' since module name is already taken.", goModFile.getAbsolutePath()), new Object[0]);
            } else {
                this.addModule(system, wsExt, modification, goModFile, (String)moduleNames.get(i));
            }
            ++i;
        }
        system.setNeedsSave(true);
        this.m_finishModelProcessor.finishModification((IWorkerContext)DefaultWorkerContext.INSTANCE, system, modification, result);
    }

    public void addModulesToSystem(IWorkerContext workerContext, OperationResult result, SoftwareSystem system, List<TFile> goModFiles) {
        Workspace ws = (Workspace)system.getUniqueExistingChild(Workspace.class);
        List modules = ws.getChildren(GoModule.class);
        ArrayList<String> moduleNames = new ArrayList<String>();
        ArrayList<TFile> moduleFiles = new ArrayList<TFile>();
        ArrayList<TFile> failedModules = new ArrayList<TFile>();
        HashMap<TFile, String> moduleNameMap = new HashMap<TFile, String>();
        for (GoModule mod : modules) {
            moduleNames.add(mod.getName());
            moduleFiles.add(mod.getGoModFile());
        }
        for (TFile modFile : goModFiles) {
            try {
                String moduleName = this.extractModuleName(modFile);
                moduleNameMap.put(modFile, moduleName);
                if (moduleNames.contains(moduleName) || moduleFiles.contains(modFile)) {
                    failedModules.add(modFile);
                    continue;
                }
                moduleNames.add(moduleName);
                moduleFiles.add(modFile);
            }
            catch (IOException ex) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, (Throwable)ex, "File '%s'", new Object[]{modFile.getPath()});
                return;
            }
        }
        WorkspaceExtension wsExt = (WorkspaceExtension)system.getExtension(WorkspaceExtension.class);
        EnumSet<Modification> modification = EnumSet.noneOf(Modification.class);
        boolean failure = failedModules.size() == goModFiles.size();
        for (TFile modFile : goModFiles) {
            if (failedModules.contains(modFile)) {
                if (failure) {
                    result.addError((OperationResult.IMessageCause)GoMessageCause.DUPLICATE_MODULE_NAME, String.format("Could not add module file '%s' since module name is already taken.", modFile.getAbsolutePath()), new Object[0]);
                    continue;
                }
                result.addWarning((OperationResult.IMessageCause)GoMessageCause.DUPLICATE_MODULE_NAME, String.format("Could not add module file '%s' since module name is already taken.", modFile.getAbsolutePath()), new Object[0]);
                continue;
            }
            this.addModule(system, wsExt, modification, modFile, (String)moduleNameMap.get(modFile));
        }
        if (!failure) {
            system.setNeedsSave(true);
        }
        this.m_finishModelProcessor.finishModification(workerContext, system, modification, result);
    }

    private static class Consumer
    implements DirectoryScanner.IFileConsumer {
        private final List<TFile> m_moduleFiles = new ArrayList<TFile>();

        private Consumer() {
        }

        public IFileType accepts(TFile file) {
            if (file.getName().equals("go.mod") && file.canRead()) {
                return GoFileType.MODULE_FILE;
            }
            return null;
        }

        public void consume(TFile rootPathBeingScanned, TFile file, IFileType fileType) {
            this.m_moduleFiles.add(file);
        }

        public boolean includeDirectory(TFile dir) {
            return !dir.getName().startsWith(".");
        }

        List<TFile> getModuleFiles() {
            return this.m_moduleFiles;
        }
    }
}

