/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.client;

import com.hello2morrow.sonargraph.build.api.FailSet;
import com.hello2morrow.sonargraph.build.api.ISonargraphBuild;
import com.hello2morrow.sonargraph.build.api.ReportRequest;
import com.hello2morrow.sonargraph.build.api.ResendFailedUploadsRequest;
import com.hello2morrow.sonargraph.build.api.ServiceResponse;
import com.hello2morrow.sonargraph.build.api.SonargraphBuildException;
import com.hello2morrow.sonargraph.build.api.StartupRequest;
import com.hello2morrow.sonargraph.build.api.SystemOpenRequest;
import com.hello2morrow.sonargraph.build.client.ConfigurationFileParser;
import com.hello2morrow.sonargraph.build.client.CreateReportInteraction;
import com.hello2morrow.sonargraph.build.client.ISonargraphBuildClient;
import com.hello2morrow.sonargraph.build.client.ISonargraphBuildInteraction;
import com.hello2morrow.sonargraph.build.client.Params;
import com.hello2morrow.sonargraph.build.client.ResendFailedUploadsInteraction;
import com.hello2morrow.sonargraph.build.client.SonargraphBuildClientVersionManager;
import com.hello2morrow.sonargraph.build.client.SonargraphBuildTransaction;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class SonargraphBuildRunner
implements ISonargraphBuildClient {
    private static final Operation DEFAULT_OPERATION = Operation.CREATE_REPORT;
    private static final int FATAL_ERROR = 3;
    private static final int SUCCESS = 0;
    private static final int FAILSET_ERROR = 1;
    private static final int EXPECTED_ERROR = 2;
    private final SonargraphBuildClientVersionManager m_versionManager = new SonargraphBuildClientVersionManager();

    @Override
    public String getClientName() {
        return "Shell";
    }

    @Override
    public void info(String msg) {
        assert (msg != null) : "Parameter 'msg' of method 'info' must not be null";
        System.out.println(msg);
    }

    @Override
    public void error(String msg) {
        assert (msg != null) : "Parameter 'msg' of method 'error' must not be null";
        System.err.println(msg);
    }

    @Override
    public File getDefaultOutputDirectory() {
        return new File(".");
    }

    @Override
    public File getProjectDirectory() {
        return new File(".");
    }

    @Override
    public ISonargraphBuild.Version getVersion() {
        return this.m_versionManager.getVersion();
    }

    private ServiceResponse executeSequence(Operation operation, Map<Params, String> params, FailSet failSet) throws Exception, SonargraphBuildException {
        assert (operation != null) : "Parameter 'operation' of method 'executeSequence' must not be null";
        assert (params != null && params.size() > 0) : "Parameter 'params' of method 'executeSequence' must not be empty";
        ArrayList<ISonargraphBuildInteraction> interactions = new ArrayList<ISonargraphBuildInteraction>();
        StartupRequest startupRequest = SonargraphBuildRunner.createStartupRequest(params);
        if (operation == Operation.CREATE_REPORT) {
            SystemOpenRequest openRequest = SonargraphBuildRunner.createOpenRequest(params);
            ReportRequest reportRequest = SonargraphBuildRunner.createReportRequest(params);
            CreateReportInteraction createReport = new CreateReportInteraction(this, openRequest, reportRequest, failSet);
            interactions.add(createReport);
        } else if (operation == Operation.RESEND_FAILED_UPLOADS) {
            ResendFailedUploadsRequest resendRequest = SonargraphBuildRunner.createResendFailedUploadsRequest(params);
            ResendFailedUploadsInteraction resendUploads = new ResendFailedUploadsInteraction(this, resendRequest);
            interactions.add(resendUploads);
        }
        SonargraphBuildTransaction transaction = new SonargraphBuildTransaction(this, startupRequest, interactions);
        ServiceResponse transactionResponse = transaction.execute();
        return transactionResponse;
    }

    public static void main(String[] args) {
        String[] parameterArguments;
        Operation operation;
        if (args == null || args.length < 1) {
            System.err.println("Missing argument: Path to XML configuration file that contains the run configuration.");
            System.exit(2);
            return;
        }
        String configFileName = args[0];
        File config = new File(args[0]);
        SonargraphBuildRunner client = new SonargraphBuildRunner();
        if (!config.exists()) {
            client.error(String.format("Provided configuration file '%s' does not exist!", configFileName));
            System.exit(2);
        }
        if (!config.isFile()) {
            client.error(String.format("Provided configuration file '%s' is not a file!", configFileName));
            System.exit(2);
        }
        if (!config.canRead()) {
            client.error(String.format("Provided configuration file '%s' cannot be read!", configFileName));
            System.exit(2);
        }
        if (args.length == 1) {
            operation = DEFAULT_OPERATION;
            parameterArguments = new String[]{};
        } else {
            String possibleOperation = args[1];
            if (possibleOperation.contains("=")) {
                operation = DEFAULT_OPERATION;
                parameterArguments = Arrays.copyOfRange(args, 1, args.length);
            } else {
                operation = Operation.fromName(possibleOperation);
                if (operation == null) {
                    client.error(String.format("Unsupported operation '%s'!", possibleOperation));
                    System.exit(2);
                }
                parameterArguments = Arrays.copyOfRange(args, 2, args.length);
            }
        }
        ServiceResponse transactionResponse = null;
        try {
            client.info("Parsing configuration file: " + configFileName);
            ConfigurationFileParser parser = new ConfigurationFileParser();
            parser.process(config);
            Map<Params, String> params = parser.getRootParams();
            params.putAll(client.parseArgs(parameterArguments));
            transactionResponse = client.executeSequence(operation, params, parser.getFailSet());
        }
        catch (SonargraphBuildException ex) {
            client.error(String.format("Build failed with %s: %s", ex.getClass().getName(), ex.getMessage()));
            ex.printStackTrace();
            System.exit(2);
        }
        catch (Exception ex) {
            client.error(String.format("Fatal error during execution of SonargraphBuild! %s: %s", ex.getClass().getName(), ex.getMessage()));
            ex.printStackTrace();
            System.exit(3);
        }
        if (transactionResponse == null) {
            client.error("Failed to execute SonargraphBuild!");
            System.exit(3);
            return;
        }
        if (transactionResponse.isFailure()) {
            client.error("Failed to execute SonargraphBuild:\n" + transactionResponse.getStatusMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    Map<Params, String> parseArgs(String[] args) {
        if (args.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<Params, String> argsMap = new HashMap<Params, String>();
        for (int i = 0; i < args.length; ++i) {
            String next = args[i];
            String[] line = next.split("=");
            if (line.length != 2) {
                this.info("Ignoring argument " + next);
                continue;
            }
            String paramName = line[0].trim();
            try {
                Params param = Params.fromParameterName(paramName);
                String value = line[1].trim();
                argsMap.put(param, value);
                continue;
            }
            catch (IllegalArgumentException ex) {
                this.error("Unsupported parameter '" + paramName + "'");
            }
        }
        return argsMap;
    }

    private static StartupRequest createStartupRequest(Map<Params, String> paramMap) {
        String requiredProfiles;
        StartupRequest request = new StartupRequest();
        request.setInstallationDirectory(paramMap.get((Object)Params.INSTALLATION_DIRECTORY));
        request.setActivationCode(paramMap.get((Object)Params.ACTIVATION_CODE));
        request.setLicenseFile(paramMap.get((Object)Params.LICENSE_FILE));
        request.setLanguages(paramMap.get((Object)Params.LANGUAGES));
        request.setAnalyzerExecutionLevel(paramMap.get((Object)Params.ANALYZER_EXECUTION_LEVEL));
        String activeDefinition = paramMap.get((Object)Params.COMPILER_DEFINITION_PATH);
        if (activeDefinition != null && !activeDefinition.trim().isEmpty()) {
            request.addLanguageIfNotPresent("CPlusPlus");
        }
        if ((requiredProfiles = paramMap.get((Object)Params.REQUIRED_INSTALLATION_PROFILES)) != null && !requiredProfiles.trim().isEmpty()) {
            request.addLanguageIfNotPresent("CSharp");
        }
        request.setLogFile(paramMap.get((Object)Params.LOG_FILE));
        request.setLogLevel(paramMap.get((Object)Params.LOG_LEVEL));
        request.setProgressInfoAsString(paramMap.get((Object)Params.PROGRESS_INFO));
        request.setProxyHost(paramMap.get((Object)Params.PROXY_HOST));
        request.setProxyPort(paramMap.get((Object)Params.PROXY_PORT));
        request.setProxyUsername(paramMap.get((Object)Params.PROXY_USERNAME));
        request.setProxyPassword(paramMap.get((Object)Params.PROXY_PASSWORD));
        request.setLicenseServerHost(paramMap.get((Object)Params.LICENSE_SERVER_HOST));
        request.setLicenseServerPort(paramMap.get((Object)Params.LICENSE_SERVER_PORT));
        request.setLicenseServerUrl(paramMap.get((Object)Params.LICENSE_SERVER_URL));
        request.setWaitForLicenseString(paramMap.get((Object)Params.WAIT_FOR_LICENSE));
        return request;
    }

    private static SystemOpenRequest createOpenRequest(Map<Params, String> paramMap) {
        SystemOpenRequest request = new SystemOpenRequest();
        request.setSystemDirectory(paramMap.get((Object)Params.SYSTEM_DIRECTORY));
        request.setWorkspaceProfile(paramMap.get((Object)Params.WORKSPACE_PROFILE));
        request.setVirtualModel(paramMap.get((Object)Params.VIRTUAL_MODEL));
        request.setQualityModelFile(paramMap.get((Object)Params.QUALITY_MODEL_FILE));
        request.setSnaphotDirectory(paramMap.get((Object)Params.SNAPSHOT_DIRECTORY));
        request.setSnapshotFileName(paramMap.get((Object)Params.SNAPSHOT_FILE_NAME));
        request.setInstallationSpecificParameter(Params.COMPILER_DEFINITION_PATH.getParameterName(), paramMap.get((Object)Params.COMPILER_DEFINITION_PATH));
        request.setInstallationSpecificParameter(Params.REQUIRED_INSTALLATION_PROFILES.getParameterName(), paramMap.get((Object)Params.REQUIRED_INSTALLATION_PROFILES));
        request.setInstallationSpecificParameter(Params.NUMBER_OF_DAEMONS.getParameterName(), paramMap.get((Object)Params.NUMBER_OF_DAEMONS));
        request.setInstallationSpecificParameter(Params.DAEMON_STACK_SIZE.getParameterName(), paramMap.get((Object)Params.DAEMON_STACK_SIZE));
        return request;
    }

    private static ReportRequest createReportRequest(Map<Params, String> paramMap) {
        ReportRequest request = new ReportRequest();
        request.setReportDirectory(paramMap.get((Object)Params.REPORT_DIRECTORY));
        request.setReportFileName(paramMap.get((Object)Params.REPORT_FILE_NAME));
        request.setReportType(paramMap.get((Object)Params.REPORT_TYPE));
        request.setReportFormat(paramMap.get((Object)Params.REPORT_FORMAT));
        request.setElementCountToSplitHtmlReport(SonargraphBuildRunner.getIntegerValue(paramMap, Params.ELEMENT_COUNT_TO_SPLIT_HTML_REPORT, 0));
        request.setMaxElementCountForHtmlDetailsPage(SonargraphBuildRunner.getIntegerValue(paramMap, Params.MAX_ELEMENT_COUNT_FOR_HTML_DETAILS_PAGE, 0));
        request.setSplitByModule(Boolean.parseBoolean(paramMap.get((Object)Params.SPLIT_BY_MODULE)));
        request.setBaselineReportPath(paramMap.get((Object)Params.BASELINE_REPORT_PATH));
        request.setUploadHostUrl(paramMap.get((Object)Params.UPLOAD_HOST_URL));
        request.setCreateAndUploadSnapshot(Boolean.parseBoolean(paramMap.get((Object)Params.CREATE_AND_UPLOAD_SNAPSHOT)));
        request.setFailedUploadDirectory(paramMap.get((Object)Params.FAILED_UPLOAD_DIRECTORY));
        request.setClientKey(paramMap.get((Object)Params.CLIENT_KEY));
        request.setBranch(paramMap.get((Object)Params.BRANCH));
        request.setVersion(paramMap.get((Object)Params.VERSION));
        request.setCommitId(paramMap.get((Object)Params.COMMIT_ID));
        request.setTimestampAsString(paramMap.get((Object)Params.TIMESTAMP));
        request.setContextInfo(paramMap.get((Object)Params.CONTEXT_INFO));
        return request;
    }

    private static ResendFailedUploadsRequest createResendFailedUploadsRequest(Map<Params, String> paramMap) {
        assert (paramMap != null) : "Parameter 'params' of method 'createResendFailedUploadsRequest' must not be null";
        ResendFailedUploadsRequest request = new ResendFailedUploadsRequest(paramMap.get((Object)Params.UPLOAD_HOST_URL), paramMap.get((Object)Params.CLIENT_KEY), paramMap.get((Object)Params.FAILED_UPLOAD_DIRECTORY));
        return request;
    }

    private static int getIntegerValue(Map<Params, String> paramMap, Params param, int defaultValue) {
        String value = paramMap.get((Object)param);
        if (value == null) {
            return defaultValue;
        }
        try {
            int number = Integer.parseInt(value.trim());
            return number;
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException("Invalid value '" + value + "' for parameter '" + param.getParameterName() + "'. Possible values are: " + param.getValueInfo());
        }
    }

    private static final class Operation
    extends Enum<Operation> {
        public static final /* enum */ Operation CREATE_REPORT = new Operation("createReport");
        public static final /* enum */ Operation RESEND_FAILED_UPLOADS = new Operation("resendFailedUploads");
        private String m_name;
        private static final /* synthetic */ Operation[] $VALUES;

        public static Operation[] values() {
            return (Operation[])$VALUES.clone();
        }

        public static Operation valueOf(String name) {
            return Enum.valueOf(Operation.class, name);
        }

        private Operation(String name) {
            assert (name != null && name.length() > 0) : "Parameter 'name' of method 'Operation' must not be empty";
            this.m_name = name;
        }

        public static Operation fromName(String name) {
            assert (name != null && name.length() > 0) : "Parameter 'name' of method 'fromName' must not be empty";
            for (Operation next : Operation.values()) {
                if (!next.m_name.equalsIgnoreCase(name)) continue;
                return next;
            }
            return null;
        }

        private static /* synthetic */ Operation[] $values() {
            return new Operation[]{CREATE_REPORT, RESEND_FAILED_UPLOADS};
        }

        static {
            $VALUES = Operation.$values();
        }
    }
}

