/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.api;

import com.hello2morrow.sonargraph.build.api.FailSet;
import com.hello2morrow.sonargraph.build.api.ReportRequest;
import com.hello2morrow.sonargraph.build.api.ResendFailedUploadsRequest;
import com.hello2morrow.sonargraph.build.api.ServiceResponse;
import com.hello2morrow.sonargraph.build.api.ServiceResponseWithOutcome;
import com.hello2morrow.sonargraph.build.api.SystemInfo;
import java.io.File;
import java.io.Serializable;
import java.util.Map;

public interface ISonargraphBuild {
    public ServiceResponse open(File var1);

    @Deprecated
    public ServiceResponse open(File var1, String var2);

    @Deprecated
    public ServiceResponse open(File var1, String var2, File var3);

    public ServiceResponse open(File var1, SystemInfo var2, String var3, File var4);

    public ServiceResponse open(File var1, SystemInfo var2, String var3, File var4, Map<String, String> var5);

    public ServiceResponse getInitializationStatus();

    default public Version getVersion() {
        return new Version(8, 6, 3, 356);
    }

    public ServiceResponse refresh();

    public ServiceResponse createReport(ReportRequest var1);

    public ServiceResponse createSnapshot(File var1, String var2);

    public ServiceResponse resendFaildUploads(ResendFailedUploadsRequest var1);

    public ServiceResponse failIfExists(FailSet var1);

    public ServiceResponse checkQualityGates();

    public ServiceResponse close();

    public ServiceResponse setVirtualModel(String var1);

    public ServiceResponse getScriptRunnerStatus();

    public ServiceResponseWithOutcome<File> createDynamicSystem(SystemInfo var1, File var2);

    public static final class Version
    implements Comparable<Version>,
    Serializable {
        private static final long serialVersionUID = 6387606412181055570L;
        final int major;
        final int minor;
        final int micro;
        final int build;

        public Version(int major, int minor, int micro, int build) {
            this.major = major;
            this.minor = minor;
            this.micro = micro;
            this.build = build;
        }

        @Override
        public int compareTo(Version o) {
            int diff = this.major - o.major;
            if (diff != 0) {
                return diff;
            }
            diff = this.minor - o.minor;
            if (diff != 0) {
                return diff;
            }
            diff = this.micro - o.micro;
            if (diff != 0) {
                return diff;
            }
            diff = this.build - o.build;
            return diff;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Version version = (Version)o;
            if (this.major != version.major) {
                return false;
            }
            if (this.minor != version.minor) {
                return false;
            }
            if (this.micro != version.micro) {
                return false;
            }
            return this.build == version.build;
        }

        public int hashCode() {
            int result = this.major;
            result = 31 * result + this.minor;
            result = 31 * result + this.micro;
            result = 31 * result + this.build;
            return result;
        }

        public String toString() {
            return String.format("%d.%d.%d.%d", this.major, this.minor, this.micro, this.build);
        }

        public String getVersionWithoutBuildNumber() {
            return String.format("%d.%d.%d", this.major, this.minor, this.micro);
        }

        public static Version fromString(String versionString) {
            assert (versionString != null) : "Parameter 'versionString' of method 'fromString' must not be null";
            String[] parts = versionString.split("\\.", 4);
            if (parts.length < 3) {
                throw new IllegalArgumentException("Version '" + versionString + "' does not match the expected format a.b.c");
            }
            try {
                int major = Integer.parseInt(parts[0]);
                int minor = Integer.parseInt(parts[1]);
                int micro = Integer.parseInt(parts[2]);
                int build = parts.length == 4 ? Integer.parseInt(parts[3]) : 0;
                return new Version(major, minor, micro, build);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Version '" + versionString + "' does not match the expected format a.b.c.d", ex);
            }
        }
    }
}

