/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.spring.microservices;

import com.hello2morrow.sonargraph.api.Aggregator;
import com.hello2morrow.sonargraph.api.AnyFactory;
import com.hello2morrow.sonargraph.api.IAggregatedDependencyAccess;
import com.hello2morrow.sonargraph.api.IDependencyAccess;
import com.hello2morrow.sonargraph.api.IDependencyKind;
import com.hello2morrow.sonargraph.api.INamedElementAccess;
import com.hello2morrow.sonargraph.api.IProgrammingElementAccess;
import com.hello2morrow.sonargraph.api.PluginProgrammingElementMetaData;
import com.hello2morrow.sonargraph.api.WebMethodType;
import com.hello2morrow.sonargraph.api.WebProperty;
import com.hello2morrow.sonargraph.api.WebUtilities;
import com.hello2morrow.sonargraph.api.java.IAnnotationAccess;
import com.hello2morrow.sonargraph.api.java.IAnnotationValueAccess;
import com.hello2morrow.sonargraph.api.java.IJavaMethodAccess;
import com.hello2morrow.sonargraph.api.java.IJavaModuleAccess;
import com.hello2morrow.sonargraph.api.java.IJavaTypeAccess;
import com.hello2morrow.sonargraph.api.java.JavaDependencyKind;
import com.hello2morrow.sonargraph.plugin.IModelPluginContext;
import com.hello2morrow.sonargraph.plugin.java.IPluginJavaAccess;
import com.hello2morrow.sonargraph.plugin.spring.microservices.IConfigurationProvider;
import com.hello2morrow.sonargraph.plugin.spring.microservices.SpringDetector;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class SpringWebResourceDetector
extends SpringDetector {
    private final String m_pluginId;
    private final IConfigurationProvider m_configurationProvider;
    private final PluginProgrammingElementMetaData m_webResourceMetaData;

    SpringWebResourceDetector(String pluginId, IConfigurationProvider contextPathProvider, PluginProgrammingElementMetaData webResourceMetaData) {
        assert (pluginId != null && pluginId.length() > 0) : "Parameter 'pluginId' of method 'SpringWebResourceDetector' must not be empty";
        assert (contextPathProvider != null) : "Parameter 'contextPathProvider' of method 'SpringWebResourceDetector' must not be null";
        assert (webResourceMetaData != null) : "Parameter 'webResourceMetaData' of method 'SpringWebResourceDetector' must not be null";
        this.m_pluginId = pluginId;
        this.m_configurationProvider = contextPathProvider;
        this.m_webResourceMetaData = webResourceMetaData;
    }

    public void detect(IModelPluginContext context, IPluginJavaAccess javaAccess) {
        assert (context != null) : "Parameter 'context' of method 'detect' must not be null";
        assert (javaAccess != null) : "Parameter 'javaAccess' of method 'detect' must not be null";
        THashMap requestMappingAnnotatedTypes = new THashMap();
        Set<IJavaTypeAccess> excludedTypes = this.collectExcludedTypes(context, javaAccess, Arrays.asList("Workspace:External [Java]:[Unknown]:org:springframework:cloud:openfeign:FeignClient:FeignClient"));
        this.identifyRequestMappingAnnotatedTypes(context, javaAccess, (Map<IJavaTypeAccess, IAnnotationAccess>)requestMappingAnnotatedTypes, excludedTypes);
        String[] stringArray = METHOD_ANNOTATIONS;
        int n = METHOD_ANNOTATIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String next = stringArray[n2];
            if (context.hasBeenCanceled()) {
                return;
            }
            IJavaTypeAccess annotation = (IJavaTypeAccess)javaAccess.findElementByFqn(next);
            if (annotation != null) {
                this.identifySpringAnnotatedMethods(context, javaAccess, (Map<IJavaTypeAccess, IAnnotationAccess>)requestMappingAnnotatedTypes, annotation, excludedTypes, EnumSet.of(AnnotationTarget.METHOD));
            }
            ++n2;
        }
    }

    private Set<IJavaTypeAccess> collectExcludedTypes(IModelPluginContext context, IPluginJavaAccess javaAccess, List<String> typeAnnotationsToExclude) {
        assert (context != null) : "Parameter 'context' of method 'collectExcludedTypes' must not be null";
        assert (javaAccess != null) : "Parameter 'javaAccess' of method 'collectExcludedTypes' must not be null";
        assert (typeAnnotationsToExclude != null && !typeAnnotationsToExclude.isEmpty()) : "Parameter 'typeAnnotationsToExclude' of method 'collectExcludedTypes' must not be empty";
        THashSet excludedTypes = new THashSet();
        for (String nextAnnotation : typeAnnotationsToExclude) {
            if (context.hasBeenCanceled()) {
                return excludedTypes;
            }
            IJavaTypeAccess annotation = (IJavaTypeAccess)javaAccess.findElementByFqn(nextAnnotation);
            if (annotation == null) continue;
            List annotatedElements = annotation.getIncomingDependencies(Aggregator.ELEMENT, true, new IDependencyKind[]{JavaDependencyKind.HAS_ANNOTATION});
            for (IAggregatedDependencyAccess nextAnnotatedElement : annotatedElements) {
                IJavaTypeAccess type;
                List typeAnnotations;
                IAnnotationAccess annotationToExclude;
                assert (nextAnnotatedElement.getNumberOfDependencies() == 1);
                IDependencyAccess dep = (IDependencyAccess)nextAnnotatedElement.getDependencies().get(0);
                IProgrammingElementAccess programmingElement = dep.getFrom();
                if (!(programmingElement instanceof IJavaTypeAccess) || (annotationToExclude = SpringWebResourceDetector.findAnnotation((List<IAnnotationAccess>)(typeAnnotations = (type = (IJavaTypeAccess)programmingElement).getAnnotations()), nextAnnotation)) == null) continue;
                excludedTypes.add(type);
            }
        }
        return excludedTypes;
    }

    private void identifyRequestMappingAnnotatedTypes(IModelPluginContext context, IPluginJavaAccess javaAccess, Map<IJavaTypeAccess, IAnnotationAccess> requestAnnotatedTypes, Set<IJavaTypeAccess> excludedTypes) {
        assert (context != null) : "Parameter 'context' of method 'identifyRequestMappingAnnotatedTypes' must not be null";
        assert (javaAccess != null) : "Parameter 'javaAccess' of method 'identifyRequestMappingAnnotatedTypes' must not be null";
        assert (requestAnnotatedTypes != null) : "Parameter 'requestAnnotatedTypes' of method 'identifyRequestMappingAnnotatedTypes' must not be null";
        assert (excludedTypes != null) : "Parameter 'excludedTypes' of method 'identifyRequestMappingAnnotatedTypes' must not be null";
        IJavaTypeAccess requestMappingAnnotation = (IJavaTypeAccess)javaAccess.findElementByFqn("Workspace:External [Java]:[Unknown]:org:springframework:web:bind:annotation:RequestMapping:RequestMapping");
        if (requestMappingAnnotation == null) {
            return;
        }
        List annotatedElements = requestMappingAnnotation.getIncomingDependencies(Aggregator.ELEMENT, true, new IDependencyKind[]{JavaDependencyKind.HAS_ANNOTATION});
        for (IAggregatedDependencyAccess nextAnnotatedElement : annotatedElements) {
            List typeAnnotations;
            IAnnotationAccess requestMapping;
            IJavaTypeAccess type;
            assert (nextAnnotatedElement.getNumberOfDependencies() == 1);
            if (context.hasBeenCanceled()) {
                return;
            }
            IDependencyAccess dep = (IDependencyAccess)nextAnnotatedElement.getDependencies().get(0);
            IProgrammingElementAccess programmingElement = dep.getFrom();
            if (!(programmingElement instanceof IJavaTypeAccess) || excludedTypes.contains(type = (IJavaTypeAccess)programmingElement) || (requestMapping = SpringWebResourceDetector.findAnnotation((List<IAnnotationAccess>)(typeAnnotations = type.getAnnotations()), requestMappingAnnotation)) == null) continue;
            requestAnnotatedTypes.put(type, requestMapping);
        }
    }

    private void identifySpringAnnotatedMethods(IModelPluginContext context, IPluginJavaAccess javaAccess, Map<IJavaTypeAccess, IAnnotationAccess> requestMappingAnnotatedTypes, IJavaTypeAccess mappingAnnotation, Set<IJavaTypeAccess> excludedTypes, EnumSet<AnnotationTarget> annotationTargets) {
        assert (javaAccess != null) : "Parameter 'javaAccess' of method 'handleSpringMappingAnnotation' must not be null";
        assert (requestMappingAnnotatedTypes != null) : "Parameter 'requestMappingAnnotatedTypes' of method 'handleSpringMappingAnnotation' must not be null";
        assert (mappingAnnotation != null) : "Parameter 'mappingAnnotation' of method 'handleSpringMappingAnnotation' must not be null";
        assert (annotationTargets != null && !annotationTargets.isEmpty()) : "Parameter 'annotationTargets' of method 'handleSpringMappingAnnotation' must not be empty";
        assert (excludedTypes != null) : "Parameter 'excludedTypes' of method 'identifySpringAnnotatedMethods' must not be null";
        THashMap methodAnnotations = new THashMap();
        List annotatedElements = mappingAnnotation.getIncomingDependencies(Aggregator.ELEMENT, true, new IDependencyKind[]{JavaDependencyKind.HAS_ANNOTATION});
        for (IAggregatedDependencyAccess iAggregatedDependencyAccess : annotatedElements) {
            IAnnotationAccess annotation;
            IJavaMethodAccess method;
            assert (iAggregatedDependencyAccess.getNumberOfDependencies() == 1);
            if (context.hasBeenCanceled()) {
                return;
            }
            IDependencyAccess dep = (IDependencyAccess)iAggregatedDependencyAccess.getDependencies().get(0);
            IProgrammingElementAccess programmingElement = dep.getFrom();
            if (!annotationTargets.contains((Object)AnnotationTarget.METHOD) || !(programmingElement instanceof IJavaMethodAccess) || excludedTypes.contains((method = (IJavaMethodAccess)programmingElement).getParent()) || (annotation = SpringWebResourceDetector.findAnnotation((List<IAnnotationAccess>)method.getAnnotations(), mappingAnnotation)) == null) continue;
            methodAnnotations.put(method, annotation);
        }
        for (Map.Entry entry : methodAnnotations.entrySet()) {
            if (context.hasBeenCanceled()) {
                return;
            }
            IJavaMethodAccess method = (IJavaMethodAccess)entry.getKey();
            IAnnotationAccess annotation = (IAnnotationAccess)entry.getValue();
            IAnnotationAccess typeAnnotation = requestMappingAnnotatedTypes.get(method.getParent());
            List<String> paths = this.getValueFromAnnotation(annotation, Arrays.asList("path", "value"));
            ArrayList<String> methods = new ArrayList<String>(this.extractMethodFromRequestMapping(annotation));
            List<String> roots = typeAnnotation != null ? this.getValueFromAnnotation(typeAnnotation, Arrays.asList("path", "value")) : Arrays.asList("");
            for (String root : roots) {
                if (context.hasBeenCanceled()) {
                    return;
                }
                for (String path : paths) {
                    if (context.hasBeenCanceled()) {
                        return;
                    }
                    IJavaModuleAccess module = (IJavaModuleAccess)method.getParent(IJavaModuleAccess.class);
                    assert (module != null) : "'module' of method '" + String.valueOf(method) + "' must not be null";
                    String contextPath = this.m_configurationProvider.getContextPath(module);
                    Object resultingPath = (contextPath + root + path).replaceAll("//", "/");
                    if (!((String)resultingPath).startsWith("/")) {
                        resultingPath = "/" + (String)resultingPath;
                    }
                    resultingPath = this.m_configurationProvider.resolveVariables(module, (String)resultingPath);
                    THashMap properties = new THashMap();
                    properties.put(WebProperty.HTTP_METHOD.getStandardName(), AnyFactory.createFrom(methods));
                    properties.put(WebProperty.FRAMEWORK.getStandardName(), AnyFactory.createFrom((Object)"Spring.Web"));
                    properties.put(WebProperty.PATH_TO_MATCH.getStandardName(), AnyFactory.createFrom((Object)WebUtilities.removeVariablesFromPath((String)resultingPath)));
                    javaAccess.createProgrammingElement(this.m_pluginId, this.m_webResourceMetaData, (INamedElementAccess)method, (String)resultingPath, annotation.getLineNumber(), (Map)properties);
                }
            }
        }
    }

    @Override
    protected List<String> extractMethodFromRequestMapping(IAnnotationAccess annotation) {
        assert (annotation != null) : "Parameter 'annotation' of method 'extractMethodFromRequestMapping' must not be null";
        String annotationName = annotation.getAnnotationClass().getShortName();
        if (!annotationName.startsWith("Request")) {
            assert (annotationName.endsWith("Mapping")) : "Annotation '" + annotationName + "' does not end with '...Request'";
            String methodName = annotationName.substring(0, annotationName.length() - "Mapping".length()).toUpperCase();
            return Arrays.asList(methodName);
        }
        IAnnotationValueAccess method = annotation.getValue(WebProperty.HTTP_METHOD.getStandardName());
        if (method == null) {
            return Collections.emptyList();
        }
        String name = method.getEnumContantName();
        if (name != null) {
            return Arrays.asList(name);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (IAnnotationValueAccess val : method.getValueList()) {
            String enumName = val.getEnumContantName();
            if (enumName == null) continue;
            result.add(enumName);
        }
        if (result.isEmpty()) {
            result = new ArrayList(WebMethodType.asList());
            result.add("PATCH");
        }
        return result;
    }

    private static enum AnnotationTarget {
        TYPE,
        METHOD;

    }
}

