/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.model.internal;

import com.hello2morrow.sonargraph.integration.access.foundation.Utility;
import com.hello2morrow.sonargraph.integration.access.model.IDependencyPattern;
import com.hello2morrow.sonargraph.integration.access.model.IElementPattern;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.IMatching;
import com.hello2morrow.sonargraph.integration.access.model.INamedElement;
import com.hello2morrow.sonargraph.integration.access.model.IResolution;
import com.hello2morrow.sonargraph.integration.access.model.Priority;
import com.hello2morrow.sonargraph.integration.access.model.ResolutionType;
import com.hello2morrow.sonargraph.integration.access.model.internal.ElementImpl;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public abstract class AbstractResolutionImpl
extends ElementImpl
implements IResolution {
    private static final long serialVersionUID = 6480407569513366548L;
    private final List<IIssue> issues;
    private final Priority priority;
    private final ResolutionType type;
    private final Date dateTime;
    private final String assignee;
    private final String description;
    private final String information;
    private final int matchingElementsCount;
    private final List<IElementPattern> elementPatterns;
    private final List<IDependencyPattern> dependencyPatterns;
    private final IMatching matching;
    private final String descriptor;

    public AbstractResolutionImpl(String fqName, ResolutionType type, Priority priority, List<IIssue> issues, int matchingElementsCount, String description, String information, String assignee, Date dateTime, List<IElementPattern> elementPatterns, List<IDependencyPattern> dependencyPatterns, IMatching matching, String descriptor) {
        super(fqName, type != null ? type.getPresentationName() : "");
        assert (type != null) : "Parameter 'type' of method 'ResolutionImpl' must not be null";
        assert (priority != null) : "Parameter 'priority' of method 'ResolutionImpl' must not be null";
        assert (issues != null) : "Parameter 'issues' of method 'ResolutionImpl' must not be null";
        assert (dateTime != null) : "Parameter 'dateTime' of method 'ResolutionImpl' must not be null";
        this.type = type;
        this.priority = priority;
        this.issues = issues;
        this.matchingElementsCount = matchingElementsCount;
        this.description = description != null ? description : "";
        this.information = information != null ? information : "";
        this.assignee = assignee != null ? assignee : "";
        this.dateTime = dateTime;
        this.elementPatterns = elementPatterns != null ? elementPatterns : Collections.emptyList();
        this.dependencyPatterns = dependencyPatterns != null ? dependencyPatterns : Collections.emptyList();
        this.matching = matching;
        this.descriptor = descriptor != null ? descriptor : "";
    }

    @Override
    public final String getFqName() {
        return this.getName();
    }

    @Override
    public final Optional<String> getOriginalFqName() {
        return Optional.of(this.getFqName());
    }

    @Override
    public final boolean isLocationOnly() {
        return false;
    }

    @Override
    public Optional<? extends INamedElement> getOriginalLocation() {
        return Optional.empty();
    }

    @Override
    public final String getKind() {
        return this.getType().getStandardName();
    }

    @Override
    public final String getPresentationKind() {
        return this.getType().getPresentationName();
    }

    @Override
    public abstract String getImageResourceName();

    @Override
    public List<IIssue> getIssues() {
        return Collections.unmodifiableList(this.issues);
    }

    @Override
    public Priority getPriority() {
        return this.priority;
    }

    @Override
    public ResolutionType getType() {
        return this.type;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(this.type.name());
        builder.append(", priority=").append(this.priority);
        builder.append(", description=").append(this.description);
        builder.append(", assignee=").append(this.assignee);
        builder.append(", date=").append(this.dateTime);
        builder.append(", number of issues=").append(this.issues.size());
        builder.append(", name=").append(this.getName());
        return builder.toString();
    }

    @Override
    public boolean isTask() {
        return this.type != ResolutionType.IGNORE;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getInformation() {
        return this.information;
    }

    @Override
    public String getAssignee() {
        return this.assignee;
    }

    @Override
    public String getDate() {
        return Utility.formatDateAndTimeForUniversalTimezone(this.dateTime);
    }

    @Override
    public Date getCreationDate() {
        return this.dateTime;
    }

    @Override
    public int getMatchingElementsCount() {
        return this.matchingElementsCount;
    }

    @Override
    public List<IElementPattern> getElementPatterns() {
        return Collections.unmodifiableList(this.elementPatterns);
    }

    @Override
    public List<IDependencyPattern> getDependencyPatterns() {
        return Collections.unmodifiableList(this.dependencyPatterns);
    }

    public final void updateElementPatterns(List<IElementPattern> migratedPatterns) {
        this.elementPatterns.clear();
        this.elementPatterns.addAll(migratedPatterns);
    }

    public final void updateDependencyPatterns(List<IDependencyPattern> migratedDependencyPatterns) {
        this.dependencyPatterns.clear();
        this.dependencyPatterns.addAll(migratedDependencyPatterns);
    }

    @Override
    public IMatching getMatching() {
        return this.matching;
    }

    @Override
    public final String getDescriptor() {
        return this.descriptor;
    }
}

