/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class LightMap<K, V>
implements Map<K, V> {
    private LightMapEntry m_first = null;

    @Override
    public int size() {
        int size = 0;
        LightMapEntry e = this.m_first;
        while (e != null) {
            ++size;
            e = e.m_next;
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        return this.m_first == null;
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.m_first == null || key == null) {
            return false;
        }
        return this.m_first.find(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        LightMapEntry e = this.m_first;
        while (e != null) {
            if (value == null) {
                return e.m_value == null;
            }
            if (value.equals(e.m_value)) {
                return true;
            }
            e = e.m_next;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (this.m_first == null || key == null) {
            return null;
        }
        return this.m_first.find((Object)key).m_value;
    }

    @Override
    public V put(K key, V value) {
        assert (key != null) : "Parameter 'key' of method 'put' must not be null";
        if (this.m_first == null) {
            this.m_first = new LightMapEntry(key, value);
            return null;
        }
        return this.m_first.add(key, value);
    }

    @Override
    public V remove(Object key) {
        if (key == null || this.m_first == null) {
            return null;
        }
        if (this.m_first.m_key.equals(key)) {
            this.m_first = this.m_first.m_next;
        }
        LightMapEntry e = this.m_first;
        while (e != null) {
            if (e.m_next == null) break;
            if (e.m_next.m_key.equals(key)) {
                LightMapEntry toBeRemoved = e.m_next;
                e.m_next = toBeRemoved.m_next;
                return toBeRemoved.m_value;
            }
            e = e.m_next;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.m_first = null;
    }

    @Override
    public Set<K> keySet() {
        LinkedHashSet result = new LinkedHashSet();
        LightMapEntry e = this.m_first;
        while (e != null) {
            result.add(e.m_key);
            e = e.m_next;
        }
        return result;
    }

    @Override
    public Collection<V> values() {
        ArrayList result = new ArrayList();
        LightMapEntry e = this.m_first;
        while (e != null) {
            result.add(e.m_value);
            e = e.m_next;
        }
        return result;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        LinkedHashSet<Map.Entry<K, V>> result = new LinkedHashSet<Map.Entry<K, V>>();
        LightMapEntry e = this.m_first;
        while (e != null) {
            result.add(e);
            e = e.m_next;
        }
        return result;
    }

    private class LightMapEntry
    implements Map.Entry<K, V> {
        private final K m_key;
        private V m_value;
        private LightMapEntry m_next;

        private LightMapEntry(K key, V value) {
            this.m_key = key;
            this.m_value = value;
            this.m_next = null;
        }

        @Override
        public K getKey() {
            return this.m_key;
        }

        @Override
        public V getValue() {
            return this.m_value;
        }

        @Override
        public V setValue(V value) {
            Object result = this.m_value;
            this.m_value = value;
            return result;
        }

        private V add(K key, V value) {
            if (key.equals(this.m_key)) {
                return this.setValue(value);
            }
            if (this.m_next != null) {
                return this.m_next.add(key, value);
            }
            this.m_next = new LightMapEntry(key, value);
            return null;
        }

        private LightMapEntry find(Object k) {
            if (this.m_key.equals(k)) {
                return this;
            }
            if (this.m_next == null) {
                return null;
            }
            return this.m_next.find(k);
        }
    }
}

