/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.client;

import com.hello2morrow.sonargraph.build.api.ISonargraphBuild;
import com.hello2morrow.sonargraph.build.api.SonargraphBuildException;
import com.hello2morrow.sonargraph.build.client.ILogger;
import com.hello2morrow.sonargraph.build.client.StandardDownloader;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class SonargraphBuildInstallationManager
implements StandardDownloader.IProgressReporter {
    private static final int TIMEOUT_IN_MIN = 5;
    private static final int TIMEOUT_ON_LOCK_DIR = 300000;
    private static final String SNAPSHOT_POSTFIX = "-SNAPSHOT";
    public static final String LOCK_DIR = "download-lock";
    private static final String APPLICATION_NAME = "SonargraphBuild";
    private final File m_sonargraphBuildRoot;
    private final ILogger m_logger;
    private String m_errorMessage;
    private final File m_lockDirectory;
    private final StandardDownloader m_downloader;
    private String m_updateInfo;

    public SonargraphBuildInstallationManager(ILogger logger, String proxyHost, String proxyPort, String proxyUser, String proxyPassword, String repository) {
        this(logger, new StandardDownloader(proxyHost, proxyPort, proxyUser, proxyPassword, repository), new StandardApplicationRootProvider());
    }

    SonargraphBuildInstallationManager(ILogger logger, StandardDownloader downloader, IApplicationRootProvider rootProvider) {
        this.m_logger = logger;
        this.m_downloader = downloader;
        this.m_sonargraphBuildRoot = rootProvider.determineDirectory();
        this.m_lockDirectory = new File(this.m_sonargraphBuildRoot, LOCK_DIR);
    }

    public File getSonargraphBuildInstallation(boolean autoUpdate, String requestedVersion, String clientVersion) {
        String selectedPath;
        block25: {
            StandardDownloader.VersionFlag param;
            String versionToRequest;
            assert (requestedVersion != null);
            assert (clientVersion != null && clientVersion.length() > 0);
            selectedPath = null;
            this.m_errorMessage = null;
            String cleanedClientVersion = clientVersion.endsWith(SNAPSHOT_POSTFIX) ? clientVersion.substring(0, clientVersion.length() - SNAPSHOT_POSTFIX.length()) : clientVersion;
            boolean isExactVersionRequested = false;
            if (StandardDownloader.VersionFlag.SAME.getPresentationName().equals(requestedVersion)) {
                versionToRequest = clientVersion;
                param = StandardDownloader.VersionFlag.SAME;
            } else if (StandardDownloader.VersionFlag.NEWEST.getPresentationName().equals(requestedVersion)) {
                versionToRequest = null;
                param = StandardDownloader.VersionFlag.NEWEST;
            } else if (requestedVersion.trim().length() == 0) {
                versionToRequest = cleanedClientVersion;
                param = StandardDownloader.VersionFlag.NEWEST_MATCHING;
            } else {
                versionToRequest = requestedVersion;
                isExactVersionRequested = versionToRequest.split("\\.").length == 4;
                param = isExactVersionRequested ? StandardDownloader.VersionFlag.SAME : StandardDownloader.VersionFlag.NEWEST_MATCHING;
            }
            this.lock();
            try {
                List<String> availableVersions = Arrays.stream(this.m_sonargraphBuildRoot.listFiles()).filter(File::isDirectory).map(File::getName).filter(name -> name.startsWith(APPLICATION_NAME)).sorted((a, b) -> -1 * a.substring(a.lastIndexOf(95) + 1).compareTo(b.substring(b.lastIndexOf(95) + 1))).collect(Collectors.toList());
                selectedPath = this.findMatchInDirectoriesList(versionToRequest, availableVersions);
                if (selectedPath != null && isExactVersionRequested) {
                    this.m_updateInfo = "Most recent version '" + versionToRequest + "' of SonargraphBuild is already installed.";
                    break block25;
                }
                if (availableVersions.isEmpty() || autoUpdate) {
                    String newestBuildUrl;
                    if (availableVersions.isEmpty()) {
                        this.m_logger.info("No local installations found. Trying to download matching version.");
                    } else if (autoUpdate) {
                        this.m_logger.info("Check if a new matching version can be downloaded.");
                    }
                    if (selectedPath != null && !autoUpdate) break block25;
                    try {
                        newestBuildUrl = this.m_downloader.determineMatchingUrl(versionToRequest, param);
                    }
                    catch (Exception ex) {
                        this.m_errorMessage = "Failed to download SonargraphBuild: " + ex.getLocalizedMessage();
                        this.m_logger.error(this.m_errorMessage);
                        this.unlock();
                        return null;
                    }
                    String versionToDownload = StandardDownloader.getDirectoryNameFromUrl(newestBuildUrl);
                    String versionFromUrl = StandardDownloader.getVersionFromUrl(newestBuildUrl);
                    if (availableVersions.contains(versionToDownload)) {
                        selectedPath = versionToDownload;
                        this.m_updateInfo = "Most recent version '" + versionFromUrl + "' is already installed.";
                        break block25;
                    }
                    File targetDirectory = new File(this.m_sonargraphBuildRoot, versionToDownload);
                    try {
                        this.m_logger.info("Downloading version '" + versionFromUrl + "'. This might take a couple of seconds ...");
                        this.m_downloader.downloadIntoDirectory(this, this.m_sonargraphBuildRoot, newestBuildUrl);
                        selectedPath = targetDirectory.getName();
                        this.m_updateInfo = "Successfully updated to version '" + versionFromUrl + "'.";
                        break block25;
                    }
                    catch (IOException ex) {
                        this.m_errorMessage = "Failed to download SonargraphBuild from '" + newestBuildUrl + "' into '" + targetDirectory.getAbsolutePath() + "'";
                        this.m_logger.error(this.m_errorMessage);
                        this.deleteDirectoryRecursively(targetDirectory);
                        this.unlock();
                        return null;
                    }
                }
                selectedPath = this.findMatchInDirectoriesList(versionToRequest, availableVersions);
                if (selectedPath == null) {
                    this.m_errorMessage = "No matching local SonargraphBuild installation for version '" + versionToRequest + "' found. Consider enabling 'autoUpdate'.";
                    return null;
                }
            }
            finally {
                this.unlock();
            }
        }
        assert (selectedPath != null) : "'selectedPath' must not be null here";
        return new File(this.m_sonargraphBuildRoot, selectedPath);
    }

    public String getUpdateInfo() {
        return this.m_updateInfo;
    }

    private String findMatchInDirectoriesList(String versionToRequest, List<String> availableVersions) {
        Optional<String> matchingInstallation = availableVersions.stream().filter(name -> (SonargraphBuildInstallationManager.extractVersionNumber(name) + ".").startsWith(versionToRequest + ".")).findFirst();
        return matchingInstallation.orElse(null);
    }

    private static String extractVersionNumber(String directoryName) {
        return directoryName.substring(directoryName.indexOf(45) + 1, directoryName.lastIndexOf(95));
    }

    private void lock() {
        while (!this.m_lockDirectory.mkdir()) {
            if (System.currentTimeMillis() - this.m_lockDirectory.lastModified() > 300000L) {
                this.m_lockDirectory.delete();
                continue;
            }
            try {
                this.m_logger.info("Waiting for other process to finish download of SonargraphBuild (max 5 min)");
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void unlock() {
        if (!this.m_lockDirectory.delete()) {
            this.m_logger.error("Failed to delete SonargraphBuild lock directory: " + this.m_lockDirectory.getPath());
        }
    }

    public static File determineOsgiJar(File installationDirectory) throws SonargraphBuildException {
        assert (installationDirectory != null) : "Parameter 'installationDirectory' of method 'determineOsgiJar' must not be null";
        File pluginDir = new File(installationDirectory, "plugins");
        if (!pluginDir.isDirectory()) {
            throw new SonargraphBuildException(String.format("Invalid 'installationDirectory': %s/plugins does not exist", installationDirectory.getPath()));
        }
        File osgiJarFile = null;
        String[] pluginDirList = pluginDir.list();
        if (pluginDirList != null) {
            String[] stringArray = pluginDirList;
            int n = pluginDirList.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                if (fileName.startsWith("org.eclipse.osgi_") && fileName.endsWith(".jar")) {
                    osgiJarFile = new File(pluginDir, fileName);
                    break;
                }
                ++n2;
            }
        }
        if (osgiJarFile == null || !osgiJarFile.canRead()) {
            throw new SonargraphBuildException(String.format("Invalid 'installationDirectory': %s/plugins does not contain the required org.eclipse.osgi jar file", installationDirectory.getPath()));
        }
        return osgiJarFile;
    }

    public static ISonargraphBuild.Version determineVersionOfInstallation(String installationDirectoryPath) throws SonargraphBuildException {
        assert (installationDirectoryPath != null && installationDirectoryPath.length() > 0) : "Parameter 'installationDirectoryPath' of method 'determineVersionOfInstallation' must not be empty";
        File pluginDir = new File(installationDirectoryPath, "plugins");
        if (!pluginDir.isDirectory()) {
            throw new SonargraphBuildException(String.format("Invalid 'installationDirectory': %s/plugins does not exist", installationDirectoryPath));
        }
        String[] pluginDirList = pluginDir.list();
        if (pluginDirList != null) {
            String[] stringArray = pluginDirList;
            int n = pluginDirList.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                if (fileName.startsWith("com.hello2morrow.sonargraph.build_") && fileName.endsWith(".jar")) {
                    String withoutExtension = fileName.substring(0, fileName.length() - ".jar".length());
                    int start = withoutExtension.indexOf("_");
                    assert (start != -1) : "'_' not found in file name: " + fileName;
                    int end = withoutExtension.lastIndexOf("_");
                    if (start == end) {
                        String version = withoutExtension.substring(start + 1);
                        return ISonargraphBuild.Version.fromString(version);
                    }
                    if (start < 0 || end < 0) {
                        throw new SonargraphBuildException("Unsupported file name: " + fileName);
                    }
                    String version = withoutExtension.substring(start + 1, end);
                    return ISonargraphBuild.Version.fromString(version);
                }
                ++n2;
            }
        }
        throw new SonargraphBuildException(String.format("Invalid 'installationDirectory': %s.", installationDirectoryPath));
    }

    public String getErrorMessage() {
        return this.m_errorMessage;
    }

    private void deleteDirectoryRecursively(File dir) {
        assert (dir != null) : "parameter 'dir' must not be null";
        if (dir.isDirectory()) {
            File[] fileList = dir.listFiles();
            if (fileList != null) {
                File[] fileArray = fileList;
                int n = fileList.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.isDirectory()) {
                        this.deleteDirectoryRecursively(file);
                    }
                    file.delete();
                    ++n2;
                }
            }
            dir.delete();
        }
    }

    @Override
    public void notify(String artifactName) {
        assert (artifactName != null && artifactName.length() > 0) : "Parameter 'artifactName' of method 'notify' must not be empty";
        this.m_logger.info("   download and extracting " + artifactName + " ...");
    }

    public static interface IApplicationRootProvider {
        public File determineDirectory();
    }

    public static class StandardApplicationRootProvider
    implements IApplicationRootProvider {
        @Override
        public File determineDirectory() {
            String osName = System.getProperty("os.name", "unknown").trim().toLowerCase();
            String userHome = System.getProperty("user.home");
            String appDataDir = null;
            if (osName.contains("windows")) {
                String appDataEnvVar = System.getenv("APPDATA");
                appDataDir = appDataEnvVar != null ? String.format("%s\\hello2morrow\\Sonargraph", appDataEnvVar) : String.format("%s\\AppData\\Roaming\\hello2morrow\\Sonargraph", userHome);
            } else if (osName.contains("linux")) {
                appDataDir = String.format("%s/.hello2morrow/Sonargraph", userHome);
            } else if (osName.contains("mac") && osName.contains("x")) {
                appDataDir = String.format("%s/Library/Application Support/hello2morrow/Sonargraph", userHome);
            }
            assert (appDataDir != null) : "Unsupported operating system: " + osName;
            File applicationDirectory = new File(appDataDir);
            if (!applicationDirectory.isDirectory()) {
                applicationDirectory.mkdirs();
            }
            assert (applicationDirectory.isDirectory()) : appDataDir + " is not a directory!";
            File sonargraphBuildRoot = new File(applicationDirectory, "Build");
            if (!sonargraphBuildRoot.exists() || !sonargraphBuildRoot.isDirectory()) {
                sonargraphBuildRoot.mkdirs();
            }
            return sonargraphBuildRoot;
        }
    }
}

