/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.go.controller.system.parser;

import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.languageprovider.go.foundation.common.GoMessageCause;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.json.simple.JSONArray;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoParser.class);
    private static File s_parserExecutable;

    static {
        GoParser.initParserExecutable();
    }

    private static File getBundleRoot() {
        URL url;
        block3: {
            String urlString = "platform:///plugin/com.hello2morrow.sonargraph.language.provider.go/";
            url = FileLocator.find((URL)new URI("platform:///plugin/com.hello2morrow.sonargraph.language.provider.go/").toURL());
            if (url != null) break block3;
            LOGGER.error("Couldn't find file '{}' in osgi bundle '{}'", (Object)"platform:///plugin/com.hello2morrow.sonargraph.language.provider.go/", (Object)"com.hello2morrow.sonargraph.language.provider.go");
            return null;
        }
        try {
            URL fileUrl = FileLocator.toFileURL((URL)url);
            URI fileUri = new URI(fileUrl.getProtocol(), fileUrl.getPath(), null).normalize();
            File file = new File(fileUri);
            LOGGER.debug("Found {} for {}", (Object)file.getAbsolutePath(), (Object)"platform:///plugin/com.hello2morrow.sonargraph.language.provider.go/");
            return file;
        }
        catch (IOException | IllegalArgumentException | URISyntaxException e) {
            LOGGER.error("Couldn't find '{}': '{}'", (Object)"platform:///plugin/com.hello2morrow.sonargraph.language.provider.go/", (Object)e.getMessage());
            return null;
        }
    }

    private static void initParserExecutable() {
        File testModeRoot = new File("./bin/mac-x86_64/goparser");
        File bundleRoot = testModeRoot.canRead() ? new File(".") : GoParser.getBundleRoot();
        assert (bundleRoot != null) : "Cannot locate go parser executable";
        String binFolder = null;
        Object exeName = "goparser";
        switch (Platform.getOperatingSystem()) {
            case LINUX_64: {
                binFolder = "linux-x86_64";
                break;
            }
            case LINUX_ARM_64: {
                binFolder = "linux-aarch64";
                break;
            }
            case MAC_64: {
                binFolder = "mac-x86_64";
                break;
            }
            case MAC_ARM_64: {
                binFolder = "mac-aarch64";
                break;
            }
            case WINDOWS_64: {
                binFolder = "windows-x86_64";
                exeName = (String)exeName + ".exe";
                break;
            }
            default: {
                assert (false) : "Unexpected operating system: " + Platform.getOperatingSystem().name();
                break;
            }
        }
        File exeFile = new File(new File(new File(bundleRoot, "bin"), binFolder), (String)exeName);
        if (exeFile.canExecute()) {
            s_parserExecutable = exeFile;
        } else if (exeFile.canRead()) {
            exeFile.setExecutable(true);
            s_parserExecutable = exeFile;
        } else assert (false) : "File " + exeFile.getPath() + " does not exist";
    }

    private void monitorErrorOutput(BufferedReader errorOutput, OperationResult result) {
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = errorOutput.readLine()) != null) {
                sb.append(line).append('\n');
            }
        }
        catch (IOException line) {
            // empty catch block
        }
        String message = sb.toString();
        if (!message.isEmpty()) {
            LOGGER.error("Go parser error output:\n '" + message + "'");
            result.addWarning((OperationResult.IMessageCause)GoMessageCause.PARSER_ERROR_OUTPUT, message, new Object[0]);
        }
    }

    private String readLineFromProcess(BufferedReader processOutput, OperationResult opResult) {
        try {
            String result = processOutput.readLine();
            return result;
        }
        catch (IOException e) {
            LOGGER.error("Error when reading from Roslyn Daemon: " + e.getMessage(), (Throwable)e);
            opResult.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, (Throwable)e);
            return null;
        }
    }

    public OperationResultWithOutcome<JSONArray> run(File directory, String goExeDir) {
        assert (directory != null);
        OperationResultWithOutcome result = new OperationResultWithOutcome("Parsing directory " + directory.getAbsolutePath());
        ProcessBuilder pb = new ProcessBuilder(s_parserExecutable.getAbsolutePath(), directory.getAbsolutePath());
        Map<String, String> env = pb.environment();
        Object path = env.get("PATH");
        path = path == null ? goExeDir : goExeDir + File.pathSeparator + (String)path;
        env.put("PATH", (String)path);
        Process process = null;
        try {
            process = pb.start();
        }
        catch (IOException e) {
            LOGGER.error("Could not start the Go parser: " + e.getMessage(), (Throwable)e);
            result.addError((OperationResult.IMessageCause)GoMessageCause.CANNOT_START_PARSER, "Cannot start go parser.", new Object[]{e});
            return result;
        }
        BufferedReader processOutput = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
        BufferedReader errorOutput = new BufferedReader(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));
        Thread errorMonitor = new Thread(() -> this.monitorErrorOutput(errorOutput, (OperationResult)result));
        errorMonitor.start();
        String opener = this.readLineFromProcess(processOutput, (OperationResult)result);
        if (opener == null) {
            return result;
        }
        if (opener.startsWith("Error: ")) {
            result.addError((OperationResult.IMessageCause)GoMessageCause.PARSER_ERROR_OUTPUT, opener.substring(7), new Object[0]);
            return result;
        }
        if (!opener.equals("OK")) {
            result.addError((OperationResult.IMessageCause)GoMessageCause.UNEXPECTED_PARSER_REPLY, "Unexpected reply from Go parser: " + opener, new Object[0]);
            return result;
        }
        String jsonModel = this.readLineFromProcess(processOutput, (OperationResult)result);
        if (jsonModel == null) {
            return result;
        }
        try {
            JSONArray model = (JSONArray)JSONValue.parseWithException((String)jsonModel);
            result.setOutcome((Object)model);
            process.waitFor();
            errorMonitor.join();
        }
        catch (ParseException e) {
            result.addError((OperationResult.IMessageCause)GoMessageCause.JSON_PARSER_ERROR, "JSON parsing failed: " + e.getMessage(), new Object[0]);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return result;
    }
}

