/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.base;

import com.hello2morrow.sonargraph.integration.access.foundation.AggregatingClassLoader;
import com.hello2morrow.sonargraph.integration.access.persistence.JaxbAdapter;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlPersistenceContext;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public final class JaxbAccess {
    public static <T> JaxbAdapter<T> createJaxbAdapter(ClassLoader classLoader, XmlPersistenceContext context) {
        assert (classLoader != null) : "Parameter 'classLoader' of method 'createJaxbAdapter' must not be null";
        assert (context != null) : "Parameter 'context' of method 'createJaxbAdapter' must not be null";
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        classLoaders.add(JaxbAdapter.class.getClassLoader());
        classLoaders.add(classLoader);
        return new JaxbAdapter(context, (ClassLoader)new AggregatingClassLoader(classLoaders));
    }

    public static <T> JaxbAdapter<T> createJaxbAdapter(AggregatingClassLoader classLoader, XmlPersistenceContext context) {
        assert (classLoader != null) : "Parameter 'classLoader' of method 'createJaxbAdapter' must not be null";
        assert (context != null) : "Parameter 'context' of method 'createJaxbAdapter' must not be null";
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        classLoaders.add(JaxbAdapter.class.getClassLoader());
        classLoaders.addAll(classLoader.getClassLoaders());
        return new JaxbAdapter(context, (ClassLoader)new AggregatingClassLoader(classLoaders));
    }

    public static <T> JaxbAdapter<T> createJaxbAdapter(AggregatingClassLoader classLoader, String namespaces) {
        assert (classLoader != null) : "Parameter 'classLoader' of method 'createJaxbAdapter' must not be null";
        assert (namespaces != null && namespaces.length() > 0) : "Parameter 'namespaces' of method 'createJaxbAdapter' must not be empty";
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        classLoaders.add(JaxbAdapter.class.getClassLoader());
        classLoaders.addAll(classLoader.getClassLoaders());
        return new JaxbAdapter(new AggregatingClassLoader(classLoaders), namespaces);
    }

    public static <T> void save(JaxbAdapter<T> jaxbAdapter, T jaxbRoot, TFile toFile) throws IOException {
        assert (jaxbAdapter != null) : "Parameter 'jaxbAdapter' of method 'save' must not be null";
        assert (jaxbRoot != null) : "Parameter 'jaxbRoot' of method 'save' must not be null";
        assert (toFile != null) : "Parameter 'toFile' of method 'save' must not be null";
        assert (!toFile.exists() || toFile.isFile()) : "'toFile' of method 'save' must be an existing file:" + String.valueOf(toFile);
        int i = 1;
        TFile tmpFile = toFile;
        while (tmpFile.exists()) {
            tmpFile = new TFile(toFile.getAbsolutePath() + "." + i);
            ++i;
        }
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (TFileOutputStream out = new TFileOutputStream((File)tmpFile);){
                jaxbAdapter.save(jaxbRoot, (OutputStream)out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            if (tmpFile.exists() && !tmpFile.equals((Object)toFile)) {
                toFile.rm();
                tmpFile.cp((File)toFile);
                try {
                    tmpFile.rm();
                }
                catch (IOException ex) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                    tmpFile.rm();
                }
            }
        }
    }
}

