/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.programming;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ShortNameFilter;
import com.hello2morrow.sonargraph.core.model.programming.UnresolvedWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class WorkspaceDependencyElementNameFilter
extends ShortNameFilter {
    private final boolean m_includeUnresolved;
    private final Pattern m_pattern;
    private static final Pattern POSTFIX_DETECTION_PATTERN = Pattern.compile("(.*)-\\d+");

    public WorkspaceDependencyElementNameFilter(String name, boolean includeUnresolved) {
        super(name, !Platform.isCaseSensitive());
        this.m_includeUnresolved = includeUnresolved;
        Matcher matcher = POSTFIX_DETECTION_PATTERN.matcher(name);
        String nameForPattern = matcher.matches() ? matcher.group(1) : name;
        String patternString = Pattern.quote(nameForPattern) + "-\\d+";
        this.m_pattern = this.isIgnoreCase() ? Pattern.compile(patternString, 2) : Pattern.compile(patternString);
    }

    @Override
    public boolean accept(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'accept' must not be null";
        if (!this.m_includeUnresolved && namedElement instanceof UnresolvedWorkspaceDependencyElement) {
            return false;
        }
        if (super.accept(namedElement)) {
            return true;
        }
        Matcher matcher = this.m_pattern.matcher(namedElement.getShortName());
        return matcher.matches();
    }

    @Override
    public String toString() {
        return super.toString() + ", unresolved=" + this.m_includeUnresolved;
    }
}

