/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.metrics;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.analysis.IValueList;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.metrics.AbstractMetric;
import com.hello2morrow.sonargraph.core.model.metrics.FloatValueList;
import com.hello2morrow.sonargraph.core.model.metrics.IntegerValueList;
import com.hello2morrow.sonargraph.core.model.metrics.ValueList;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import java.util.function.Predicate;

public final class PropertyMetric
extends AbstractMetric {
    private final String m_propertyName;
    private final boolean m_recursive;

    public PropertyMetric(NamedElement parent, IMetricId id, IMetricLevel level, String propertyName, boolean recursive) {
        super(parent, id, level);
        assert (propertyName != null && propertyName.length() > 0) : "Parameter 'propertyName' of method 'PropertyMetric' must not be empty";
        this.m_propertyName = propertyName;
        this.m_recursive = recursive;
    }

    @Override
    protected NamedElementVisitor createCollector(IWorkerContext workerContext, IValueList collectionRoot) {
        return new ValueCollector(workerContext, this.getLevel().getAssociatedClass(), this.getLevel().getPredicate(), collectionRoot);
    }

    @Override
    public IValueList collectValues(IWorkerContext workerContext, NamedElement root) {
        ValueList values = this.getMetricId().isFloat() ? new FloatValueList(null, this) : new IntegerValueList(null, this, root);
        return this.collect(workerContext, root, values);
    }

    private class ValueCollector
    extends NamedElementVisitor
    implements SoftwareSystem.IVisitor {
        private final IValueList m_collectionRoot;
        private final Class<?> m_providingClass;
        private final Predicate<Object> m_predicate;
        private final IWorkerContext m_workerContext;

        private ValueCollector(IWorkerContext workerContext, Class<?> providingClass, Predicate<Object> predicate, IValueList collectionRoot) {
            assert (providingClass != null) : "Parameter 'providingClass' of method 'ValueCollector' must not be null";
            this.m_providingClass = providingClass;
            this.m_predicate = predicate;
            this.m_collectionRoot = collectionRoot;
            this.m_workerContext = workerContext;
        }

        @Override
        public void visitNamedElement(NamedElement element) {
            if (!element.isExcluded()) {
                if (!element.getRefactoringState().hasBeenDeleted()) {
                    if (this.m_providingClass.isAssignableFrom(element.getClass())) {
                        if (element.isDefinedInEnclosingElement() && (this.m_predicate == null || this.m_predicate.test(element))) {
                            Number value = element.getProperty(PropertyMetric.this.m_propertyName, Number.class);
                            if (value != null) {
                                this.m_collectionRoot.addValue(element, value);
                            }
                            if (PropertyMetric.this.m_recursive && !this.m_workerContext.hasBeenCanceled()) {
                                this.visitChildrenOf(element);
                            }
                        }
                    } else if (!this.m_workerContext.hasBeenCanceled()) {
                        this.visitChildrenOf(element);
                    }
                }
                if (element instanceof IComponent) {
                    this.m_workerContext.workItemCompleted();
                }
            }
        }

        @Override
        public void visitSoftwareSystem(SoftwareSystem element) {
            assert (element != null) : "Parameter 'element' of method 'visitSoftwareSystem' must not be null";
            element.getUniqueExistingChild(Workspace.class).getChildren(Module.class).forEach(m -> m.accept(this));
        }
    }
}

