/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.LeafNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AssignableToArtifactNode
extends LeafNode {
    private final ArrayList<NamedElement> m_underlyingElements = new ArrayList(2);
    private String m_architectureFilterName;
    private NamedElement m_prototypeElement;

    public AssignableToArtifactNode(ArchitecturalViewElement parent, PresentationMode presentationMode, boolean isReadOnly, IAssignableToArtifact element) {
        super(parent, presentationMode, isReadOnly);
        assert (element != null) : "Parameter 'element' of method 'NonRecursiveLeafNode' must not be null";
        this.m_underlyingElements.add(element.getNamedElement());
    }

    protected final void addUnderlyingElement(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'addUnderlyingElement' must not be null";
        assert (!this.m_underlyingElements.contains(element)) : "Already added: " + String.valueOf(element);
        this.m_underlyingElements.add(element);
    }

    public final void setPrototypeElement(NamedElement element) {
        assert (element == null || element instanceof IAssignableToArtifact) : "'element' of method 'setPrototypeElement' unexpected: " + String.valueOf(element);
        this.m_prototypeElement = element;
        this.m_architectureFilterName = null;
    }

    public final IAssignableToArtifact getAssignableToArtifact() {
        return (IAssignableToArtifact)((Object)this.getFirstUnderlyingElement());
    }

    @Override
    public String getShortName() {
        return this.m_prototypeElement == null ? super.getShortName() : this.m_prototypeElement.getShortName();
    }

    @Override
    public String getName() {
        return this.m_prototypeElement == null ? super.getName() : this.m_prototypeElement.getName();
    }

    @Override
    public String getFullyQualifiedNamePart() {
        return this.m_prototypeElement == null ? super.getFullyQualifiedNamePart() : this.m_prototypeElement.getFullyQualifiedNamePart();
    }

    @Override
    public final String getArchitectureFilterName() {
        if (this.m_architectureFilterName == null) {
            this.m_architectureFilterName = this.m_prototypeElement == null ? super.getArchitectureFilterName() : super.getArchitectureFilterName(this.m_prototypeElement);
        }
        return this.m_architectureFilterName;
    }

    @Override
    public final NamedElement getFirstUnderlyingElement() {
        return this.m_underlyingElements.get(0);
    }

    @Override
    public final List<NamedElement> getUnderlyingElements() {
        return Collections.unmodifiableList(this.m_underlyingElements);
    }

    @Override
    public final void finishModification() {
        this.m_underlyingElements.trimToSize();
        super.finishModification();
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitAssignableToArtifactNode(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitAssignableToArtifactNode(AssignableToArtifactNode var1);
    }
}

