/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.architecture;

import com.hello2morrow.javapg.runtime.messaging.Position;
import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.architecture.ArtifactClass;
import com.hello2morrow.sonargraph.core.model.architecture.ConnectionScheme;
import com.hello2morrow.sonargraph.core.model.architecture.Identifier;
import java.util.Collections;
import java.util.List;

public final class Connection {
    private final Artifact m_context;
    private final ConnectionScheme m_scheme;
    private final List<Identifier> m_to;
    private final Position m_pos;
    private final ArtifactClass m_toClass;
    private final boolean m_isDeprecated;

    public Connection(Artifact context, List<Identifier> to, ConnectionScheme scheme, Position pos, boolean isDeprecated) {
        assert (context != null) : "Parameter 'context' of method 'Connection' must not be null";
        assert (to != null && to.size() > 0) : "Parameter 'to' of method 'Connection' must not be empty";
        assert (scheme != null) : "Parameter 'scheme' of method 'Connection' must not be null";
        assert (pos != null) : "Parameter 'pos' of method 'Connection' must not be null";
        this.m_context = context;
        this.m_to = to;
        this.m_scheme = scheme;
        this.m_pos = pos;
        this.m_toClass = null;
        this.m_isDeprecated = isDeprecated;
    }

    public Connection(Artifact context, ArtifactClass toClass, ConnectionScheme scheme, Position pos, boolean isDeprecated) {
        assert (context != null) : "Parameter 'context' of method 'Connection' must not be null";
        assert (toClass != null) : "Parameter 'toClass' of method 'Connection' must not be empty";
        assert (scheme != null) : "Parameter 'scheme' of method 'Connection' must not be null";
        assert (pos != null) : "Parameter 'pos' of method 'Connection' must not be null";
        this.m_context = context;
        this.m_to = Collections.emptyList();
        this.m_scheme = scheme;
        this.m_pos = pos;
        this.m_toClass = toClass;
        this.m_isDeprecated = isDeprecated;
    }

    public Position getPosition() {
        return this.m_pos;
    }

    public Artifact getContext() {
        return this.m_context;
    }

    public ConnectionScheme getScheme() {
        return this.m_scheme;
    }

    public List<Identifier> getTo() {
        return this.m_to;
    }

    public ArtifactClass getToClass() {
        return this.m_toClass;
    }

    public boolean isDeprecated() {
        return this.m_isDeprecated;
    }
}

