/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controllerinterface.system;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricCategory;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.element.IExtension;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.report.CreateReportResult;
import com.hello2morrow.sonargraph.core.model.report.IReport;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import de.schlichtherle.truezip.file.TFile;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface IReportExtension
extends IExtension {
    public static final int DEFAULT_METRIC_VALUE_ROW_COUNT = 25;
    public static final int DEFAULT_ISSUES_RESOLUTIONS_COUNT_FOR_SPLIT = 100;
    public static final int MAX_NUMBER_OF_ENTRIES_IN_DETAILS_PAGE = 2000;

    public List<IMetricLevel> getStandardMetricLevels();

    public Map<IMetricCategory, List<IMetricId>> getAvailableMetricIds(IWorkerContext var1);

    public List<IProviderId> getIssueProviderIds(IWorkerContext var1);

    public List<IIssueId> getIssueIds(IWorkerContext var1);

    public OperationResultWithOutcome<TFile> exportMetaData(IWorkerContext var1, List<IMetricId> var2, List<IProviderId> var3, List<IIssueId> var4, TFile var5);

    public OperationResultWithOutcome<CreateReportResult> createReport(IWorkerContext var1, CreateReportRequest var2);

    public IReport createReportObjectForBasicSystemInfo(IWorkerContext var1);

    public static class CreateReportRequest {
        public static final List<IMetricLevel> STANDARD_METRIC_LEVELS = Arrays.asList(CoreMetricLevel.SYSTEM, CoreMetricLevel.MODULE);
        private TFile m_reportDirectory;
        private String m_reportFileName;
        private List<IMetricLevel> m_metricLevels = STANDARD_METRIC_LEVELS;
        private Set<IReport.Format> m_reportFormats;
        private boolean m_splitByModule = false;
        private TFile m_baselineXmlReportFile;
        private int m_maxRowCountPerMetricForHtml = 25;
        private int m_elementCountToSplitHtmlReport = 100;
        private int m_maxElementCountForHtmlDetailsPage = 2000;
        private String m_reportDescription;
        private boolean m_systemDiffLicensed = false;
        private Date m_timestamp;

        public final TFile getReportDirectory() {
            return this.m_reportDirectory;
        }

        public final void setReportDirectory(TFile targetDirectory) {
            assert (targetDirectory != null) : "Parameter 'targetDirectory' of method 'setTargetDirectory' must not be null";
            this.m_reportDirectory = targetDirectory;
        }

        public final String getReportFileName() {
            return this.m_reportFileName;
        }

        public final void setReportFileName(String targetFileName) {
            this.m_reportFileName = targetFileName;
        }

        public final void setMetricLevels(List<IMetricLevel> metricLevels) {
            assert (metricLevels != null) : "Parameter 'metricLevels' of method 'setMetricLevels' must not be null";
            this.m_metricLevels = metricLevels;
        }

        public final List<IMetricLevel> getMetricLevels() {
            assert (this.m_metricLevels != null) : "'m_metricLevels' of method 'getMetricLevels' must not be null";
            return this.m_metricLevels;
        }

        public final void setReportFormats(Set<IReport.Format> reportFormats) {
            assert (reportFormats != null) : "Parameter 'reportFormats' of method 'setReportFormats' must not be null";
            this.m_reportFormats = reportFormats;
        }

        public final Set<IReport.Format> getReportFormats() {
            assert (this.m_reportFormats != null && !this.m_reportFormats.isEmpty()) : "'m_reportFormats' of method 'getReportFormats' must not be empty";
            return this.m_reportFormats;
        }

        public final void setBaselineXmlReportFile(TFile baselineXmlReportFile) {
            assert (baselineXmlReportFile != null) : "Parameter 'baselineXmlReportFile' of method 'setBaselineXmlReportFile' must not be null";
            this.m_baselineXmlReportFile = baselineXmlReportFile;
        }

        public final TFile getBaselineXmlReportFile() {
            return this.m_baselineXmlReportFile;
        }

        public final int getMaxRowCountPerMetricForHtml() {
            return this.m_maxRowCountPerMetricForHtml;
        }

        public final void setMaxRowCountPerMetricForHtml(int maxRowCountPerMetricForHtml) {
            this.m_maxRowCountPerMetricForHtml = maxRowCountPerMetricForHtml;
        }

        public final void setElementCountToSplitHtmlReport(int maxNumberForSplit) {
            if (maxNumberForSplit != 0) {
                this.m_elementCountToSplitHtmlReport = maxNumberForSplit;
            }
        }

        public final int getElementCountToSplitHtmlReport() {
            return this.m_elementCountToSplitHtmlReport;
        }

        public final void setMaxElementCountForHtmlDetailsPage(int maxNumberInDetailPage) {
            if (maxNumberInDetailPage != 0) {
                this.m_maxElementCountForHtmlDetailsPage = maxNumberInDetailPage;
            }
        }

        public final int getMaxElementCountForHtmlDetailsPage() {
            return this.m_maxElementCountForHtmlDetailsPage;
        }

        public final void setSplitByModule(boolean splitByModule) {
            this.m_splitByModule = splitByModule;
        }

        public final boolean isSplitByModule() {
            return this.m_splitByModule;
        }

        public final void setReportDescription(String info) {
            this.m_reportDescription = info;
        }

        public String getReportDescription() {
            return this.m_reportDescription;
        }

        public final void setSystemDiffLicensed(boolean isLicensed) {
            this.m_systemDiffLicensed = isLicensed;
        }

        public boolean isSystemDiffLicensed() {
            return this.m_systemDiffLicensed;
        }

        public Date getTimestamp() {
            return this.m_timestamp;
        }

        public void setTimestamp(Date timestamp) {
            this.m_timestamp = timestamp;
        }
    }
}

