/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ArchitecturalViewNodeInfo {
    private final List<ArchitecturalViewNode> m_selectedNodes = new ArrayList<ArchitecturalViewNode>();
    private final List<ArchitecturalViewNode> m_expandedNodes = new ArrayList<ArchitecturalViewNode>();
    private final List<ArchitecturalViewNode> m_leafNodes = new ArrayList<ArchitecturalViewNode>();

    ArchitecturalViewNodeInfo() {
    }

    void addSelected(ArchitecturalViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'addSelected' must not be null";
        assert (!node.isDeleted()) : "'node' is deleted: " + node.getElementInfo();
        this.m_selectedNodes.add(node);
    }

    void addExpanded(ArchitecturalViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'addExpanded' must not be null";
        assert (!node.isDeleted()) : "'node' is deleted: " + node.getElementInfo();
        this.m_expandedNodes.add(node);
    }

    void addLeafNode(ArchitecturalViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'addLeafNode' must not be null";
        assert (!node.isDeleted()) : "'node' is deleted: " + node.getElementInfo();
        this.m_leafNodes.add(node);
    }

    List<ArchitecturalViewNode> getExpandedNodes() {
        return Collections.unmodifiableList(this.m_expandedNodes);
    }

    List<ArchitecturalViewNode> getSelectedNodes() {
        return Collections.unmodifiableList(this.m_selectedNodes);
    }

    List<ArchitecturalViewNode> getLeafNodes() {
        return Collections.unmodifiableList(this.m_leafNodes);
    }
}

