/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.architecture;

import com.hello2morrow.javapg.runtime.lexer.KeywordToken;
import com.hello2morrow.sonargraph.core.controller.system.architecture.ArchitectureLexer;
import com.hello2morrow.sonargraph.core.controller.system.parser.ISourceLineProcessor;
import com.hello2morrow.sonargraph.core.controller.system.parser.SourceLineProcessor;
import com.hello2morrow.sonargraph.core.model.path.ISourceFileRegionVisitor;

public final class ArchitectureSourceLineVisitor
extends ISourceLineProcessor.SourceLineVisitor {
    private final ISourceLineProcessor m_processor = new SourceLineProcessor();
    private final KeywordToken m_keywords = new KeywordToken(0, ArchitectureLexer.kw_IDENT, false);
    private ISourceFileRegionVisitor m_visitor;
    private boolean m_isFirstWord = true;

    public void process(ISourceFileRegionVisitor visitor, String content) {
        assert (this.m_visitor == null) : "'m_visitor' of method 'process' must be null";
        assert (visitor != null) : "Parameter 'visitor' of method 'process' must not be null";
        assert (content != null) : "Parameter 'content' of method 'process' must not be null";
        this.m_visitor = visitor;
        this.m_processor.accept(content, (ISourceLineProcessor.SourceLineVisitor)this);
        this.m_visitor = null;
        this.m_isFirstWord = true;
    }

    @Override
    public boolean isWordCharacter(int ch) {
        return ch == 45 || super.isWordCharacter(ch);
    }

    @Override
    public void visitCharLiteral(int offset, String c) {
        assert (c != null) : "Parameter 'c' of method 'visitCharLiteral' must not be null";
        this.m_visitor.visitLiteral(offset, c.length());
    }

    @Override
    public void visitStringLiteral(int offset, String s) {
        assert (s != null) : "Parameter 's' of method 'visitStringLiteral' must not be null";
        this.m_visitor.visitLiteral(offset, s.length());
    }

    @Override
    public void visitSingleLineComment(int offset, String comment) {
        assert (comment != null) : "Parameter 'comment' of method 'visitSingleLineComment' must not be null";
        this.m_visitor.visitComment(offset, comment.length());
    }

    @Override
    public void visitMultiLineComment(int offset, String comment) {
        assert (comment != null) : "Parameter 'comment' of method 'visitMultiLineComment' must not be null";
        this.m_visitor.visitComment(offset, comment.length());
        int atIndex = comment.indexOf("@");
        if (atIndex != -1) {
            boolean stillAtsRemaining = true;
            while (stillAtsRemaining) {
                int nextSpaceIndex = comment.indexOf(32, atIndex);
                if (nextSpaceIndex > 0) {
                    this.m_visitor.visitAnnotation(offset + atIndex, nextSpaceIndex - atIndex, true);
                    atIndex = comment.indexOf("@", nextSpaceIndex);
                }
                if (nextSpaceIndex != -1 && atIndex != -1) continue;
                stillAtsRemaining = false;
            }
        }
    }

    @Override
    public void visitWord(int offset, String word) {
        assert (word != null) : "Parameter 'word' of method 'word' must not be null";
        if (this.m_keywords.isKeyword(word) || this.m_isFirstWord && "model".equals(word)) {
            this.m_visitor.visitKeyword(offset, word.length());
        }
        this.m_isFirstWord = false;
    }

    @Override
    public void visitAt(int offset, String atWord) {
        assert (atWord != null) : "Parameter 'word' of method 'visitAtWord' must not be null";
        this.m_visitor.visitAnnotation(offset, atWord.length(), false);
    }
}

