/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerJob;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IAuthorsExtension;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IScmExtension;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.analysis.ScmAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.StringList;
import com.hello2morrow.sonargraph.core.model.author.Author;
import com.hello2morrow.sonargraph.core.model.author.AuthorsInfo;
import com.hello2morrow.sonargraph.core.model.author.SourceFilesToAuthorsInfo;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.element.CoreProviderId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.path.scm.CouplingLink;
import com.hello2morrow.sonargraph.core.model.path.scm.SourceNode;
import com.hello2morrow.sonargraph.core.model.path.scm.TemporalCouplingModel;
import com.hello2morrow.sonargraph.core.model.path.scm.TemporalCouplingNode;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.system.INamedElementResolver;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.collections.MultipleValueMap;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.scm.BranchCommits;
import com.hello2morrow.sonargraph.scm.Commit;
import com.hello2morrow.sonargraph.scm.ConfigurationException;
import com.hello2morrow.sonargraph.scm.Diff;
import com.hello2morrow.sonargraph.scm.DiffMode;
import com.hello2morrow.sonargraph.scm.ICommitRetriever;
import com.hello2morrow.sonargraph.scm.IScmDataAndConfigurationProvider;
import com.hello2morrow.sonargraph.scm.IScmDataProvider;
import com.hello2morrow.sonargraph.scm.RetrieveException;
import com.hello2morrow.sonargraph.scm.ScmManager;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScmAnalyzerAdapter
extends AnalyzerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScmAnalyzerAdapter.class);
    public static final IConfigurableAnalyzerId ID = CoreAnalyzerId.SCM_METRICS;
    private static final String SNAPSHOT_AUTHORS_PERIOD_SEPARATOR = ";";
    private final ScmManager m_scmManager;
    private final IAuthorsExtension m_authorsProvider;
    private final IMetricDescriptor m_change30;
    private final IMetricDescriptor m_change90;
    private final IMetricDescriptor m_change365;
    private final IMetricDescriptor m_change2y;
    private final IMetricDescriptor m_change5y;
    private final IMetricDescriptor m_churnRate30;
    private final IMetricDescriptor m_churnRate90;
    private final IMetricDescriptor m_churnRate365;
    private final IMetricDescriptor m_churnRate2y;
    private final IMetricDescriptor m_churnRate5y;
    private final IMetricDescriptor m_churn30;
    private final IMetricDescriptor m_churn90;
    private final IMetricDescriptor m_churn365;
    private final IMetricDescriptor m_churn2y;
    private final IMetricDescriptor m_churn5y;
    private final IMetricDescriptor m_authors30;
    private final IMetricDescriptor m_authors90;
    private final IMetricDescriptor m_authors365;
    private final IMetricDescriptor m_authors2y;
    private final IMetricDescriptor m_authors5y;
    private final IMetricDescriptor m_modChange30;
    private final IMetricDescriptor m_modChange90;
    private final IMetricDescriptor m_modChange365;
    private final IMetricDescriptor m_modChange2y;
    private final IMetricDescriptor m_modChange5y;
    private final IMetricDescriptor m_modChurnRate30;
    private final IMetricDescriptor m_modChurnRate90;
    private final IMetricDescriptor m_modChurnRate365;
    private final IMetricDescriptor m_modChurnRate2y;
    private final IMetricDescriptor m_modChurnRate5y;
    private final IMetricDescriptor m_modChurn30;
    private final IMetricDescriptor m_modChurn90;
    private final IMetricDescriptor m_modChurn365;
    private final IMetricDescriptor m_modChurn2y;
    private final IMetricDescriptor m_modChurn5y;
    private final IMetricDescriptor m_modAuthorsCount30;
    private final IMetricDescriptor m_modAuthorsCount90;
    private final IMetricDescriptor m_modAuthorsCount365;
    private final IMetricDescriptor m_modAuthorsCount2y;
    private final IMetricDescriptor m_modAuthorsCount5y;
    private final IMetricDescriptor m_sysChange30;
    private final IMetricDescriptor m_sysChange90;
    private final IMetricDescriptor m_sysChange365;
    private final IMetricDescriptor m_sysChange2y;
    private final IMetricDescriptor m_sysChange5y;
    private final IMetricDescriptor m_sysChurnRate30;
    private final IMetricDescriptor m_sysChurnRate90;
    private final IMetricDescriptor m_sysChurnRate365;
    private final IMetricDescriptor m_sysChurnRate2y;
    private final IMetricDescriptor m_sysChurnRate5y;
    private final IMetricDescriptor m_sysChurn30;
    private final IMetricDescriptor m_sysChurn90;
    private final IMetricDescriptor m_sysChurn365;
    private final IMetricDescriptor m_sysChurn2y;
    private final IMetricDescriptor m_sysChurn5y;
    private final IMetricDescriptor m_sysAuthorsCount30;
    private final IMetricDescriptor m_sysAuthorsCount90;
    private final IMetricDescriptor m_sysAuthorsCount365;
    private final IMetricDescriptor m_sysAuthorsCount2y;
    private final IMetricDescriptor m_sysAuthorsCount5y;
    private final IMetricDescriptor m_daysSinceLastCommit;

    public ScmAnalyzerAdapter(IAnalyzerController controller, ScmManager scmManager) {
        super(controller, ID);
        assert (scmManager != null) : "Parameter 'scmManager' of method 'ScmAnalyzerAdapter' must not be null";
        IMetricsProvider metricsProvider = this.getInstallation().getExtension(IMetricsProvider.class);
        MetricProvider mp = metricsProvider.getMetricProvider(CoreProviderId.INSTANCE);
        this.m_authorsProvider = this.getSoftwareSystem().getExtension(IAuthorsExtension.class);
        this.m_scmManager = scmManager;
        this.m_change30 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CHANGES_30, CoreMetricLevel.SOURCE_FILE);
        this.m_change90 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CHANGES_90, CoreMetricLevel.SOURCE_FILE);
        this.m_change365 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CHANGES_365, CoreMetricLevel.SOURCE_FILE);
        this.m_change2y = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CHANGES_2Y, CoreMetricLevel.SOURCE_FILE);
        this.m_change5y = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CHANGES_5Y, CoreMetricLevel.SOURCE_FILE);
        this.m_churnRate30 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CODE_CHURN_RATE_30, CoreMetricLevel.SOURCE_FILE);
        this.m_churnRate90 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CODE_CHURN_RATE_90, CoreMetricLevel.SOURCE_FILE);
        this.m_churnRate365 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CODE_CHURN_RATE_365, CoreMetricLevel.SOURCE_FILE);
        this.m_churnRate2y = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CODE_CHURN_RATE_2Y, CoreMetricLevel.SOURCE_FILE);
        this.m_churnRate5y = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CODE_CHURN_RATE_5Y, CoreMetricLevel.SOURCE_FILE);
        this.m_churn30 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CODE_CHURN_30, CoreMetricLevel.SOURCE_FILE);
        this.m_churn90 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CODE_CHURN_90, CoreMetricLevel.SOURCE_FILE);
        this.m_churn365 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CODE_CHURN_365, CoreMetricLevel.SOURCE_FILE);
        this.m_churn2y = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CODE_CHURN_2Y, CoreMetricLevel.SOURCE_FILE);
        this.m_churn5y = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CODE_CHURN_5Y, CoreMetricLevel.SOURCE_FILE);
        this.m_authors30 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_NUMBER_OF_AUTHORS_30, CoreMetricLevel.SOURCE_FILE);
        this.m_authors90 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_NUMBER_OF_AUTHORS_90, CoreMetricLevel.SOURCE_FILE);
        this.m_authors365 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_NUMBER_OF_AUTHORS, CoreMetricLevel.SOURCE_FILE);
        this.m_authors2y = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_NUMBER_OF_AUTHORS_2Y, CoreMetricLevel.SOURCE_FILE);
        this.m_authors5y = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_NUMBER_OF_AUTHORS_5Y, CoreMetricLevel.SOURCE_FILE);
        this.m_daysSinceLastCommit = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_DAYS_SINCE_LAST_COMMIT, CoreMetricLevel.SOURCE_FILE);
        this.m_modChange30 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CHANGES_30, CoreMetricLevel.MODULE);
        this.m_modChange90 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CHANGES_90, CoreMetricLevel.MODULE);
        this.m_modChange365 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CHANGES_365, CoreMetricLevel.MODULE);
        this.m_modChange2y = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CHANGES_2Y, CoreMetricLevel.MODULE);
        this.m_modChange5y = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CHANGES_5Y, CoreMetricLevel.MODULE);
        this.m_modChurnRate30 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CODE_CHURN_RATE_30, CoreMetricLevel.MODULE);
        this.m_modChurnRate90 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CODE_CHURN_RATE_90, CoreMetricLevel.MODULE);
        this.m_modChurnRate365 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CODE_CHURN_RATE_365, CoreMetricLevel.MODULE);
        this.m_modChurnRate2y = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CODE_CHURN_RATE_2Y, CoreMetricLevel.MODULE);
        this.m_modChurnRate5y = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CODE_CHURN_RATE_5Y, CoreMetricLevel.MODULE);
        this.m_modChurn30 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CODE_CHURN_30, CoreMetricLevel.MODULE);
        this.m_modChurn90 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CODE_CHURN_90, CoreMetricLevel.MODULE);
        this.m_modChurn365 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CODE_CHURN_365, CoreMetricLevel.MODULE);
        this.m_modChurn2y = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CODE_CHURN_2Y, CoreMetricLevel.MODULE);
        this.m_modChurn5y = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CODE_CHURN_5Y, CoreMetricLevel.MODULE);
        this.m_modAuthorsCount30 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_NUMBER_OF_AUTHORS_30, CoreMetricLevel.MODULE);
        this.m_modAuthorsCount90 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_NUMBER_OF_AUTHORS_90, CoreMetricLevel.MODULE);
        this.m_modAuthorsCount365 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_NUMBER_OF_AUTHORS, CoreMetricLevel.MODULE);
        this.m_modAuthorsCount2y = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_NUMBER_OF_AUTHORS_2Y, CoreMetricLevel.MODULE);
        this.m_modAuthorsCount5y = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_NUMBER_OF_AUTHORS_5Y, CoreMetricLevel.MODULE);
        this.m_sysChange30 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CHANGES_30, CoreMetricLevel.SYSTEM);
        this.m_sysChange90 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CHANGES_90, CoreMetricLevel.SYSTEM);
        this.m_sysChange365 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CHANGES_365, CoreMetricLevel.SYSTEM);
        this.m_sysChange2y = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CHANGES_2Y, CoreMetricLevel.SYSTEM);
        this.m_sysChange5y = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CHANGES_5Y, CoreMetricLevel.SYSTEM);
        this.m_sysChurnRate30 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CODE_CHURN_RATE_30, CoreMetricLevel.SYSTEM);
        this.m_sysChurnRate90 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CODE_CHURN_RATE_90, CoreMetricLevel.SYSTEM);
        this.m_sysChurnRate365 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CODE_CHURN_RATE_365, CoreMetricLevel.SYSTEM);
        this.m_sysChurnRate2y = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CODE_CHURN_RATE_2Y, CoreMetricLevel.SYSTEM);
        this.m_sysChurnRate5y = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CODE_CHURN_RATE_5Y, CoreMetricLevel.SYSTEM);
        this.m_sysChurn30 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CODE_CHURN_30, CoreMetricLevel.SYSTEM);
        this.m_sysChurn90 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CODE_CHURN_90, CoreMetricLevel.SYSTEM);
        this.m_sysChurn365 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CODE_CHURN_365, CoreMetricLevel.SYSTEM);
        this.m_sysChurn2y = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CODE_CHURN_2Y, CoreMetricLevel.SYSTEM);
        this.m_sysChurn5y = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CODE_CHURN_5Y, CoreMetricLevel.SYSTEM);
        this.m_sysAuthorsCount30 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_NUMBER_OF_AUTHORS_30, CoreMetricLevel.SYSTEM);
        this.m_sysAuthorsCount90 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_NUMBER_OF_AUTHORS_90, CoreMetricLevel.SYSTEM);
        this.m_sysAuthorsCount365 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_NUMBER_OF_AUTHORS, CoreMetricLevel.SYSTEM);
        this.m_sysAuthorsCount2y = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_NUMBER_OF_AUTHORS_2Y, CoreMetricLevel.SYSTEM);
        this.m_sysAuthorsCount5y = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_NUMBER_OF_AUTHORS_5Y, CoreMetricLevel.SYSTEM);
    }

    @Override
    protected boolean canRun() {
        String scm = this.getScm();
        if (scm.equals("No SCM System")) {
            return false;
        }
        return this.m_scmManager.canRun(scm, (IScmDataAndConfigurationProvider)this.getSoftwareSystem().getExtension(IScmExtension.class));
    }

    @Override
    protected boolean clearResult(AnalyzerResult result) {
        boolean done = super.clearResult(result);
        result.removeChildren(SourceFilesToAuthorsInfo.class, Author.class, TemporalCouplingModel.class);
        return done;
    }

    @Override
    public void systemSavedAs(boolean baseDirectoryChanged) {
        super.systemSavedAs(baseDirectoryChanged);
        if (baseDirectoryChanged) {
            this.reset();
        }
    }

    private String getScm() {
        String scm = (String)this.getAnalyzer().getConfiguration(ScmAnalyzerConfiguration.class).getValue("ScmName");
        return scm == null ? "Auto Detect" : scm;
    }

    @Override
    protected void runJobs(AnalyzerResult result) {
        ScmMetricsAnalyzerJob job = new ScmMetricsAnalyzerJob(this.getGroup(), result, this.getController());
        job.start();
    }

    @Override
    public boolean canStoreResult() {
        return true;
    }

    @Override
    protected void saveResult(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'saveResult' must not be null";
        INamedElementResolver resolver = this.getController().getResolver();
        SourceFilesToAuthorsInfo sourceFilesToAuthorsInfo = result.getUniqueChild(SourceFilesToAuthorsInfo.class);
        if (sourceFilesToAuthorsInfo != null) {
            ArrayList<String> flattened = new ArrayList<String>();
            for (Map.Entry<SourceFile, AuthorsInfo> nextEntry : sourceFilesToAuthorsInfo.getInfo().entrySet()) {
                flattened.add(resolver.getDescriptor(nextEntry.getKey()));
                flattened.add(SNAPSHOT_AUTHORS_PERIOD_SEPARATOR);
                AuthorsInfo info = nextEntry.getValue();
                Author[] authors30 = info.getAuthors30();
                int i = 0;
                while (i < authors30.length) {
                    flattened.add(authors30[i].getName());
                    ++i;
                }
                flattened.add(SNAPSHOT_AUTHORS_PERIOD_SEPARATOR);
                Author[] authors90 = info.getAuthors90();
                int i2 = 0;
                while (i2 < authors90.length) {
                    flattened.add(authors90[i2].getName());
                    ++i2;
                }
                flattened.add(SNAPSHOT_AUTHORS_PERIOD_SEPARATOR);
                Author[] authors365 = info.getAuthors365();
                int i3 = 0;
                while (i3 < authors365.length) {
                    flattened.add(authors365[i3].getName());
                    ++i3;
                }
                Author[] authors2y = info.getAuthors2y();
                int i4 = 0;
                while (i4 < authors2y.length) {
                    flattened.add(authors2y[i4].getName());
                    ++i4;
                }
                Author[] authors5y = info.getAuthors5y();
                int i5 = 0;
                while (i5 < authors5y.length) {
                    flattened.add(authors5y[i5].getName());
                    ++i5;
                }
                flattened.add(null);
            }
            StringList stringList = new StringList(result, flattened.toArray(new String[flattened.size()]));
            result.addChild(stringList);
        }
        long start = System.currentTimeMillis();
        super.saveResult(result);
        LOGGER.debug("Finished saving result in {} ms", (Object)(System.currentTimeMillis() - start));
        result.removeChildren(StringList.class);
    }

    @Override
    protected void resultSuccessfullyRestored(AnalyzerResult result) throws RestoreException {
        assert (result != null) : "Parameter 'result' of method 'resultSuccessfullyRestored' must not be null";
        THashMap authorMap = new THashMap();
        for (Author next : result.getChildren(Author.class)) {
            authorMap.put(next.getShortName(), next);
        }
        StringList stringList = result.getUniqueChild(StringList.class);
        if (stringList != null) {
            SourceFilesToAuthorsInfo info = new SourceFilesToAuthorsInfo(result);
            result.addChild(info);
            INamedElementResolver resolver = this.getController().getResolver();
            ArrayList<String> sourceFileAndAuthors = new ArrayList<String>();
            String[] stringArray = stringList.getList();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String next = stringArray[n2];
                if (next == null) {
                    this.processSourceFileAndAuthors(resolver, (Map<String, Author>)authorMap, info, sourceFileAndAuthors);
                    sourceFileAndAuthors.clear();
                } else {
                    sourceFileAndAuthors.add(next);
                }
                ++n2;
            }
            result.removeChild(stringList);
        }
        super.resultSuccessfullyRestored(result);
    }

    private void processSourceFileAndAuthors(INamedElementResolver resolver, Map<String, Author> authorMap, SourceFilesToAuthorsInfo sourceFilesToAuthorsInfo, List<String> sourceFileAndAuthors) {
        assert (resolver != null) : "Parameter 'resolver' of method 'processSourceFileAndAuthors' must not be null";
        assert (authorMap != null) : "Parameter 'authorMap' of method 'processSourceFileAndAuthors' must not be null";
        assert (sourceFileAndAuthors != null) : "Parameter 'sourceFileAndAuthors' of method 'processSourceFileAndAuthors' must not be null";
        assert (sourceFileAndAuthors.size() >= 4) : "Parameter 'sourceFileAndAuthors' of method 'processSourceFileAndAuthors' must at least be of size 4: " + String.valueOf(sourceFileAndAuthors);
        String fileDescriptor = sourceFileAndAuthors.get(0);
        Element resolvedSource = resolver.resolve(fileDescriptor);
        if (!(resolvedSource instanceof SourceFile)) {
            LOGGER.error("Failed to resolve source file for descriptor {}", (Object)fileDescriptor);
            return;
        }
        StrictPair<Author[], Integer> authors30 = this.convertToAuthorsArray(authorMap, sourceFileAndAuthors, 2);
        StrictPair<Author[], Integer> authors90 = this.convertToAuthorsArray(authorMap, sourceFileAndAuthors, (Integer)authors30.getSecond());
        StrictPair<Author[], Integer> authors365 = this.convertToAuthorsArray(authorMap, sourceFileAndAuthors, (Integer)authors90.getSecond());
        StrictPair<Author[], Integer> authors2y = this.convertToAuthorsArray(authorMap, sourceFileAndAuthors, (Integer)authors365.getSecond());
        StrictPair<Author[], Integer> authors5y = this.convertToAuthorsArray(authorMap, sourceFileAndAuthors, (Integer)authors2y.getSecond());
        sourceFilesToAuthorsInfo.addInfo((SourceFile)resolvedSource, new AuthorsInfo((Author[])authors30.getFirst(), (Author[])authors90.getFirst(), (Author[])authors365.getFirst(), (Author[])authors2y.getFirst(), (Author[])authors5y.getFirst()));
    }

    private StrictPair<Author[], Integer> convertToAuthorsArray(Map<String, Author> authorMap, List<String> sourceFileAndAuthors, int start) {
        ArrayList<Author> authors = new ArrayList<Author>();
        int i = start;
        while (i < sourceFileAndAuthors.size()) {
            String authorName = sourceFileAndAuthors.get(i);
            if (authorName.equals(SNAPSHOT_AUTHORS_PERIOD_SEPARATOR)) {
                ++i;
                break;
            }
            Author author = authorMap.get(authorName);
            if (author == null) {
                LOGGER.debug("Missing author element for name {}", (Object)authorName);
            } else {
                authors.add(author);
            }
            ++i;
        }
        Author[] authorsArray = authors.toArray(new Author[0]);
        return new StrictPair((Object)authorsArray, (Object)i);
    }

    private class ScmMetricsAnalyzerJob
    extends AnalyzerJob {
        private final Map<String, SourceFile> m_sourceFileMap;
        private final long m_thirtyDaysAgo;
        private final long m_ninetyDaysAgo;
        private final long m_oneYearAgo;
        private final long m_twoYearsAgo;
        private final long m_now;
        private final Map<Module, Integer> m_modChangedLines30;
        private final Map<Module, Integer> m_modChangedLines90;
        private final Map<Module, Integer> m_modChangedLines365;
        private final Map<Module, Integer> m_modChangedLines2y;
        private final Map<Module, Integer> m_modChangedLines5y;
        private final Map<Module, Integer> m_modChanges30;
        private final Map<Module, Integer> m_modChanges90;
        private final Map<Module, Integer> m_modChanges365;
        private final Map<Module, Integer> m_modChanges2y;
        private final Map<Module, Integer> m_modChanges5y;
        private final Map<Module, Integer> m_modTotalLines;
        private final Map<Module, Set<Author>> m_modAuthors30;
        private final Map<Module, Set<Author>> m_modAuthors90;
        private final Map<Module, Set<Author>> m_modAuthors365;
        private final Map<Module, Set<Author>> m_modAuthors2y;
        private final Map<Module, Set<Author>> m_modAuthors5y;
        private final Map<String, Module> m_rootToModuleMap;
        private int m_nextNodeId;

        private ScmMetricsAnalyzerJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller) {
            super(group, result, controller);
            this.m_sourceFileMap = new THashMap(4201);
            this.m_modChangedLines30 = new THashMap();
            this.m_modChangedLines90 = new THashMap();
            this.m_modChangedLines365 = new THashMap();
            this.m_modChangedLines2y = new THashMap();
            this.m_modChangedLines5y = new THashMap();
            this.m_modChanges30 = new THashMap();
            this.m_modChanges90 = new THashMap();
            this.m_modChanges365 = new THashMap();
            this.m_modChanges2y = new THashMap();
            this.m_modChanges5y = new THashMap();
            this.m_modTotalLines = new THashMap();
            this.m_modAuthors30 = new THashMap();
            this.m_modAuthors90 = new THashMap();
            this.m_modAuthors365 = new THashMap();
            this.m_modAuthors2y = new THashMap();
            this.m_modAuthors5y = new THashMap();
            this.m_rootToModuleMap = new THashMap();
            this.m_nextNodeId = 0;
            this.m_now = System.currentTimeMillis();
            this.m_thirtyDaysAgo = this.m_now - 2592000000L;
            this.m_ninetyDaysAgo = this.m_now - 7776000000L;
            this.m_oneYearAgo = this.m_now - 31536000000L;
            this.m_twoYearsAgo = this.m_now - 63072000000L;
        }

        private void buildAndProcessTemporalCouplingModel(List<Commit> commits, Map<String, String> renameMap, IWorkerContext workerContext) {
            assert (commits != null) : "Parameter 'commits' of method 'buildAndProcessTemporalCouplingModel' must not be null";
            assert (renameMap != null) : "Parameter 'renameMap' of method 'buildAndProcessTemporalCouplingModel' must not be null";
            assert (workerContext != null) : "Parameter 'workerContext' of method 'buildAndProcessTemporalCouplingModel' must not be null";
            THashMap nodeMap = new THashMap();
            ArrayList<SourceNode> nodes = new ArrayList<SourceNode>();
            THashMap connectionMap = new THashMap();
            for (Commit commit : commits) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                List diffs = commit.getChanges();
                int i = 0;
                while (i < diffs.size() - 1) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    SourceNode node1 = this.getNode((Diff)diffs.get(i), (Map<String, SourceNode>)nodeMap, renameMap, (Map<SourceNode, Map<SourceNode, CouplingLink>>)connectionMap, nodes);
                    if (node1 != null) {
                        int j = i + 1;
                        while (j < diffs.size()) {
                            if (workerContext.hasBeenCanceled()) {
                                return;
                            }
                            SourceNode node2 = this.getNode((Diff)diffs.get(j), (Map<String, SourceNode>)nodeMap, renameMap, (Map<SourceNode, Map<SourceNode, CouplingLink>>)connectionMap, nodes);
                            if (node2 != null && node1 != node2) {
                                Map linkMap1 = (Map)connectionMap.get(node1);
                                CouplingLink link = (CouplingLink)linkMap1.get(node2);
                                if (link == null) {
                                    Map linkMap2 = (Map)connectionMap.get(node2);
                                    link = new CouplingLink(node1, node2);
                                    node1.addLink(link);
                                    node2.addLink(link);
                                    linkMap1.put(node2, link);
                                    linkMap2.put(node1, link);
                                } else {
                                    link.increaseWeight();
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                workerContext.workItemCompleted();
            }
            if (nodes.size() > 0) {
                TemporalCouplingNode[] modelNodes = new TemporalCouplingNode[nodes.size()];
                int j = 0;
                for (SourceNode node : nodes) {
                    int[] links = new int[node.getLinkCount() * 2];
                    int i = 0;
                    for (CouplingLink link : node.getLinks()) {
                        int targetId = link.getTarget(node).getId();
                        assert (targetId != node.getId());
                        links[i++] = targetId;
                        links[i++] = link.getWeight();
                    }
                    modelNodes[j++] = new TemporalCouplingNode(node.getSourceFile(), links);
                }
                nodes.clear();
                TemporalCouplingModel model = new TemporalCouplingModel(this.getResult(), modelNodes);
                this.getResult().addChild(model);
            }
        }

        private void processCommits(List<Commit> commits, IWorkerContext workerContext) throws IWorkerContext.WorkerContextCancelledException {
            assert (commits != null) : "Parameter 'commits' of method 'processCommits' must not be null";
            assert (workerContext != null) : "Parameter 'workerContext' of method 'processCommits' must not be null";
            MultipleValueMap fileHistory = new MultipleValueMap();
            THashMap renameMap = new THashMap();
            if (this.getWorkerContext().hasBeenCanceled()) {
                throw new IWorkerContext.WorkerContextCancelledException();
            }
            long startTime = System.currentTimeMillis();
            this.getSoftwareSystem().getUniqueExistingChild(Workspace.class).accept(new SourceVisitor());
            this.buildFileHistory(commits, (MultipleValueMap<String, Pair<Commit, Diff>>)fileHistory, (Map<String, String>)renameMap);
            LOGGER.debug("Time to build history: " + (System.currentTimeMillis() - startTime) + " ms");
            workerContext.beginBlockOfWork(commits.size() + fileHistory.size());
            startTime = System.currentTimeMillis();
            this.buildAndProcessTemporalCouplingModel(commits, (Map<String, String>)renameMap, workerContext);
            LOGGER.debug("Time to build temporal coupling model: " + (System.currentTimeMillis() - startTime) + " ms");
            startTime = System.currentTimeMillis();
            this.processFileHistory((MultipleValueMap<String, Pair<Commit, Diff>>)fileHistory, workerContext);
            fileHistory.keySet().forEach(k -> {
                SourceFile sourceFile = this.m_sourceFileMap.remove(k);
            });
            this.processUntouchedFiles();
            this.storeModuleAndSystemMetrics();
            LOGGER.debug("Time to process history: " + (System.currentTimeMillis() - startTime) + " ms");
        }

        private void buildFileHistory(List<Commit> commits, MultipleValueMap<String, Pair<Commit, Diff>> fileHistory, Map<String, String> renameMap) throws IWorkerContext.WorkerContextCancelledException {
            for (Commit commit : commits) {
                for (Diff diff : commit.getChanges()) {
                    if (this.getWorkerContext().hasBeenCanceled()) {
                        throw new IWorkerContext.WorkerContextCancelledException();
                    }
                    String path = renameMap.get(diff.getPath());
                    if (path == null) {
                        path = diff.getPath();
                    }
                    if (diff.getMode() == DiffMode.RENAMED) {
                        renameMap.put(diff.getOriginalPath(), path);
                    }
                    if (path != null) {
                        if (this.m_sourceFileMap.get(path) == null) continue;
                        fileHistory.put((Object)path, (Object)new Pair((Object)commit, (Object)diff));
                        continue;
                    }
                    path = diff.getOriginalPath();
                    for (String root : this.m_rootToModuleMap.keySet()) {
                        if (this.getWorkerContext().hasBeenCanceled()) {
                            throw new IWorkerContext.WorkerContextCancelledException();
                        }
                        if (!path.startsWith(root)) continue;
                        Module mod = this.m_rootToModuleMap.get(root);
                        assert (mod != null);
                        int deletedLines = diff.getRemovedLines();
                        if (commit.getTimeStamp() >= this.m_thirtyDaysAgo) {
                            this.m_modChanges30.put(mod, this.m_modChanges30.get(mod) + 1);
                            this.m_modChangedLines30.put(mod, this.m_modChangedLines30.get(mod) + deletedLines);
                        }
                        if (commit.getTimeStamp() >= this.m_ninetyDaysAgo) {
                            this.m_modChanges90.put(mod, this.m_modChanges90.get(mod) + 1);
                            this.m_modChangedLines90.put(mod, this.m_modChangedLines90.get(mod) + deletedLines);
                        }
                        if (commit.getTimeStamp() >= this.m_oneYearAgo) {
                            this.m_modChanges365.put(mod, this.m_modChanges365.get(mod) + 1);
                            this.m_modChangedLines365.put(mod, this.m_modChangedLines365.get(mod) + deletedLines);
                        }
                        if (commit.getTimeStamp() >= this.m_twoYearsAgo) {
                            this.m_modChanges2y.put(mod, this.m_modChanges2y.get(mod) + 1);
                            this.m_modChangedLines2y.put(mod, this.m_modChangedLines2y.get(mod) + deletedLines);
                        }
                        this.m_modChanges5y.put(mod, this.m_modChanges5y.get(mod) + 1);
                        this.m_modChangedLines5y.put(mod, this.m_modChangedLines5y.get(mod) + deletedLines);
                    }
                }
            }
        }

        private SourceNode getNode(Diff diff, Map<String, SourceNode> nodeMap, Map<String, String> renameMap, Map<SourceNode, Map<SourceNode, CouplingLink>> connectionMap, List<SourceNode> nodes) {
            String path = diff.getPath();
            String path2 = renameMap.get(path);
            if (path2 != null) {
                path = path2;
            }
            if (path == null) {
                return null;
            }
            SourceNode node = nodeMap.get(path);
            if (node == null) {
                SourceFile source = this.m_sourceFileMap.get(path);
                if (source == null) {
                    return null;
                }
                node = new SourceNode(source, this.m_nextNodeId++);
                nodes.add(node);
                nodeMap.put(path, node);
                connectionMap.put(node, (Map<SourceNode, CouplingLink>)new THashMap());
            }
            return node;
        }

        private void processFileHistory(MultipleValueMap<String, Pair<Commit, Diff>> fileHistory, IWorkerContext workerContext) throws IWorkerContext.WorkerContextCancelledException {
            SourceFilesToAuthorsInfo sourceFilesToAuthorsMap = new SourceFilesToAuthorsInfo(this.getResult());
            THashSet unprocessedSources = new THashSet();
            THashMap authorNameToAuthor = new THashMap();
            AnalyzerResult result = this.getResult();
            for (Author nextAuthor : result.getChildren(Author.class)) {
                authorNameToAuthor.put(nextAuthor.getShortName(), nextAuthor);
            }
            unprocessedSources.addAll(this.m_sourceFileMap.values());
            for (String path : fileHistory.keySet()) {
                if (workerContext.hasBeenCanceled()) {
                    throw new IWorkerContext.WorkerContextCancelledException();
                }
                SourceFile source = this.m_sourceFileMap.get(path);
                THashSet authors30 = new THashSet();
                THashSet authors90 = new THashSet();
                THashSet authors365 = new THashSet();
                THashSet authors2y = new THashSet();
                THashSet authors5y = new THashSet();
                boolean thirtyDaysPassed = false;
                boolean ninetyDaysPassed = false;
                boolean oneYearPassed = false;
                boolean twoYearsPassed = false;
                int changeCount = 0;
                int changedLines = 0;
                int changeCount30 = 0;
                int changeCount90 = 0;
                int changeCount1y = 0;
                int changeCount2y = 0;
                int changedLines30 = 0;
                int changedLines90 = 0;
                int changedLines1y = 0;
                int changedLines2y = 0;
                long time = System.currentTimeMillis();
                boolean first = true;
                assert (source != null);
                for (Pair pair : fileHistory.get((Object)path)) {
                    if (workerContext.hasBeenCanceled()) {
                        throw new IWorkerContext.WorkerContextCancelledException();
                    }
                    Commit commit = (Commit)pair.getFirst();
                    Diff diff = (Diff)pair.getSecond();
                    long commitTime = commit.getTimeStamp();
                    if (first) {
                        int daysSinceLasstCommit = (int)((this.m_now - commitTime) / 86400000L);
                        unprocessedSources.remove(source);
                        ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, daysSinceLasstCommit, ScmAnalyzerAdapter.this.m_daysSinceLastCommit);
                        first = false;
                    }
                    if (!thirtyDaysPassed && commitTime < this.m_thirtyDaysAgo) {
                        thirtyDaysPassed = true;
                        authors30.addAll(authors5y);
                        changeCount30 = changeCount;
                        changedLines30 = changedLines;
                    }
                    if (!ninetyDaysPassed && commitTime < this.m_ninetyDaysAgo) {
                        ninetyDaysPassed = true;
                        authors90.addAll(authors5y);
                        changeCount90 = changeCount;
                        changedLines90 = changedLines;
                    }
                    if (!oneYearPassed && commitTime < this.m_oneYearAgo) {
                        oneYearPassed = true;
                        authors365.addAll(authors5y);
                        changeCount1y = changeCount;
                        changedLines1y = changedLines;
                    }
                    if (!twoYearsPassed && commitTime < this.m_twoYearsAgo) {
                        twoYearsPassed = true;
                        authors2y.addAll(authors5y);
                        changeCount2y = changeCount;
                        changedLines2y = changedLines;
                    }
                    assert (commitTime <= time) : "We assume commits to be ordered descending by time";
                    time = commitTime;
                    String authorName = commit.getAuthor();
                    if (authorName != null && !authorName.isEmpty()) {
                        Author author = (Author)authorNameToAuthor.get(authorName = ScmAnalyzerAdapter.this.m_authorsProvider.getAuthorNameFromPotentialAlias(authorName));
                        if (author == null) {
                            author = new Author(result, authorName);
                            result.addChild(author);
                            authorNameToAuthor.put(authorName, author);
                        }
                        authors5y.add(author);
                    }
                    ++changeCount;
                    changedLines += diff.getAddedLines() + diff.getRemovedLines();
                }
                if (!thirtyDaysPassed) {
                    thirtyDaysPassed = true;
                    authors30.addAll(authors5y);
                    changeCount30 = changeCount;
                    changedLines30 = changedLines;
                }
                if (!ninetyDaysPassed) {
                    ninetyDaysPassed = true;
                    authors90.addAll(authors5y);
                    changeCount90 = changeCount;
                    changedLines90 = changedLines;
                }
                if (!oneYearPassed) {
                    oneYearPassed = true;
                    authors365.addAll(authors5y);
                    changeCount1y = changeCount;
                    changedLines1y = changedLines;
                }
                if (!twoYearsPassed) {
                    twoYearsPassed = true;
                    authors2y.addAll(authors5y);
                    changeCount2y = changeCount;
                    changedLines2y = changedLines;
                }
                if (source.getTotalLines() == 0) continue;
                float churn30 = (float)(100.0 * (double)changedLines30 / (double)source.getTotalLines());
                float churn90 = (float)(100.0 * (double)changedLines90 / (double)source.getTotalLines());
                float churn365 = (float)(100.0 * (double)changedLines1y / (double)source.getTotalLines());
                float churn2y = (float)(100.0 * (double)changedLines2y / (double)source.getTotalLines());
                float churn5y = (float)(100.0 * (double)changedLines / (double)source.getTotalLines());
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, changeCount30, ScmAnalyzerAdapter.this.m_change30);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, changeCount90, ScmAnalyzerAdapter.this.m_change90);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, changeCount1y, ScmAnalyzerAdapter.this.m_change365);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, changeCount2y, ScmAnalyzerAdapter.this.m_change2y);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, changeCount, ScmAnalyzerAdapter.this.m_change5y);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, changedLines30, ScmAnalyzerAdapter.this.m_churn30);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, changedLines90, ScmAnalyzerAdapter.this.m_churn90);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, changedLines1y, ScmAnalyzerAdapter.this.m_churn365);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, changedLines2y, ScmAnalyzerAdapter.this.m_churn2y);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, changedLines, ScmAnalyzerAdapter.this.m_churn5y);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, Float.valueOf(churn30), ScmAnalyzerAdapter.this.m_churnRate30);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, Float.valueOf(churn90), ScmAnalyzerAdapter.this.m_churnRate90);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, Float.valueOf(churn365), ScmAnalyzerAdapter.this.m_churnRate365);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, Float.valueOf(churn2y), ScmAnalyzerAdapter.this.m_churnRate2y);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, Float.valueOf(churn5y), ScmAnalyzerAdapter.this.m_churnRate5y);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, authors30.size(), ScmAnalyzerAdapter.this.m_authors30);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, authors90.size(), ScmAnalyzerAdapter.this.m_authors90);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, authors365.size(), ScmAnalyzerAdapter.this.m_authors365);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, authors2y.size(), ScmAnalyzerAdapter.this.m_authors2y);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, authors5y.size(), ScmAnalyzerAdapter.this.m_authors5y);
                AuthorsInfo authorsInfo = new AuthorsInfo(this.getSortedAuthorsAsArray((Set<Author>)authors30), this.getSortedAuthorsAsArray((Set<Author>)authors90), this.getSortedAuthorsAsArray((Set<Author>)authors365), this.getSortedAuthorsAsArray((Set<Author>)authors2y), this.getSortedAuthorsAsArray((Set<Author>)authors5y));
                sourceFilesToAuthorsMap.addInfo(source, authorsInfo);
                Module module = source.getParent(Module.class, new Class[0]);
                assert (module != null) : "Missing module for source " + String.valueOf(source);
                this.m_modChanges30.put(module, this.m_modChanges30.get(module) + changeCount30);
                this.m_modChanges90.put(module, this.m_modChanges90.get(module) + changeCount90);
                this.m_modChanges365.put(module, this.m_modChanges365.get(module) + changeCount1y);
                this.m_modChanges2y.put(module, this.m_modChanges2y.get(module) + changeCount2y);
                this.m_modChanges5y.put(module, this.m_modChanges5y.get(module) + changeCount);
                this.m_modChangedLines30.put(module, this.m_modChangedLines30.get(module) + changedLines30);
                this.m_modChangedLines90.put(module, this.m_modChangedLines90.get(module) + changedLines90);
                this.m_modChangedLines365.put(module, this.m_modChangedLines365.get(module) + changedLines1y);
                this.m_modChangedLines2y.put(module, this.m_modChangedLines2y.get(module) + changedLines2y);
                this.m_modChangedLines5y.put(module, this.m_modChangedLines5y.get(module) + changedLines);
                this.m_modAuthors30.get(module).addAll((Collection<Author>)authors30);
                this.m_modAuthors90.get(module).addAll((Collection<Author>)authors90);
                this.m_modAuthors365.get(module).addAll((Collection<Author>)authors365);
                this.m_modAuthors2y.get(module).addAll((Collection<Author>)authors2y);
                this.m_modAuthors5y.get(module).addAll((Collection<Author>)authors5y);
                if (workerContext.hasBeenCanceled()) {
                    throw new IWorkerContext.WorkerContextCancelledException();
                }
                workerContext.workItemCompleted();
            }
            unprocessedSources.forEach(src -> ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), (NamedElement)src, 9999, ScmAnalyzerAdapter.this.m_daysSinceLastCommit));
            this.getResult().addChild(sourceFilesToAuthorsMap);
        }

        private Author[] getSortedAuthorsAsArray(Set<Author> authors) {
            assert (authors != null) : "Parameter 'authors' of method 'getSortedAuthorsAsArray' must not be null";
            if (authors.isEmpty()) {
                return new Author[0];
            }
            Author[] array = new Author[authors.size()];
            int i = 0;
            for (Author next : authors) {
                array[i++] = next;
            }
            if (array.length > 1) {
                Arrays.sort(array, 0, i, (a1, a2) -> a1.getName().compareTo(a2.getName()));
            }
            return array;
        }

        private void processUntouchedFiles() throws IWorkerContext.WorkerContextCancelledException {
            for (SourceFile source : this.m_sourceFileMap.values()) {
                if (this.getWorkerContext().hasBeenCanceled()) {
                    throw new IWorkerContext.WorkerContextCancelledException();
                }
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, 0, ScmAnalyzerAdapter.this.m_change30);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, 0, ScmAnalyzerAdapter.this.m_change90);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, 0, ScmAnalyzerAdapter.this.m_change365);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, 0, ScmAnalyzerAdapter.this.m_change2y);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, 0, ScmAnalyzerAdapter.this.m_change5y);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, 0, ScmAnalyzerAdapter.this.m_churn30);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, 0, ScmAnalyzerAdapter.this.m_churn90);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, 0, ScmAnalyzerAdapter.this.m_churn365);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, 0, ScmAnalyzerAdapter.this.m_churn2y);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, 0, ScmAnalyzerAdapter.this.m_churn5y);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, Float.valueOf(0.0f), ScmAnalyzerAdapter.this.m_churnRate30);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, Float.valueOf(0.0f), ScmAnalyzerAdapter.this.m_churnRate90);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, Float.valueOf(0.0f), ScmAnalyzerAdapter.this.m_churnRate365);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, Float.valueOf(0.0f), ScmAnalyzerAdapter.this.m_churnRate2y);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, Float.valueOf(0.0f), ScmAnalyzerAdapter.this.m_churnRate5y);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, 0, ScmAnalyzerAdapter.this.m_authors30);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, 0, ScmAnalyzerAdapter.this.m_authors90);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, 0, ScmAnalyzerAdapter.this.m_authors365);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, 0, ScmAnalyzerAdapter.this.m_authors2y);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), source, 0, ScmAnalyzerAdapter.this.m_authors5y);
            }
        }

        private void storeModuleAndSystemMetrics() throws IWorkerContext.WorkerContextCancelledException {
            int sysTotalLines = 0;
            int sysChanges30 = 0;
            int sysChanges90 = 0;
            int sysChanges365 = 0;
            int sysChanges2y = 0;
            int sysChanges5y = 0;
            int sysChangedLines30 = 0;
            int sysChangedLines90 = 0;
            int sysChangedLines365 = 0;
            int sysChangedLines2y = 0;
            int sysChangedLines5y = 0;
            THashSet sysAuthors30 = new THashSet();
            THashSet sysAuthors90 = new THashSet();
            THashSet sysAuthors365 = new THashSet();
            THashSet sysAuthors2y = new THashSet();
            THashSet sysAuthors5y = new THashSet();
            for (Module module : this.m_modTotalLines.keySet()) {
                if (this.getWorkerContext().hasBeenCanceled()) {
                    throw new IWorkerContext.WorkerContextCancelledException();
                }
                int totalLines = this.m_modTotalLines.get(module);
                if (totalLines == 0) continue;
                int changes30 = this.m_modChanges30.get(module);
                int changes90 = this.m_modChanges90.get(module);
                int changes365 = this.m_modChanges365.get(module);
                int changes2y = this.m_modChanges2y.get(module);
                int changes5y = this.m_modChanges5y.get(module);
                int changedLines30 = this.m_modChangedLines30.get(module);
                int changedLines90 = this.m_modChangedLines90.get(module);
                int changedLines365 = this.m_modChangedLines365.get(module);
                int changedLines2y = this.m_modChangedLines2y.get(module);
                int changedLines5y = this.m_modChangedLines5y.get(module);
                float churn30 = (float)(100.0 * (double)changedLines30 / (double)totalLines);
                float churn90 = (float)(100.0 * (double)changedLines90 / (double)totalLines);
                float churn365 = (float)(100.0 * (double)changedLines365 / (double)totalLines);
                float churn2y = (float)(100.0 * (double)changedLines2y / (double)totalLines);
                float churn5y = (float)(100.0 * (double)changedLines5y / (double)totalLines);
                Set<Author> modAuthors30 = this.m_modAuthors30.get(module);
                Set<Author> modAuthors90 = this.m_modAuthors90.get(module);
                Set<Author> modAuthors365 = this.m_modAuthors365.get(module);
                Set<Author> modAuthors2y = this.m_modAuthors2y.get(module);
                Set<Author> modAuthors5y = this.m_modAuthors5y.get(module);
                sysTotalLines += totalLines;
                sysChanges30 += changes30;
                sysChanges90 += changes90;
                sysChanges365 += changes365;
                sysChanges2y += changes2y;
                sysChanges5y += changes5y;
                sysChangedLines30 += changedLines30;
                sysChangedLines90 += changedLines90;
                sysChangedLines365 += changedLines365;
                sysChangedLines2y += changedLines2y;
                sysChangedLines5y += changedLines5y;
                sysAuthors30.addAll(modAuthors30);
                sysAuthors90.addAll(modAuthors90);
                sysAuthors365.addAll(modAuthors365);
                sysAuthors2y.addAll(modAuthors2y);
                sysAuthors5y.addAll(modAuthors5y);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), module, changes30, ScmAnalyzerAdapter.this.m_modChange30);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), module, changes90, ScmAnalyzerAdapter.this.m_modChange90);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), module, changes365, ScmAnalyzerAdapter.this.m_modChange365);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), module, changes2y, ScmAnalyzerAdapter.this.m_modChange2y);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), module, changes5y, ScmAnalyzerAdapter.this.m_modChange5y);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), module, changedLines30, ScmAnalyzerAdapter.this.m_modChurn30);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), module, changedLines90, ScmAnalyzerAdapter.this.m_modChurn90);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), module, changedLines365, ScmAnalyzerAdapter.this.m_modChurn365);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), module, changedLines2y, ScmAnalyzerAdapter.this.m_modChurn2y);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), module, changedLines5y, ScmAnalyzerAdapter.this.m_modChurn5y);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), module, Float.valueOf(churn30), ScmAnalyzerAdapter.this.m_modChurnRate30);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), module, Float.valueOf(churn90), ScmAnalyzerAdapter.this.m_modChurnRate90);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), module, Float.valueOf(churn365), ScmAnalyzerAdapter.this.m_modChurnRate365);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), module, Float.valueOf(churn2y), ScmAnalyzerAdapter.this.m_modChurnRate2y);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), module, Float.valueOf(churn5y), ScmAnalyzerAdapter.this.m_modChurnRate5y);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), module, modAuthors30.size(), ScmAnalyzerAdapter.this.m_modAuthorsCount30);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), module, modAuthors90.size(), ScmAnalyzerAdapter.this.m_modAuthorsCount90);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), module, modAuthors365.size(), ScmAnalyzerAdapter.this.m_modAuthorsCount365);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), module, modAuthors2y.size(), ScmAnalyzerAdapter.this.m_modAuthorsCount2y);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), module, modAuthors5y.size(), ScmAnalyzerAdapter.this.m_modAuthorsCount5y);
            }
            if (sysTotalLines > 0) {
                float churn30 = (float)(100.0 * (double)sysChangedLines30 / (double)sysTotalLines);
                float churn90 = (float)(100.0 * (double)sysChangedLines90 / (double)sysTotalLines);
                float churn365 = (float)(100.0 * (double)sysChangedLines365 / (double)sysTotalLines);
                float churn2y = (float)(100.0 * (double)sysChangedLines2y / (double)sysTotalLines);
                float churn5y = (float)(100.0 * (double)sysChangedLines5y / (double)sysTotalLines);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), sysChanges30, ScmAnalyzerAdapter.this.m_sysChange30);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), sysChanges90, ScmAnalyzerAdapter.this.m_sysChange90);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), sysChanges365, ScmAnalyzerAdapter.this.m_sysChange365);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), sysChanges2y, ScmAnalyzerAdapter.this.m_sysChange2y);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), sysChanges5y, ScmAnalyzerAdapter.this.m_sysChange5y);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), sysChangedLines30, ScmAnalyzerAdapter.this.m_sysChurn30);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), sysChangedLines90, ScmAnalyzerAdapter.this.m_sysChurn90);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), sysChangedLines365, ScmAnalyzerAdapter.this.m_sysChurn365);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), sysChangedLines2y, ScmAnalyzerAdapter.this.m_sysChurn2y);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), sysChangedLines5y, ScmAnalyzerAdapter.this.m_sysChurn5y);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), Float.valueOf(churn30), ScmAnalyzerAdapter.this.m_sysChurnRate30);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), Float.valueOf(churn90), ScmAnalyzerAdapter.this.m_sysChurnRate90);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), Float.valueOf(churn365), ScmAnalyzerAdapter.this.m_sysChurnRate365);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), Float.valueOf(churn2y), ScmAnalyzerAdapter.this.m_sysChurnRate2y);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), Float.valueOf(churn5y), ScmAnalyzerAdapter.this.m_sysChurnRate5y);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), sysAuthors30.size(), ScmAnalyzerAdapter.this.m_sysAuthorsCount30);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), sysAuthors90.size(), ScmAnalyzerAdapter.this.m_sysAuthorsCount90);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), sysAuthors365.size(), ScmAnalyzerAdapter.this.m_sysAuthorsCount365);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), sysAuthors2y.size(), ScmAnalyzerAdapter.this.m_sysAuthorsCount2y);
                ScmAnalyzerAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), sysAuthors5y.size(), ScmAnalyzerAdapter.this.m_sysAuthorsCount5y);
            }
        }

        @Override
        protected void internalRun() {
            IScmDataAndConfigurationProvider scmProvider = this.getSoftwareSystem().getExtension(IScmExtension.class);
            try {
                ICommitRetriever retriever = ScmAnalyzerAdapter.this.m_scmManager.getCommitRetriever(ScmAnalyzerAdapter.this.getScm(), scmProvider);
                Date after = new Date(System.currentTimeMillis() - 157593600000L);
                IWorkerContext workerContext = this.getWorkerContext();
                workerContext.setNumberOfSteps(2, new int[]{60, 40});
                workerContext.beginSubTask("Retrieve commits");
                long startTime = System.currentTimeMillis();
                BranchCommits branchCommits = retriever.retrieveCommits((IScmDataProvider)scmProvider, after, workerContext);
                assert (branchCommits != null) : "'branchCommits' of method 'internalRun' must not be null";
                List commits = branchCommits.getCommits();
                LOGGER.debug("Time to retrieve " + commits.size() + " commit(s): " + (System.currentTimeMillis() - startTime) + " ms");
                workerContext.endSubTask();
                workerContext.beginSubTask("Process commits");
                startTime = System.currentTimeMillis();
                this.processCommits(commits, workerContext);
                LOGGER.debug("Time to process " + commits.size() + " commit(s): " + (System.currentTimeMillis() - startTime) + " ms");
                ScmAnalyzerAdapter.this.m_authorsProvider.scmDataAnalysisFinished();
                workerContext.endSubTask();
            }
            catch (ConfigurationException | RetrieveException e) {
                LOGGER.error("Problem reading data from Git: ", e);
                this.getResult().setErrorMessage(e.getMessage());
            }
            catch (IWorkerContext.WorkerContextCancelledException workerContextCancelledException) {
                // empty catch block
            }
        }

        private class SourceVisitor
        extends NamedElementVisitor
        implements SourceFile.IVisitor,
        Module.IVisitor,
        External.IVisitor,
        RootDirectoryPath.IVisitor {
            private int m_totalLines = 0;
            private Module m_currentModule = null;

            private SourceVisitor() {
            }

            @Override
            public void visitExternal(External external) {
            }

            @Override
            public void visitRootDirectoryPath(RootDirectoryPath root) {
                if (root.mayContainSourceFiles()) {
                    ScmMetricsAnalyzerJob.this.m_rootToModuleMap.put(root.getIdentifyingPath(), this.m_currentModule);
                    this.visitChildrenOf(root);
                }
            }

            @Override
            public void visitModule(Module module) {
                Integer zero = 0;
                this.m_currentModule = module;
                ScmMetricsAnalyzerJob.this.m_modChanges30.put(module, zero);
                ScmMetricsAnalyzerJob.this.m_modChanges90.put(module, zero);
                ScmMetricsAnalyzerJob.this.m_modChanges365.put(module, zero);
                ScmMetricsAnalyzerJob.this.m_modChanges2y.put(module, zero);
                ScmMetricsAnalyzerJob.this.m_modChanges5y.put(module, zero);
                ScmMetricsAnalyzerJob.this.m_modChangedLines30.put(module, zero);
                ScmMetricsAnalyzerJob.this.m_modChangedLines90.put(module, zero);
                ScmMetricsAnalyzerJob.this.m_modChangedLines365.put(module, zero);
                ScmMetricsAnalyzerJob.this.m_modChangedLines2y.put(module, zero);
                ScmMetricsAnalyzerJob.this.m_modChangedLines5y.put(module, zero);
                ScmMetricsAnalyzerJob.this.m_modAuthors30.put(module, (Set<Author>)new THashSet());
                ScmMetricsAnalyzerJob.this.m_modAuthors90.put(module, (Set<Author>)new THashSet());
                ScmMetricsAnalyzerJob.this.m_modAuthors365.put(module, (Set<Author>)new THashSet());
                ScmMetricsAnalyzerJob.this.m_modAuthors2y.put(module, (Set<Author>)new THashSet());
                ScmMetricsAnalyzerJob.this.m_modAuthors5y.put(module, (Set<Author>)new THashSet());
                this.visitChildrenOf(module);
                ScmMetricsAnalyzerJob.this.m_modTotalLines.put(module, this.m_totalLines);
                this.m_totalLines = 0;
                this.m_currentModule = null;
            }

            @Override
            public void visitSourceFile(SourceFile source) {
                if (!source.isExcluded()) {
                    ScmMetricsAnalyzerJob.this.m_sourceFileMap.put(source.getIdentifyingPath(), source);
                    this.m_totalLines += source.getTotalLines();
                }
            }
        }
    }
}

