/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.IQualityModelProvider;
import com.hello2morrow.sonargraph.core.controller.system.TreeMapProvider;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.base.ISoftwareSystemLifecycleListener;
import com.hello2morrow.sonargraph.core.controller.system.base.ModelModificationInfo;
import com.hello2morrow.sonargraph.core.controller.system.treemap.TreeMapRepresentationCreator;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ITreeMapExtension;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.element.NameFilter;
import com.hello2morrow.sonargraph.core.model.element.SoftwareSystemDefinitionFileReadError;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemEvent;
import com.hello2morrow.sonargraph.core.model.event.TreeMapLoadedEvent;
import com.hello2morrow.sonargraph.core.model.event.TreeMapModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.TreeMapUnloadedEvent;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.ImportQualityModel;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileCandidate;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFilesDirectory;
import com.hello2morrow.sonargraph.core.model.path.TreeMapsDirectory;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapFile;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapProperties;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapPropertiesNotValid;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapRepresentation;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.persistence.treemap.TreeMapMigration;
import com.hello2morrow.sonargraph.core.persistence.treemap.TreeMapPersistence;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.event.Event;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.file.TrueZipFacade;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TreeMapExtension
extends TreeMapProvider
implements ITreeMapExtension,
ISoftwareSystemLifecycleListener,
IQualityModelProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TreeMapExtension.class);
    private TreeMapProperties m_treeMapProperties;

    TreeMapExtension(Installation installation, SoftwareSystem softwareSystem, IFinishModelProcessor finishModelProcessor, boolean enabled) {
        super(installation, softwareSystem, finishModelProcessor, enabled);
        if (this.isEnabled()) {
            this.getFinishModelProcessor().addListener(this);
        }
    }

    @Override
    public final void finishSoftwareSystemInitialization(OperationResult result) {
        if (this.isEnabled()) {
            Files files = this.getSoftwareSystem().getUniqueExistingChild(Files.class);
            TreeMapMigration.migrate(files.getSystemDirectory(), (TreeMapsDirectory)this.getDirectory(), result);
            super.finishSoftwareSystemInitialization(result);
        }
    }

    private void contentUpdated(TreeMapFile file) {
        assert (file != null) : "Parameter 'file' of method 'contentUpdated' must not be null";
        file.removeIssues(CoreIssueId.TREEMAP_PROPERTIES_NOT_VALID);
        ValidationResult validationResult = file.getTreeMapProperties().isValid();
        if (!validationResult.isSuccess()) {
            file.addIssue(new TreeMapPropertiesNotValid(file, validationResult.toFormattedString()));
        }
    }

    @Override
    protected void added(ModifiableFileCandidate added, OperationResult result) {
        assert (added != null) : "Parameter 'added' of method 'added' must not be null";
        assert (result != null) : "Parameter 'result' of method 'added' must not be null";
        TFile file = added.getFile();
        String name = file.getName();
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        TreeMapsDirectory directory = (TreeMapsDirectory)this.getDirectory();
        TreeMapFile treeMapFile = new TreeMapFile(directory, new TFile((File)directory.getFile(), name), this.getDefaultProperties(), softwareSystem.getUniqueExistingChild(Files.class));
        directory.addChild(treeMapFile);
        OperationResult loadResult = this.getPersistence().load(file, treeMapFile);
        if (loadResult.isFailure() && this.getFinishModelProcessor().getLicenseProvider().isFeatureAvailable(SonargraphFeature.ARCHITECTURE)) {
            treeMapFile.addIssue(new SoftwareSystemDefinitionFileReadError(treeMapFile, loadResult.toString()));
            result.addMessagesFrom(loadResult);
        }
        this.contentUpdated(treeMapFile);
    }

    @Override
    protected void modified(TreeMapFile modified, OperationResult result) {
        assert (modified != null) : "Parameter 'modified' of method 'modified' must not be null";
        assert (result != null) : "Parameter 'result' of method 'modified' must not be null";
        modified.removeIssues(CoreIssueId.SOFTWARE_SYSTEM_DEFINITION_FILE_READ_ERROR);
        OperationResult loadResult = this.getPersistence().load(modified.getFile(), modified);
        if (loadResult.isFailure()) {
            modified.addIssue(new SoftwareSystemDefinitionFileReadError(modified, loadResult.toString()));
        }
        result.addMessagesFrom(loadResult);
        this.contentUpdated(modified);
    }

    @Override
    protected void deleted(TreeMapFile deleted, OperationResult result) {
        assert (deleted != null) : "Parameter 'deleted' of method 'deleted' must not be null";
        assert (result != null) : "Parameter 'result' of method 'deleted' must not be null";
        if (this.hasBeenLoaded(deleted)) {
            this.performUnload(deleted);
            EventManager.getInstance().dispatch((Object)this, (Event)new TreeMapUnloadedEvent(this.getSoftwareSystem().getExtension(ISoftwareSystemProvider.class), deleted));
        }
    }

    @Override
    public void modelModificationFinished(IWorkerContext workerContext, SoftwareSystem softwareSystem, EnumSet<ModelModificationInfo.ModelModification> modelModifications, List<SoftwareSystemEvent> eventsToDispatch, List<IModifiableFile> restoredFiles, INavigationState navigationState) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'modelModificationFinished' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'modelModificationFinished' must not be null";
        assert (modelModifications != null) : "Parameter 'modelModifications' of method 'modelModificationFinished' must not be null";
        assert (eventsToDispatch != null) : "Parameter 'eventsToDispatch' of method 'modelModificationFinished' must not be null";
        if (modelModifications.contains((Object)ModelModificationInfo.ModelModification.PHYSICAL_MODEL_MODIFIED) || modelModifications.contains((Object)ModelModificationInfo.ModelModification.LOGIGAL_MODEL_MODIFIED) || modelModifications.contains((Object)ModelModificationInfo.ModelModification.WORKSPACE_MODEL_MODIFIED) || restoredFiles != null) {
            for (TreeMapFile nextFile : this.getAvailableFiles()) {
                if (!this.hasBeenLoaded(nextFile)) continue;
                List<Module> nextModules = this.getValidModules(nextFile.getUniqueExistingChild(TreeMapRepresentation.class));
                this.performUnload(nextFile);
                TreeMapRepresentation representation = null;
                if (softwareSystem.isClearable() && !nextModules.isEmpty()) {
                    OperationResult result = new OperationResult("Re-create treemap");
                    representation = TreeMapRepresentationCreator.create(workerContext, this.getInstallation(), this.getSoftwareSystem(), nextModules, nextFile, nextFile.getTreeMapProperties(), result);
                    if (result.isFailure()) {
                        LOGGER.error("Failed to re-create treemap: " + String.valueOf(result));
                    }
                }
                if (representation != null) {
                    eventsToDispatch.add(new TreeMapModifiedEvent(this.getSoftwareSystem().getExtension(ISoftwareSystemProvider.class), nextFile, false, false));
                    continue;
                }
                eventsToDispatch.add(new TreeMapUnloadedEvent(softwareSystem.getExtension(ISoftwareSystemProvider.class), nextFile));
            }
        }
    }

    @Override
    public void analyzerFinished(SoftwareSystem softwareSystem, IAnalyzerId analyzerId, boolean issuesModified, boolean metricValuesAdded, boolean metricDescriptorAdded, List<SoftwareSystemEvent> eventsToDispatch) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'analyzerFinished' must not be null";
        assert (eventsToDispatch != null) : "Parameter 'eventsToDispatch' of method 'analyzerFinished' must not be null";
        if (issuesModified || metricValuesAdded) {
            for (TreeMapFile nextFile : this.getAvailableFiles()) {
                if (!this.hasBeenLoaded(nextFile)) continue;
                TreeMapRepresentationCreator.updateLeafInfo(this.getInstallation(), softwareSystem, nextFile.getTreeMapProperties(), nextFile.getUniqueExistingChild(TreeMapRepresentation.class));
                eventsToDispatch.add(new TreeMapModifiedEvent(this.getSoftwareSystem().getExtension(ISoftwareSystemProvider.class), nextFile, true, false));
            }
        }
    }

    @Override
    public void cleared(IWorkerContext workerContext, SoftwareSystem softwareSystem, List<SoftwareSystemEvent> eventsToDispatch, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'cleared' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'cleared' must not be null";
        assert (eventsToDispatch != null) : "Parameter 'eventsToDispatch' of method 'cleared' must not be null";
        assert (result != null) : "Parameter 'result' of method 'cleared' must not be null";
        for (TreeMapFile nextFile : this.getAvailableFiles()) {
            if (!this.hasBeenLoaded(nextFile)) continue;
            this.performUnload(nextFile);
            eventsToDispatch.add(new TreeMapUnloadedEvent(softwareSystem.getExtension(ISoftwareSystemProvider.class), nextFile));
        }
    }

    @Override
    public void released(SoftwareSystem softwareSystem, List<SoftwareSystemEvent> eventsToDispatch, OperationResult result) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'released' must not be null";
        assert (eventsToDispatch != null) : "Parameter 'eventsToDispatch' of method 'released' must not be null";
        for (TreeMapFile nextFile : this.getAvailableFiles()) {
            if (!this.hasBeenLoaded(nextFile)) continue;
            this.performUnload(nextFile);
            eventsToDispatch.add(new TreeMapUnloadedEvent(softwareSystem.getExtension(ISoftwareSystemProvider.class), nextFile));
        }
    }

    private TreeMapFile createFile(TreeMapProperties properties, OperationResult result) {
        assert (properties != null) : "Parameter 'properties' of method 'createFile' must not be null";
        assert (result != null) : "Parameter 'result' of method 'createFile' must not be null";
        TreeMapsDirectory directory = (TreeMapsDirectory)this.getDirectory();
        TreeMapFile newFile = new TreeMapFile(directory, new TFile((File)directory.getFile(), properties.getName() + CoreFileType.TREEMAP.getDefaultExtension()), properties, this.getSoftwareSystem().getUniqueExistingChild(Files.class));
        directory.addChild(newFile);
        result.addMessagesFrom(this.getPersistence().save(newFile));
        this.contentUpdated(newFile);
        if (result.isSuccess()) {
            newFile.setNeedsSave(false);
            newFile.setExistsOnDisk(true);
            newFile.resetTimestamp();
        } else {
            newFile.setNeedsSave(true);
            newFile.setExistsOnDisk(false);
        }
        return newFile;
    }

    @Override
    public OperationResultWithOutcome<TreeMapFile> create(IWorkerContext workerContext, TreeMapProperties properties) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'create' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'create' must not be null";
        assert (this.getNameValidator(null).isValid("", properties.getName()).isSuccess()) : "Not a valid name: " + properties.getName();
        assert (this.isEnabled()) : "Extension not enabled";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Create treemap '" + properties.getName() + "'");
        this.checkOutOfSync((OperationResult)result);
        if (result.isSuccess()) {
            TreeMapFile file = this.createFile(properties, (OperationResult)result);
            result.setOutcome((Object)file);
            this.getFinishModelProcessor().finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), (OperationResult)result);
        }
        return result;
    }

    private List<Module> getValidModules(TreeMapRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'getValidModules' must not be null";
        ArrayList<Module> modules = new ArrayList<Module>();
        for (Module nextModule : representation.getModules()) {
            if (!nextModule.isValid()) continue;
            modules.add(nextModule);
        }
        return modules;
    }

    @Override
    public OperationResult edit(IWorkerContext workerContext, TreeMapFile file, TreeMapProperties properties) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'edit' must not be null";
        assert (file != null) : "Parameter 'file' of method 'edit' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'edit' must not be null";
        assert (!file.getTreeMapProperties().equals(properties)) : "Nothing to edit: " + String.valueOf(properties);
        assert (this.getNameValidator(file).isValid("", properties.getName()).isSuccess()) : "Not a valid name: " + properties.getName();
        OperationResult result = new OperationResult("Edit treemap '" + file.getIdentifyingPath() + "'");
        List<Module> modules = null;
        if (this.hasBeenLoaded(file)) {
            modules = this.getValidModules(file.getUniqueExistingChild(TreeMapRepresentation.class));
            this.performUnload(file);
        }
        if (!file.getTreeMapProperties().getName().equals(properties.getName())) {
            this.checkOutOfSync(result);
            if (result.isFailure()) {
                return result;
            }
            TFile targetFile = new TFile((File)((TreeMapsDirectory)this.getDirectory()).getFile(), properties.getName() + CoreFileType.TREEMAP.getDefaultExtension());
            try {
                file.getFile().mv((File)targetFile);
                file.setPath(targetFile);
                file.setTreeMapProperties(properties);
                file.setNeedsSave(true);
                OperationResult saveResult = this.getPersistence().save(file);
                this.contentUpdated(file);
                if (saveResult.isSuccess()) {
                    TrueZipFacade.sync((TFile)file.getFile());
                    file.setNeedsSave(false);
                }
                result.addMessagesFrom(saveResult);
            }
            catch (IOException e) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_MOVE);
                return result;
            }
        } else {
            file.setTreeMapProperties(properties);
            file.setNeedsSave(true);
        }
        this.contentUpdated(file);
        if (modules != null) {
            TreeMapRepresentation representation = TreeMapRepresentationCreator.create(workerContext, this.getInstallation(), this.getSoftwareSystem(), modules, file, properties, result);
            this.getFinishModelProcessor().finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), result);
            if (representation != null) {
                EventManager.getInstance().dispatch((Object)this, (Event)new TreeMapModifiedEvent(this.getSoftwareSystem().getExtension(ISoftwareSystemProvider.class), file, false, true));
            } else {
                EventManager.getInstance().dispatch((Object)this, (Event)new TreeMapUnloadedEvent(this.getSoftwareSystem().getExtension(ISoftwareSystemProvider.class), file));
            }
        } else {
            this.getFinishModelProcessor().finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), result);
        }
        return result;
    }

    @Override
    public TreeMapProperties getDefaultProperties() {
        Installation installation = this.getInstallation();
        if (this.m_treeMapProperties == null) {
            this.m_treeMapProperties = TreeMapRepresentationCreator.createDefaultProperties(installation);
        }
        TreeMapRepresentationCreator.updateScriptMetricValueSources(installation, this.m_treeMapProperties);
        return new TreeMapProperties(this.m_treeMapProperties);
    }

    @Override
    public OperationResult open(IWorkerContext workerContext, TreeMapFile file, List<Module> modules) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'open' must not be null";
        assert (file != null) : "Parameter 'file' of method 'open' must not be null";
        assert (modules != null && !modules.isEmpty()) : "Parameter 'modules' of method 'open' must not be empty";
        assert (this.isEnabled()) : "Extension not enabled";
        OperationResult result = new OperationResult("Load treemap '" + file.getIdentifyingPath() + "'");
        this.checkOutOfSync(result);
        if (result.isSuccess()) {
            TreeMapProperties properties = file.getTreeMapProperties();
            TreeMapRepresentation representation = TreeMapRepresentationCreator.create(workerContext, this.getInstallation(), this.getSoftwareSystem(), modules, file, properties, result);
            if (representation != null) {
                this.getFinishModelProcessor().finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), result);
                EventManager.getInstance().dispatch((Object)this, (Event)new TreeMapLoadedEvent(this.getSoftwareSystem().getExtension(ISoftwareSystemProvider.class), file));
            }
        }
        return result;
    }

    @Override
    public void save(TreeMapFile file, OutputStream outputStream, OperationResult result) {
        assert (file != null) : "Parameter 'file' of method 'save' must not be null";
        assert (outputStream != null) : "Parameter 'outputStream' of method 'save' must not be null";
        assert (result != null) : "Parameter 'result' of method 'save' must not be null";
        this.getPersistence().save(file, outputStream, result);
        this.contentUpdated(file);
    }

    OperationResult save(TreeMapFile file) {
        assert (file != null) : "Parameter 'file' of method 'save' must not be null";
        OperationResult saveResult = this.getPersistence().save(file);
        this.contentUpdated(file);
        if (saveResult.isSuccess()) {
            file.setNeedsSave(false);
            file.resetTimestamp();
        }
        return saveResult;
    }

    @Override
    public void restore(TreeMapFile file, InputStream inputStream, OperationResult result) {
        assert (file != null) : "Parameter 'file' of method 'restore' must not be null";
        assert (inputStream != null) : "Parameter 'inputStream' of method 'restore' must not be null";
        assert (result != null) : "Parameter 'result' of method 'restore' must not be null";
        result.addMessagesFrom(this.getPersistence().load(inputStream, file));
        this.contentUpdated(file);
    }

    @Override
    public OperationResult deleteTreeMaps(IWorkerContext workerContext, List<TreeMapFile> files) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'deleteTreeMaps' must not be null";
        assert (files != null && !files.isEmpty()) : "Parameter 'files' of method 'deleteTreeMaps' must not be empty";
        assert (this.isDeleteTreeMapsPossible(files)) : "Delete not possible";
        OperationResult result = new OperationResult("Delete " + files.size() + " treemap(s)");
        this.checkOutOfSync(result);
        if (result.isSuccess()) {
            for (TreeMapFile nextFile : files) {
                if (this.hasBeenLoaded(nextFile)) {
                    this.performUnload(nextFile);
                    EventManager.getInstance().dispatch((Object)this, (Event)new TreeMapUnloadedEvent(this.getSoftwareSystem().getExtension(ISoftwareSystemProvider.class), nextFile));
                }
                SoftwareSystemFilesDirectory.removeFile(nextFile.getFile(), false, result);
                nextFile.remove();
            }
            this.getFinishModelProcessor().finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), result);
        }
        return result;
    }

    @Override
    public boolean exports(IModifiableFile modifiableFile) {
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'exports' must not be null";
        IFileType fileType = modifiableFile.getFileType();
        return CoreFileType.TREEMAP.equals(fileType);
    }

    @Override
    public String getExportBaseDirectory() {
        return "Treemaps";
    }

    @Override
    public void exportFile(IModifiableFile modifiableFile, TFile targetFile, OperationResult result) {
        assert (modifiableFile != null && modifiableFile instanceof TreeMapFile) : "Unexpected class in method 'exportFile': " + String.valueOf(modifiableFile);
        assert (targetFile != null) : "Parameter 'targetFile' of method 'exportFile' must not be null";
        assert (result != null) : "Parameter 'result' of method 'exportFile' must not be null";
        TreeMapFile treeMapFile = (TreeMapFile)modifiableFile;
        result.addMessagesFrom(this.getPersistence().save(treeMapFile, targetFile));
    }

    @Override
    public void importFiles(IWorkerContext workerContext, ImportQualityModel importQualityModel, EnumSet<Modification> modfications, OperationResult result) {
        assert (importQualityModel != null) : "Parameter 'importQualityModel' of method 'importFiles' must not be null";
        TreeMapsDirectory treeMapsDirectory = (TreeMapsDirectory)this.getDirectory();
        List<ImportQualityModel.ImportQualityModelCandidate> candidates = importQualityModel.getCandidatesByFileType(CoreFileType.TREEMAP);
        block0: for (ImportQualityModel.ImportQualityModelCandidate nextImportQualityModelCandidate : candidates) {
            if (!nextImportQualityModelCandidate.isIncluded()) continue;
            TFile contentFile = nextImportQualityModelCandidate.getModifiableFile().getFile();
            String contentFileIdentifyingPath = nextImportQualityModelCandidate.getModifiableFile().getIdentifyingPath();
            if (importQualityModel.discardCurrentContent() || !nextImportQualityModelCandidate.isAlreadyInModel()) {
                TFile targetFile = new TFile((File)treeMapsDirectory.getFile(), contentFileIdentifyingPath);
                result.addMessagesFrom(this.addTreeMapFile(contentFile, targetFile.getNormalizedFile(), null, true));
                continue;
            }
            if (importQualityModel.discardCurrentContent()) continue;
            for (IModifiableFile nextAvailable : this.getAvailableFiles()) {
                if (!(nextAvailable instanceof TreeMapFile) || !nextAvailable.getIdentifyingPath().equals(contentFileIdentifyingPath)) continue;
                result.addMessagesFrom(this.addTreeMapFile(contentFile, nextAvailable.getFile(), (TreeMapFile)nextAvailable, true));
                continue block0;
            }
        }
    }

    private OperationResult addTreeMapFile(TFile contentFile, TFile modelFile, TreeMapFile treeMapFile, boolean saveToDisk) {
        assert (contentFile != null) : "Parameter 'contentFile' of method 'addTreeMapFile' must not be null";
        assert (modelFile != null) : "Parameter 'modelFile' of method 'addTreeMapFile' must not be null";
        OperationResult result = new OperationResult("Add TreeMap File");
        TreeMapPersistence persistence = this.getPersistence();
        if (treeMapFile == null) {
            TreeMapsDirectory treeMaps = (TreeMapsDirectory)this.getDirectory();
            TFile treeMapsDirectoryFile = treeMaps.getFile();
            String treeMapName = modelFile.getName();
            String treeMapRelPath = "./" + treeMapName;
            treeMapFile = treeMaps.getFirstChild(new NameFilter(treeMapRelPath), TreeMapFile.class);
            assert (treeMapFile == null) : "File should not be there: " + treeMapName;
            treeMapFile = new TreeMapFile(treeMaps, new TFile((File)treeMapsDirectoryFile, treeMapName), this.getDefaultProperties(), this.getSoftwareSystem().getUniqueExistingChild(Files.class));
            treeMaps.addChild(treeMapFile);
            OperationResult loadResult = this.getPersistence().load(contentFile, treeMapFile);
            if (loadResult.isFailure()) {
                treeMapFile.addIssue(new SoftwareSystemDefinitionFileReadError(treeMapFile, loadResult.toString()));
            }
            result.addMessagesFrom(loadResult);
            this.contentUpdated(treeMapFile);
        } else {
            result.addMessagesFrom(persistence.load(contentFile, treeMapFile));
            treeMapFile.reloaded(contentFile.lastModified(), false);
        }
        if (saveToDisk) {
            OperationResult saveResult = persistence.save(treeMapFile, modelFile);
            result.addMessagesFrom(saveResult);
            if (saveResult.isSuccess()) {
                treeMapFile.setExistsOnDisk(true);
                treeMapFile.resetTimestamp();
            }
            TrueZipFacade.clear((TFile)modelFile);
        }
        return result;
    }

    @Override
    public void discardFiles(IWorkerContext workerContext, EnumSet<Modification> modfications, OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'discardFiles' must not be null";
        ((TreeMapsDirectory)this.getDirectory()).removeAll(result);
    }

    @Override
    public void setQualityModelRoot(TFile qualityModel) {
        assert (qualityModel != null) : "Parameter 'qualityModel' of method 'setQualityModelRoot' must not be null";
        TreeMapsDirectory treeMapsDirectory = (TreeMapsDirectory)this.getDirectory();
        treeMapsDirectory.setPath(new TFile((File)qualityModel, "./Treemaps"));
    }
}

