/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.QualityGateExtension;
import com.hello2morrow.sonargraph.core.controller.system.base.AbstractUndoRedoProvider;
import com.hello2morrow.sonargraph.core.foundation.common.history.RestoreStateDto;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.CurrentSystemConditions;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.DiffAgainstBaselineConditions;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGate;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGates;
import com.hello2morrow.sonargraph.core.model.transaction.AnalyzerExecutionInfo;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;

final class QualityGateUndoRedoProvider
extends AbstractUndoRedoProvider {
    private final SoftwareSystem m_softwareSystem;

    QualityGateUndoRedoProvider(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'QualityGateUndoRedoProvider' must not be null";
        this.m_softwareSystem = softwareSystem;
    }

    @Override
    public List<Class<? extends IModifiableFile>> getModifiableFileClasses() {
        return Collections.singletonList(QualityGate.class);
    }

    @Override
    public void writeModifiableFileToStream(IModifiableFile file, OutputStream outputStream, OperationResult result) {
        assert (file != null) : "Parameter 'file' of method 'writeModifiableFileToStream' must not be null";
        assert (outputStream != null) : "Parameter 'outputStream' of method 'writeModifiableFileToStream' must not be null";
        assert (result != null) : "Parameter 'result' of method 'writeModifiableFileToStream' must not be null";
        this.m_softwareSystem.getExtension(QualityGateExtension.class).getPersistence().save(outputStream, (QualityGate)file, result);
    }

    @Override
    public OperationResultWithOutcome<? extends IModifiableFile> restoreModifiableFileFromStream(InputStream inputStream, RestoreStateDto dto, EnumSet<Modification> determinedModifications, List<String> otherFilesOfTx) throws IOException {
        assert (inputStream != null) : "Parameter 'inputStream' of method 'restoreModifiableFileFromStream' must not be null";
        assert (dto != null) : "Parameter 'dto' of method 'restoreModifiableFileFromStream' must not be null";
        assert (determinedModifications != null) : "Parameter 'determinedModifications' of method 'restoreModifiableFileFromStream' must not be null";
        assert (otherFilesOfTx != null) : "Parameter 'otherFilesOfTx' of method 'restoreModifiableFileFromStream' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Restore quality gate '" + dto.getModifiableFilePath() + "'");
        Files files = this.m_softwareSystem.getUniqueExistingChild(Files.class);
        Optional<IModifiableFile> match = files.findById(dto.getModifiableFileId());
        assert (match.isPresent()) : "Quality gate '" + dto.getModifiableFilePath() + "' must exist!";
        QualityGate toBeRestored = (QualityGate)match.get();
        QualityGateExtension qualityGateExtension = this.m_softwareSystem.getExtension(QualityGateExtension.class);
        toBeRestored.removeChildren(CurrentSystemConditions.class, DiffAgainstBaselineConditions.class);
        result.addMessagesFrom(qualityGateExtension.getPersistence().load(inputStream, toBeRestored));
        if (result.isFailure()) {
            return result;
        }
        if (!toBeRestored.getIdentifyingPath().equals(dto.getCurrentStateFileEntry().getIdentifyingPath())) {
            TFile newPath = new TFile((File)toBeRestored.getParent(QualityGates.class, new Class[0]).getFile(), dto.getCurrentStateFileEntry().getIdentifyingPath()).getNormalizedAbsoluteFile();
            try {
                toBeRestored.getFile().mv((File)newPath);
            }
            catch (IOException ex) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_MOVE, (Throwable)ex);
                return result;
            }
            toBeRestored.setPath(newPath);
        }
        result.setOutcome((Object)toBeRestored);
        return result;
    }

    @Override
    public AnalyzerExecutionInfo getAnalyzerExecutionInfo(String identifyingPath, RestoreStateDto restoreDto) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'getAnalyzerExecutionInfo' must not be empty";
        assert (restoreDto != null) : "Parameter 'restoreDto' of method 'getAnalyzerExecutionInfo' must not be null";
        return AnalyzerExecutionInfo.groups(EnumSet.of(AnalyzerGroup.SYSTEM_DIFF, AnalyzerGroup.QUALITY_GATE));
    }
}

