/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericInternalLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericLogicalModuleNamespace;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericLogicalSystemNamespace;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericPackage;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.refactoring.AssignableToArtifactRefactoringDescriptor;
import com.hello2morrow.sonargraph.core.model.refactoring.RecursiveElementRefactoringDescriptor;
import com.hello2morrow.sonargraph.core.model.workspace.ModuleBasedLogicalNamespaceRoot;
import java.util.List;

public abstract class LanguageProviderRefactoringDescriptorProvider {
    private final Language m_language;

    protected LanguageProviderRefactoringDescriptorProvider(Language language) {
        assert (language != null) : "Parameter 'language' of method 'LanguageProviderRefactoringDescriptorProvider' must not be null";
        this.m_language = language;
    }

    public final Language getLanguage() {
        return this.m_language;
    }

    protected IMetricLevel getPackageMetricLevel() {
        if (this.m_language.hasLogicalModel()) assert (false) : "Must be overidden if called";
        return null;
    }

    public RecursiveElementRefactoringDescriptor getLogicalSystemScopeRecursiveElementRefactoringDescriptor(final IModelServiceProvider msp, final NamedElement fallbackRoot) {
        assert (msp != null) : "Parameter 'msp' of method 'getLogicalSystemScopeRecursiveElementRefactoringDescriptor' must not be null";
        assert (fallbackRoot != null) : "Parameter 'fallbackRoot' of method 'getLogicalSystemScopeRecursiveElementRefactoringDescriptor' must not be null";
        return new RecursiveElementRefactoringDescriptor(){

            @Override
            public Language getLanguage() {
                return LanguageProviderRefactoringDescriptorProvider.this.m_language;
            }

            @Override
            public String getImageResource() {
                return "NamespaceFragment";
            }

            @Override
            public String getPresentationName() {
                return this.getLanguage().getNamespacePresentationName();
            }

            @Override
            public String getImageResourcePart() {
                return "NamespaceFragmentPart";
            }

            @Override
            public RecursiveElementRefactoringDescriptor.ElementType getType() {
                return RecursiveElementRefactoringDescriptor.ElementType.NAMESPACE;
            }

            @Override
            public String getSeparator() {
                return this.getLanguage().getNamespaceSeparator();
            }

            @Override
            public NamedElement createPrototype(NamedElement parent, String name, NamedElement template) {
                if (!$assertionsDisabled && parent == null) {
                    throw new AssertionError((Object)"Parameter 'parent' of method 'createPrototype' must not be null");
                }
                if (!($assertionsDisabled || name != null && name.length() > 0)) {
                    throw new AssertionError((Object)"Parameter 'name' of method 'createPrototype' must not be empty");
                }
                NamedElement parentForPackageFragment = null;
                if (parent instanceof GenericInternalLogicalNamespaceRoot) {
                    parentForPackageFragment = fallbackRoot;
                } else if (parent instanceof GenericLogicalSystemNamespace) {
                    GenericLogicalSystemNamespace logicalSystemNamespace = (GenericLogicalSystemNamespace)parent;
                    List<LogicalNamespace.ISourceNamespace> representativeSourceNamespaces = logicalSystemNamespace.getRepresentativeSourceNamespaces();
                    if (!$assertionsDisabled && (representativeSourceNamespaces == null || representativeSourceNamespaces.isEmpty())) {
                        throw new AssertionError((Object)"'representativeSourceNamespaces' of method 'createPrototype' must not be empty");
                    }
                    parentForPackageFragment = representativeSourceNamespaces.get(0).getNamedElement();
                } else if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unexpected parent of class: " + parent.getClass().getName()));
                }
                GenericPackage sourceNamespace = new GenericPackage(msp, parentForPackageFragment, name);
                GenericLogicalSystemNamespace logicalNamespace = new GenericLogicalSystemNamespace(parent, name, LanguageProviderRefactoringDescriptorProvider.this.m_language, LanguageProviderRefactoringDescriptorProvider.this.getPackageMetricLevel());
                logicalNamespace.connect(sourceNamespace);
                return logicalNamespace;
            }
        };
    }

    public RecursiveElementRefactoringDescriptor getLogicalModuleScopeRecursiveElementRefactoringDescriptor(final IModelServiceProvider msp) {
        assert (msp != null) : "Parameter 'msp' of method 'getLogicalModuleScopeRecursiveElementDescriptor' must not be null";
        return new RecursiveElementRefactoringDescriptor(){

            @Override
            public Language getLanguage() {
                return LanguageProviderRefactoringDescriptorProvider.this.m_language;
            }

            @Override
            public String getImageResource() {
                return "NamespaceFragment";
            }

            @Override
            public String getPresentationName() {
                return this.getLanguage().getNamespacePresentationName();
            }

            @Override
            public String getImageResourcePart() {
                return "NamespaceFragmentPart";
            }

            @Override
            public RecursiveElementRefactoringDescriptor.ElementType getType() {
                return RecursiveElementRefactoringDescriptor.ElementType.NAMESPACE;
            }

            @Override
            public String getSeparator() {
                return this.getLanguage().getNamespaceSeparator();
            }

            @Override
            public NamedElement createPrototype(NamedElement parent, String name, NamedElement template) {
                if (!$assertionsDisabled && parent == null) {
                    throw new AssertionError((Object)"Parameter 'parent' of method 'createPrototype' must not be null");
                }
                if (!($assertionsDisabled || name != null && name.length() > 0)) {
                    throw new AssertionError((Object)"Parameter 'name' of method 'createPrototype' must not be empty");
                }
                NamedElement parentForPackageFragment = null;
                if (parent instanceof ModuleBasedLogicalNamespaceRoot) {
                    parentForPackageFragment = ((ModuleBasedLogicalNamespaceRoot)parent).getPhysicalElement();
                } else if (parent instanceof GenericLogicalModuleNamespace) {
                    GenericLogicalModuleNamespace logicalModuleNamespace = (GenericLogicalModuleNamespace)parent;
                    List<LogicalNamespace.ISourceNamespace> representativeSourceNamespaces = logicalModuleNamespace.getRepresentativeSourceNamespaces();
                    if (!$assertionsDisabled && (representativeSourceNamespaces == null || representativeSourceNamespaces.isEmpty())) {
                        throw new AssertionError((Object)"'representativeSourceNamespaces' of method 'createPrototype' must not be empty");
                    }
                    parentForPackageFragment = representativeSourceNamespaces.get(0).getNamedElement();
                } else if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unexpected parent of class: " + parent.getClass().getName()));
                }
                GenericPackage sourceNamespace = new GenericPackage(msp, parentForPackageFragment, name);
                GenericLogicalModuleNamespace logicalNamespace = new GenericLogicalModuleNamespace(parent, name, LanguageProviderRefactoringDescriptorProvider.this.m_language, LanguageProviderRefactoringDescriptorProvider.this.getPackageMetricLevel());
                logicalNamespace.connect(sourceNamespace);
                return logicalNamespace;
            }
        };
    }

    public abstract RecursiveElementRefactoringDescriptor getPhysicalRecursiveElementRefactoringDescriptor(IModelServiceProvider var1);

    public abstract AssignableToArtifactRefactoringDescriptor getLogicalSystemScopeAssignableToArtifactRefactoringDescriptor(IModelServiceProvider var1);

    public abstract AssignableToArtifactRefactoringDescriptor getLogicalModuleScopeAssignableToArtifactRefactoringDescriptor(IModelServiceProvider var1);

    public abstract AssignableToArtifactRefactoringDescriptor getPhysicalAssignableToArtifactRefactoringDescriptor(IModelServiceProvider var1);

    public abstract class BaseAssignableToArtifactRefactoringDescriptor
    extends AssignableToArtifactRefactoringDescriptor {
        @Override
        public Language getLanguage() {
            return LanguageProviderRefactoringDescriptorProvider.this.m_language;
        }

        @Override
        public AssignableToArtifactRefactoringDescriptor.ElementType getType() {
            return AssignableToArtifactRefactoringDescriptor.ElementType.TYPE;
        }

        @Override
        public String getPresentationName() {
            return "Class";
        }
    }
}

