/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.IDeltaDetector;
import com.hello2morrow.sonargraph.core.controller.system.RootDirectoryPathValidator;
import com.hello2morrow.sonargraph.core.model.filter.IWorkspaceFilter;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.ILanguageProvider;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.DirectoryScanner;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DeltaDetector
implements DirectoryScanner.IFileConsumer,
IDeltaDetector {
    public static final long NEEDS_REPARSE = 1L;
    public static final long DELETED = 0L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DeltaDetector.class);
    protected final Map<TFile, FilePath> m_existingFiles = new HashMap<TFile, FilePath>();
    protected final IWorkerContext m_workerContext;
    private final List<String> m_ignoreDirectories;
    protected ModuleDelta m_delta;
    protected final Module m_module;
    protected RootDirectoryPath m_currentRootDirectory;
    private DirectoryScanner m_scanner;

    protected DeltaDetector(IWorkerContext workerContext, ILanguageProvider languageProvider, IWorkspaceFilter filter, Module module, List<String> ignoreDirectories) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'RefreshJob' must not be null";
        assert (languageProvider != null) : "Parameter 'languageProvider' of method 'DeltaDetector' must not be null";
        assert (filter != null) : "Parameter 'filter' of method 'DeltaDetector' must not be null";
        assert (module != null) : "Parameter 'softwareSystem' of method 'RefreshJob' must not be null";
        assert (ignoreDirectories != null) : "Parameter 'ignoreDirectories' of method 'RefreshJob' must not be null";
        this.m_workerContext = workerContext;
        this.m_module = module;
        this.m_delta = new ModuleDelta(languageProvider, filter, module);
        this.m_ignoreDirectories = ignoreDirectories;
        for (RootDirectoryPath nextRootDirectory : module.getOriginalChildren(RootDirectoryPath.class)) {
            for (FilePath nextFile : nextRootDirectory.getOriginalChildrenRecursively(FilePath.class, ProgrammingElement.class)) {
                TFile file = nextFile.getFile();
                long timeStamp = nextFile.getTimestamp();
                if (timeStamp == 1L) {
                    this.m_delta.modified(nextFile);
                } else if (timeStamp == 0L) {
                    this.m_delta.deleted(nextFile);
                } else {
                    long actualTimeStamp = file.lastModified();
                    if (timeStamp != 0L && actualTimeStamp != 0L && actualTimeStamp != timeStamp) {
                        this.m_delta.modified(nextFile);
                    }
                }
                this.m_existingFiles.put(file, nextFile);
            }
        }
    }

    protected Collection<FilePath> getExistingFiles() {
        return this.m_existingFiles.values();
    }

    @Override
    public Module getModule() {
        return this.m_module;
    }

    protected void changesDetectedInPreceedingModules() {
    }

    @Override
    public final ModuleDelta detectDelta(IWorkerContext workerContext, OperationResult result, boolean changesDetectedBefore) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'detectDelta' must not be null";
        assert (result != null) : "Parameter 'result' of method 'detectDelta' must not be null";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Starting delta detection for Module " + this.getModule().getName());
        }
        workerContext.setNumberOfSteps(1);
        this.detectRemovedFiles();
        this.prepareScan(result);
        if (changesDetectedBefore) {
            this.changesDetectedInPreceedingModules();
        }
        this.processLinkedFiles(result);
        if (!workerContext.hasBeenCanceled() && result.isSuccess()) {
            this.scanDirectories(result);
        }
        workerContext.endStep();
        this.m_scanner = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Delta detection finished for Module " + this.getModule().getName());
        }
        return this.m_delta;
    }

    protected void processLinkedFiles(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'processLinkedFiles' must not be null";
    }

    protected void detectRemovedFiles() {
        for (Map.Entry<TFile, FilePath> next : this.m_existingFiles.entrySet()) {
            if (next.getKey().exists() && next.getValue().getTimestamp() != 0L) continue;
            this.m_delta.deleted(next.getValue());
        }
    }

    protected void prepareScan(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'prepareScan' must not be null";
        this.m_scanner = new DirectoryScanner(this.m_ignoreDirectories, false);
    }

    protected void scanRootDirectory(RootDirectoryPath root) {
        this.m_scanner.scan(root.getFile(), (DirectoryScanner.IFileConsumer)this);
    }

    protected void scanDirectories(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'scanDirectories' must not be null";
        ArrayList<RootDirectoryPath> roots = new ArrayList<RootDirectoryPath>();
        for (RootDirectoryPath nextRootDirectory : this.m_module.getChildren(RootDirectoryPath.class)) {
            if (RootDirectoryPathValidator.validate(nextRootDirectory)) {
                if (nextRootDirectory.isAutomatic()) continue;
                roots.add(nextRootDirectory);
                continue;
            }
            LOGGER.warn("Root directory is not a directory or does not exist: {}", (Object)nextRootDirectory);
        }
        this.m_workerContext.beginBlockOfWork(roots.size());
        Iterator<RootDirectoryPath> iterator = roots.iterator();
        while (iterator.hasNext()) {
            RootDirectoryPath nextRootDirectory;
            this.m_currentRootDirectory = nextRootDirectory = iterator.next();
            this.aboutToScanRoot(nextRootDirectory);
            this.m_workerContext.working("Scanning " + nextRootDirectory.getFile().getAbsolutePath(), true);
            if (this.m_workerContext.hasBeenCanceled()) {
                this.m_delta = null;
                break;
            }
            this.scanRootDirectory(nextRootDirectory);
            this.m_workerContext.workItemCompleted();
            this.m_currentRootDirectory = null;
        }
    }

    protected void aboutToScanRoot(RootDirectoryPath root) {
        assert (root != null) : "Parameter 'root' of method 'aboutToScanRoot' must not be null";
    }

    public final void consume(TFile rootPathBeingScanned, TFile file, IFileType fileType) {
        assert (rootPathBeingScanned != null) : "'rootPathBeingScanned' must not be null";
        assert (file != null) : "'file' must not be null";
        assert (fileType != null) : "'fileType' must not be null";
        FilePath existingFile = this.m_existingFiles.get(file);
        if (existingFile == null) {
            this.m_delta.added(this.m_currentRootDirectory, fileType, file);
        } else {
            long timeStamp = existingFile.getTimestamp();
            long actualTimeStamp = file.lastModified();
            if (timeStamp != 0L && actualTimeStamp != 0L && actualTimeStamp != timeStamp) {
                this.m_delta.modified(existingFile);
            }
        }
    }

    public boolean continueScanning(TFile rootPathBeingScanned, TFile path) {
        assert (path != null) : "Parameter 'path' of method 'continueScanning' must not be null";
        this.m_workerContext.working(path.getAbsolutePath(), false);
        return !this.m_workerContext.hasBeenCanceled();
    }
}

