/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.architecturediagram.ArchitectureDiagramRepresentationCreator;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureElement;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecturediagram.ArchitectureDiagramDeletedEvent;
import com.hello2morrow.sonargraph.core.model.architecturediagram.ArchitectureDiagramModifiedEvent;
import com.hello2morrow.sonargraph.core.model.architecturediagram.ArchitectureDiagramRepresentation;
import com.hello2morrow.sonargraph.core.model.architecturediagram.IArchitectureDiagramProvider;
import com.hello2morrow.sonargraph.core.model.architecturediagram.IUmlComponentElement;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponent;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponentAnchor;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponentConnector;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponentInterface;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.OptionalExtension;
import com.hello2morrow.sonargraph.core.model.system.Representations;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.event.Event;
import com.hello2morrow.sonargraph.foundation.event.EventManager;

abstract class ArchitectureDiagramProvider
extends OptionalExtension
implements IArchitectureDiagramProvider {
    private final SoftwareSystem m_softwareSystem;

    ArchitectureDiagramProvider(SoftwareSystem softwareSystem, boolean enabled) {
        super(enabled);
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'ArchitectureDiagramProvider' must not be null";
        this.m_softwareSystem = softwareSystem;
    }

    protected final SoftwareSystem getSoftwareSystem() {
        return this.m_softwareSystem;
    }

    protected final ArchitectureFile isCheckedAndLoaded(ArchitectureFile architectureFile) {
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'isCheckedAndLoaded' must not be null";
        return architectureFile.isChecked() && architectureFile.modelLoaded() ? architectureFile : null;
    }

    @Override
    public final boolean hasBeenCreated(ArchitectureFile file) {
        assert (file != null) : "Parameter 'file' of method 'hasBeenLoaded' must not be null";
        for (ArchitectureDiagramRepresentation next : this.getSoftwareSystem().getUniqueExistingChild(Representations.class).getChildren(ArchitectureDiagramRepresentation.class)) {
            if (next.getArchitectureFile() != file) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isCreatePossible(ArchitectureFile file) {
        assert (file != null) : "Parameter 'file' of method 'isLoadable' must not be null";
        ArchitectureFile architectureFile = this.isCheckedAndLoaded(file);
        return architectureFile != null && ArchitectureDiagramRepresentationCreator.isCreatePossible(architectureFile);
    }

    protected final void performDelete(ArchitectureDiagramRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'performDelete' must not be null";
        representation.setInvalid();
        representation.remove();
    }

    @Override
    public final void delete(ArchitectureDiagramRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'delete' must not be null";
        this.performDelete(representation);
        EventManager.getInstance().dispatch((Object)this, (Event)new ArchitectureDiagramDeletedEvent(this.m_softwareSystem.getExtension(ISoftwareSystemProvider.class), representation.getArchitectureFile(), representation));
    }

    private boolean resetSelectionRelatedFlags(ArchitectureDiagramRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'resetSelectionRelatedFlags' must not be null";
        boolean updateNeeded = false;
        for (UmlComponent nextUmlComponent : representation.getChildrenRecursively(UmlComponent.class, new Class[0])) {
            for (UmlComponentAnchor umlComponentAnchor : nextUmlComponent.getChildren(UmlComponentAnchor.class)) {
                if (umlComponentAnchor.isSelected() || umlComponentAnchor.isHighlighted()) {
                    updateNeeded = true;
                }
                umlComponentAnchor.setSelected(false);
                umlComponentAnchor.setHighlighted(false);
            }
            for (UmlComponent.Uses uses : nextUmlComponent.getOutgoingUses()) {
                if (uses.isSelected() || uses.isHighlighted() || uses.isHidden()) {
                    updateNeeded = true;
                }
                uses.setSelected(false);
                uses.setHighlighted(false);
                uses.setHidden(false);
            }
            for (UmlComponent.AnchorBased anchorBased : nextUmlComponent.getAnchorBased()) {
                if (anchorBased.isSelected() || anchorBased.isHighlighted() || anchorBased.isHidden()) {
                    updateNeeded = true;
                }
                anchorBased.setSelected(false);
                anchorBased.setHighlighted(false);
                anchorBased.setHidden(false);
            }
            if (nextUmlComponent.isSelected() || nextUmlComponent.isHighlighted()) {
                updateNeeded = true;
            }
            nextUmlComponent.setSelected(false);
            nextUmlComponent.setHighlighted(false);
        }
        return updateNeeded;
    }

    @Override
    public void deselectAll(ArchitectureDiagramRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'deselectAll' must not be null";
        if (this.resetSelectionRelatedFlags(representation)) {
            EventManager.getInstance().dispatch((Object)this, (Event)new ArchitectureDiagramModifiedEvent(this.m_softwareSystem.getExtension(ISoftwareSystemProvider.class), representation.getArchitectureFile(), representation, ArchitectureDiagramModifiedEvent.Mode.UPDATE));
        }
    }

    private boolean setHidden(UmlComponent.UmlComponentDependency dependency, Selection selection) {
        assert (dependency != null) : "Parameter 'dependency' of method 'setHidden' must not be null";
        assert (selection != null) : "Parameter 'selection' of method 'setHidden' must not be null";
        switch (selection) {
            case CONNECTOR: {
                if (dependency.getSourceAnchor().isSelected()) {
                    return false;
                }
                if (!dependency.getSourceAnchor().isHighlighted()) break;
                return false;
            }
            case INTERFACE: {
                if (dependency.getTargetAnchor().isSelected()) {
                    return false;
                }
                if (!dependency.getTargetAnchor().isHighlighted()) break;
                return false;
            }
            case USES: {
                return !dependency.isSelected();
            }
            case COMPONENT: {
                if (!dependency.getSourceAnchor().isSelected() && !dependency.getSourceAnchor().isHighlighted() || !dependency.getTargetAnchor().isSelected() && !dependency.getTargetAnchor().isHighlighted()) break;
                return false;
            }
            case NONE: {
                break;
            }
            default: {
                assert (false) : "Unhandled selection: " + String.valueOf((Object)selection);
                break;
            }
        }
        return true;
    }

    private void selectIncludedBy(UmlComponent umlComponent) {
        assert (umlComponent != null) : "Parameter 'umlComponent' of method 'selectIncludedBy' must not be null";
        for (UmlComponent.AnchorBased nextAnchorBased : umlComponent.getAnchorBased()) {
            if (nextAnchorBased.getType() != UmlComponent.DependencyType.INCLUDED_BY) continue;
            UmlComponentAnchor<? extends ArchitectureElement> nextTargetAnchor = nextAnchorBased.getTargetAnchor();
            nextTargetAnchor.setSelected(true);
            UmlComponent nextUmlComponent = nextTargetAnchor.getParent(UmlComponent.class, ParentMode.ONLY_DIRECT_PARENT);
            assert (nextUmlComponent != null) : "Parameter 'nextUmlComponent' of method 'selectExportedBy' must not be null";
            this.selectIncludedBy(nextUmlComponent);
        }
    }

    private void selectExportedBy(UmlComponent umlComponent) {
        assert (umlComponent != null) : "Parameter 'umlComponent' of method 'selectExportedBy' must not be null";
        for (UmlComponent.AnchorBased nextAnchorBased : umlComponent.getAnchorBased()) {
            if (nextAnchorBased.getType() != UmlComponent.DependencyType.EXPORTED_BY) continue;
            UmlComponentAnchor<? extends ArchitectureElement> nextTargetAnchor = nextAnchorBased.getTargetAnchor();
            nextTargetAnchor.setSelected(true);
            UmlComponent nextUmlComponent = nextTargetAnchor.getParent(UmlComponent.class, ParentMode.ONLY_DIRECT_PARENT);
            assert (nextUmlComponent != null) : "Parameter 'nextUmlComponent' of method 'selectExportedBy' must not be null";
            this.selectExportedBy(nextUmlComponent);
        }
    }

    @Override
    public final void select(IUmlComponentElement element, ArchitectureDiagramRepresentation representation) {
        assert (element != null) : "Parameter 'element' of method 'select' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'select' must not be null";
        this.resetSelectionRelatedFlags(representation);
        Selection selection = Selection.NONE;
        if (element instanceof UmlComponent) {
            selection = Selection.COMPONENT;
            UmlComponent umlComponent = (UmlComponent)element;
            umlComponent.setSelected(true);
            this.selectIncludedBy(umlComponent);
            this.selectExportedBy(umlComponent);
            for (UmlComponentConnector nextConnector : umlComponent.getChildren(UmlComponentConnector.class)) {
                nextConnector.setSelected(true);
                for (UmlComponentInterface nextInterface : representation.getAllowedInterfaces(nextConnector)) {
                    nextInterface.setHighlighted(true);
                }
            }
            for (UmlComponentInterface nextInterface : umlComponent.getChildren(UmlComponentInterface.class)) {
                nextInterface.setSelected(true);
                for (UmlComponentConnector nextConnector : representation.getAllowedConnectors(nextInterface)) {
                    nextConnector.setHighlighted(true);
                }
            }
        } else if (element instanceof UmlComponent.UmlComponentDependency) {
            UmlComponent.UmlComponentDependency umlComponentDependency = (UmlComponent.UmlComponentDependency)element;
            if (umlComponentDependency.getType() == UmlComponent.DependencyType.USES) {
                selection = Selection.USES;
                umlComponentDependency.setSelected(true);
                umlComponentDependency.getSourceAnchor().setHighlighted(true);
                umlComponentDependency.getTargetAnchor().setHighlighted(true);
            }
        } else if (element instanceof UmlComponentConnector) {
            UmlComponentConnector connector = (UmlComponentConnector)element;
            connector.setSelected(true);
            umlComponent = connector.getParent(UmlComponent.class, ParentMode.ONLY_DIRECT_PARENT);
            assert (umlComponent != null) : "Parameter 'umlComponent' of method 'select' must not be null";
            this.selectIncludedBy(umlComponent);
            for (UmlComponentInterface umlComponentInterface : representation.getAllowedInterfaces(connector)) {
                umlComponentInterface.setHighlighted(true);
            }
            selection = Selection.CONNECTOR;
        } else if (element instanceof UmlComponentInterface) {
            UmlComponentInterface inter = (UmlComponentInterface)element;
            inter.setSelected(true);
            umlComponent = inter.getParent(UmlComponent.class, ParentMode.ONLY_DIRECT_PARENT);
            assert (umlComponent != null) : "Parameter 'umlComponent' of method 'select' must not be null";
            this.selectExportedBy(umlComponent);
            for (UmlComponentConnector umlComponentConnector : representation.getAllowedConnectors(inter)) {
                umlComponentConnector.setHighlighted(true);
            }
            selection = Selection.INTERFACE;
        }
        if (selection != Selection.NONE) {
            for (UmlComponent nextUmlComponent : representation.getChildrenRecursively(UmlComponent.class, new Class[0])) {
                for (UmlComponent.Uses uses : nextUmlComponent.getOutgoingUses()) {
                    uses.setHidden(this.setHidden(uses, selection));
                }
                for (UmlComponent.AnchorBased anchorBased : nextUmlComponent.getAnchorBased()) {
                    anchorBased.setHidden(this.setHidden(anchorBased, selection));
                }
            }
        }
        EventManager.getInstance().dispatch((Object)this, (Event)new ArchitectureDiagramModifiedEvent(this.m_softwareSystem.getExtension(ISoftwareSystemProvider.class), representation.getArchitectureFile(), representation, ArchitectureDiagramModifiedEvent.Mode.UPDATE));
    }

    private static enum Selection {
        COMPONENT,
        USES,
        CONNECTOR,
        INTERFACE,
        NONE;

    }
}

