/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecture;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IArchitectureExtension;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import java.util.List;

public final class EditArchitectureFileCommand
extends SoftwareSystemBasedCommand<IEditInteraction> {
    public static final ICommandId ID = CoreCommandId.EDIT_ARCHITECTURE_FILE;

    public EditArchitectureFileCommand(ISoftwareSystemProvider provider, IEditInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return ID;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        EditData data;
        IEditInteraction interaction = (IEditInteraction)this.getInteraction();
        if (!interaction.collect(data = new EditData())) {
            return;
        }
        ArchitectureFile architectureFile = data.getArchitectureFile();
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'internalRun' must not be null";
        IArchitectureExtension architectureExtension = this.getController().getSoftwareSystem().getExtension(IArchitectureExtension.class);
        List<ArchitectureFile> applyingFiles = architectureExtension.getApplyingAndRequiringFiles(architectureFile);
        if (!interaction.confirmSaveOnEdit(architectureFile, applyingFiles)) {
            return;
        }
        OperationResult result = architectureExtension.editArchitectureFile(workerContext, data.getArchitectureFile(), data.getName());
        interaction.processEditResult(result);
    }

    public static final class EditData
    implements ICommandInteractionData {
        private ArchitectureFile m_architectureFile;
        private String m_name;

        public ArchitectureFile getArchitectureFile() {
            return this.m_architectureFile;
        }

        public void setArchitectureFile(ArchitectureFile architectureFile) {
            assert (architectureFile != null) : "Parameter 'architectureFile' of method 'setArchitectureFile' must not be null";
            this.m_architectureFile = architectureFile;
        }

        public String getName() {
            assert (this.m_name != null && this.m_name.length() > 0) : "'m_name' of method 'getName' must not be empty";
            return this.m_name;
        }

        public void setName(String name) {
            assert (name != null && name.length() > 0) : "Parameter 'name' of method 'setName' must not be empty";
            this.m_name = name;
        }
    }

    public static interface IEditInteraction
    extends ICommandInteraction {
        public boolean collect(EditData var1);

        public boolean confirmSaveOnEdit(ArchitectureFile var1, List<ArchitectureFile> var2);

        public void processEditResult(OperationResult var1);
    }
}

