/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.application;

import com.hello2morrow.sonargraph.core.application.ILicenseHandlerProvider;
import com.hello2morrow.sonargraph.core.application.SonargraphPluginRegistry;
import com.hello2morrow.sonargraph.core.command.common.CommandRegistry;
import com.hello2morrow.sonargraph.core.command.common.ICommandProvider;
import com.hello2morrow.sonargraph.core.command.common.SonargraphLicenseHandler;
import com.hello2morrow.sonargraph.core.controllerinterface.system.SoftwareSystemProviderFactory;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.common.SonargraphProduct;
import com.hello2morrow.sonargraph.core.model.script.ScriptOutputStreamProvider;
import com.hello2morrow.sonargraph.core.model.system.ILanguageProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.file.TrueZipFacade;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginManager;
import com.hello2morrow.sonargraph.plugin.angular.AngularPlugin;
import com.hello2morrow.sonargraph.plugin.issues.csv.IssuesCsvPlugin;
import com.hello2morrow.sonargraph.plugin.pmd.PmdPlugin;
import com.hello2morrow.sonargraph.plugin.spotbugs.SpotbugsPlugin;
import com.hello2morrow.sonargraph.plugin.spring.microservices.SpringMicroservicesPlugin;
import com.hello2morrow.sonargraph.plugin.swagger.SwaggerPlugin;
import com.hello2morrow.sonargraph.scm.ScmManager;
import com.hello2morrow.sonargraph.scm.git.controller.GitCommitRetrieverFactory;
import gnu.trove.set.hash.THashSet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SonargraphApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonargraphApplication.class);
    private static final String SONARGRAPH_LANGUAGE_ENV_PARAMETER = "sonargraph.language";
    private final List<WeakReference<ISoftwareSystemProvider>> m_providers = new ArrayList<WeakReference<ISoftwareSystemProvider>>(5);
    private final SonargraphProduct m_product;
    private List<ICommandProvider> m_commandProviders;
    private SonargraphLicenseHandler m_licenseHandler;
    private SonargraphPluginRegistry m_sonargraphPluginRegistry;
    private boolean m_isInitialized;

    public SonargraphApplication(SonargraphProduct product) {
        assert (product != null) : "Parameter 'product' of method 'SonargraphApplication' must not be null";
        this.m_product = product;
        TrueZipFacade.initialize();
    }

    public Set<String> determineSpecifiedLanguagesFromEnvironment() {
        THashSet languages;
        String envParameter = System.getProperty(SONARGRAPH_LANGUAGE_ENV_PARAMETER);
        if (envParameter == null) {
            languages = Collections.emptySet();
        } else {
            languages = new THashSet();
            String[] stringArray = envParameter.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String next = stringArray[n2];
                String language = next.trim();
                if (language.length() > 0) {
                    languages.add(language.toLowerCase());
                }
                ++n2;
            }
        }
        return languages;
    }

    public boolean isLanguageExcluded(Set<String> languagesToBeUsed, Language language) {
        assert (languagesToBeUsed != null) : "Parameter 'languagesToBeUsed' of method 'isLanguageExcluded' must not be null";
        assert (language != null) : "Parameter 'language' of method 'isLanguageExcluded' must not be null";
        return !this.m_licenseHandler.hasValidLicense() || !languagesToBeUsed.isEmpty() && !languagesToBeUsed.contains(language.getStandardName().toLowerCase());
    }

    public boolean initializeLicenseHandler(ILicenseHandlerProvider licenseHandlerProvider, Set<Language> availableLanguages, SonargraphLicenseHandler.ILicenseLostEventHandler licenseLostHandler) {
        assert (availableLanguages != null) : "Parameter 'availableLanguages' of method 'initializeLicenseHandler' must not be null";
        assert (licenseHandlerProvider != null) : "Parameter 'licenseHandlerProvider' of method 'initializeLicenseHandler' must not be null";
        this.m_licenseHandler = licenseHandlerProvider.initializeLicenseHandler(this.m_product, availableLanguages, licenseLostHandler);
        assert (this.m_licenseHandler != null) : "LicenseHandler must not be null!";
        return this.m_licenseHandler.hasValidLicense();
    }

    public boolean isInitialized() {
        return this.m_isInitialized;
    }

    public void finishInitialization(List<ICommandProvider> commandProviders) {
        assert (commandProviders != null) : "Parameter 'commandProviders' of method 'finishInitialization' must not be null";
        this.m_commandProviders = new ArrayList<ICommandProvider>(commandProviders);
        CommandRegistry.createInstance(this.m_licenseHandler, commandProviders);
        if (this.m_licenseHandler.hasValidLicense()) {
            if (this.m_licenseHandler.isFeatureAvailable(SonargraphFeature.ARCHITECTURE) && !ScmManager.getInstance().isAvailable("Git")) {
                new GitCommitRetrieverFactory();
                LOGGER.info("SCM 'Git' support installed.");
            }
            if (this.m_licenseHandler.isFeatureAvailable(SonargraphFeature.PLUGINS)) {
                if (!SonargraphPluginManager.getInstance().isAvailable("com.hello2morrow.sonargraph.plugin.angular")) {
                    new AngularPlugin();
                }
                if (!SonargraphPluginManager.getInstance().isAvailable("com.hello2morrow.sonargraph.plugin.issues.csv")) {
                    new IssuesCsvPlugin();
                }
                if (!SonargraphPluginManager.getInstance().isAvailable("com.hello2morrow.sonargraph.plugin.pmd")) {
                    new PmdPlugin();
                }
                if (!SonargraphPluginManager.getInstance().isAvailable("com.hello2morrow.sonargraph.plugin.spotbugs")) {
                    new SpotbugsPlugin();
                }
                if (!SonargraphPluginManager.getInstance().isAvailable("com.hello2morrow.sonargraph.plugin.spring.microservices")) {
                    new SpringMicroservicesPlugin();
                }
                if (!SonargraphPluginManager.getInstance().isAvailable("com.hello2morrow.sonargraph.plugin.swagger")) {
                    new SwaggerPlugin();
                }
                this.m_sonargraphPluginRegistry = new SonargraphPluginRegistry();
                StringBuilder builder = new StringBuilder();
                List plugins = SonargraphPluginManager.getInstance().getPlugins();
                if (plugins.isEmpty()) {
                    builder.append("0 Sonargraph plugins installed");
                } else {
                    if (plugins.size() == 1) {
                        builder.append(plugins.size() + " Sonargraph plugin installed:");
                    } else {
                        builder.append(plugins.size() + " Sonargraph plugins installed:");
                    }
                    for (SonargraphPlugin next : plugins) {
                        builder.append("\n  ").append(next.getId());
                    }
                }
                LOGGER.info(builder.toString());
            }
        }
        this.m_isInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISoftwareSystemProvider createSoftwareSystemProvider(List<ILanguageProvider> languageProviders, ScriptOutputStreamProvider outputStreamProvider, AnalyzerExecutionLevel level) {
        assert (languageProviders != null) : "Parameter 'languageProviders' of method 'finishInitialization' must not be null";
        assert (outputStreamProvider != null) : "Parameter 'outputStreamProvider' of method 'finishInitialization' must not be null";
        assert (level != null) : "Parameter 'level' of method 'createSoftwareSystemProvider' must not be null";
        ISoftwareSystemProvider provider = SoftwareSystemProviderFactory.create(this.m_licenseHandler, languageProviders, outputStreamProvider, this.m_product.getStandardName(), level);
        LOGGER.debug("Created SoftwareSystemProvider {}", (Object)provider);
        List<WeakReference<ISoftwareSystemProvider>> list = this.m_providers;
        synchronized (list) {
            this.m_providers.add(new WeakReference<ISoftwareSystemProvider>(provider));
        }
        if (this.m_sonargraphPluginRegistry != null) {
            this.m_sonargraphPluginRegistry.initializeSoftwareSystemProvider(provider);
        }
        return provider;
    }

    public void resetLicense() {
        assert (this.m_isInitialized) : "SonargraphApplication must have been initialized to reset license";
        CommandRegistry.delete();
        CommandRegistry.createInstance(this.m_licenseHandler, this.m_commandProviders);
    }

    public void shutdownStarted(ISoftwareSystemProvider provider) {
        if (provider != null) {
            provider.shutdown();
        }
        if (this.m_licenseHandler != null) {
            this.m_licenseHandler.releaseLicenseTicket();
        }
        CommandRegistry.delete();
        this.m_isInitialized = false;
    }

    public void shutdown() {
        TrueZipFacade.clear();
    }

    public SonargraphLicenseHandler getLicenseHandler() {
        return this.m_licenseHandler;
    }

    public SonargraphProduct getProduct() {
        return this.m_product;
    }
}

